/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.extensions.reliable;

import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIGroupCTB;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIReliableCommunicationsClientFacade;

public class NICommandTransmissionBlock {
    public static final int FREE = 0;
    public static final int AWAITING_RESPONSE = 1;
    public static final int ALLOCATED = 2;
    private int slotNumber;
    private NICommand command;
    private boolean success;
    private int status;
    private int numAttempts;
    private boolean groupedCommand;
    private NIGroupCTB groupCTB;
    private int groupIndex;
    private NIReliableCommunicationsClientFacade rccf;

    public NICommandTransmissionBlock(int n) {
        this.slotNumber = n;
        this.numAttempts = 0;
        this.groupedCommand = false;
        this.groupCTB = null;
        this.groupIndex = -1;
    }

    public void setRCCF(NIReliableCommunicationsClientFacade nIReliableCommunicationsClientFacade) {
        if (nIReliableCommunicationsClientFacade == null) {
            if (this.rccf != null) {
                --this.rccf.numActiveCommands;
            }
        } else {
            ++nIReliableCommunicationsClientFacade.numActiveCommands;
        }
        this.rccf = nIReliableCommunicationsClientFacade;
    }

    public void setGrouped(boolean bl) {
        this.groupedCommand = bl;
    }

    public boolean isGrouped() {
        return this.groupedCommand;
    }

    public void setGroupCTB(NIGroupCTB nIGroupCTB) {
        this.groupCTB = nIGroupCTB;
    }

    public NIGroupCTB getGroupCTB() {
        return this.groupCTB;
    }

    public void setGroupIndex(int n) {
        this.groupIndex = n;
    }

    public synchronized void processResponse(NICommand nICommand) {
        this.setSuccess(true);
        this.setCommand(nICommand);
        if (this.groupedCommand) {
            this.groupCTB.processResponse(nICommand, this.groupIndex);
        } else {
            this.notify();
        }
    }

    public void setCommand(NICommand nICommand) {
        this.command = nICommand;
    }

    public NICommand getCommand() {
        return this.command;
    }

    public int getSlotNum() {
        return this.slotNumber;
    }

    public synchronized void setSuccess(boolean bl) {
        this.success = bl;
    }

    public synchronized boolean getSuccess() {
        return this.success;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public String statusToString() {
        switch (this.status) {
            case 0: {
                return "FREE";
            }
            case 1: {
                return "AWAITING_RESPONSE";
            }
            case 2: {
                return "ALLOCATED";
            }
        }
        return "INVALID";
    }

    public int getNumAttempts() {
        return this.numAttempts;
    }

    public void setNumAttempts(int n) {
        this.numAttempts = n;
    }

    public void incrementNumAttempts() {
        ++this.numAttempts;
    }
}

