/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.extensions.reliable;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.client.extensions.services.event.NIEventServiceFacade;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIReliableCommunicationsClient;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIReliableCommunicationsClientImpl;
import com.ibm.storage.ess.ni.exception.NIAuthenticationFailureException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.services.NIEventService;
import java.net.InetAddress;

class NIReliableCommunicationsClientFacade
implements NIReliableCommunicationsClient {
    private NIReliableCommunicationsClientImpl impl;
    private int id;
    private NIEventService eventServiceFacade;
    private boolean reverse;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$extensions$reliable$NIReliableCommunicationsClientImpl == null ? (class$com$ibm$storage$ess$ni$communication$extensions$reliable$NIReliableCommunicationsClientImpl = NIReliableCommunicationsClientFacade.class$("com.ibm.storage.ess.ni.communication.extensions.reliable.NIReliableCommunicationsClientImpl")) : class$com$ibm$storage$ess$ni$communication$extensions$reliable$NIReliableCommunicationsClientImpl);
    boolean facadeConnected = false;
    int numActiveCommands = 0;
    boolean revertToLocal = false;
    int numRetries = 0;
    long commandTimeout = 900000L;
    private int connectRC;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$extensions$reliable$NIReliableCommunicationsClientImpl;

    NIReliableCommunicationsClientFacade(NIReliableCommunicationsClientImpl nIReliableCommunicationsClientImpl, boolean bl, int n) {
        this.impl = nIReliableCommunicationsClientImpl;
        this.id = n;
        this.reverse = bl;
    }

    private String genLabel() {
        NIClientConnectionToken nIClientConnectionToken = null;
        if (this.impl != null) {
            nIClientConnectionToken = this.impl.getClientConnectionToken();
        }
        return "<client #" + (nIClientConnectionToken != null ? nIClientConnectionToken.toString() : "?") + ":" + this.id + "> ";
    }

    public synchronized void disconnect() {
        logger.debug_general(this.genLabel() + "disconnect called");
        if (this.facadeConnected) {
            this.impl.disconnect();
            this.facadeConnected = false;
        }
    }

    public synchronized boolean checkConnection() {
        if (this.facadeConnected) {
            return this.impl.checkConnection();
        }
        return false;
    }

    public synchronized int connect() throws NIAuthenticationFailureException, NIUnavailableServerException {
        logger.debug_general(this.genLabel() + "connect called");
        if (!this.facadeConnected) {
            try {
                this.connectRC = this.impl.connect();
                if (this.connectRC == 1 || this.connectRC == 0) {
                    this.facadeConnected = true;
                }
            }
            catch (NIAuthenticationFailureException nIAuthenticationFailureException) {
                throw nIAuthenticationFailureException;
            }
            catch (NIUnavailableServerException nIUnavailableServerException) {
                throw nIUnavailableServerException;
            }
        }
        return this.connectRC;
    }

    public NICommand send(NICommand nICommand) throws NIServerException, NIUnauthorizedServerException, NIUnsupportedException, NIUnavailableServerException {
        if (this.facadeConnected) {
            return this.impl.send(nICommand, this);
        }
        logger.debug_general(this.genLabel() + "send called when not connected");
        throw new NIUnavailableServerException(3, "All connections disconnected");
    }

    public NICommand[] sendGroup(NICommand[] nICommandArray) throws NIServerException, NIUnauthorizedServerException, NIUnsupportedException, NIUnavailableServerException {
        if (this.facadeConnected) {
            return this.impl.sendGroup(nICommandArray, this);
        }
        logger.debug_general(this.genLabel() + "sendGroup called when not connected");
        throw new NIUnavailableServerException(3, "All connections disconnected");
    }

    public long getCommandTimeout() {
        return this.commandTimeout / 1000L;
    }

    public void setCommandTimeout(long l) {
        this.commandTimeout = l * 1000L;
    }

    public int getRetryAmount() {
        return this.numRetries;
    }

    public void setRetryAmount(int n) {
        this.numRetries = n;
    }

    public synchronized NIEventService getEventService() {
        if (this.facadeConnected && this.eventServiceFacade == null) {
            this.eventServiceFacade = new NIEventServiceFacade(this.impl.getEventService(), this.id, this);
        }
        return this.eventServiceFacade;
    }

    public NIClientConnectionToken getClientConnectionToken() {
        if (this.facadeConnected) {
            return this.impl.getClientConnectionToken();
        }
        return null;
    }

    public synchronized int getStatusOfConnectionToHMC(int n) {
        if (this.facadeConnected) {
            return this.impl.getStatusOfConnectionToHMC(n);
        }
        return 1;
    }

    public int getConnectionType() {
        if (this.facadeConnected) {
            return this.impl.getConnectionType();
        }
        return 0;
    }

    public int getNumberOfActiveCommands() {
        if (this.facadeConnected) {
            return this.numActiveCommands;
        }
        return 0;
    }

    public void updateConnectionPassword(String string, String string2) {
        if (this.facadeConnected) {
            this.impl.updateConnectionPassword(string, string2);
        }
    }

    public NICommand sendLocal(NICommand nICommand) throws NIServerException, NIUnauthorizedServerException, NIUnsupportedException, NIUnavailableServerException {
        if (this.facadeConnected) {
            return this.impl.sendLocal(nICommand, this);
        }
        logger.debug_general(this.genLabel() + "sendLocal called when not connected");
        throw new NIUnavailableServerException(3, "All connections disconnected");
    }

    public NICommand[] sendAll(NICommand[] nICommandArray) throws NIServerException, NIUnauthorizedServerException, NIUnsupportedException, NIUnavailableServerException {
        if (this.facadeConnected) {
            return this.impl.sendAll(nICommandArray, this);
        }
        logger.debug_general(this.genLabel() + "sendAll called when not connected");
        throw new NIUnavailableServerException(3, "All connections disconnected");
    }

    public void setRevertToAddress(InetAddress inetAddress) {
        if (this.facadeConnected) {
            this.impl.setRevertToAddress(inetAddress);
        }
    }

    public InetAddress getServerAddressByIndex(int n) {
        if (this.facadeConnected) {
            return this.impl.getServerAddressByIndex(n);
        }
        return null;
    }

    public InetAddress getRevertToAddress() {
        if (this.facadeConnected) {
            return this.impl.getRevertToAddress();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

