/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.extensions.reliable;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.event.NIEvent;
import com.ibm.storage.ess.ni.application.event.extensions.NIPeerDeletedEvent;
import com.ibm.storage.ess.ni.application.event.extensions.NIPeerDeletedEventListener;
import com.ibm.storage.ess.ni.application.event.extensions.NIPeerSetEvent;
import com.ibm.storage.ess.ni.application.event.extensions.NIPeerSetEventListener;
import com.ibm.storage.ess.ni.client.extensions.services.event.NIEventDistributor;
import com.ibm.storage.ess.ni.client.extensions.services.event.NIEventExecutor;
import com.ibm.storage.ess.ni.client.extensions.services.event.NIEventServiceImpl;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.command.extensions.NICommandID;
import com.ibm.storage.ess.ni.command.extensions.NIConnectionTypeQuery;
import com.ibm.storage.ess.ni.command.extensions.NIGetPeerHMCAddressCommand;
import com.ibm.storage.ess.ni.communication.NICommunication;
import com.ibm.storage.ess.ni.communication.extensions.client.NICommunicationClient;
import com.ibm.storage.ess.ni.communication.extensions.client.NICommunicationClientStatusListener;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.communication.extensions.common.NITokenUnavailableException;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIClientCommandRouter;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIClientResponseProcessor;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NICommandTransmissionBlock;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIFreeCTBList;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIGroupCTB;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIReliableCommunicationsClient;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIReliableCommunicationsClientFacade;
import com.ibm.storage.ess.ni.communication.extensions.reliable.NIResponseExecutor;
import com.ibm.storage.ess.ni.event.extensions.NIHMCConnectionStatusChangedEventImpl;
import com.ibm.storage.ess.ni.exception.NIAuthenticationFailureException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NITimeoutServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.security.common.NIAuthenticationInfo;
import com.ibm.storage.ess.ni.util.NIWakeupTask;
import com.ibm.storage.ess.ni.util.NIWatchdogManager;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class NIReliableCommunicationsClientImpl
implements NICommunicationClientStatusListener,
NIClientResponseProcessor,
NIPeerSetEventListener,
NIPeerDeletedEventListener {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$extensions$reliable$NIReliableCommunicationsClientImpl == null ? (class$com$ibm$storage$ess$ni$communication$extensions$reliable$NIReliableCommunicationsClientImpl = NIReliableCommunicationsClientImpl.class$("com.ibm.storage.ess.ni.communication.extensions.reliable.NIReliableCommunicationsClientImpl")) : class$com$ibm$storage$ess$ni$communication$extensions$reliable$NIReliableCommunicationsClientImpl);
    private static final int MAX_CHANNELS = 2;
    private static final int NUM_CMDS = 256;
    private NICommunicationClient[] channels;
    private NICommunicationClient[] oldChannels;
    private NICommunicationClient localHostChannel;
    private int[] status;
    private InetAddress[] servers;
    private NIAuthenticationInfo authInfo;
    private int[] hmc;
    private NIWatchdogManager watchdogManager = NIWatchdogManager.getWatchdogManager();
    private NICommandTransmissionBlock[] slot;
    private NIFreeCTBList freeList;
    private NIEventServiceImpl eventService = null;
    private int sequenceNum = 0;
    private int numChannels;
    private int oldNumChannels;
    private boolean connected = false;
    private boolean haveBeenConnected = false;
    private boolean disconnected = false;
    private int connectCount = 0;
    private static final long BLOCKING_SEND_TIMEOUT = 60000L;
    private static final long BLOCKING_CHECK_CONNECTION_TIMEOUT = 30000L;
    private boolean swappingConnections = false;
    private NIClientCommandRouter router;
    private NIClientConnectionToken clientToken;
    private NIEventExecutor eventExecutor;
    private NIEventDistributor distributor;
    private NIResponseExecutor[] responseExecutors;
    private int connectionType = 0;
    private NIReliableCommunicationsClientFacade rccf;
    private String label = "<client #?> ";
    private static LinkedList rccList = new LinkedList();
    private int nextFacade = 0;
    private static final int MAX_NUM_ATTEMPTS = 5;
    private static final int MAX_NUM_GET_PEER_ATTEMPTS = 3;
    private Object sequenceNumberLock = new Object();
    private Object eventServiceCreationLock = new Object();
    private Object statusChangeLock = new Object();
    private Collection terminatorThreads = Collections.synchronizedCollection(new Vector());
    private InetAddress revertToAddress = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$extensions$reliable$NIReliableCommunicationsClientImpl;

    public static synchronized NIReliableCommunicationsClient getDistinctInstance(InetAddress[] inetAddressArray, NIAuthenticationInfo nIAuthenticationInfo) {
        InetAddress[] inetAddressArray2 = new InetAddress[2];
        int n = 0;
        while (n < inetAddressArray.length) {
            InetAddress inetAddress;
            if (inetAddressArray[n].isLoopbackAddress() && (inetAddress = NIReliableCommunicationsClientImpl.getLocalHostAddress()) != null) {
                logger.debug_general("converted " + inetAddressArray[n] + " to " + inetAddress);
                inetAddressArray[n] = inetAddress;
            }
            inetAddressArray2[n] = inetAddressArray[n];
            ++n;
        }
        NIReliableCommunicationsClientImpl nIReliableCommunicationsClientImpl = new NIReliableCommunicationsClientImpl(inetAddressArray2, nIAuthenticationInfo);
        return nIReliableCommunicationsClientImpl.allocateFacade(false);
    }

    private static InetAddress getLocalHostAddress() {
        InetAddress inetAddress;
        block10: {
            inetAddress = null;
            try {
                inetAddress = InetAddress.getLocalHost();
                if (!inetAddress.isLoopbackAddress()) break block10;
                logger.warning("getLocalHost returned a loopback IP... hostname is probably \"localhost\"... trying to get IP from eth2");
                try {
                    NetworkInterface networkInterface = NetworkInterface.getByName("eth2");
                    if (networkInterface != null) {
                        inetAddress = networkInterface.getInetAddresses().nextElement();
                        if (inetAddress != null) {
                            if (inetAddress.isLoopbackAddress()) {
                                logger.debug_general("the address associated with eth2 is loopback!... we are stuck with that");
                            } else {
                                logger.debug_general("found a non-loopback IP: " + inetAddress);
                            }
                        } else {
                            logger.debug_general("there are no addresses associated with eth2... returning null");
                        }
                    } else {
                        logger.debug_general("there was no eth2 interface... returning null");
                    }
                }
                catch (SocketException socketException) {
                    logger.error("exception when trying to get the eth2 interface.... returning null");
                    logger.throwable((Throwable)socketException);
                }
            }
            catch (UnknownHostException unknownHostException) {
                logger.error("unknown host exception when getting local host... returning null");
                logger.throwable((Throwable)unknownHostException);
            }
        }
        return inetAddress;
    }

    public static synchronized NIReliableCommunicationsClient getInstance(InetAddress[] inetAddressArray, NIAuthenticationInfo nIAuthenticationInfo) {
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = rccList.iterator();
        NIReliableCommunicationsClientImpl nIReliableCommunicationsClientImpl = null;
        NIReliableCommunicationsClient nIReliableCommunicationsClient = null;
        InetAddress[] inetAddressArray2 = new InetAddress[2];
        int n = 0;
        while (n < inetAddressArray.length) {
            InetAddress inetAddress;
            if (inetAddressArray[n].isLoopbackAddress() && (inetAddress = NIReliableCommunicationsClientImpl.getLocalHostAddress()) != null) {
                logger.debug_general("converted " + inetAddressArray[n] + " to " + inetAddress);
                inetAddressArray[n] = inetAddress;
            }
            inetAddressArray2[n] = inetAddressArray[n];
            ++n;
        }
        if (inetAddressArray2[1] != null && inetAddressArray2[1].equals(inetAddressArray2[0])) {
            inetAddressArray2[1] = null;
        }
        while (iterator.hasNext() && !bl) {
            nIReliableCommunicationsClientImpl = (NIReliableCommunicationsClientImpl)iterator.next();
            if (!nIAuthenticationInfo.equals(nIReliableCommunicationsClientImpl.getAuthenticationInfo())) continue;
            if (inetAddressArray2[0] != null && inetAddressArray2[0].equals(nIReliableCommunicationsClientImpl.getServerAddress(0)) && (inetAddressArray2.length == 1 || inetAddressArray2[1] == null || inetAddressArray2[1].equals(inetAddressArray2[0]) || inetAddressArray2[1].equals(nIReliableCommunicationsClientImpl.getServerAddress(1)))) {
                bl = true;
                continue;
            }
            if (inetAddressArray2[0] == null || !inetAddressArray2[0].equals(nIReliableCommunicationsClientImpl.getServerAddress(1)) || inetAddressArray2.length != 1 && inetAddressArray2[1] != null && !inetAddressArray2[1].equals(inetAddressArray2[0]) && !inetAddressArray2[1].equals(nIReliableCommunicationsClientImpl.getServerAddress(0))) continue;
            bl = true;
            bl2 = true;
        }
        if (!bl) {
            nIReliableCommunicationsClientImpl = new NIReliableCommunicationsClientImpl(inetAddressArray2, nIAuthenticationInfo);
            rccList.add(nIReliableCommunicationsClientImpl);
        }
        nIReliableCommunicationsClient = super.allocateFacade(bl2);
        return nIReliableCommunicationsClient;
    }

    private NIAuthenticationInfo getAuthenticationInfo() {
        return this.authInfo;
    }

    private InetAddress getServerAddress(int n) {
        InetAddress inetAddress = null;
        if (n < this.servers.length) {
            inetAddress = this.servers[n];
        }
        return inetAddress;
    }

    public InetAddress getServerAddressByIndex(int n) {
        InetAddress inetAddress = null;
        if (n < this.hmc.length && this.hmc[n] < this.servers.length) {
            inetAddress = this.servers[this.hmc[n]];
        }
        return inetAddress;
    }

    private NIReliableCommunicationsClient allocateFacade(boolean bl) {
        logger.debug_general(this.label + "Allocating facade #" + this.nextFacade);
        return new NIReliableCommunicationsClientFacade(this, bl, this.nextFacade++);
    }

    private NIReliableCommunicationsClientImpl(InetAddress[] inetAddressArray, NIAuthenticationInfo nIAuthenticationInfo) {
        this.channels = new NICommunicationClient[2];
        this.status = new int[2];
        int n = 0;
        while (n < 2) {
            this.status[n] = 3;
            ++n;
        }
        this.responseExecutors = new NIResponseExecutor[2];
        this.servers = new InetAddress[2];
        int n2 = 0;
        while (n2 < inetAddressArray.length) {
            this.servers[n2] = inetAddressArray[n2];
            ++n2;
        }
        this.hmc = new int[2];
        int n3 = 0;
        while (n3 < 2) {
            this.hmc[n3] = n3;
            ++n3;
        }
        this.authInfo = nIAuthenticationInfo;
        this.slot = new NICommandTransmissionBlock[256];
        int n4 = 0;
        while (n4 < 256) {
            this.slot[n4] = new NICommandTransmissionBlock(n4);
            ++n4;
        }
        this.freeList = new NIFreeCTBList();
        int n5 = 0;
        while (n5 < 256) {
            this.freeList.freeCTB(this.slot[n5]);
            ++n5;
        }
        this.rccf = (NIReliableCommunicationsClientFacade)this.allocateFacade(false);
        this.rccf.facadeConnected = true;
    }

    public synchronized void disconnect() {
        logger.debug_general(this.label + "disconnect called");
        --this.connectCount;
        if (this.connectCount <= 0) {
            this.connectCount = 0;
            this.disconnected = true;
            int n = 0;
            while (n < this.numChannels) {
                if (this.channels[n] != null) {
                    this.channels[n].disconnect();
                }
                this.channels[n] = null;
                this.responseExecutors[n] = null;
                ++n;
            }
            this.distributor.shutdown();
            this.distributor = null;
            this.eventExecutor = null;
            this.eventService = null;
            rccList.remove(this);
            this.router = null;
            Iterator iterator = this.terminatorThreads.iterator();
            while (iterator.hasNext()) {
                NICCTerminatorThread nICCTerminatorThread = (NICCTerminatorThread)iterator.next();
                nICCTerminatorThread.interrupt();
            }
        }
    }

    public boolean checkConnection() {
        if (this.swappingConnections) {
            return this.checkConnection(this.oldChannels, this.oldNumChannels);
        }
        return this.checkConnection(this.channels, this.numChannels);
    }

    private boolean checkConnection(NICommunicationClient[] nICommunicationClientArray, int n) {
        boolean bl;
        block6: {
            bl = false;
            long l = System.currentTimeMillis();
            int n2 = 0;
            while (n2 < n) {
                if (this.status[n2] == 1 && nICommunicationClientArray[n2].checkConnection(true)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) break block6;
            try {
                long l2 = System.currentTimeMillis();
                NIWakeupTask nIWakeupTask = this.watchdogManager.scheduleWakeup(logger, 30000L - (l2 - l));
                int n3 = 0;
                while (n3 < n) {
                    if (this.status[n3] != 3 && nICommunicationClientArray[n3].blockingCheckConnection(true)) {
                        bl = true;
                        this.watchdogManager.cancelWakeup(nIWakeupTask);
                        break;
                    }
                    ++n3;
                }
            }
            catch (InterruptedException interruptedException) {
                logger.debug_general("interrupted while trying blocking check connection");
            }
        }
        return bl;
    }

    public synchronized int connect() throws NIAuthenticationFailureException, NIUnavailableServerException {
        return this.connect(false);
    }

    private synchronized int connect(boolean bl) throws NIAuthenticationFailureException, NIUnavailableServerException {
        int n = 3;
        int n2 = 0;
        while (n2 < 5 && n == 3) {
            try {
                n = this.attemptConnect(bl);
            }
            catch (NITokenUnavailableException nITokenUnavailableException) {
                logger.debug_general(this.label + "connect attempt #" + n2 + " failed with token unavailable");
                this.disconnect();
            }
            ++n2;
        }
        if (n != 3 && n != 4 && !bl) {
            ++this.connectCount;
        }
        logger.debug_general(this.label + "connect returning " + n);
        return n;
    }

    private synchronized int attemptConnect(boolean bl) throws NIAuthenticationFailureException, NIUnavailableServerException {
        this.disconnected = false;
        int n = 3;
        boolean bl2 = false;
        logger.debug_general(this.label + "connect called, we have HMC addresses: [" + this.servers[0] + "," + this.servers[1] + "]");
        if (!this.connected || bl) {
            Serializable serializable;
            block60: {
                if (this.servers != null && this.servers[0] != null) {
                    NIGetPeerHMCAddressCommand nIGetPeerHMCAddressCommand;
                    this.responseExecutors[0] = new NIResponseExecutor(this);
                    if (this.eventExecutor == null) {
                        this.distributor = new NIEventDistributor();
                        this.eventExecutor = new NIEventExecutor(this.distributor);
                    }
                    this.channels[0] = new NICommunicationClient(this.servers[0], this.authInfo, this.eventExecutor, this.responseExecutors[0]);
                    this.channels[0].registerListener(this);
                    try {
                        this.clientToken = this.channels[0].connect(null);
                        this.label = "<client #" + (this.clientToken == null ? "?" : this.clientToken.toString()) + "> ";
                        this.numChannels = 1;
                        serializable = new NIGetPeerHMCAddressCommand();
                        nIGetPeerHMCAddressCommand = null;
                        int n2 = 1;
                        while (n2 <= 3) {
                            try {
                                nIGetPeerHMCAddressCommand = (NIGetPeerHMCAddressCommand)this.sendDirect((NICommand)serializable, this.channels[0], this.rccf);
                                break;
                            }
                            catch (Exception exception) {
                                if (n2 >= 3) {
                                    logger.error("Unable to get peer HMC address.");
                                    logger.throwable((Throwable)exception);
                                } else {
                                    logger.warning("Retrying to get peer HMC address " + exception.getMessage());
                                }
                                ++n2;
                            }
                        }
                        if (nIGetPeerHMCAddressCommand == null) {
                            this.disconnect();
                            throw new NIUnavailableServerException();
                        }
                        int n3 = nIGetPeerHMCAddressCommand.getHMCNumber();
                        logger.debug_general(this.label + "first hmc reports hmcNumber: " + n3);
                        if (n3 == 2) {
                            this.hmc[0] = 1;
                            this.hmc[1] = 0;
                        } else {
                            this.hmc[0] = 0;
                            this.hmc[1] = 1;
                        }
                        InetAddress inetAddress = nIGetPeerHMCAddressCommand.getPeerHMCAddress();
                        if (inetAddress == null && this.servers[1] == null) {
                            logger.debug_general(this.label + "HMC at " + this.servers[0] + " reports no peer, we were given no second address (MATCH!).... connecting to just one HMC");
                            break block60;
                        }
                        if (inetAddress == null) {
                            logger.debug_general(this.label + "HMC at " + this.servers[0] + " reports no peer, but we were also given address " + this.servers[1] + " trying to connect to validate");
                            this.responseExecutors[1] = new NIResponseExecutor(this);
                            this.channels[1] = new NICommunicationClient(this.servers[1], this.authInfo, this.eventExecutor, this.responseExecutors[1]);
                            this.channels[1].registerListener(this);
                            try {
                                this.channels[1].connect(this.clientToken);
                                this.numChannels = 2;
                                logger.error(this.label + "secondHMC(" + this.servers[1] + ") is accessible, but firstHMC(" + this.servers[0] + ") doesn't think it has a peer.... invalid peers");
                                serializable = new NIGetPeerHMCAddressCommand();
                                try {
                                    nIGetPeerHMCAddressCommand = (NIGetPeerHMCAddressCommand)this.sendDirect((NICommand)serializable, this.channels[1], this.rccf);
                                }
                                catch (Exception exception) {
                                    logger.error(this.label + "exception when trying to get peer from second HMC... ignoring");
                                    logger.throwable((Throwable)exception);
                                }
                                logger.error(this.label + "secondHMC reports " + nIGetPeerHMCAddressCommand.getPeerHMCAddress() + " as its peer");
                                logger.error(this.label + "please check the peer setup of the given HMCs.... failing this connection");
                                this.disconnect();
                                return 4;
                            }
                            catch (NITokenUnavailableException nITokenUnavailableException) {
                                logger.debug_general(this.label + "could not connect to second HMC with the given token... invalid peers since firstHMC reports no peer");
                                logger.debug_general(this.label + "check peer configuration of the given HMCs, and try to connect again if valid");
                                this.disconnect();
                                return 4;
                            }
                            catch (NIUnavailableServerException nIUnavailableServerException) {
                                logger.debug_general(this.label + "could not connect to second HMC, allowing connection to firstHMC only");
                                this.servers[1] = null;
                                break block60;
                            }
                            catch (NIAuthenticationFailureException nIAuthenticationFailureException) {
                                logger.debug_general(this.label + "could not connect to second HMC (auth failure).... invalid peers");
                                logger.debug_general(this.label + "check the peer configuration, and make sure security repositories are synced, then retry");
                                logger.throwable((Throwable)nIAuthenticationFailureException);
                                this.disconnect();
                                return 4;
                            }
                        }
                        if (inetAddress != null && (this.servers[1] == null || inetAddress.equals(this.servers[1]))) {
                            this.responseExecutors[1] = new NIResponseExecutor(this);
                            this.channels[1] = new NICommunicationClient(inetAddress, this.authInfo, this.eventExecutor, this.responseExecutors[1]);
                            this.channels[1].registerListener(this);
                            try {
                                this.channels[1].connect(this.clientToken);
                                serializable = new NIGetPeerHMCAddressCommand();
                                try {
                                    nIGetPeerHMCAddressCommand = (NIGetPeerHMCAddressCommand)this.sendDirect((NICommand)serializable, this.channels[1], this.rccf);
                                }
                                catch (Exception exception) {
                                    logger.error(this.label + "exception when trying to get peer from second HMC... disconnecting");
                                    logger.throwable((Throwable)exception);
                                    this.numChannels = 2;
                                    this.disconnect();
                                    return 3;
                                }
                                InetAddress inetAddress2 = nIGetPeerHMCAddressCommand.getPeerHMCAddress();
                                int n4 = nIGetPeerHMCAddressCommand.getHMCNumber();
                                logger.debug_general(this.label + "second hmc reports hmcNumber: " + n4);
                                if (inetAddress2 == null || !inetAddress2.equals(this.servers[0])) {
                                    logger.error(this.label + "peer reported by secondHMC is not the first (" + inetAddress2 + ")... invalid peers.... disconnecting");
                                    this.disconnect();
                                    return 4;
                                }
                                if (n4 != 0 && n4 == n3) {
                                    logger.error(this.label + "hmcNumber reported by secondHMC is the same as the first (" + n4 + ")... invalid peers.... disconnecting");
                                    this.disconnect();
                                    return 4;
                                }
                                this.servers[1] = inetAddress;
                                this.numChannels = 2;
                                break block60;
                            }
                            catch (NITokenUnavailableException nITokenUnavailableException) {
                                logger.debug_general(this.label + "could not connect to second HMC with the given token");
                                this.channels[1] = null;
                                throw nITokenUnavailableException;
                            }
                            catch (NIUnavailableServerException nIUnavailableServerException) {
                                logger.debug_general(this.label + "could not connect to second HMC, calling reconnect");
                                this.channels[1].reconnect();
                                this.servers[1] = inetAddress;
                                this.numChannels = 2;
                                break block60;
                            }
                            catch (NIAuthenticationFailureException nIAuthenticationFailureException) {
                                logger.debug_general(this.label + "could not connect to second HMC.... security databases need to be resynchronized");
                                logger.throwable((Throwable)nIAuthenticationFailureException);
                                this.channels[1] = null;
                                break block60;
                            }
                        }
                        if (inetAddress == null || this.servers[1] == null || inetAddress.equals(this.servers[1])) break block60;
                        logger.error(this.label + "The server reports a peer HMC (" + inetAddress + "), but it is different from the one given... this may be valid if we can't connect to address B(" + this.servers[1] + ")");
                        this.responseExecutors[1] = new NIResponseExecutor(this);
                        this.channels[1] = new NICommunicationClient(this.servers[1], this.authInfo, this.eventExecutor, this.responseExecutors[1]);
                        this.channels[1].registerListener(this);
                        try {
                            this.channels[1].connect(this.clientToken);
                            logger.error(this.label + "we were able to connect to address B(" + this.servers[1] + "), doesn't match A's peer(" + inetAddress + ")... failing");
                            this.numChannels = 2;
                            this.disconnect();
                            return 4;
                        }
                        catch (NITokenUnavailableException nITokenUnavailableException) {
                            logger.debug_general(this.label + "could not connect to second HMC with the given token... invalid peers");
                            logger.debug_general(this.label + "check the HMC addresses and peer configuration, then retry");
                            this.disconnect();
                            return 4;
                        }
                        catch (NIUnavailableServerException nIUnavailableServerException) {
                            logger.debug_general(this.label + "could not connect to second HMC, this means that the peer addresses given may" + " be valid, but we cannot confirm that.");
                            logger.debug_general(this.label + "allowing the connection to the first HMC to remain open.... will not connect to the" + " second HMC even if it comes back up");
                        }
                        catch (NIAuthenticationFailureException nIAuthenticationFailureException) {
                            logger.error(this.label + "authentication failure... the addresses given are not valid peers.");
                            logger.warning(this.label + "check the addresses and the HMC peer configuration, and make sure security repositories are sync'ed... then retry");
                            logger.throwable((Throwable)nIAuthenticationFailureException);
                            this.disconnect();
                            return 4;
                        }
                    }
                    catch (NIUnavailableServerException nIUnavailableServerException) {
                        logger.error(this.label + "unavailable server exception caught when trying to connect to first IP");
                        logger.throwable((Throwable)nIUnavailableServerException);
                        if (this.servers.length > 1 && this.servers[1] != null) {
                            NIGetPeerHMCAddressCommand nIGetPeerHMCAddressCommand2;
                            this.channels[1] = this.channels[0];
                            if (this.responseExecutors[0] == null) {
                                this.responseExecutors[0] = new NIResponseExecutor(this);
                            }
                            if (this.eventExecutor == null) {
                                this.distributor = new NIEventDistributor();
                                this.eventExecutor = new NIEventExecutor(this.distributor);
                            }
                            this.channels[0] = new NICommunicationClient(this.servers[1], this.authInfo, this.eventExecutor, this.responseExecutors[0]);
                            this.channels[0].registerListener(this);
                            this.clientToken = this.channels[0].connect(null);
                            this.label = "<client #" + (this.clientToken == null ? "?" : this.clientToken.toString()) + "> ";
                            this.numChannels = 1;
                            nIGetPeerHMCAddressCommand = new NIGetPeerHMCAddressCommand();
                            try {
                                nIGetPeerHMCAddressCommand2 = (NIGetPeerHMCAddressCommand)this.sendDirect(nIGetPeerHMCAddressCommand, this.channels[0], this.rccf);
                            }
                            catch (Exception exception) {
                                logger.error(this.label + "exception when trying to get the peer from the secondHMC... disconnecting");
                                logger.throwable((Throwable)exception);
                                this.disconnect();
                                throw new NIUnavailableServerException();
                            }
                            InetAddress inetAddress = nIGetPeerHMCAddressCommand2.getPeerHMCAddress();
                            if (inetAddress != null && inetAddress.equals(this.servers[0])) {
                                logger.error(this.label + "peer reported by secondHMC matches... spawning reconnect");
                                this.channels[1].reconnect();
                                this.servers[0] = this.servers[1];
                                this.servers[1] = inetAddress;
                                this.numChannels = 2;
                            } else {
                                logger.debug_general(this.label + "cannot verify peers... we have " + this.servers[0] + ", and connected HMC reports " + inetAddress);
                                logger.debug_general(this.label + "allowing connection to address B(" + this.servers[1] + ") only");
                                this.servers[0] = this.servers[1];
                                this.servers[1] = null;
                            }
                            int n5 = nIGetPeerHMCAddressCommand2.getHMCNumber();
                            logger.debug_general(this.label + "second hmc reports hmcNumber: " + n5);
                            if (n5 == 2 || n5 == 0) {
                                this.hmc[0] = 1;
                                this.hmc[1] = 0;
                            } else {
                                this.hmc[0] = 0;
                                this.hmc[1] = 1;
                            }
                        }
                        throw nIUnavailableServerException;
                    }
                }
            }
            serializable = null;
            try {
                serializable = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                logger.error(this.label + "unable to getLocalHost address... sendLocal will not work");
                logger.throwable((Throwable)unknownHostException);
            }
            if (this.servers[0].equals(serializable)) {
                this.localHostChannel = this.channels[0];
            } else if (this.servers[1] != null && this.servers[1].equals(serializable)) {
                this.localHostChannel = this.channels[1];
            } else {
                logger.warning(this.label + "no channels are established to local host.... sendLocal will fail if attempted");
                this.localHostChannel = null;
            }
            this.router = new NIClientCommandRouter(this.channels, this.numChannels, this.clientToken);
            try {
                this.determineConnectionType();
            }
            catch (NIServerException nIServerException) {
                logger.error(this.label + "problem determining connection type");
                logger.throwable((Throwable)nIServerException);
                throw new NIUnavailableServerException();
            }
            try {
                this.rccf.getEventService().addListener(this);
            }
            catch (NIServerException nIServerException) {
                logger.error(this.label + "server exception when registering for intial config events");
                logger.error(this.label + "this client will not update properly if setPeer or removePeer is done");
                logger.throwable((Throwable)nIServerException);
                logger.error(this.label + "removing listener since this is likely a down level server");
                try {
                    this.rccf.getEventService().removeListener(this);
                }
                catch (NIServerException nIServerException2) {
                    logger.warning(this.label + "exception when deregistering");
                    logger.throwable((Throwable)nIServerException2);
                }
            }
        }
        switch (this.numChannels) {
            case 0: {
                n = 3;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 0;
                break;
            }
            default: {
                n = 3;
            }
        }
        return n;
    }

    private void determineConnectionType() throws NIUnauthorizedServerException, NIUnsupportedException, NIUnavailableServerException, NIServerException {
        NIConnectionTypeQuery nIConnectionTypeQuery = new NIConnectionTypeQuery();
        NIConnectionTypeQuery nIConnectionTypeQuery2 = (NIConnectionTypeQuery)this.send(nIConnectionTypeQuery, this.rccf);
        this.connectionType = nIConnectionTypeQuery2.getConnectionType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NICommand send(NICommand nICommand, NIReliableCommunicationsClientFacade nIReliableCommunicationsClientFacade) throws NIServerException, NIUnauthorizedServerException, NIUnsupportedException, NIUnavailableServerException {
        NICommandTransmissionBlock nICommandTransmissionBlock = null;
        long l = System.currentTimeMillis();
        if (this.connected) {
            long l2 = Math.min(nIReliableCommunicationsClientFacade.commandTimeout, nICommand.getTimeout());
            nICommandTransmissionBlock = this.freeList.getCTB();
            if (nICommandTransmissionBlock != null) {
                NICommandID nICommandID = new NICommandID();
                nICommandID.setClientID(this.clientToken);
                nICommand.setID(nICommandID);
                nICommandTransmissionBlock.setRCCF(nIReliableCommunicationsClientFacade);
                boolean bl = false;
                while (!bl) {
                    int n = this.getSequenceNumber();
                    nICommandID.setCommandID(n |= nICommandTransmissionBlock.getSlotNum() << 24);
                    nICommandTransmissionBlock.setCommand(nICommand);
                    nICommandTransmissionBlock.setSuccess(false);
                    nICommandTransmissionBlock.setStatus(1);
                    try {
                        NICommandTransmissionBlock nICommandTransmissionBlock2 = nICommandTransmissionBlock;
                        synchronized (nICommandTransmissionBlock2) {
                            block15: {
                                nICommandTransmissionBlock.incrementNumAttempts();
                                try {
                                    this.router.route(nICommand);
                                }
                                catch (NIUnavailableServerException nIUnavailableServerException) {
                                    long l3 = System.currentTimeMillis();
                                    long l4 = l3 - l;
                                    long l5 = Math.min(l2 / 4L, 60000L);
                                    if (l2 - l4 <= l5 * 2L) break block15;
                                    try {
                                        NIWakeupTask nIWakeupTask = this.watchdogManager.scheduleWakeup(logger, l5);
                                        this.router.blockingRoute(nICommand);
                                        this.watchdogManager.cancelWakeup(nIWakeupTask);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        logger.error(this.label + "blocking send timed out");
                                        throw nIUnavailableServerException;
                                    }
                                }
                            }
                            if (!nICommandTransmissionBlock.getSuccess()) {
                                logger.debug_detailed(this.label + "Send method called, sleeping waiting for response");
                                long l6 = System.currentTimeMillis();
                                long l7 = l2 - (l6 - l);
                                nICommandTransmissionBlock.wait(l7);
                                logger.debug_detailed(this.label + "Send method awakened, checking for valid response");
                            }
                        }
                        if (nICommandTransmissionBlock.getSuccess()) {
                            logger.debug_general(this.label + "Successful response returned");
                            bl = true;
                            continue;
                        }
                        logger.debug_general(this.label + "Command timed out");
                        if (nICommand.isIdempotent() && nICommandTransmissionBlock.getNumAttempts() < nIReliableCommunicationsClientFacade.numRetries) continue;
                        this.freeList.freeCTB(nICommandTransmissionBlock);
                        throw new NITimeoutServerException(0, "command timed out");
                    }
                    catch (NIUnavailableServerException nIUnavailableServerException) {
                        logger.throwable((Throwable)nIUnavailableServerException);
                        logger.error(this.label + "UnavailableServerException when sending command to server");
                        this.freeList.freeCTB(nICommandTransmissionBlock);
                        throw nIUnavailableServerException;
                    }
                    catch (InterruptedException interruptedException) {
                        logger.throwable((Throwable)interruptedException);
                        logger.error(this.label + "Interrupted while waiting for response");
                        throw new NIServerException(0, "Interrupted while waiting for response");
                    }
                }
                NICommand nICommand2 = nICommandTransmissionBlock.getCommand();
                this.freeList.freeCTB(nICommandTransmissionBlock);
                return nICommand2;
            }
            logger.debug_general(this.label + "number of outstanding commands exceeded");
            throw new NIUnavailableServerException();
        }
        logger.debug_general(this.label + "send called when not connected");
        throw new NIUnavailableServerException(3, "All connections disconnected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NICommand[] sendGroup(NICommand[] nICommandArray, NIReliableCommunicationsClientFacade nIReliableCommunicationsClientFacade) throws NIServerException, NIUnauthorizedServerException, NIUnsupportedException, NIUnavailableServerException {
        int n = nICommandArray.length;
        NICommandTransmissionBlock[] nICommandTransmissionBlockArray = new NICommandTransmissionBlock[n];
        NIGroupCTB nIGroupCTB = new NIGroupCTB(nICommandArray);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        long l = System.currentTimeMillis();
        if (this.connected) {
            int n2;
            long l2 = Math.min(nIReliableCommunicationsClientFacade.commandTimeout, nICommandArray[0].getTimeout());
            int n3 = 0;
            while (n3 < n) {
                nICommandTransmissionBlockArray[n3] = this.freeList.getCTB();
                if (nICommandTransmissionBlockArray[n3] == null) {
                    int n4 = 0;
                    while (n4 < n3) {
                        this.freeList.freeCTB(nICommandTransmissionBlockArray[n4]);
                        ++n4;
                    }
                    logger.debug_general(this.label + "not enough free CTBs to send all commands.... number of outstanding commands exceeded");
                    throw new NIUnavailableServerException();
                }
                NICommandID nICommandID = new NICommandID();
                nICommandID.setClientID(this.clientToken);
                nICommandArray[n3].setID(nICommandID);
                nICommandTransmissionBlockArray[n3].setCommand(nICommandArray[n3]);
                nICommandTransmissionBlockArray[n3].setSuccess(false);
                nICommandTransmissionBlockArray[n3].setStatus(1);
                nICommandTransmissionBlockArray[n3].setGrouped(true);
                nICommandTransmissionBlockArray[n3].setGroupCTB(nIGroupCTB);
                nICommandTransmissionBlockArray[n3].setGroupIndex(n3);
                nICommandTransmissionBlockArray[n3].setRCCF(nIReliableCommunicationsClientFacade);
                ++n3;
            }
            do {
                Object object;
                n2 = 0;
                while (n2 < n) {
                    if (!bl || !nICommandTransmissionBlockArray[n2].getSuccess() && nICommandTransmissionBlockArray[n2].getCommand().isIdempotent() && nICommandTransmissionBlockArray[n2].getNumAttempts() < nIReliableCommunicationsClientFacade.numRetries) {
                        int n5 = this.getSequenceNumber();
                        nICommandTransmissionBlockArray[n2].getCommand().getID().setCommandID(n5 |= nICommandTransmissionBlockArray[n2].getSlotNum() << 24);
                        try {
                            object = nICommandTransmissionBlockArray[n2];
                            synchronized (object) {
                                block27: {
                                    if (!nICommandTransmissionBlockArray[n2].getSuccess()) {
                                        nICommandTransmissionBlockArray[n2].incrementNumAttempts();
                                        try {
                                            this.router.route(nICommandArray[n2]);
                                        }
                                        catch (NIUnavailableServerException nIUnavailableServerException) {
                                            long l3 = System.currentTimeMillis();
                                            long l4 = l3 - l;
                                            long l5 = Math.min(l2 / 4L, 60000L);
                                            if (l2 - l4 <= l5 * 2L) break block27;
                                            try {
                                                NIWakeupTask nIWakeupTask = this.watchdogManager.scheduleWakeup(logger, l5);
                                                this.router.blockingRoute(nICommandArray[n2]);
                                                this.watchdogManager.cancelWakeup(nIWakeupTask);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                logger.error(this.label + "blocking send timed out");
                                                throw nIUnavailableServerException;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        catch (NIUnavailableServerException nIUnavailableServerException) {
                            logger.error(this.label + "unable to send command: " + nICommandTransmissionBlockArray[n2].getCommand());
                            logger.throwable((Throwable)nIUnavailableServerException);
                            nICommandTransmissionBlockArray[n2].processResponse(null);
                        }
                    } else if (!(nICommandTransmissionBlockArray[n2].getSuccess() || nICommandTransmissionBlockArray[n2].getCommand().isIdempotent() && nICommandTransmissionBlockArray[n2].getNumAttempts() < nIReliableCommunicationsClientFacade.numRetries)) {
                        object = nICommandTransmissionBlockArray[n2].getCommand();
                        logger.error(this.label + "giving up on command: " + object + " isIdempotent: " + ((NICommand)object).isIdempotent() + " numAttempts: " + nICommandTransmissionBlockArray[n2].getNumAttempts());
                        nICommandTransmissionBlockArray[n2].processResponse(null);
                    }
                    ++n2;
                }
                bl = true;
                bl2 = nIGroupCTB.getSuccess();
                if (bl2) continue;
                try {
                    object = nIGroupCTB;
                    synchronized (object) {
                        if (!nIGroupCTB.getSuccess()) {
                            long l6 = System.currentTimeMillis();
                            long l7 = l2 - (l6 - l);
                            nIGroupCTB.wait(l7);
                        }
                    }
                    bl2 = nIGroupCTB.getSuccess();
                    if (bl2) {
                        logger.debug_general(this.label + "grouped response returned: " + nIGroupCTB);
                        continue;
                    }
                    logger.debug_general(this.label + "A Grouped command timed out: " + nIGroupCTB);
                }
                catch (InterruptedException interruptedException) {
                    logger.error(this.label + "interrupted while waiting on groupCTB: " + nIGroupCTB);
                }
            } while (!bl2);
            n2 = 0;
            while (n2 < nICommandTransmissionBlockArray.length) {
                this.freeList.freeCTB(nICommandTransmissionBlockArray[n2]);
                ++n2;
            }
            NICommand[] nICommandArray2 = nIGroupCTB.getResponses();
            return nICommandArray2;
        }
        logger.debug_general(this.label + "sendGroup called when not connected");
        throw new NIUnavailableServerException(3, "All connections disconnected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NICommand[] sendAll(NICommand[] nICommandArray, NIReliableCommunicationsClientFacade nIReliableCommunicationsClientFacade) throws NIServerException, NIUnauthorizedServerException, NIUnsupportedException, NIUnavailableServerException {
        int n = nICommandArray.length;
        NICommandTransmissionBlock[] nICommandTransmissionBlockArray = new NICommandTransmissionBlock[n];
        NIGroupCTB nIGroupCTB = new NIGroupCTB(nICommandArray);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        long l = System.currentTimeMillis();
        if (this.connected) {
            int n2;
            long l2 = Math.min(nIReliableCommunicationsClientFacade.commandTimeout, nICommandArray[0].getTimeout());
            int n3 = 0;
            while (n3 < n) {
                nICommandTransmissionBlockArray[n3] = this.freeList.getCTB();
                if (nICommandTransmissionBlockArray[n3] == null) {
                    int n4 = 0;
                    while (n4 < n3) {
                        this.freeList.freeCTB(nICommandTransmissionBlockArray[n4]);
                        ++n4;
                    }
                    logger.debug_general(this.label + "not enough free CTBs to send all commands.... number of outstanding commands exceeded");
                    throw new NIUnavailableServerException();
                }
                NICommandID nICommandID = new NICommandID();
                nICommandID.setClientID(this.clientToken);
                nICommandArray[n3].setID(nICommandID);
                nICommandTransmissionBlockArray[n3].setCommand(nICommandArray[n3]);
                nICommandTransmissionBlockArray[n3].setSuccess(false);
                nICommandTransmissionBlockArray[n3].setStatus(1);
                nICommandTransmissionBlockArray[n3].setGrouped(true);
                nICommandTransmissionBlockArray[n3].setGroupCTB(nIGroupCTB);
                nICommandTransmissionBlockArray[n3].setGroupIndex(n3);
                nICommandTransmissionBlockArray[n3].setRCCF(nIReliableCommunicationsClientFacade);
                ++n3;
            }
            do {
                Object object;
                n2 = 0;
                while (n2 < n) {
                    if (!bl || !nICommandTransmissionBlockArray[n2].getSuccess() && nICommandTransmissionBlockArray[n2].getCommand().isIdempotent() && nICommandTransmissionBlockArray[n2].getNumAttempts() < nIReliableCommunicationsClientFacade.numRetries) {
                        int n5 = this.getSequenceNumber();
                        nICommandTransmissionBlockArray[n2].getCommand().getID().setCommandID(n5 |= nICommandTransmissionBlockArray[n2].getSlotNum() << 24);
                        try {
                            object = nICommandTransmissionBlockArray[n2];
                            synchronized (object) {
                                if (!nICommandTransmissionBlockArray[n2].getSuccess()) {
                                    nICommandTransmissionBlockArray[n2].incrementNumAttempts();
                                    if (this.status[n2] == 1) {
                                        if (this.swappingConnections) {
                                            this.oldChannels[n2].send(nICommandArray[n2]);
                                        } else {
                                            this.channels[n2].send(nICommandArray[n2]);
                                        }
                                    } else {
                                        nICommandTransmissionBlockArray[n2].processResponse(null);
                                    }
                                }
                            }
                        }
                        catch (NIUnavailableServerException nIUnavailableServerException) {
                            logger.error(this.label + "unable to send command: " + nICommandTransmissionBlockArray[n2].getCommand());
                            logger.throwable((Throwable)nIUnavailableServerException);
                            nICommandTransmissionBlockArray[n2].processResponse(null);
                        }
                    } else if (!(nICommandTransmissionBlockArray[n2].getSuccess() || nICommandTransmissionBlockArray[n2].getCommand().isIdempotent() && nICommandTransmissionBlockArray[n2].getNumAttempts() < nIReliableCommunicationsClientFacade.numRetries)) {
                        object = nICommandTransmissionBlockArray[n2].getCommand();
                        logger.error(this.label + "giving up on command: " + object + " isIdempotent: " + ((NICommand)object).isIdempotent() + " numAttempts: " + nICommandTransmissionBlockArray[n2].getNumAttempts());
                        nICommandTransmissionBlockArray[n2].processResponse(null);
                    }
                    ++n2;
                }
                bl = true;
                bl2 = nIGroupCTB.getSuccess();
                if (bl2) continue;
                try {
                    object = nIGroupCTB;
                    synchronized (object) {
                        if (!nIGroupCTB.getSuccess()) {
                            long l3 = System.currentTimeMillis();
                            long l4 = l2 - (l3 - l);
                            nIGroupCTB.wait(l4);
                        }
                    }
                    bl2 = nIGroupCTB.getSuccess();
                    if (bl2) {
                        logger.debug_general(this.label + "grouped response returned: " + nIGroupCTB);
                        continue;
                    }
                    logger.debug_general(this.label + "A Grouped command timed out: " + nIGroupCTB);
                }
                catch (InterruptedException interruptedException) {
                    logger.error(this.label + "interrupted while waiting on groupCTB: " + nIGroupCTB);
                }
            } while (!bl2);
            n2 = 0;
            while (n2 < nICommandTransmissionBlockArray.length) {
                this.freeList.freeCTB(nICommandTransmissionBlockArray[n2]);
                ++n2;
            }
            NICommand[] nICommandArray2 = nIGroupCTB.getResponses();
            return nICommandArray2;
        }
        logger.debug_general(this.label + "sendAll called when not connected");
        throw new NIUnavailableServerException(3, "All connections disconnected");
    }

    public NICommand sendLocal(NICommand nICommand, NIReliableCommunicationsClientFacade nIReliableCommunicationsClientFacade) throws NIServerException, NIUnauthorizedServerException, NIUnsupportedException, NIUnavailableServerException {
        if (this.connected) {
            if (this.localHostChannel != null) {
                return this.sendDirect(nICommand, this.localHostChannel, nIReliableCommunicationsClientFacade);
            }
            logger.debug_general(this.label + "sendLocal called when not connected to localHost");
            throw new NIUnavailableServerException(3, "No connection to local server");
        }
        logger.debug_general(this.label + "sendLocal called when not connected");
        throw new NIUnavailableServerException(3, "All connections disconnected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NICommand sendDirect(NICommand nICommand, NICommunicationClient nICommunicationClient, NIReliableCommunicationsClientFacade nIReliableCommunicationsClientFacade) throws NIServerException, NIUnauthorizedServerException, NIUnsupportedException, NIUnavailableServerException {
        long l = System.currentTimeMillis();
        if (this.connected) {
            long l2 = Math.min(nIReliableCommunicationsClientFacade.commandTimeout, nICommand.getTimeout());
            int n = -1;
            int n2 = 0;
            while (n2 < 2) {
                if (this.channels[n2] == nICommunicationClient) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n < 0) {
                if (this.swappingConnections) {
                    int n3 = 0;
                    while (n3 < 2) {
                        if (this.oldChannels[n3] == nICommunicationClient) {
                            n = n3;
                            break;
                        }
                        ++n3;
                    }
                }
                if (n < 0) {
                    logger.error(this.label + "RCCM sendDirect: illegal channel");
                    throw new NIUnavailableServerException();
                }
            }
            NICommandTransmissionBlock nICommandTransmissionBlock = null;
            nICommandTransmissionBlock = this.freeList.getCTB();
            if (nICommandTransmissionBlock != null) {
                NICommandID nICommandID = new NICommandID();
                nICommandID.setClientID(this.clientToken);
                nICommand.setID(nICommandID);
                nICommandTransmissionBlock.setRCCF(nIReliableCommunicationsClientFacade);
                boolean bl = false;
                while (!bl) {
                    int n4 = this.getSequenceNumber();
                    nICommandID.setCommandID(n4 |= nICommandTransmissionBlock.getSlotNum() << 24);
                    nICommandTransmissionBlock.setCommand(nICommand);
                    nICommandTransmissionBlock.setSuccess(false);
                    nICommandTransmissionBlock.setStatus(1);
                    try {
                        long l3;
                        long l4;
                        block22: {
                            nICommandTransmissionBlock.incrementNumAttempts();
                            try {
                                nICommunicationClient.send(nICommand);
                            }
                            catch (NIUnavailableServerException nIUnavailableServerException) {
                                l4 = System.currentTimeMillis();
                                l3 = l4 - l;
                                long l5 = Math.min(l2 / 4L, 60000L);
                                if (l2 - l3 <= l5 * 2L) break block22;
                                try {
                                    NIWakeupTask nIWakeupTask = this.watchdogManager.scheduleWakeup(logger, l5);
                                    nICommunicationClient.blockingSend(nICommand);
                                    this.watchdogManager.cancelWakeup(nIWakeupTask);
                                }
                                catch (InterruptedException interruptedException) {
                                    logger.error(this.label + "blocking send timed out");
                                    throw nIUnavailableServerException;
                                }
                            }
                        }
                        NICommandTransmissionBlock nICommandTransmissionBlock2 = nICommandTransmissionBlock;
                        synchronized (nICommandTransmissionBlock2) {
                            if (!nICommandTransmissionBlock.getSuccess()) {
                                logger.debug_detailed(this.label + "sendDirect method called, sleeping waiting for response");
                                l4 = System.currentTimeMillis();
                                l3 = l2 - (l4 - l);
                                nICommandTransmissionBlock.wait(l3);
                                logger.debug_detailed(this.label + "sendDirect method awakened, checking for valid response");
                            }
                        }
                        if (nICommandTransmissionBlock.getSuccess()) {
                            logger.debug_general(this.label + "successful response returned");
                            bl = true;
                            continue;
                        }
                        logger.debug_general(this.label + "Command timed out");
                        if (nICommand.isIdempotent() && nICommandTransmissionBlock.getNumAttempts() < nIReliableCommunicationsClientFacade.numRetries) continue;
                        this.freeList.freeCTB(nICommandTransmissionBlock);
                        throw new NITimeoutServerException(0, "command timed out");
                    }
                    catch (NIUnavailableServerException nIUnavailableServerException) {
                        logger.throwable((Throwable)nIUnavailableServerException);
                        logger.error(this.label + "UnavailableServerException when routing command to server");
                        this.freeList.freeCTB(nICommandTransmissionBlock);
                        throw nIUnavailableServerException;
                    }
                    catch (InterruptedException interruptedException) {
                        logger.throwable((Throwable)interruptedException);
                        logger.error(this.label + "Interrupted while waiting for response");
                        throw new NIServerException(0, "Interrupted while waiting for response");
                    }
                }
                NICommand nICommand2 = nICommandTransmissionBlock.getCommand();
                this.freeList.freeCTB(nICommandTransmissionBlock);
                return nICommand2;
            }
            logger.debug_general(this.label + "number of outstanding commands exceeded");
            throw new NIUnavailableServerException();
        }
        logger.debug_general(this.label + "sendDirect called when not connected");
        throw new NIUnavailableServerException(3, "All connections disconnected");
    }

    public void processResponse(NICommand nICommand) {
        NICommandID nICommandID = nICommand.getID();
        int n = nICommandID.getCommandID();
        logger.debug_detailed(this.label + "received response with UCI of " + Integer.toHexString(n));
        n >>= 24;
        if (this.slot[n &= 0xFF].getStatus() == 1) {
            logger.debug_detailed(this.label + "found NICTB.... call its process method");
            this.slot[n].processResponse(nICommand);
        } else {
            logger.error(this.label + "processResponse found NICTB, but it was in an invalid status: " + this.slot[n].statusToString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSequenceNumber() {
        int n;
        Object object = this.sequenceNumberLock;
        synchronized (object) {
            n = this.sequenceNum++;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIEventServiceImpl getEventService() {
        Object object = this.eventServiceCreationLock;
        synchronized (object) {
            if (this.connected && this.eventService == null) {
                NICommunicationClient[] nICommunicationClientArray = this.numChannels == 2 ? this.channels : new NICommunicationClient[]{this.channels[0]};
                this.eventService = new NIEventServiceImpl(this.rccf, this.distributor, nICommunicationClientArray, this.clientToken);
            }
        }
        return this.eventService;
    }

    public NIClientConnectionToken getClientConnectionToken() {
        return this.clientToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commClientStatusChanged(NICommunicationClient nICommunicationClient, int n) {
        InetAddress inetAddress = null;
        Object object = this.statusChangeLock;
        synchronized (object) {
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = true;
            int n3 = -1;
            int n4 = 0;
            while (n4 < 2) {
                if (this.channels[n4] == nICommunicationClient) {
                    if (n == 0 && this.status[n4] == 4 || n == 1 && this.status[n4] == 0 || n == 3 && n != this.status[n4]) {
                        bl = true;
                        int n5 = 0;
                        while (n5 < 2) {
                            if (this.hmc[n5] == n4) {
                                n3 = n5;
                            }
                            ++n5;
                        }
                        inetAddress = this.servers[n4];
                    }
                    this.status[n4] = n;
                }
                if (this.status[n4] == 1 || this.status[n4] == 4) {
                    ++n2;
                }
                if (this.status[n4] != 3) {
                    bl2 = false;
                }
                ++n4;
            }
            if (n2 > 0) {
                this.connected = true;
                this.haveBeenConnected = true;
            } else {
                this.connected = false;
            }
            if (bl) {
                NIHMCConnectionStatusChangedEventImpl nIHMCConnectionStatusChangedEventImpl = n == 1 ? new NIHMCConnectionStatusChangedEventImpl(n3, 0, inetAddress) : new NIHMCConnectionStatusChangedEventImpl(n3, 1, inetAddress);
                if (this.distributor != null) {
                    this.distributor.enqueue(nIHMCConnectionStatusChangedEventImpl);
                }
            }
            if (!this.disconnected && bl2 && this.haveBeenConnected) {
                logger.error(this.label + "All connections are in the DEAD state.... most likely the account password changed... need to reconnect");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatusOfConnectionToHMC(int n) {
        Object object = this.statusChangeLock;
        synchronized (object) {
            logger.debug_general(this.label + "getStatus of connection, hmcNumber=" + n + ", hmc[hmcNumber]=" + this.hmc[n] + ", status[hmc[hmcNumber]]=" + this.status[this.hmc[n]] + ", servers[hmc[hmcNumber]]=" + this.servers[this.hmc[n]]);
            if (this.status[this.hmc[n]] == 1 || this.status[this.hmc[n]] == 4) {
                return 0;
            }
            return 1;
        }
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public void updateConnectionPassword(String string, String string2) {
        if (this.authInfo.getUsername().equals(string)) {
            this.authInfo.setPassword(string2);
        }
    }

    public void process(NIEvent nIEvent) {
        Object object;
        NICommunicationClient[] nICommunicationClientArray = new NICommunicationClient[2];
        int n = 0;
        boolean bl = false;
        NIEventExecutor nIEventExecutor = new NIEventExecutor(null){

            protected NICommunication executeImpl(NICommunication nICommunication) {
                return nICommunication;
            }
        };
        if (nIEvent instanceof NIPeerDeletedEvent) {
            bl = true;
            NIPeerDeletedEvent nIPeerDeletedEvent = (NIPeerDeletedEvent)nIEvent;
            logger.error(this.label + "processing NIPeerDeletedEvent: " + nIEvent);
            if (this.revertToAddress == null) {
                object = nIPeerDeletedEvent.getPeerConfiguration().getPrimaryNodeIP();
                if (this.servers[0] != null && this.servers[0].equals(object)) {
                    this.servers[0] = this.servers[1];
                    n = 0;
                } else {
                    n = 1;
                }
            } else if (this.revertToAddress.equals(this.servers[0])) {
                n = 1;
            } else if (this.revertToAddress.equals(this.servers[1])) {
                this.servers[0] = this.servers[1];
                n = 0;
            } else {
                logger.error("revertToAddress is not connected:" + this.revertToAddress);
                object = nIPeerDeletedEvent.getPeerConfiguration().getPrimaryNodeIP();
                if (this.servers[0] != null && this.servers[0].equals(object)) {
                    this.servers[0] = this.servers[1];
                    n = 0;
                } else {
                    n = 1;
                }
            }
            this.servers[1] = null;
        } else if (nIEvent instanceof NIPeerSetEvent) {
            logger.error(this.label + "processing NIPeerSetEvent: " + nIEvent);
        } else {
            logger.error(this.label + "unexpected event received... ignoring:" + nIEvent);
            return;
        }
        try {
            this.oldNumChannels = this.numChannels;
            int n2 = 0;
            while (n2 < this.oldNumChannels) {
                nICommunicationClientArray[n2] = this.channels[n2];
                nICommunicationClientArray[n2].deregisterListener(this.eventService);
                nICommunicationClientArray[n2].setExecutor(nIEventExecutor);
                if (bl && n2 == n) {
                    nICommunicationClientArray[n2].goHalfDuplex();
                }
                nICommunicationClientArray[n2].deregisterListener(this.router);
                nICommunicationClientArray[n2].deregisterListener(this);
                ++n2;
            }
            this.oldChannels = nICommunicationClientArray;
            this.swappingConnections = true;
            this.connect(true);
            this.swappingConnections = false;
            NICommunicationClient[] nICommunicationClientArray2 = this.numChannels == 2 ? this.channels : new NICommunicationClient[]{this.channels[0]};
            if (this.eventService != null) {
                this.eventService.update(nICommunicationClientArray2, this.clientToken);
            }
            object = new NICCTerminatorThread(nICommunicationClientArray, this.oldNumChannels);
            ((Thread)object).start();
        }
        catch (NIAuthenticationFailureException nIAuthenticationFailureException) {
            logger.error(this.label + "authentication failure when trying to reconnect after domain change");
            logger.throwable((Throwable)nIAuthenticationFailureException);
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            logger.error(this.label + "unavailable server exception when trying to reconnect after domain change");
            logger.throwable((Throwable)nIUnavailableServerException);
        }
    }

    public void setRevertToAddress(InetAddress inetAddress) {
        InetAddress inetAddress2;
        logger.debug_general(this.label + " setRevertToAddress called with address: " + inetAddress);
        if (inetAddress.isLoopbackAddress() && (inetAddress2 = NIReliableCommunicationsClientImpl.getLocalHostAddress()) != null) {
            logger.debug_general("converted " + inetAddress + " to " + inetAddress2);
            inetAddress = inetAddress2;
        }
        this.revertToAddress = inetAddress;
    }

    public InetAddress getRevertToAddress() {
        return this.revertToAddress;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NICCTerminatorThread
    extends Thread {
        private NICommunicationClient[] oldChannelArray;
        private int oldNumChannels;

        public NICCTerminatorThread(NICommunicationClient[] nICommunicationClientArray, int n) {
            super("NICCTerminatorThread");
            this.oldChannelArray = nICommunicationClientArray;
            this.oldNumChannels = n;
        }

        public void run() {
            NIReliableCommunicationsClientImpl.this.terminatorThreads.add(this);
            try {
                Thread.sleep(900000L);
            }
            catch (InterruptedException interruptedException) {
                logger.error(NIReliableCommunicationsClientImpl.this.label + "interrupted while waiting to disconnect");
                logger.throwable((Throwable)interruptedException);
            }
            int n = 0;
            while (n < this.oldNumChannels) {
                this.oldChannelArray[n].disconnect();
                ++n;
            }
            NIReliableCommunicationsClientImpl.this.terminatorThreads.remove(this);
        }
    }
}

