/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.communication.extensions.server;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.event.NIEvent;
import com.ibm.storage.ess.ni.application.results.NIClientDescriptor;
import com.ibm.storage.ess.ni.application.results.security.NISecurityResult;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogEntryImpl;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogFileHandler;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogTable;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogUtil;
import com.ibm.storage.ess.ni.command.extensions.NICommand;
import com.ibm.storage.ess.ni.command.extensions.NICommandID;
import com.ibm.storage.ess.ni.command.extensions.NISecurityCommand;
import com.ibm.storage.ess.ni.communication.NICommunication;
import com.ibm.storage.ess.ni.communication.connection.NIConnectionFactory;
import com.ibm.storage.ess.ni.communication.extensions.NIHandler;
import com.ibm.storage.ess.ni.communication.extensions.NIHandlerMonitor;
import com.ibm.storage.ess.ni.communication.extensions.NIHeartbeatCommunication;
import com.ibm.storage.ess.ni.communication.extensions.NIInitiator;
import com.ibm.storage.ess.ni.communication.extensions.NILowLevelCommunication;
import com.ibm.storage.ess.ni.communication.extensions.common.NIACKCommunication;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientConnectionToken;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientInterface;
import com.ibm.storage.ess.ni.communication.extensions.common.NIClientUnavailableException;
import com.ibm.storage.ess.ni.communication.extensions.common.NICommunicationConstants;
import com.ibm.storage.ess.ni.communication.extensions.common.NIConnectionCommunication;
import com.ibm.storage.ess.ni.communication.extensions.common.NIDisconnectionCommunication;
import com.ibm.storage.ess.ni.communication.extensions.common.NIEventConnectionCommunication;
import com.ibm.storage.ess.ni.communication.extensions.common.NITokenUnavailableException;
import com.ibm.storage.ess.ni.communication.extensions.server.NICommunicationServer;
import com.ibm.storage.ess.ni.communication.extensions.server.NIResponseACKManager;
import com.ibm.storage.ess.ni.event.NIEventImpl;
import com.ibm.storage.ess.ni.exception.NIAuthenticationFailureException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.resource.NIUserAccountImpl;
import com.ibm.storage.ess.ni.security.NIClientAuthenticator;
import com.ibm.storage.ess.ni.security.NICommandAuthorizer;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseHelper;
import com.ibm.storage.ess.ni.security.NISecurityDatabaseManager;
import com.ibm.storage.ess.ni.security.NISecuritySynchronizer;
import com.ibm.storage.ess.ni.security.common.NIAuthenticationInfo;
import com.ibm.storage.ess.ni.security.common.NIAuthorizationInfo;
import com.ibm.storage.ess.ni.security.common.NISynchronizationData;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

public class NIClientConnection
implements NIHandlerMonitor,
NICommunicationConstants,
NIClientInterface {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$communication$extensions$server$NIClientConnection == null ? (class$com$ibm$storage$ess$ni$communication$extensions$server$NIClientConnection = NIClientConnection.class$("com.ibm.storage.ess.ni.communication.extensions.server.NIClientConnection")) : class$com$ibm$storage$ess$ni$communication$extensions$server$NIClientConnection);
    private static final int HASHCODE_OFFSET = 1000;
    private NIInitiator eventInitiator;
    private NIInitiator responseInitiator;
    private NIHandler commandHandler;
    private NIHandler eventHandler;
    private boolean responseHBNext = true;
    private NIClientConnectionToken token;
    private Object hbBarrier = new Object();
    private boolean hbACKReceived;
    private boolean connected = false;
    private NICommunicationServer server;
    private NIAuthenticationInfo authenticationInfo = null;
    private NIAuthorizationInfo authorizationInfo = null;
    private InetAddress clientAddress;
    private NIConnectionFactory connectionFactory = null;
    private NIClientAuthenticator clientAuthenticator = null;
    private NICommandAuthorizer commandAuthorizer = null;
    private NISecurityDatabaseHelper securityDatabase = null;
    private NISecuritySynchronizer syncObject;
    private boolean generateACKs = false;
    private boolean zipped = false;
    private boolean eventHBs = false;
    private boolean responseACKs = false;
    private String label = "<client #?> ";
    private NIAuditLogFileHandler auditLogFileHandler = NIAuditLogFileHandler.getInstance();
    private NIAuditLogTable auditLogTable = NIAuditLogTable.getInstance();
    private NIResponseACKManager responseACKManager = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$communication$extensions$server$NIClientConnection;

    NIClientConnection(NICommunicationServer nICommunicationServer, Socket socket) {
        this.server = nICommunicationServer;
        this.token = null;
        this.eventInitiator = null;
        this.connectionFactory = NIConnectionFactory.getConnectionFactory();
        this.clientAuthenticator = nICommunicationServer.getClientAuthenticator();
        this.commandAuthorizer = nICommunicationServer.getCommandAuthorizer();
        this.securityDatabase = NISecurityDatabaseManager.getDatabaseHelper();
        this.syncObject = NISecuritySynchronizer.getSecuritySynchronizer();
        this.clientAddress = socket.getInetAddress();
        this.responseACKManager = NIResponseACKManager.getSingleton();
        try {
            this.setResponseInitiator(new NIInitiator(socket, "responseInitiator"));
            this.setCommandHandler(new NIHandler(socket, null, "commandHandler"));
            this.commandHandler.start();
        }
        catch (IOException iOException) {
            logger.error("IOException occurred during init");
            logger.throwable((Throwable)iOException);
            this.handleConnectionProblem();
        }
    }

    synchronized void setCommandHandler(NIHandler nIHandler) {
        this.commandHandler = nIHandler;
        nIHandler.setMonitor(this);
    }

    synchronized void setEventConnection(NIInitiator nIInitiator, NIHandler nIHandler) {
        this.eventInitiator = nIInitiator;
        this.eventInitiator.setName("eventInitiator");
        this.eventHandler = nIHandler;
        this.eventHandler.setHandlerName("eventHandler");
        this.eventHandler.setMonitor(this);
        if (!this.eventHBs) {
            logger.debug_general(this.label + "the client will not heartbeat on the event socket, kill the handler");
            nIHandler.setDisconnecting();
        }
        if (this.responseInitiator != null) {
            if (this.zipped) {
                logger.debug_general(this.label + "zipped is true, telling event connection to goZipped");
                this.eventInitiator.goZipped();
                this.eventHandler.goZipped();
            } else {
                logger.debug_general(this.label + "zipped is false, leaving eventInitiator unzipped");
            }
            this.connected = true;
        } else {
            this.connected = false;
        }
    }

    synchronized void setResponseInitiator(NIInitiator nIInitiator) {
        this.responseInitiator = nIInitiator;
        this.connected = this.eventInitiator != null;
    }

    public void handleConnectionProblem(NIHandler nIHandler) {
        logger.debug_general(this.label + "handleConnectionProblem(NIHandler) called... disconnecting");
        if (this.connected) {
            this.server.disconnectClient(this.token, false);
            this.disconnect();
        }
    }

    private void handleConnectionProblem() {
        logger.debug_general(this.label + "handleConnectionProblem() called... disconnecting");
        if (this.connected) {
            this.server.disconnectClient(this.token, false);
            this.disconnect();
        }
    }

    public void handleUnsupportedCommunication(NIHandler nIHandler) {
        logger.warning(this.label + "unsupported communication received");
    }

    public void send(NIEvent nIEvent) throws NIClientUnavailableException, NIUnsupportedException {
        try {
            this.eventInitiator.send((NIEventImpl)nIEvent);
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
            this.handleConnectionProblem();
            throw new NIClientUnavailableException();
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            this.handleConnectionProblem();
            throw new NIClientUnavailableException();
        }
    }

    public void send(NICommand nICommand) throws NIClientUnavailableException, NIUnsupportedException {
        try {
            if (nICommand instanceof NISecurityCommand && nICommand.getMethodName().equals("modifyUserAccountPassword") && nICommand.retrieveResponseData() != null && ((NISecurityResult)nICommand.retrieveResponseData()).isSuccessful()) {
                String string = this.authenticationInfo.getUsername();
                String string2 = "";
                try {
                    string2 = (String)nICommand.getParameters()[0];
                }
                catch (Exception exception) {
                    logger.throwable((Throwable)exception);
                }
                if (this.isPasswordExpired() && string.equals(string2)) {
                    this.authorizationInfo = new NIAuthorizationInfo(string);
                } else if (!string.equals(string2)) {
                    NIUserAccountImpl nIUserAccountImpl = (NIUserAccountImpl)this.securityDatabase.getUserAccount(string2);
                    if (nIUserAccountImpl != null) {
                        logger.debug_general("Expiring user " + string2 + " because user " + string + " changed its password");
                        nIUserAccountImpl.setPasswordExpired();
                        NISynchronizationData nISynchronizationData = new NISynchronizationData(2, 1, nIUserAccountImpl, string2);
                        NISecurityResult nISecurityResult = this.syncObject.performRequest(nISynchronizationData);
                        if (!nISecurityResult.isSuccessful()) {
                            logger.error(this.label + "Failed to updated user " + string2 + " and return code is 0x" + Integer.toHexString(nISecurityResult.getCode()));
                        }
                    } else {
                        logger.error(this.label + "Attempted to expire user " + string2 + ", but was not found in database");
                    }
                }
            }
            this.responseInitiator.send(nICommand);
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
            this.handleConnectionProblem();
            throw new NIClientUnavailableException();
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            this.handleConnectionProblem();
            throw new NIClientUnavailableException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean testConnection() {
        boolean bl = false;
        try {
            Object object = this.hbBarrier;
            synchronized (object) {
                this.hbACKReceived = false;
                this.responseInitiator.send(new NIHeartbeatCommunication());
                if (this.generateACKs) {
                    this.hbBarrier.wait(25000L);
                    bl = this.hbACKReceived;
                } else {
                    bl = true;
                }
                if (!bl) {
                    logger.error(this.label + "heartbeat did not come back from client");
                    this.handleConnectionProblem();
                }
            }
        }
        catch (NIUnsupportedException nIUnsupportedException) {
            logger.error(this.label + "exception when trying to test connection");
            logger.throwable((Throwable)nIUnsupportedException);
            this.handleConnectionProblem();
        }
        catch (IOException iOException) {
            logger.error(this.label + "exception when trying to test connection");
            logger.throwable((Throwable)iOException);
            this.handleConnectionProblem();
        }
        catch (InterruptedException interruptedException) {
            logger.error(this.label + "exception when trying to test connection");
            logger.throwable((Throwable)interruptedException);
            this.handleConnectionProblem();
        }
        return bl;
    }

    void disconnect() {
        block8: {
            if (!this.connected) break block8;
            this.connected = false;
            try {
                this.eventInitiator.close();
            }
            catch (Exception exception) {
                logger.warning(this.label + "problem closing the event connection.  Ignored");
            }
            try {
                this.responseInitiator.close();
            }
            catch (Exception exception) {
                logger.warning(this.label + "problem closing the response connection.  Ignored");
            }
            try {
                this.commandHandler.close();
            }
            catch (Exception exception) {
                logger.warning(this.label + "problem closing the command handler.  Ignored");
            }
            try {
                this.eventHandler.close();
            }
            catch (Exception exception) {
                logger.warning(this.label + "problem closing the event handler.  Ignored");
            }
        }
    }

    public NIClientConnectionToken getToken() {
        return this.token;
    }

    public boolean equals(Object object) {
        if (object instanceof NIClientConnection) {
            return this.token.equals(((NIClientConnection)object).token);
        }
        return false;
    }

    public int hashCode() {
        return this.token.hashCode() + 1000;
    }

    public int getConnectionStatus() {
        int n = 0;
        if (this.connected) {
            n = 1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLowLevelCommunication(NILowLevelCommunication nILowLevelCommunication, NIHandler nIHandler) {
        block54: {
            boolean bl = true;
            if (nILowLevelCommunication instanceof NIEventConnectionCommunication) {
                NIEventConnectionCommunication nIEventConnectionCommunication = (NIEventConnectionCommunication)nILowLevelCommunication;
                NIClientConnectionToken nIClientConnectionToken = nIEventConnectionCommunication.getClientConnectionToken();
                logger.debug_general("NIEventConnectionCommunication received for client: " + nIClientConnectionToken);
                this.responseInitiator.setToken(nIClientConnectionToken);
                this.commandHandler.setToken(nIClientConnectionToken);
                NIClientConnection nIClientConnection = this.server.getClient(nIClientConnectionToken);
                try {
                    this.responseInitiator.send(nIEventConnectionCommunication);
                }
                catch (NIUnsupportedException nIUnsupportedException) {
                    logger.throwable((Throwable)nIUnsupportedException);
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                    iOException.printStackTrace();
                }
                nIClientConnection.setEventConnection(this.responseInitiator, this.commandHandler);
                this.responseInitiator = null;
                this.commandHandler = null;
                logger.debug_general(this.label + "completing the client connection");
                this.server.completeClientConnection(nIClientConnection);
            } else if (nILowLevelCommunication instanceof NIConnectionCommunication) {
                boolean bl2;
                int n;
                block51: {
                    logger.debug_general(this.label + "NIConnectionCommunication received");
                    n = 2;
                    bl2 = false;
                    NIConnectionCommunication nIConnectionCommunication = (NIConnectionCommunication)nILowLevelCommunication;
                    int n2 = nIConnectionCommunication.getVersionCode();
                    logger.debug_general(this.label + "versionCode reported by client is:" + n2);
                    boolean bl3 = this.generateACKs = n2 >= 1;
                    if (this.generateACKs) {
                        logger.debug_general(this.label + "client expects command ACKs");
                    }
                    if (n2 >= 2) {
                        this.zipped = true;
                        nIConnectionCommunication.setVersionCode(3);
                        logger.debug_general(this.label + "client uses zipped communication");
                    }
                    if (n2 >= 4) {
                        this.eventHBs = true;
                        nIConnectionCommunication.setVersionCode(5);
                        logger.debug_general(this.label + "client HBs on event connection");
                    }
                    if (n2 >= 6) {
                        this.responseACKs = true;
                        nIConnectionCommunication.setVersionCode(7);
                        logger.debug_general(this.label + "client ACKs responses");
                    }
                    try {
                        this.authenticationInfo = nIConnectionCommunication.getAuthenticationInfo();
                        int n3 = this.clientAuthenticator.isAuthenticated(this.authenticationInfo);
                        logger.debug_general(this.label + "isAuthenticated returned (" + n3 + ")");
                        if (n3 == 7) {
                            n = n3;
                            this.authorizationInfo = new NIAuthorizationInfo(this.authenticationInfo.getUsername());
                            if (nIConnectionCommunication.getClientConnectionToken() == null) {
                                logger.debug_general(this.label + "getting a new token");
                                this.token = this.server.getNewToken();
                                bl2 = true;
                            } else {
                                logger.debug_general(this.label + "testing the given token: " + nIConnectionCommunication.getClientConnectionToken());
                                bl2 = this.server.isNewToken(nIConnectionCommunication.getClientConnectionToken());
                                this.token = this.server.testOldToken(nIConnectionCommunication.getClientConnectionToken());
                            }
                            if (this.token == null) {
                                nIConnectionCommunication.setClientConnectionToken(null);
                                nIConnectionCommunication.handleException(new NITokenUnavailableException());
                                n = 2;
                            } else {
                                this.label = "<client #" + this.token + "> ";
                                this.server.addConnectingClient(this, this.token, nIHandler);
                                this.commandHandler.setToken(this.token);
                                this.responseInitiator.setToken(this.token);
                            }
                        } else {
                            nIConnectionCommunication.handleException(new NIAuthenticationFailureException(n3));
                            bl = false;
                            n = n3;
                            bl2 = true;
                        }
                        nIConnectionCommunication.setClientConnectionToken(this.token);
                        this.responseInitiator.send(nIConnectionCommunication);
                        if (bl) break block51;
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            logger.throwable((Throwable)interruptedException);
                        }
                        this.commandHandler.close();
                    }
                    catch (NIUnsupportedException nIUnsupportedException) {
                        logger.error(this.label + "UnsupportedException caught when sending back connection communication");
                        logger.throwable((Throwable)nIUnsupportedException);
                        this.handleConnectionProblem();
                        n = 2;
                    }
                    catch (NIUnavailableServerException nIUnavailableServerException) {
                        nIConnectionCommunication.setClientConnectionToken(null);
                        try {
                            this.responseInitiator.send(nIConnectionCommunication);
                        }
                        catch (NIUnsupportedException nIUnsupportedException) {
                            logger.error(this.label + "UnsupportedException caught when sending back connection communication");
                            logger.throwable((Throwable)nIUnavailableServerException);
                            this.handleConnectionProblem();
                        }
                        catch (IOException iOException) {
                            logger.error(this.label + "IOException caught when sending back connection communication (with null token)");
                            logger.throwable((Throwable)nIUnavailableServerException);
                            this.handleConnectionProblem();
                        }
                        n = 2;
                    }
                    catch (IOException iOException) {
                        logger.error(this.label + "IOException caught when sending back connection communication");
                        logger.throwable((Throwable)iOException);
                        this.handleConnectionProblem();
                        n = 2;
                    }
                }
                if (bl2) {
                    this.writeAuditLogEntry(n);
                }
                if (this.zipped) {
                    logger.debug_general(this.label + "zipped is true, setting response initiator and command handler to zipped");
                    this.responseInitiator.goZipped();
                    this.commandHandler.goZipped();
                } else {
                    logger.debug_general(this.label + "zipped is false, leaving response initiator and command handler unzipped");
                }
            } else if (nILowLevelCommunication instanceof NIDisconnectionCommunication) {
                logger.debug_general(this.label + "disconnecting");
                this.commandHandler.setDisconnecting();
                this.eventHandler.setDisconnecting();
                try {
                    this.responseInitiator.send(nILowLevelCommunication);
                }
                catch (NIUnsupportedException nIUnsupportedException) {
                    logger.error(this.label + "unsupported exception when echoing a disconnect comm back... impossible");
                    logger.throwable((Throwable)nIUnsupportedException);
                }
                catch (IOException iOException) {
                    logger.error(this.label + "IOException when echoing a disconnect back... ignore");
                    logger.throwable((Throwable)iOException);
                }
                try {
                    NIClientConnection nIClientConnection = this;
                    synchronized (nIClientConnection) {
                        this.wait(5000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    logger.debug_detailed(this.label + "interrupted while pausing during disconnect.. no problem");
                }
                this.server.disconnectClient(this.token, true);
                this.disconnect();
            } else if (nILowLevelCommunication instanceof NIHeartbeatCommunication) {
                NIHeartbeatCommunication nIHeartbeatCommunication = (NIHeartbeatCommunication)nILowLevelCommunication;
                try {
                    if (!this.generateACKs || !nIHeartbeatCommunication.isAck()) {
                        nIHeartbeatCommunication.setAck();
                        if (this.responseHBNext) {
                            this.responseInitiator.send(nIHeartbeatCommunication);
                        } else {
                            this.eventInitiator.send(nIHeartbeatCommunication);
                        }
                        this.responseHBNext = !this.responseHBNext;
                        break block54;
                    }
                    Object object = this.hbBarrier;
                    synchronized (object) {
                        this.hbACKReceived = true;
                        this.hbBarrier.notify();
                    }
                }
                catch (NIUnsupportedException nIUnsupportedException) {
                    logger.error(this.label + ": unsupported exception when echoing HB back");
                    logger.throwable((Throwable)nIUnsupportedException);
                    this.handleConnectionProblem();
                }
                catch (IOException iOException) {
                    logger.error(this.label + ": IO exception when echoing HB back");
                    logger.throwable((Throwable)iOException);
                    this.handleConnectionProblem();
                }
            } else if (nILowLevelCommunication instanceof NIACKCommunication) {
                this.responseACKManager.ackReceived((NIACKCommunication)nILowLevelCommunication);
            }
        }
    }

    public boolean doesResponseACKs() {
        return this.responseACKs;
    }

    public boolean isCommandAuthorized(NICommand nICommand) {
        return this.commandAuthorizer.isAuthorized(nICommand, this.authenticationInfo, this.authorizationInfo);
    }

    public boolean isPasswordExpired() {
        return this.authorizationInfo.isPasswordExpired();
    }

    public boolean isNewAccount() {
        return this.authorizationInfo.isNewAccount();
    }

    public NIClientDescriptor getNIClientDescriptor() {
        return new NIClientDescriptor(this.clientAddress, this.authenticationInfo.getUsername());
    }

    public void updateAuthorizations(String string) {
        if (this.authenticationInfo.getUsername().equals(string)) {
            this.authorizationInfo = new NIAuthorizationInfo(string);
        }
    }

    public void communicationReceived(NICommunication nICommunication, NIHandler nIHandler) {
        block3: {
            if (!this.generateACKs || !(nICommunication instanceof NICommand) || !((NICommand)nICommunication).isIdempotent()) break block3;
            NICommandID nICommandID = ((NICommand)nICommunication).getID();
            try {
                this.responseInitiator.send(new NIACKCommunication(nICommandID));
            }
            catch (NIUnsupportedException nIUnsupportedException) {
                logger.error(this.label + "unsupported exception caught when sending ACK for id:" + nICommandID);
                logger.throwable((Throwable)nIUnsupportedException);
            }
            catch (IOException iOException) {
                logger.error(this.label + "IOException caught when sending ACK for id:" + nICommandID);
                logger.throwable((Throwable)iOException);
                this.handleConnectionProblem();
            }
        }
    }

    public NIAuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    private void writeAuditLogEntry(int n) {
        try {
            NIAuditLogEntryImpl nIAuditLogEntryImpl = new NIAuditLogEntryImpl();
            nIAuditLogEntryImpl.setLogLocation(NIAuditLogUtil.getLogLocation());
            nIAuditLogEntryImpl.setUserName(this.authenticationInfo.getUsername());
            String string = "1000";
            if (n == 7) {
                n = 0;
                if (this.authorizationInfo.isPasswordExpired()) {
                    string = "1001";
                }
            } else {
                string = "1002";
            }
            nIAuditLogEntryImpl.setStaticFields(this.auditLogTable.getEntry(string));
            nIAuditLogEntryImpl.setExitCode(Integer.toHexString(n));
            nIAuditLogEntryImpl.setInputParam(this.getAuditLogInputParam());
            this.auditLogFileHandler.output(nIAuditLogEntryImpl);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
    }

    private String getAuditLogInputParam() {
        StringBuffer stringBuffer = new StringBuffer("IP = ");
        stringBuffer.append(this.clientAddress);
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

