/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.constants;

import com.ibm.storage.ess.ni.constants.NIConfigurationConstants;
import com.ibm.storage.ess.ni.option.config.NIRaidType;
import com.ibm.storage.ess.ni.option.config.NIRaidType10;
import com.ibm.storage.ess.ni.option.config.NIRaidType5;
import java.io.Serializable;

public class NIMachineTypeModel
implements Serializable {
    public static final long serialVersionUID = 1L;
    private static final int[] noOptionToReturn = new int[0];
    private static final int[] supportedDDMCapacities_2107 = new int[]{73000, 146000, 300000, 500000};
    private static final int[] supportedDDMCapacities_1750 = new int[]{73000, 146000, 300000, 500000};
    private static final int[] supportedDDMRPMs_2107 = new int[]{10000, 15000};
    private static final int[] supportedDDMRPMs_1750 = new int[]{10000, 15000};
    private static final NIRaidType[] noRaidTypes = new NIRaidType[0];
    public static final NIRaidType[] supportedRaidTypes_2107 = new NIRaidType[]{NIRaidType5.Option, NIRaidType10.Option};
    public static final NIRaidType[] supportedRaidTypes_1750 = new NIRaidType[]{NIRaidType5.Option, NIRaidType10.Option};
    private String machineType;
    private String modelNumber;
    private int maxNumImages;
    private int maxNumDDMPacks;
    private int maxNumAdapters;
    private int maxNumArraySites;
    private int maxNumArrays;
    private int maxNumRanks;
    private int maxNumExtPools;
    private int maxNumDAPairs;
    private int maxNumLSSs;
    private int maxNumAddGrps;
    private int maxNumVolumes;
    private int numDDMsPerSite;
    private int[] supportedDDMCapacities;
    private int[] supportedDDMRPMs;
    private NIRaidType[] supportedRaidTypes;

    public NIMachineTypeModel(String string, String string2) {
        this.machineType = string;
        this.modelNumber = string2;
        this.maxNumImages = 0;
        this.maxNumDDMPacks = 0;
        this.maxNumAdapters = 0;
        this.maxNumArraySites = 0;
        this.maxNumArrays = 0;
        this.maxNumRanks = 0;
        this.maxNumExtPools = 0;
        this.maxNumDAPairs = 0;
        this.maxNumLSSs = 0;
        this.maxNumAddGrps = 0;
        this.maxNumVolumes = 0;
        this.numDDMsPerSite = 0;
        this.supportedDDMCapacities = noOptionToReturn;
        this.supportedDDMRPMs = noOptionToReturn;
        this.supportedRaidTypes = noRaidTypes;
        if (this.machineType.equals("2107")) {
            if (this.modelNumber.equals("921")) {
                this.maxNumImages = 1;
                this.maxNumDDMPacks = 24;
                this.maxNumAdapters = 16;
                this.maxNumArraySites = 48;
                this.maxNumArrays = 48;
                this.maxNumRanks = 48;
                this.maxNumExtPools = 48;
                this.maxNumDAPairs = 4;
            } else if (this.modelNumber.equals("922") || this.modelNumber.equals("9A2")) {
                this.maxNumImages = 2;
                this.maxNumDDMPacks = 40;
                this.maxNumAdapters = 32;
                this.maxNumArraySites = 80;
                this.maxNumArrays = 80;
                this.maxNumRanks = 80;
                this.maxNumExtPools = 80;
                this.maxNumDAPairs = 8;
            }
            this.maxNumLSSs = 255;
            this.maxNumAddGrps = 16;
            this.maxNumVolumes = 65280;
            this.numDDMsPerSite = 8;
            this.supportedDDMCapacities = supportedDDMCapacities_2107;
            this.supportedDDMRPMs = supportedDDMRPMs_2107;
            this.supportedRaidTypes = supportedRaidTypes_2107;
        } else if (this.machineType.equals("1750")) {
            if (this.modelNumber.equals("511") || this.modelNumber.equals("522")) {
                this.maxNumDDMPacks = 56;
                this.maxNumAdapters = 1;
                this.maxNumArraySites = 56;
                this.maxNumArrays = 56;
                this.maxNumRanks = 56;
                this.maxNumExtPools = 56;
            }
            this.maxNumDAPairs = 1;
            this.maxNumImages = 1;
            this.maxNumLSSs = 32;
            this.maxNumAddGrps = 2;
            this.maxNumVolumes = NIConfigurationConstants.MAX_VOLUMES_PER_ESS_1750;
            this.numDDMsPerSite = 4;
            this.supportedDDMCapacities = supportedDDMCapacities_1750;
            this.supportedDDMRPMs = supportedDDMRPMs_1750;
            this.supportedRaidTypes = supportedRaidTypes_1750;
        }
    }

    public String getMachineType() {
        return this.machineType;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public int getMaxNumImages() {
        return this.maxNumImages;
    }

    public int getMaxNumDDMPack() {
        return this.maxNumDDMPacks;
    }

    public int getMaxNumAdapters() {
        return this.maxNumAdapters;
    }

    public int getMaxNumSites() {
        return this.maxNumArraySites;
    }

    public int getMaxNumArrays() {
        return this.maxNumArrays;
    }

    public int getMaxNumRanks() {
        return this.maxNumRanks;
    }

    public int getMaxNumExtPools() {
        return this.maxNumExtPools;
    }

    public int getMaxDAPairs() {
        return this.maxNumDAPairs;
    }

    public int getMaxLSSs() {
        return this.maxNumLSSs;
    }

    public int getMaxAddressGroups() {
        return this.maxNumAddGrps;
    }

    public int getMaxVolumes() {
        return this.maxNumVolumes;
    }

    public int getNumDDMsPerSite() {
        return this.numDDMsPerSite;
    }

    public int[] getSupportedDDMCapacities() {
        return this.supportedDDMCapacities;
    }

    public int[] getSupportedDDMRPMs() {
        return this.supportedDDMRPMs;
    }

    public NIRaidType[] getSupportedRaidTypes() {
        return this.supportedRaidTypes;
    }
}

