/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.event.extensions;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.event.extensions.NIAsyncPPRCEvent;
import com.ibm.storage.ess.ni.application.results.NIAsyncPPRCCGFailureInfo;
import com.ibm.storage.ess.ni.event.extensions.NICopyServicesEventImpl;
import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap;
import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap210;
import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap211;
import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap212;
import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap213;
import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap214;
import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap215;
import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap216;
import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap217;
import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap218;
import com.ibm.storage.ess.ni.eventManager.snmp.NISnmpTrap219;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NISessionID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NIAsyncPPRCCGFailureInfoImpl;
import com.ibm.storage.ess.ni.util.NIByteArray;
import java.util.Date;
import java.util.Vector;

public class NIAsyncPPRCEventImpl
extends NICopyServicesEventImpl
implements NIAsyncPPRCEvent {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$event$extensions$NISessionEventImpl == null ? (class$com$ibm$storage$ess$ni$event$extensions$NISessionEventImpl = NIAsyncPPRCEventImpl.class$("com.ibm.storage.ess.ni.event.extensions.NISessionEventImpl")) : class$com$ibm$storage$ess$ni$event$extensions$NISessionEventImpl);
    private static final long serialVersionUID = 1L;
    private static Class[] listenerTypes = null;
    private NIESSID essID = null;
    private NISessionID sessionID = null;
    private int asyncEvent = -1;
    private int asyncPPRCState = -1;
    private NIAsyncPPRCCGFailureInfo mostRecentCGFailureInfo = null;
    protected Vector snmpTrapList = new Vector();
    protected String subordinateSequenceNum = null;
    protected static int OFFSET = 28;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$event$extensions$NISessionEventImpl;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$application$event$extensions$NIAsyncPPRCEventListener;

    public NIAsyncPPRCEventImpl() {
    }

    public NIAsyncPPRCEventImpl(Date date, NISessionID nISessionID, NIESSID nIESSID, int n, int n2) {
        super(date);
        this.essID = nIESSID;
        this.sessionID = nISessionID;
        this.asyncEvent = n;
        this.asyncPPRCState = n2;
    }

    public Class[] getListenerTypes() {
        if (listenerTypes == null) {
            this.buildListenerTypes();
        }
        return listenerTypes;
    }

    private void buildListenerTypes() {
        Class[] classArray = super.getListenerTypes();
        listenerTypes = new Class[classArray.length + 1];
        NIAsyncPPRCEventImpl.listenerTypes[0] = class$com$ibm$storage$ess$ni$application$event$extensions$NIAsyncPPRCEventListener == null ? (class$com$ibm$storage$ess$ni$application$event$extensions$NIAsyncPPRCEventListener = NIAsyncPPRCEventImpl.class$("com.ibm.storage.ess.ni.application.event.extensions.NIAsyncPPRCEventListener")) : class$com$ibm$storage$ess$ni$application$event$extensions$NIAsyncPPRCEventListener;
        System.arraycopy(classArray, 0, listenerTypes, 1, classArray.length);
    }

    public void setData(byte[] byArray) {
        NISnmpTrap nISnmpTrap = null;
        int n = -1;
        NIByteArray nIByteArray = new NIByteArray();
        nIByteArray.setByteArray(byArray);
        nIByteArray.setBigEndian(true);
        this.asyncEvent = nIByteArray.extractInt(OFFSET + 4);
        this.asyncPPRCState = byArray[OFFSET + 10];
        String string = nIByteArray.extractString(8, 20);
        this.essID = new NIESSID("" + string);
        try {
            this.sessionID = new NISessionID(byArray[OFFSET + 2], byArray[OFFSET + 3]);
        }
        catch (Exception exception) {
            logger.error("Failed to construct session ID");
            logger.throwable((Throwable)exception);
        }
        n = NISessionID.getESSSessionID(this.sessionID.getSessionType(), this.sessionID.getSessionNumber());
        this.subordinateSequenceNum = nIByteArray.extractString(OFFSET + 12, 10);
        byte by = byArray[OFFSET + 22];
        short s = nIByteArray.extractShort(OFFSET + 24);
        byte by2 = byArray[OFFSET + 26];
        this.mostRecentCGFailureInfo = new NIAsyncPPRCCGFailureInfoImpl(this.subordinateSequenceNum, by, s, by2);
        switch (this.asyncEvent) {
            case 210: {
                nISnmpTrap = new NISnmpTrap210(string, n);
                break;
            }
            case 211: {
                nISnmpTrap = new NISnmpTrap211(string, n);
                break;
            }
            case 212: {
                nISnmpTrap = new NISnmpTrap212(string, n);
                break;
            }
            case 213: {
                nISnmpTrap = new NISnmpTrap213(string, n);
                break;
            }
            case 214: {
                nISnmpTrap = new NISnmpTrap214(string, n);
                break;
            }
            case 215: {
                nISnmpTrap = new NISnmpTrap215(string, n);
                break;
            }
            case 216: {
                nISnmpTrap = new NISnmpTrap216(string, n, this.subordinateSequenceNum);
                break;
            }
            case 217: {
                nISnmpTrap = new NISnmpTrap217(string, n);
                break;
            }
            case 218: {
                nISnmpTrap = new NISnmpTrap218(string, n);
                break;
            }
            case 219: {
                nISnmpTrap = new NISnmpTrap219(string, n);
            }
        }
        if (nISnmpTrap != null) {
            this.snmpTrapList.add(nISnmpTrap);
        }
    }

    public NIESSID getMasterESSID() {
        return this.essID;
    }

    public NISessionID getSessionID() {
        return this.sessionID;
    }

    public int getEventType() {
        return this.asyncEvent;
    }

    public int getAsyncPPRCState() {
        return this.asyncPPRCState;
    }

    public NIAsyncPPRCCGFailureInfo getMostRecentCGFailureInfo() {
        return this.mostRecentCGFailureInfo;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NIAsyncPPRCEvent [");
        stringBuffer.append("sessionID = " + this.sessionID + ", ");
        stringBuffer.append("MasterEssID = " + this.essID + ", ");
        stringBuffer.append("eventType = " + this.asyncEvent + ", ");
        stringBuffer.append("asyncPPRCState = " + this.asyncPPRCState + ", ");
        stringBuffer.append("CGFailureInfo = " + this.mostRecentCGFailureInfo + "]");
        return stringBuffer.toString();
    }

    public Vector getSnmpTraps() {
        return this.snmpTrapList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

