/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.event.extensions;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.resource.NIArraySiteConfiguration;
import com.ibm.storage.ess.ni.event.extensions.NIEventExtractionConstants;
import com.ibm.storage.ess.ni.identifiers.NIAddressGroupID;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIEnclosureID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model3;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model3TPF;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model6;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUTypeBS2000;
import com.ibm.storage.ess.ni.option.config.NIDataType;
import com.ibm.storage.ess.ni.option.config.NIDataType3380;
import com.ibm.storage.ess.ni.option.config.NIDataType3390;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock512;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Protected;
import com.ibm.storage.ess.ni.option.config.NIDataTypeBlock520Unprotected;
import com.ibm.storage.ess.ni.option.config.NIDeviceType;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB;
import com.ibm.storage.ess.ni.option.config.NIESSState;
import com.ibm.storage.ess.ni.option.config.NIESSStateFenced;
import com.ibm.storage.ess.ni.option.config.NIESSStateForcedQuiescing;
import com.ibm.storage.ess.ni.option.config.NIESSStateOffline;
import com.ibm.storage.ess.ni.option.config.NIESSStateOnline;
import com.ibm.storage.ess.ni.option.config.NIESSStateQuiescing;
import com.ibm.storage.ess.ni.option.config.NIESSStateQuiescingException;
import com.ibm.storage.ess.ni.option.config.NIESSStateResuming;
import com.ibm.storage.ess.ni.option.config.NIExtentType;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIExtentTypeFB;
import com.ibm.storage.ess.ni.option.config.NIFabricTopology;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyFCArbitratedLoop;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyScsiFcp;
import com.ibm.storage.ess.ni.option.config.NIFabricTopologyUnknown;
import com.ibm.storage.ess.ni.option.config.NIRaidType;
import com.ibm.storage.ess.ni.option.config.NIRaidType10;
import com.ibm.storage.ess.ni.option.config.NIRaidType5;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlMode;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlModeIndetermined;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlModeLocal;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteHMCAuto;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteHMCManual;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteHMCScheduled;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteHMCScheduledAuto;
import com.ibm.storage.ess.ni.option.config.NISFPowerControlModeRemoteS390PowerControl;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupType;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeCopyServices;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconAll;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeFiconEsconMixedMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520All;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSI520Mask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIAll;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMap256;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeGroupTypeSCSIMixedMask;
import com.ibm.storage.ess.ni.option.config.NIVolumeType;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDBase;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDCrossCUAlias;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDMap;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeCKDSingleCuAlias;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeFixedBlockBase;
import com.ibm.storage.ess.ni.option.config.NIVolumeTypeFixedBlockMap;
import com.ibm.storage.ess.ni.util.NIMtmsParser;

public class NIEventExtractor
implements NIEventExtractionConstants {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$event$extensions$NIEventExtractor == null ? (class$com$ibm$storage$ess$ni$event$extensions$NIEventExtractor = NIEventExtractor.class$("com.ibm.storage.ess.ni.event.extensions.NIEventExtractor")) : class$com$ibm$storage$ess$ni$event$extensions$NIEventExtractor);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$event$extensions$NIEventExtractor;

    public static int extractInt(byte[] byArray, int n, boolean bl) {
        if (bl) {
            return byArray[n] << 24 | byArray[n + 1] << 16 | byArray[n + 2] << 8 | byArray[n + 3];
        }
        return byArray[n + 3] << 24 | byArray[n + 2] << 16 | byArray[n + 1] << 8 | byArray[n];
    }

    public static long extractLong(byte[] byArray, int n, boolean bl) {
        if (bl) {
            return (long)byArray[n] << 56 | (long)byArray[n + 1] << 48 | (long)byArray[n + 2] << 40 | (long)byArray[n + 3] << 32 | (long)byArray[n + 4] << 24 | (long)byArray[n + 5] << 16 | (long)byArray[n + 6] << 8 | (long)byArray[n + 7];
        }
        return (long)byArray[n + 7] << 56 | (long)byArray[n + 6] << 48 | (long)byArray[n + 5] << 40 | (long)byArray[n + 4] << 32 | (long)byArray[n + 3] << 24 | (long)byArray[n + 2] << 16 | (long)byArray[n + 1] << 8 | (long)byArray[n];
    }

    public static String extractString(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n + n3] == 0) break;
            ++n3;
        }
        return new String(byArray, n, n3);
    }

    public static boolean extractBooleanZeroFalse(byte[] byArray, int n) {
        boolean bl = true;
        if ((byArray[n] | byArray[n + 1] | byArray[n + 2] | byArray[n + 3]) == 0) {
            bl = false;
        }
        return bl;
    }

    public static boolean extractBooleanZeroTrue(byte[] byArray, int n) {
        boolean bl = false;
        if ((byArray[n] | byArray[n + 1] | byArray[n + 2] | byArray[n + 3]) == 0) {
            bl = true;
        }
        return bl;
    }

    public static NIExtentType extractNIExtentType(int n) {
        NIExtentType nIExtentType = null;
        if (n == 4) {
            nIExtentType = NIExtentTypeFB.Option;
        } else if (n == 132) {
            nIExtentType = NIExtentTypeCKD.Option;
        } else {
            logger.error("parsed invalid extent type [" + n + "]... returning null NIExtentType");
        }
        return nIExtentType;
    }

    public static NIRankID extractNIRankID(NIESSID nIESSID, int n) {
        NIRankID nIRankID = null;
        nIRankID = new NIRankID(nIESSID, n);
        return nIRankID;
    }

    public static NIExtentPoolID extractNIExtentPoolID(NIESSID nIESSID, int n) {
        NIExtentPoolID nIExtentPoolID = null;
        nIExtentPoolID = new NIExtentPoolID(nIESSID, n);
        return nIExtentPoolID;
    }

    public static NIRaidType extractNIRaidType(String string) {
        NIRaidType nIRaidType = null;
        if (string.compareTo("RAID5") == 0) {
            nIRaidType = NIRaidType5.Option;
        } else if (string.compareTo("RAID10") == 0) {
            nIRaidType = NIRaidType10.Option;
        } else {
            logger.error("parsed invalid raid type [" + string + "]... returning null NIRaidType");
        }
        return nIRaidType;
    }

    public static NIArrayID extractNIArrayID(NIESSID nIESSID, int n) {
        NIArrayID nIArrayID = null;
        nIArrayID = new NIArrayID(nIESSID, n);
        return nIArrayID;
    }

    public static NIArraySiteConfiguration extractNIArraySiteConfiguration(String string) {
        NIArraySiteConfiguration nIArraySiteConfiguration = null;
        if (string.compareTo("6+P+S") == 0) {
            nIArraySiteConfiguration = new NIArraySiteConfiguration(1, 1);
        } else if (string.compareTo("3*2+2S") == 0) {
            nIArraySiteConfiguration = new NIArraySiteConfiguration(2, 0);
        } else if (string.compareTo("7+P") == 0) {
            nIArraySiteConfiguration = new NIArraySiteConfiguration(0, 1);
        } else if (string.compareTo("4*2") == 0) {
            nIArraySiteConfiguration = new NIArraySiteConfiguration(0, 0);
        } else {
            logger.error("parsed invalid array site configuration [" + string + "].. returning null NIArraySiteConfiguration");
        }
        return nIArraySiteConfiguration;
    }

    public static NIArraySiteID extractNIArraySiteID(NIESSID nIESSID, int n) {
        NIArraySiteID nIArraySiteID = null;
        nIArraySiteID = new NIArraySiteID(nIESSID, n);
        return nIArraySiteID;
    }

    public static NIVolumeType extractNIVolumeType(int n) {
        NIVolumeType nIVolumeType = null;
        switch (n) {
            case 10: {
                nIVolumeType = NIVolumeTypeCKDBase.Option;
                break;
            }
            case 11: {
                nIVolumeType = NIVolumeTypeCKDSingleCuAlias.Option;
                break;
            }
            case 12: {
                nIVolumeType = NIVolumeTypeCKDCrossCUAlias.Option;
                break;
            }
            case 13: {
                nIVolumeType = NIVolumeTypeCKDMap.Option;
                break;
            }
            case 20: {
                nIVolumeType = NIVolumeTypeFixedBlockBase.Option;
                break;
            }
            case 21: {
                nIVolumeType = NIVolumeTypeFixedBlockMap.Option;
                break;
            }
            default: {
                logger.error("parsed invalid volume type [" + n + "].. returning null NIVolumeType");
            }
        }
        return nIVolumeType;
    }

    public static NIAddressGroupID extractNIAddressGroupID(NIESSID nIESSID, String string) {
        NIAddressGroupID nIAddressGroupID = null;
        nIAddressGroupID = new NIAddressGroupID(nIESSID, Integer.parseInt(string, 16));
        return nIAddressGroupID;
    }

    public static NIVolumeGroupID extractNIVolumeGroupID(NIESSID nIESSID, int n) {
        NIVolumeGroupID nIVolumeGroupID = null;
        nIVolumeGroupID = new NIVolumeGroupID(nIESSID, n);
        return nIVolumeGroupID;
    }

    public static NIDataType extractNIDataType(int n) {
        NIDataType nIDataType = null;
        switch (n) {
            case 0: {
                nIDataType = NIDataTypeBlock512.Option;
                break;
            }
            case 1: {
                nIDataType = NIDataTypeBlock520Protected.Option;
                break;
            }
            case 2: {
                nIDataType = NIDataTypeBlock520Unprotected.Option;
                break;
            }
            case 10: {
                nIDataType = NIDataType3380.Option;
                break;
            }
            case 11: {
                nIDataType = NIDataType3390.Option;
                break;
            }
            default: {
                logger.error("parsed unknown data type [" + n + "]... returning null NIDataType");
            }
        }
        return nIDataType;
    }

    public static NIVolumeGroupType extractNIVolumeGroupType(int n) {
        NIVolumeGroupType nIVolumeGroupType = null;
        switch (n) {
            case 10: {
                nIVolumeGroupType = NIVolumeGroupTypeFiconEsconAll.Option;
                break;
            }
            case 11: {
                nIVolumeGroupType = NIVolumeGroupTypeFiconEsconMask.Option;
                break;
            }
            case 12: {
                nIVolumeGroupType = NIVolumeGroupTypeFiconEsconMixedMask.Option;
                break;
            }
            case 20: {
                nIVolumeGroupType = NIVolumeGroupTypeSCSIAll.Option;
                break;
            }
            case 21: {
                nIVolumeGroupType = NIVolumeGroupTypeSCSIMask.Option;
                break;
            }
            case 22: {
                nIVolumeGroupType = NIVolumeGroupTypeSCSIMap256.Option;
                break;
            }
            case 23: {
                nIVolumeGroupType = NIVolumeGroupTypeSCSIMixedMask.Option;
                break;
            }
            case 30: {
                nIVolumeGroupType = NIVolumeGroupTypeSCSI520All.Option;
                break;
            }
            case 31: {
                nIVolumeGroupType = NIVolumeGroupTypeSCSI520Mask.Option;
                break;
            }
            case 80: {
                nIVolumeGroupType = NIVolumeGroupTypeCopyServices.Option;
                break;
            }
            default: {
                logger.error("parsed invalid volume group type [" + n + "].. returning null NIVolumeGroupType");
            }
        }
        return nIVolumeGroupType;
    }

    public static NIDeviceType extractNIDeviceType(String string) {
        NIDeviceType nIDeviceType = null;
        if (string.compareTo("CKD") == 0) {
            nIDeviceType = NIDeviceTypeCKD.Option;
        } else if (string.compareTo("FB") == 0) {
            nIDeviceType = NIDeviceTypeFB.Option;
        } else {
            logger.error("parsed invalid device type [" + string + "].. returning null NIDeviceType");
        }
        return nIDeviceType;
    }

    public static NISFPowerControlMode extractNISFPowerControlMode(int n) {
        NISFPowerControlMode nISFPowerControlMode = null;
        switch (n) {
            case 0: {
                nISFPowerControlMode = NISFPowerControlModeLocal.Option;
                break;
            }
            case 1: {
                nISFPowerControlMode = NISFPowerControlModeRemoteHMCManual.Option;
                break;
            }
            case 2: {
                nISFPowerControlMode = NISFPowerControlModeRemoteHMCScheduled.Option;
                break;
            }
            case 3: {
                nISFPowerControlMode = NISFPowerControlModeRemoteHMCAuto.Option;
                break;
            }
            case 4: {
                nISFPowerControlMode = NISFPowerControlModeRemoteHMCScheduledAuto.Option;
                break;
            }
            case 5: {
                nISFPowerControlMode = NISFPowerControlModeRemoteS390PowerControl.Option;
                break;
            }
            default: {
                logger.error("parsed invalid power control mode [" + n + "].. returning NISFPowerControlModeIndetermined");
                nISFPowerControlMode = NISFPowerControlModeIndetermined.Option;
            }
        }
        return nISFPowerControlMode;
    }

    public static NIESSState extractNIESSState(int n) {
        NIESSState nIESSState = null;
        switch (n) {
            case 0: {
                nIESSState = NIESSStateOnline.Option;
                break;
            }
            case 1: {
                nIESSState = NIESSStateOffline.Option;
                break;
            }
            case 2: {
                nIESSState = new NIESSStateResuming(){
                    private static final long serialVersionUID = 1L;

                    public String toString() {
                        return "NIESSStateResuming";
                    }
                };
                break;
            }
            case 3: {
                nIESSState = new NIESSStateQuiescing(){
                    private static final long serialVersionUID = 1L;

                    public String toString() {
                        return "NIESSStateQuiescing";
                    }
                };
                break;
            }
            case 4: {
                nIESSState = new NIESSStateQuiescingException(){
                    private static final long serialVersionUID = 1L;

                    public String toString() {
                        return "NIESSStateQuiescingException";
                    }
                };
                break;
            }
            case 5: {
                nIESSState = new NIESSStateForcedQuiescing(){
                    private static final long serialVersionUID = 1L;

                    public String toString() {
                        return "NIESSStateForcedQuiescing";
                    }
                };
                break;
            }
            case 6: {
                nIESSState = new NIESSStateFenced(){
                    private static final long serialVersionUID = 1L;

                    public String toString() {
                        return "NIESSStateFenced";
                    }
                };
                break;
            }
            default: {
                logger.error("parsed invalid ess state [" + n + "].. returning null NIESSState");
            }
        }
        return nIESSState;
    }

    public static NIFabricTopology extractNIFabricTopology(int n) {
        NIFabricTopology nIFabricTopology = null;
        switch (n) {
            case 0: {
                nIFabricTopology = NIFabricTopologyUnknown.Option;
                break;
            }
            case 1: {
                nIFabricTopology = NIFabricTopologyScsiFcp.Option;
                break;
            }
            case 2: {
                nIFabricTopology = NIFabricTopologyFCArbitratedLoop.Option;
                break;
            }
            default: {
                logger.error("parsed invalid fabric topology [" + n + "].. returnig null NIFabricTopology");
            }
        }
        return nIFabricTopology;
    }

    public static NISCSIHostPortID extractNISCSIHostPortID(NIESSID nIESSID, int n) {
        return new NISCSIHostPortID(nIESSID, n);
    }

    public static NILSSID extractNILSSID(NIESSID nIESSID, String string) {
        NILSSID nILSSID = null;
        nILSSID = new NILSSID(nIESSID, Integer.parseInt(string, 16));
        return nILSSID;
    }

    public static NICKDBaseCUType extractNICKDBaseCUType(int n) {
        NICKDBaseCUType nICKDBaseCUType = null;
        switch (n) {
            case 0: {
                nICKDBaseCUType = NICKDBaseCUType3990Model3.Option;
                break;
            }
            case 1: {
                nICKDBaseCUType = NICKDBaseCUType3990Model3TPF.Option;
                break;
            }
            case 2: {
                nICKDBaseCUType = NICKDBaseCUType3990Model6.Option;
                break;
            }
            case 4: {
                nICKDBaseCUType = NICKDBaseCUTypeBS2000.Option;
                break;
            }
            default: {
                logger.error("parsed invalid base cu type [" + n + "].. returning null NICKDBaseCUType");
            }
        }
        return nICKDBaseCUType;
    }

    public static NIEnclosureID extractNIEnclosureID(NIESSID nIESSID, String string) {
        NIEnclosureID nIEnclosureID = null;
        NIMtmsParser nIMtmsParser = new NIMtmsParser(string);
        nIEnclosureID = new NIEnclosureID(nIESSID, nIMtmsParser.getType(), nIMtmsParser.getModel(), nIMtmsParser.getSequence());
        return nIEnclosureID;
    }

    public static NIESSID extractNIESSID(String string) {
        return new NIESSID(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

