/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.eventManager.agent;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.event.NIEventImpl;
import com.ibm.storage.ess.ni.event.NIEventLostEventImpl;
import com.ibm.storage.ess.ni.eventManager.agent.NIEventProcessor;
import com.ibm.storage.ess.ni.eventManager.common.NIEventFactory;
import com.ibm.storage.ess.ni.eventManager.common.NIEventQueue;
import com.ibm.storage.ess.ni.eventManager.common.NIEventType;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.util.NIQueueFullException;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;

public class NIServerSocketThread
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$eventManager$agent$NIServerSocketThread == null ? (class$com$ibm$storage$ess$ni$eventManager$agent$NIServerSocketThread = NIServerSocketThread.class$("com.ibm.storage.ess.ni.eventManager.agent.NIServerSocketThread")) : class$com$ibm$storage$ess$ni$eventManager$agent$NIServerSocketThread);
    private boolean interrupted;
    private ServerSocket serverSocket;
    private static final int PORT_ADDRESS = 1722;
    private static final int EA_VERSION = 124439;
    private static final int SERVER_SOCKET_WAIT_TIME = 60000;
    private NIEventFactory eventFactory;
    private NIEventQueue eventQueue;
    private NIEventProcessor eventProcessor;
    private boolean singleConnection = false;
    private NIEAIProcessorThread openConnection = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$eventManager$agent$NIServerSocketThread;

    public NIServerSocketThread(NIEventFactory nIEventFactory, NIEventProcessor nIEventProcessor, boolean bl) {
        super("NIServerSocketThread");
        this.eventQueue = nIEventProcessor.getEventQueue();
        this.eventFactory = nIEventFactory;
        this.interrupted = false;
        this.eventProcessor = nIEventProcessor;
        this.singleConnection = bl;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        while (!this.interrupted) {
            NIServerSocketThread.logger.debug_general("NIServerSocketThread: creating the server socket");
            try {
                this.serverSocket = new ServerSocket(1722, 4);
                if (true) ** GOTO lbl31
            }
            catch (IOException var3_4) {
                NIServerSocketThread.logger.error("IOException caught when trying to establish server socket... will retry in a minute");
                NIServerSocketThread.logger.throwable((Throwable)var3_4);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException var4_6) {
                    NIServerSocketThread.logger.error("Interrupted while sleeping to retry socket establish");
                    NIServerSocketThread.logger.throwable((Throwable)var4_6);
                }
                continue;
            }
            do {
                try {
                    NIServerSocketThread.logger.debug_general("NIServerSocketThread: accepting the client socket");
                    var1_1 = this.serverSocket.accept();
                    NIServerSocketThread.logger.debug_general("NIServerSocketThread: socket accepted, creating processor thread");
                    var2_2 = new NIEAIProcessorThread(var1_1);
                    var2_2.start();
                    if (!this.singleConnection) continue;
                    if (this.openConnection != null) {
                        this.openConnection.terminate();
                    }
                    this.openConnection = var2_2;
                }
                catch (Exception var3_5) {
                    NIServerSocketThread.logger.debug_general("in server run" + var3_5.toString());
                    NIServerSocketThread.logger.throwable((Throwable)var3_5);
                }
lbl31:
                // 4 sources

            } while (!this.interrupted);
        }
    }

    public void shutDown() {
        logger.debug_general("NIServerSocketThread: Shutting down");
        this.interrupted = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
        }
        this.interrupt();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NIEAIProcessorThread
    extends Thread {
        private static final int BUFFER_SIZE = 16384;
        Socket clientSocket;
        private byte[] data;
        private DataInputStream inputStream;
        private int classID;
        private int objectType;
        private int sizeOfEvent;
        private NIEventType mtype;
        private int eaiVersion;

        public NIEAIProcessorThread(Socket socket) {
            super("NIEAIProcessorThread");
            this.data = new byte[16384];
            this.clientSocket = socket;
        }

        public synchronized void terminate() {
            block5: {
                logger.debug_general("terminating NIEAIProcessorThread" + this.clientSocket);
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                    }
                    catch (Exception exception) {
                        logger.error("caught exception when closing input stream");
                        logger.throwable((Throwable)exception);
                    }
                }
                if (this.clientSocket == null) break block5;
                try {
                    this.clientSocket.close();
                }
                catch (Exception exception) {
                    logger.error("exception caught when closing socket");
                    logger.throwable((Throwable)exception);
                }
            }
        }

        public void run() {
            boolean bl;
            boolean bl2;
            block22: {
                bl2 = false;
                boolean bl3 = true;
                bl = false;
                try {
                    this.inputStream = new DataInputStream(this.clientSocket.getInputStream());
                    bl2 = true;
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                    logger.error("NIEAIProcessorThread: couldn't create input stream");
                    bl2 = false;
                }
                if (bl2 && !NIServerSocketThread.this.interrupted && !bl) {
                    try {
                        logger.debug_detailed("NIEAIProcessorThread: created stream, reading eai metadata");
                        this.eaiVersion = this.inputStream.readInt();
                        if (this.eaiVersion == 124439) {
                            logger.debug_general("NIEAIProcessorThread: connection accepted for EAI version " + this.eaiVersion);
                            break block22;
                        }
                        logger.error("EA/EAI version mismatch!!!  EA (java) version = 124439  EAI (c) version = " + this.eaiVersion);
                        logger.error("Make sure that the EAI library (libnieai.a) is from the same build as the jar");
                        bl = true;
                    }
                    catch (IOException iOException) {
                        logger.throwable((Throwable)iOException);
                        logger.error("NIEAIProcessorThread: couldn't read version number");
                        bl = true;
                    }
                }
            }
            while (this.inputStream != null && bl2 && !NIServerSocketThread.this.interrupted && !bl) {
                NIEventImpl nIEventImpl;
                try {
                    logger.debug_detailed("NIEAIProcessorThread: created stream, reading classID");
                    this.classID = this.inputStream.readInt();
                    logger.debug_detailed("classID = [" + Integer.toHexString(this.classID) + "], reading objetcType");
                    this.objectType = this.inputStream.readInt();
                    logger.trace("objectType = [" + Integer.toHexString(this.objectType) + "], reading sizeOfEvent");
                    this.sizeOfEvent = this.inputStream.readInt();
                    logger.debug_detailed("sizeOfEvent = [" + Integer.toHexString(this.sizeOfEvent) + "], reading data");
                    if (this.sizeOfEvent > 16384) {
                        logger.error("size received [" + this.sizeOfEvent + "] is bigger than buffer... out of sync with EAI.. closing");
                        nIEventImpl = new NIEventLostEventImpl(new Date(), 5);
                        try {
                            logger.debug_general("NIEAIProcessorThread: enqueuing event: " + nIEventImpl);
                            NIServerSocketThread.this.eventQueue.enqueueEvent(nIEventImpl);
                        }
                        catch (NIQueueFullException nIQueueFullException) {
                            logger.debug_general("NIEAIProcessorThread: Event Agent queue is full, Event: " + nIEventImpl + " was discarded");
                            logger.throwable((Throwable)nIQueueFullException);
                        }
                        bl = true;
                        continue;
                    }
                    this.inputStream.readFully(this.data, 0, this.sizeOfEvent);
                    logger.debug_detailed(this.sizeOfEvent + " bytes read");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\n{{Event data received: }}\n{{");
                    int n = 0;
                    while (n < this.sizeOfEvent) {
                        if (n > 0 && n % 16 == 0) {
                            stringBuffer.append("}}\n{{");
                        }
                        stringBuffer.append(Integer.toHexString(this.data[n] & 0xFF) + " ");
                        ++n;
                    }
                    logger.debug_general(stringBuffer.toString() + "}}");
                    nIEventImpl = null;
                    try {
                        this.mtype = new NIEventType(this.classID, this.objectType);
                        nIEventImpl = NIServerSocketThread.this.eventFactory.createNIEventImplInstance(this.mtype);
                    }
                    catch (Exception exception) {
                        logger.debug_general("NIEAIProcessorThread: Invalid event ClassID=" + this.classID + " ObjectType=" + this.objectType);
                        continue;
                    }
                    if (nIEventImpl != null) {
                        logger.debug_general("calling set data for event: " + nIEventImpl);
                        nIEventImpl.setData(this.data);
                        logger.debug_general("calling processEvent for " + nIEventImpl);
                        NIServerSocketThread.this.eventProcessor.processEvent(nIEventImpl);
                        continue;
                    }
                    logger.debug_general("NIEAIProcessorThread: Error constructing new event object for ClassID=" + this.classID + " ObjectType=" + this.objectType);
                }
                catch (EOFException eOFException) {
                    logger.debug_general("NIEAIProcessorThread: EAI disconnected");
                    bl2 = false;
                }
                catch (IOException iOException) {
                    logger.debug_general("IOException caught.... closing");
                    logger.throwable((Throwable)iOException);
                    bl = true;
                }
                catch (Exception exception) {
                    logger.throwable((Throwable)exception);
                    nIEventImpl = new NIEventLostEventImpl(new Date(), 5);
                    try {
                        logger.debug_general("NIEAIProcessorThread: enqueuing event: " + nIEventImpl);
                        NIServerSocketThread.this.eventQueue.enqueueEvent(nIEventImpl);
                    }
                    catch (NIQueueFullException nIQueueFullException) {
                        logger.debug_general("NIEAIProcessorThread: Event Agent queue is full, Event: " + nIEventImpl + " was discarded");
                        logger.throwable((Throwable)nIQueueFullException);
                    }
                }
            }
            if (bl2) {
                this.terminate();
            }
            logger.debug_general("NIEAIProcessorThread shutting down");
        }
    }
}

