/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.identifiers;

import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIEnclosureID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import java.io.IOException;
import java.io.ObjectInputStream;

public class NIFRUID
extends NIResourceID {
    private static final long serialVersionUID = 1L;
    private NIESSID essImage;
    private String machineType;
    private String model;
    private String sequence;
    private NIEnclosureID enclosureID;
    private String serialNumber;
    private String partNumber;
    private transient Class type;
    private String typeString;
    private String locationCode;

    public NIFRUID(NIESSID nIESSID, String string, String string2, String string3, String string4, String string5, String string6, Class clazz) {
        this.essImage = nIESSID;
        this.machineType = string;
        this.model = string2;
        this.sequence = string3;
        this.serialNumber = string4;
        this.partNumber = string5;
        this.locationCode = string6;
        this.type = clazz;
        if (clazz != null) {
            this.typeString = clazz.getName();
        }
        this.enclosureID = new NIEnclosureID(nIESSID, string, string2, string3);
    }

    public NIFRUID(NIEnclosureID nIEnclosureID, String string, String string2, String string3, Class clazz) {
        this.enclosureID = nIEnclosureID;
        this.serialNumber = string;
        this.partNumber = string2;
        this.locationCode = string3;
        this.type = clazz;
        if (clazz != null) {
            this.typeString = clazz.getName();
        }
        this.essImage = nIEnclosureID.getESS();
        this.machineType = nIEnclosureID.getType();
        this.model = nIEnclosureID.getModel();
        this.sequence = nIEnclosureID.getSerialNumber();
    }

    public NIESSID getESS() {
        return this.essImage;
    }

    public String getMachineType() {
        return this.machineType;
    }

    public String getModel() {
        return this.model;
    }

    public String getSequenceNum() {
        return this.sequence;
    }

    public NIEnclosureID getEnclosureID() {
        return this.enclosureID;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String toString() {
        return this.enclosureID.toString() + "/FRU:" + this.serialNumber + "." + this.typeString + "." + this.partNumber + "." + this.locationCode;
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object == null || this.getClass() != object.getClass()) {
            return n;
        }
        NIFRUID nIFRUID = (NIFRUID)object;
        n = this.essImage.compareTo(nIFRUID.essImage);
        if (n == 0) {
            if (this.model != null && nIFRUID.model != null) {
                n = nIFRUID.model.compareTo(this.model);
            } else if (this.model != null) {
                n = -1;
            } else if (nIFRUID.model != null) {
                n = 1;
            }
        }
        if (n == 0) {
            if (this.sequence != null && nIFRUID.sequence != null) {
                n = nIFRUID.sequence.compareTo(this.sequence);
            } else if (this.sequence != null) {
                n = -1;
            } else if (nIFRUID.sequence != null) {
                n = 1;
            }
        }
        return n;
    }

    public int hashCode() {
        return this.essImage.hashCode() + this.model.hashCode() + this.sequence.hashCode() + this.getClass().hashCode();
    }

    public String getLocationCode() {
        return this.locationCode;
    }

    public String getPartNumber() {
        return this.partNumber;
    }

    public Class getType() {
        return this.type;
    }

    public void setLocationCode(String string) {
        this.locationCode = string;
    }

    public void setPartNumber(String string) {
        this.partNumber = string;
    }

    public void setSerialNumber(String string) {
        this.serialNumber = string;
    }

    public void setType(Class clazz) {
        this.type = clazz;
        if (this.type != null) {
            this.typeString = this.type.getName();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.typeString != null) {
            this.type = Class.forName(this.typeString);
        }
    }
}

