/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.identifiers;

import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.identifiers.NIStoragePlexID;
import com.ibm.storage.ess.ni.util.NIMtmsParser;

public class NIStorageFacilityID
extends NIResourceID {
    private static final long serialVersionUID = 1L;
    public static final String IBM_MANUFACTURER = "IBM";
    public static final long WWNN_UNKNOWN = 0L;
    private String type;
    private String manufactureplant;
    private String sequence;
    private long wwnn;
    private NIStoragePlexID offlinePlexID;
    private NIESSID essID;

    public NIStorageFacilityID(String string, String string2, String string3, long l) {
        this.type = string;
        this.manufactureplant = string2;
        this.sequence = string3;
        this.wwnn = l;
        this.offlinePlexID = null;
        this.essID = new NIESSID(this, 1);
    }

    public NIStorageFacilityID(NIESSID nIESSID) {
        this.type = nIESSID.getType();
        this.manufactureplant = nIESSID.getManufacturePlant();
        this.sequence = nIESSID.getSequence();
        this.wwnn = nIESSID.getWWNN();
        this.offlinePlexID = null;
        this.essID = nIESSID;
    }

    public NIStorageFacilityID(String string) {
        NIMtmsParser nIMtmsParser = new NIMtmsParser(string);
        this.type = nIMtmsParser.getType();
        this.manufactureplant = nIMtmsParser.getManufacturePlant();
        this.sequence = nIMtmsParser.getSequence();
        this.wwnn = 0L;
        NIStorageFacilityID nIStorageFacilityID = new NIStorageFacilityID(this.type, this.manufactureplant, this.sequence, this.wwnn);
        this.essID = new NIESSID(this, 1);
    }

    public NIStorageFacilityID(String string, String string2, String string3, long l, NIStoragePlexID nIStoragePlexID) {
        this.type = string;
        this.manufactureplant = string2;
        this.sequence = string3;
        this.wwnn = l;
        this.offlinePlexID = nIStoragePlexID;
    }

    public NIStorageFacilityID(NIESSID nIESSID, NIStoragePlexID nIStoragePlexID) {
        this.type = nIESSID.getType();
        this.manufactureplant = nIESSID.getManufacturePlant();
        this.sequence = nIESSID.getSequence();
        this.wwnn = nIESSID.getWWNN();
        this.offlinePlexID = null;
        this.essID = nIESSID;
        this.offlinePlexID = nIStoragePlexID;
    }

    public String getManufacturer() {
        return IBM_MANUFACTURER;
    }

    public String getType() {
        return this.type;
    }

    public String getManufacturePlant() {
        return this.manufactureplant;
    }

    public String getSequence() {
        return this.sequence;
    }

    public long getWWNN() {
        return this.wwnn;
    }

    public NIStoragePlexID getStoragePlex() {
        return this.offlinePlexID;
    }

    public void setSequence(String string) {
        this.sequence = string;
    }

    public String toString() {
        return "IBM." + this.type + "-" + this.manufactureplant + this.getSequence();
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object == null || this.getClass() != object.getClass()) {
            return n;
        }
        NIStorageFacilityID nIStorageFacilityID = (NIStorageFacilityID)object;
        if (this.sequence != null && nIStorageFacilityID.sequence != null) {
            n = nIStorageFacilityID.sequence.compareTo(this.sequence);
        } else if (this.sequence != null) {
            n = -1;
        } else if (nIStorageFacilityID.sequence != null) {
            n = 1;
        }
        if (n == 0) {
            if (this.type != null && nIStorageFacilityID.type != null) {
                n = nIStorageFacilityID.type.compareTo(this.type);
            } else if (this.type != null) {
                n = -1;
            } else if (nIStorageFacilityID.type != null) {
                n = 1;
            }
        }
        return n;
    }

    public int hashCode() {
        return this.sequence.hashCode() + this.type.hashCode() + this.getClass().hashCode();
    }

    public NIESSID getESS() {
        return this.essID;
    }

    public boolean isOffline() {
        return this.offlinePlexID != null;
    }
}

