/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class NIBroadcastMessage {
    private static final int N_MESSAGE_FIELDS = 7;
    private static final char FIELD_SEPARATOR = '/';
    private InetAddress ip1;
    private InetAddress ip2;
    private String serverName;
    private int port;
    private int secondaryPort;
    private String domainGroupID;
    private String storagePlexName;

    public NIBroadcastMessage(byte[] byArray) throws Exception {
        String string = new String(byArray);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n = stringTokenizer.countTokens();
        if (n < 7 && n >= 1) {
            throw new NIMessageRouterException("MR Broadcast Exception: Incomplete message from " + stringTokenizer.nextToken());
        }
        if (n < 7) {
            throw new NIMessageRouterException("MR Broadcast Exception: Incomplete broadcast message.  Unable to read message.");
        }
        if (n == 8) {
            this.serverName = stringTokenizer.nextToken();
            this.ip1 = InetAddress.getByName(stringTokenizer.nextToken());
            this.ip2 = InetAddress.getByName(stringTokenizer.nextToken());
            this.port = Integer.parseInt(stringTokenizer.nextToken());
            this.domainGroupID = stringTokenizer.nextToken();
            this.storagePlexName = stringTokenizer.nextToken();
            this.secondaryPort = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (n == 7) {
            this.serverName = stringTokenizer.nextToken();
            this.ip1 = InetAddress.getByName(stringTokenizer.nextToken());
            this.ip2 = InetAddress.getByName(stringTokenizer.nextToken());
            this.secondaryPort = this.port = Integer.parseInt(stringTokenizer.nextToken());
            this.domainGroupID = stringTokenizer.nextToken();
            this.storagePlexName = stringTokenizer.nextToken();
        }
    }

    public NIBroadcastMessage(InetAddress inetAddress, InetAddress inetAddress2, int n, String string, String string2, String string3) {
        this.ip1 = inetAddress;
        this.ip2 = inetAddress2;
        this.serverName = string;
        this.domainGroupID = string2;
        this.secondaryPort = this.port = n;
        this.storagePlexName = string3;
    }

    public NIBroadcastMessage(InetAddress inetAddress, InetAddress inetAddress2, int n, String string, String string2, String string3, int n2) {
        this(inetAddress, inetAddress2, n, string, string2, string3);
        this.secondaryPort = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(47);
        stringBuffer.append(this.serverName + '/');
        stringBuffer.append(this.ip1.getHostAddress() + '/');
        stringBuffer.append(this.ip2.getHostAddress() + '/');
        stringBuffer.append(String.valueOf(this.port) + '/');
        stringBuffer.append(this.domainGroupID + '/');
        stringBuffer.append(this.storagePlexName + '/');
        stringBuffer.append(String.valueOf(this.secondaryPort) + '/');
        return stringBuffer.toString();
    }

    protected InetAddress getIPAddress1() {
        return this.ip1;
    }

    protected InetAddress getIPAddress2() {
        return this.ip2;
    }

    protected String getServerName() {
        return this.serverName;
    }

    protected String getDomainGroupID() {
        return this.domainGroupID;
    }

    protected void setStoragePlexName(String string) {
        this.storagePlexName = string;
    }

    protected String getStoragePlexName() {
        return this.storagePlexName;
    }

    protected int getPortNumber() {
        return this.port;
    }

    protected int getSecondaryPortNumber() {
        return this.secondaryPort;
    }
}

