/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIDomainGroupTable;
import com.ibm.storage.ess.ni.messageRouter.NIMessage;
import com.ibm.storage.ess.ni.messageRouter.NIMessageHeader;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConfigurationInterface;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterEssNodeData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterEstablishConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterInputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMessage;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterOutputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.messageRouter.NIProcessChannelTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableFile;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.util.NICircularBufferOverflowException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class NIInternalMessageHandler {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIInternalMessageHandler == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIInternalMessageHandler = NIInternalMessageHandler.class$("com.ibm.storage.ess.ni.messageRouter.NIInternalMessageHandler")) : class$com$ibm$storage$ess$ni$messageRouter$NIInternalMessageHandler);
    private static boolean noHMC = false;
    private static NIMessage msg = null;
    private static NIInternalMessageHandler msgHandler = null;
    private static Object reInitializeTableLock = new Object();
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIInternalMessageHandler;

    private NIInternalMessageHandler() {
    }

    public static synchronized NIInternalMessageHandler getInternalMessageHandler() {
        if (msgHandler == null) {
            msgHandler = new NIInternalMessageHandler();
        }
        return msgHandler;
    }

    public void processMessage(NIMessage nIMessage) {
        try {
            int n;
            if (NIAgentProperties.getAgentType() == 2 || NIAgentProperties.getAgentType() == 3) {
                this.heartbeat(nIMessage);
            }
            if ((n = ((NIMessageRouterMessage)nIMessage.getMessage()).getMessageType()) == 2) {
                this.newRoutingTable(nIMessage, false);
            } else if (n == 7) {
                this.newRoutingTable(nIMessage, true);
            } else if (n == 9) {
                this.checkPeerMsg(nIMessage);
            } else if (n == 11) {
                this.reinitializetables();
            } else if (n == 14 || n == 13 || n == 12) {
                new NIConfigThread(nIMessage, n).start();
            } else if (n == 5) {
                NIInternalMessageHandler.returnMessage(nIMessage.getMessageHeader(), new NIMessageRouterMessage(6));
            } else if (n == 3 || n == 4) {
                this.updateRoutingTableEntry(nIMessage);
            } else {
                try {
                    NIMessageRouterInputStream nIMessageRouterInputStream = NIInternalMessageHandler.getChannel().getNIMessageRouterInputStream();
                    nIMessageRouterInputStream.open();
                    nIMessageRouterInputStream.writeObject(nIMessage.getMessage());
                }
                catch (NICircularBufferOverflowException nICircularBufferOverflowException) {
                    logger.throwable((Throwable)nICircularBufferOverflowException);
                    logger.warning("Buffer overflow.  Dropped Incoming message from::  " + nIMessage.getMessageHeader().getSourceAddress().toString());
                }
            }
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
        nIMessage = null;
    }

    public void finalize() {
    }

    private static void returnMessage(NIMessageHeader nIMessageHeader, NIMessageRouterMessage nIMessageRouterMessage) {
        try {
            NIMessageRouterChannel nIMessageRouterChannel = NIInternalMessageHandler.getChannel();
            if (nIMessageRouterChannel == null) {
                logger.error("getChannel() returned null channel. Trying to recreate.");
            } else {
                NIMessageRouterOutputStream nIMessageRouterOutputStream = nIMessageRouterChannel.getNIMessageRouterOutputStream();
                if (nIMessageRouterOutputStream == null) {
                    logger.error("Can not get outputStream");
                } else {
                    NIMessageRouterAddress nIMessageRouterAddress = new NIMessageRouterAddress(nIMessageHeader.getSourceAddress().getProcessChannelID(), nIMessageHeader.getSourceAddress().getEssServerName());
                    NIMessageRouterReturnStatus nIMessageRouterReturnStatus = nIMessageRouterOutputStream.send(nIMessageRouterAddress, nIMessageRouterMessage.getMessageType(), nIMessageRouterMessage);
                    if (nIMessageRouterReturnStatus.getStatus() != 9) {
                        logger.error("MR Server:  " + NIMessageRouterMetaData.getEssServerName() + "  can not return message: " + nIMessageRouterMessage.getMessageType() + "  Status: " + nIMessageRouterReturnStatus.getStatus() + "  Destination:  " + nIMessageRouterAddress.toString());
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
    }

    private synchronized boolean newRoutingTable(NIMessage nIMessage, boolean bl) {
        boolean bl2 = false;
        noHMC = false;
        NIMessageRouterMessage nIMessageRouterMessage = (NIMessageRouterMessage)nIMessage.getMessage();
        Map map = nIMessageRouterMessage.getTableEntries();
        logger.debug_general("New Routing Table Received  " + NIMessageRouterMetaData.getEssServerName());
        if (!this.verifyNewRoutingTable(map, bl)) {
            logger.error("Received bad routing information.  Unable to recognize current node in table.  No updates performed");
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                NIRoutingTableEntry nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
                logger.error("Rejected entry:   " + nIRoutingTableEntry.toString());
            }
            bl2 = false;
        } else {
            this.updateRoutingTable(map);
            NIInternalMessageHandler.returnMessage(nIMessage.getMessageHeader(), new NIMessageRouterMessage(3, nIMessage.getMessageHeader().getDestinationAddress()));
            bl2 = true;
        }
        return bl2;
    }

    private void updateRoutingTableEntry(NIMessage nIMessage) {
        NIMessageHeader nIMessageHeader = nIMessage.getMessageHeader();
        int n = ((NIMessageRouterMessage)nIMessage.getMessage()).getMessageType();
        NIRoutingTableEntry nIRoutingTableEntry = NIRoutingTable.getRoutingTable().get(nIMessageHeader.getSourceAddress().getEssServerName());
        if (nIRoutingTableEntry != null) {
            logger.debug_general("Updating " + nIRoutingTableEntry);
            if (n == 3) {
                nIRoutingTableEntry.nodeUpdated();
            } else if (n == 4) {
                nIRoutingTableEntry.updateNeeded();
            }
        } else {
            logger.error("Entry not found " + nIMessageHeader.getSourceAddress().getEssServerName());
        }
    }

    private static NIMessageRouterChannel getChannel() {
        return NIProcessChannelTable.getProcessChannelTable().get(666);
    }

    private void updateRoutingTable(Map map) {
        logger.debug_general("Updating routing table");
        if (NIMessageRouterMetaData.getGroupDomainID().compareTo("HMC") == 0) {
            this.updateHmcRoutingTable(map);
        } else {
            this.updateCecRoutingTable(map);
        }
        NIRoutingTableFile nIRoutingTableFile = new NIRoutingTableFile(NIMessageRouterMetaData.getFileNamePath());
        nIRoutingTableFile.writeRoutingTableFile(null);
        logger.debug_general("Done updating routing table");
    }

    private void checkPeerMsg(NIMessage nIMessage) {
        logger.debug_general("Checking peer message");
        Map<String, NIRoutingTableEntry> map = Collections.synchronizedMap(new HashMap());
        NIRoutingTableEntry nIRoutingTableEntry = NIMessageRouterFactory.getInstanceOf().getPeer();
        if (nIRoutingTableEntry != null) {
            map.put(nIRoutingTableEntry.getKey(), nIRoutingTableEntry);
        }
        NIMessageRouterMetaData.setEssServerStateOnline();
        NIInternalMessageHandler.returnMessage(nIMessage.getMessageHeader(), new NIMessageRouterMessage(10, map));
        logger.debug_general("Done checking peer message");
    }

    private void updateCecRoutingTable(Map map) {
        logger.debug_general("Updating CEC Routing table");
        this.updateHmcEntry(map, "HMC1");
        this.updateHmcEntry(map, "HMC2");
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            NIRoutingTableEntry nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
            if (NIRoutingTable.getRoutingTable().contains(nIRoutingTableEntry.getKey())) {
                if (nIRoutingTableEntry != null && !nIRoutingTableEntry.equals(NIRoutingTable.getRoutingTable().get(nIRoutingTableEntry.getKey()))) {
                    NIMessageRouterConnectionMonitor.getConnectionMonitor().remove(nIRoutingTableEntry.getKey());
                    nIRoutingTableEntry.updateTimeStamp();
                    NIRoutingTable.getRoutingTable().add(nIRoutingTableEntry);
                    logger.debug_general("Entry changed:   " + nIRoutingTableEntry.toString());
                    continue;
                }
                logger.debug_general("Updated entry:   " + nIRoutingTableEntry.toString());
                continue;
            }
            logger.debug_general("Unidentified entry " + nIRoutingTableEntry);
        }
        logger.debug_general("Done updating CEC Routing table");
    }

    private boolean verifySerialNumbers(Map map) {
        boolean bl = true;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            NIRoutingTableEntry nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
            NIRoutingTableEntry nIRoutingTableEntry2 = NIRoutingTable.getRoutingTable().get(nIRoutingTableEntry.getKey());
            if (nIRoutingTableEntry2 == null || nIRoutingTableEntry2.getEssServerName().compareTo(nIRoutingTableEntry.getEssServerName()) == 0) continue;
            bl = false;
            logger.error("Mismatched ESS Server Names for entry " + nIRoutingTableEntry);
        }
        return bl;
    }

    private void updateHmcRoutingTable(Map map) {
        logger.debug_general("Updating HMC Routing table");
        if (!noHMC) {
            logger.debug_general("Clearing domain group table");
            NIDomainGroupTable.getDomainGroupTable().clear();
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            NIRoutingTableEntry nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
            if (nIRoutingTableEntry != null && !nIRoutingTableEntry.equals(NIRoutingTable.getRoutingTable().get(nIRoutingTableEntry.getKey()))) {
                NIMessageRouterConnectionMonitor.getConnectionMonitor().remove(nIRoutingTableEntry.getKey());
                nIRoutingTableEntry.updateTimeStamp();
                NIRoutingTable.getRoutingTable().add(nIRoutingTableEntry);
                logger.debug_general("Entry changed:   " + nIRoutingTableEntry.toString());
            } else {
                logger.debug_general("Updated entry:   " + nIRoutingTableEntry);
            }
            NIDomainGroupTable.getDomainGroupTable().add(nIRoutingTableEntry.getDomainGroupID(), nIRoutingTableEntry.getEssServerName());
        }
        logger.debug_general("Done updating HMC Routing table");
    }

    private boolean verifyNewRoutingTable(Map map, boolean bl) {
        Serializable serializable;
        boolean bl2 = false;
        boolean bl3 = false;
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        logger.debug_general("Verifying Routing table");
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            serializable = (NIRoutingTableEntry)iterator.next();
            if (((NIRoutingTableEntry)serializable).getEssServerName().compareTo("HMC1") == 0) {
                bl3 = true;
            }
            if (NIMessageRouterMetaData.isNodeThisServer((NIRoutingTableEntry)serializable) || bl && ((NIRoutingTableEntry)serializable).getEssServerName().compareTo("HMC2") == 0 && NIMessageRouterMetaData.getEssServerName().compareTo("HMC1") == 0) {
                logger.debug_general("Updating metadata to " + serializable);
                NIMessageRouterMetaData.updateMetaData(serializable);
                bl2 = true;
            }
            if (NIMessageRouterMetaData.getGroupDomainID().compareTo("HMC") == 0) continue;
            if (NIMessageRouterMetaData.isNodeThisServer(serializable)) {
                inetAddress = ((NIRoutingTableEntry)serializable).getIP();
                continue;
            }
            if (((NIRoutingTableEntry)serializable).getDomainGroupID().compareTo(NIMessageRouterMetaData.getGroupDomainID()) != 0) continue;
            inetAddress2 = ((NIRoutingTableEntry)serializable).getIP();
        }
        if (NIMessageRouterMetaData.getGroupDomainID().compareTo("HMC") != 0 && !((NIRoutingTableFile)((Object)(serializable = new NIRoutingTableFile(NIMessageRouterMetaData.getFileNamePath())))).checkDomainIP(inetAddress, inetAddress2)) {
            logger.debug_general("Check domain failed");
            bl2 = false;
        }
        if (!bl3 && NIMessageRouterMetaData.getEssServerName().compareTo("HMC2") == 0) {
            logger.debug_general("Removing HMC2 and reinitializing tables");
            map.remove("HMC2");
            this.reinitializetables();
            NIMessageRouterMetaData.setEssServerStateOnline();
            noHMC = true;
        } else if (NIMessageRouterMetaData.getGroupDomainID().compareTo("HMC") == 0) {
            logger.debug_general("Clearing the message routing table");
            serializable = new Vector<String>(6);
            iterator = NIRoutingTable.getRoutingTable().iterator();
            while (iterator.hasNext()) {
                NIRoutingTableEntry nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
                if (map.get(nIRoutingTableEntry.getKey()) != null) continue;
                serializable.add(nIRoutingTableEntry.getKey());
            }
            int n = 0;
            while (n < serializable.size()) {
                String string = (String)serializable.get(n);
                NIRoutingTable.getRoutingTable().remove(string);
                NIMessageRouterConnectionMonitor.getConnectionMonitor().remove(string);
                logger.debug_general("Deleting node from routing table " + string);
                ++n;
            }
            NIDomainGroupTable.getDomainGroupTable().clear();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitializetables() {
        Object object = reInitializeTableLock;
        synchronized (object) {
            Object object2;
            logger.debug_general("Entering reinitializetables");
            Iterator iterator = NIRoutingTable.getRoutingTable().iterator();
            NIRoutingTable.getRoutingTable().clear();
            NIDomainGroupTable.getDomainGroupTable().clear();
            while (iterator.hasNext()) {
                object2 = (NIRoutingTableEntry)iterator.next();
                NIMessageRouterConnectionMonitor.getConnectionMonitor().remove(((NIRoutingTableEntry)object2).getEssServerName());
                NIMessageRouterEstablishConnectionMonitor.getConnectionTable().stop(((NIRoutingTableEntry)object2).getEssServerName());
            }
            object2 = new NIRoutingTableFile(NIMessageRouterMetaData.getFileNamePath());
            ((NIRoutingTableFile)object2).reinitializeRoutingInformation();
            logger.debug_general("Leaving reinitializetables");
        }
    }

    private void removePeer() {
        NIRoutingTable.getRoutingTable().remove("HMC2");
        NIDomainGroupTable.getDomainGroupTable().remove("HMC", "HMC2");
        logger.debug_general("Removed HMC2");
        ((NIMessageRouterConfigurationInterface)NIMessageRouterFactory.getInstanceOf()).saveChanges(0);
    }

    private void cecConfiguration(NIMessage nIMessage, int n) {
        try {
            NIMessageRouterMessage nIMessageRouterMessage = (NIMessageRouterMessage)nIMessage.getMessage();
            Map map = nIMessageRouterMessage.getTableEntries();
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                NIRoutingTableEntry nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
                NIMessageRouterEssNodeData nIMessageRouterEssNodeData = new NIMessageRouterEssNodeData(nIRoutingTableEntry.getEssServerName(), nIRoutingTableEntry.getPrimaryIP(), nIRoutingTableEntry.getSecondaryIP(), nIRoutingTableEntry.getPrimaryPort(), nIRoutingTableEntry.getSecondaryPort(), nIRoutingTableEntry.getDomainGroupID());
                if (n == 13) {
                    logger.debug_general("Calling removeEssNode() " + nIMessageRouterEssNodeData);
                    ((NIMessageRouterConfigurationInterface)NIMessageRouterFactory.getInstanceOf()).removeEssNode(nIMessageRouterEssNodeData);
                    continue;
                }
                logger.debug_general("Calling addEssNode() " + nIMessageRouterEssNodeData);
                ((NIMessageRouterConfigurationInterface)NIMessageRouterFactory.getInstanceOf()).addEssNode(nIMessageRouterEssNodeData);
            }
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
    }

    private void heartbeat(NIMessage nIMessage) {
    }

    private void updateHmcEntry(Map map, String string) {
        NIRoutingTableEntry nIRoutingTableEntry = (NIRoutingTableEntry)map.get(string);
        if (nIRoutingTableEntry != null) {
            if (!nIRoutingTableEntry.equals(NIRoutingTable.getRoutingTable().get(nIRoutingTableEntry.getKey()))) {
                NIMessageRouterConnectionMonitor.getConnectionMonitor().remove(string);
                NIMessageRouterEstablishConnectionMonitor.getConnectionTable().stop(string);
                nIRoutingTableEntry.updateTimeStamp();
                NIRoutingTable.getRoutingTable().add(nIRoutingTableEntry);
                logger.debug_general("Entry changed " + string + ":   " + nIRoutingTableEntry.toString());
            } else {
                logger.debug_general("Updated " + string + ":   " + nIRoutingTableEntry.toString());
            }
            NIDomainGroupTable.getDomainGroupTable().add(nIRoutingTableEntry.getDomainGroupID(), nIRoutingTableEntry.getEssServerName());
            map.remove(string);
        } else if (NIRoutingTable.getRoutingTable().get(string) != null) {
            NIMessageRouterConnectionMonitor.getConnectionMonitor().remove(string);
            NIMessageRouterEstablishConnectionMonitor.getConnectionTable().stop(string);
            NIRoutingTable.getRoutingTable().remove(string);
            NIDomainGroupTable.getDomainGroupTable().remove("HMC", string);
            logger.debug_general("Removed " + string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NIConfigThread
    extends Thread {
        NIMessage msg;
        int type;

        public NIConfigThread(NIMessage nIMessage, int n) {
            this.msg = nIMessage;
            this.type = n;
        }

        public void run() {
            logger.debug_general("Starting Thread type = " + this.type);
            if (this.type == 14 || this.type == 13) {
                NIInternalMessageHandler.this.cecConfiguration(this.msg, this.type);
            } else if (this.type == 12) {
                NIInternalMessageHandler.this.removePeer();
            }
        }
    }
}

