/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIDomainGroup;
import com.ibm.storage.ess.ni.messageRouter.NIDomainGroupTable;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterEssNodeData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.NIProcessChannelTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public abstract class NIMessageRouter {
    protected static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterThread == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterThread = NIMessageRouter.class$("com.ibm.storage.ess.ni.messageRouter.NIMessageRouterThread")) : class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterThread);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterThread;

    protected NIMessageRouter() {
    }

    public void destroyNIMessageRouterChannel(NIMessageRouterChannel nIMessageRouterChannel) {
        NIProcessChannelTable.getProcessChannelTable().remove(nIMessageRouterChannel.getProcessChannelID());
        try {
            nIMessageRouterChannel.close();
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
        }
    }

    public NIMessageRouterChannel createNIMessageRouterChannel(int n) throws NIMessageRouterException {
        NIMessageRouterChannel nIMessageRouterChannel = null;
        nIMessageRouterChannel = new NIMessageRouterChannel(n);
        try {
            NIProcessChannelTable.getProcessChannelTable().add(n, nIMessageRouterChannel);
        }
        catch (NIMessageRouterException nIMessageRouterException) {
            logger.throwable((Throwable)nIMessageRouterException);
            logger.warning("Unable to create process id channel for " + new Integer(n).toString());
            nIMessageRouterChannel = null;
            throw nIMessageRouterException;
        }
        return nIMessageRouterChannel;
    }

    public InetAddress[] getPeerIPAddresses() {
        int n = 0;
        NIDomainGroup nIDomainGroup = NIDomainGroupTable.getDomainGroupTable().get(NIMessageRouterMetaData.getGroupDomainID());
        if (nIDomainGroup == null) {
            return new InetAddress[0];
        }
        InetAddress[] inetAddressArray = new InetAddress[nIDomainGroup.size() - 1];
        Enumeration enumeration = nIDomainGroup.enumeration();
        while (enumeration.hasMoreElements()) {
            NIRoutingTableEntry nIRoutingTableEntry = NIRoutingTable.getRoutingTable().get((String)enumeration.nextElement());
            InetAddress inetAddress = nIRoutingTableEntry.getPrimaryIP();
            if (NIMessageRouterMetaData.isNodeThisServer(nIRoutingTableEntry)) continue;
            inetAddressArray[n] = inetAddress;
            ++n;
        }
        return inetAddressArray;
    }

    public NIRoutingTableEntry getPeer() {
        NIRoutingTableEntry nIRoutingTableEntry = null;
        NIDomainGroup nIDomainGroup = NIDomainGroupTable.getDomainGroupTable().get(NIMessageRouterMetaData.getGroupDomainID());
        if (nIDomainGroup != null) {
            Enumeration enumeration = nIDomainGroup.enumeration();
            while (enumeration.hasMoreElements() && nIRoutingTableEntry == null) {
                NIRoutingTableEntry nIRoutingTableEntry2 = NIRoutingTable.getRoutingTable().get((String)enumeration.nextElement());
                if (NIMessageRouterMetaData.isNodeThisServer(nIRoutingTableEntry2)) continue;
                nIRoutingTableEntry = nIRoutingTableEntry2;
            }
        }
        return nIRoutingTableEntry;
    }

    public String getEssServerName() {
        return NIMessageRouterMetaData.getEssServerName();
    }

    public InetAddress getEssServerPrimaryIP() {
        return NIMessageRouterMetaData.getPrimaryInetAddress();
    }

    public boolean isESSServerOnline(String string) {
        boolean bl = false;
        if (string != null && NIRoutingTable.getRoutingTable().get(string) != null && (NIRoutingTable.getRoutingTable().get(string).isEssOnline() || NIRoutingTable.getRoutingTable().get(string).isSecondaryEssOnline())) {
            bl = true;
        }
        return bl;
    }

    public synchronized Collection getAllKnownEssNodes() {
        Vector<NIMessageRouterEssNodeData> vector = new Vector<NIMessageRouterEssNodeData>();
        try {
            Iterator iterator = NIRoutingTable.getRoutingTable().iterator();
            while (iterator.hasNext()) {
                NIRoutingTableEntry nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
                vector.add(new NIMessageRouterEssNodeData(nIRoutingTableEntry.getEssServerName(), nIRoutingTableEntry.getPrimaryIP(), nIRoutingTableEntry.getSecondaryIP(), nIRoutingTableEntry.getPrimaryPort(), nIRoutingTableEntry.getSecondaryPort(), nIRoutingTableEntry.getDomainGroupID()));
            }
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
            logger.warning("Unable to create list from routing table");
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

