/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIBroadcastMessage;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;

public class NIMessageRouterBroadcastThread
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterBroadcastThread == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterBroadcastThread = NIMessageRouterBroadcastThread.class$("com.ibm.storage.ess.ni.messageRouter.NIMessageRouterBroadcastThread")) : class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterBroadcastThread);
    private static final int INITIAL_BROADCAST_SLEEP_TIME = 250;
    private static final int NODE_TIMEOUT = 4500;
    private static int multiCastPort;
    private static int backupMultiCastPort;
    private static int multiCastPortOld;
    private static InetAddress mcGroupIPAddress;
    private MulticastSocket broadcastSocket;
    private MulticastSocket backupBroadcastSocket;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterBroadcastThread;

    public NIMessageRouterBroadcastThread() throws UnknownHostException {
        super("NIMessageRouterBroadcastThread");
        multiCastPort = NIMessageRouterMetaData.getEssBroadcastPort();
        backupMultiCastPort = NIMessageRouterMetaData.getEssBackupBroadcastPort();
        multiCastPortOld = NIMessageRouterMetaData.getEssBroadcastPortOld();
        try {
            mcGroupIPAddress = NIMessageRouterMetaData.getBroadcastInetAddress();
        }
        catch (UnknownHostException unknownHostException) {
            logger.throwable((Throwable)unknownHostException);
            logger.error("Could Not assign obtain broadcast IP address");
            throw unknownHostException;
        }
        logger.trace("NIMessageRouterBroadcastThread Thread");
    }

    public void run() {
        while (true) {
            try {
                NIBroadcastMessage nIBroadcastMessage = this.createBroadcastMessage();
                DatagramPacket datagramPacket = this.makeDatagramPacket(nIBroadcastMessage, multiCastPort);
                DatagramPacket datagramPacket2 = this.makeDatagramPacket(nIBroadcastMessage, backupMultiCastPort);
                DatagramPacket datagramPacket3 = this.makeDatagramPacket(nIBroadcastMessage, multiCastPortOld);
                this.broadcastSocket = this.getMulticastSocket(NIMessageRouterMetaData.getPrimaryInetAddress());
                this.backupBroadcastSocket = this.getMulticastSocket(NIMessageRouterMetaData.getSecondaryInetAddress());
                int n = 250;
                while (true) {
                    this.broadcastSocket.send(datagramPacket);
                    this.broadcastSocket.send(datagramPacket3);
                    this.backupBroadcastSocket.send(datagramPacket2);
                    this.checkTableForNodeTimeOut();
                    Thread.sleep(n);
                    if (n < 2000) {
                        n *= 2;
                    }
                    if (nIBroadcastMessage.getStoragePlexName().equals(NIMessageRouterMetaData.getStoragePlexName())) continue;
                    nIBroadcastMessage.setStoragePlexName(NIMessageRouterMetaData.getStoragePlexName());
                    datagramPacket = this.makeDatagramPacket(nIBroadcastMessage, multiCastPort);
                    datagramPacket2 = this.makeDatagramPacket(nIBroadcastMessage, backupMultiCastPort);
                    datagramPacket3 = this.makeDatagramPacket(nIBroadcastMessage, multiCastPortOld);
                }
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
                logger.error("Lost Socket in MessageRouter Broadcast:  Get new Socket.");
                try {
                    Thread.sleep(30000L);
                    continue;
                }
                catch (Exception exception2) {
                    logger.throwable((Throwable)exception2);
                    continue;
                }
            }
            break;
        }
    }

    public void shutdown() {
        this.interrupt();
        try {
            if (this.broadcastSocket != null) {
                this.broadcastSocket.close();
            }
            if (this.backupBroadcastSocket != null) {
                this.backupBroadcastSocket.close();
            }
        }
        catch (RuntimeException runtimeException) {
            logger.throwable((Throwable)runtimeException);
        }
    }

    private MulticastSocket getMulticastSocket(InetAddress inetAddress) {
        MulticastSocket multicastSocket = null;
        try {
            multicastSocket = new MulticastSocket();
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            multicastSocket.setNetworkInterface(networkInterface);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            multicastSocket = null;
        }
        return multicastSocket;
    }

    private void checkTableForNodeTimeOut() {
        Iterator iterator = NIRoutingTable.getRoutingTable().iterator();
        try {
            while (iterator.hasNext()) {
                NIRoutingTableEntry nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
                if (this.isNodeTimedOut(nIRoutingTableEntry, true)) {
                    if (nIRoutingTableEntry.isEssOnline()) {
                        nIRoutingTableEntry.setEssOffline();
                        NIRoutingTable.getRoutingTable().add(nIRoutingTableEntry);
                        NIMessageRouterConnectionMonitor.getConnectionMonitor().remove(nIRoutingTableEntry.getEssServerName(), true);
                        logger.warning("Node  " + nIRoutingTableEntry.getEssServerName() + " Primary Network Interface OFFLINE");
                    }
                } else if (!nIRoutingTableEntry.isEssOnline()) {
                    nIRoutingTableEntry.setEssOnline();
                    NIRoutingTable.getRoutingTable().add(nIRoutingTableEntry);
                    logger.warning("Node " + nIRoutingTableEntry.getEssServerName() + "  Primary Network Interface ONLINE.");
                }
                if (this.isNodeTimedOut(nIRoutingTableEntry, false)) {
                    if (!nIRoutingTableEntry.isSecondaryEssOnline()) continue;
                    nIRoutingTableEntry.setSecondaryEssOffline();
                    NIRoutingTable.getRoutingTable().add(nIRoutingTableEntry);
                    NIMessageRouterConnectionMonitor.getConnectionMonitor().remove(nIRoutingTableEntry.getEssServerName(), false);
                    logger.warning("Node  " + nIRoutingTableEntry.getEssServerName() + " Secondary Network Interface OFFLINE");
                    continue;
                }
                if (nIRoutingTableEntry.isSecondaryEssOnline()) continue;
                nIRoutingTableEntry.setSecondaryEssOnline();
                NIRoutingTable.getRoutingTable().add(nIRoutingTableEntry);
                logger.warning("Node " + nIRoutingTableEntry.getEssServerName() + "  Secondary Network Interface ONLINE.");
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            logger.warning("Concurrent Modification Exception when checking routing table for timeouts.");
        }
    }

    private boolean isNodeTimedOut(NIRoutingTableEntry nIRoutingTableEntry, boolean bl) {
        Date date = new Date();
        long l = date.getTime();
        long l2 = 0L;
        l2 = bl ? nIRoutingTableEntry.getTimeStamp() : nIRoutingTableEntry.getSecondaryTimeStamp();
        long l3 = l - l2;
        return l3 > 4500L;
    }

    private NIBroadcastMessage createBroadcastMessage() {
        return new NIBroadcastMessage(NIMessageRouterMetaData.getPrimaryInetAddress(), NIMessageRouterMetaData.getSecondaryInetAddress(), NIMessageRouterMetaData.getEssServerPort(), NIMessageRouterMetaData.getEssServerName(), NIMessageRouterMetaData.getGroupDomainID(), NIMessageRouterMetaData.getStoragePlexName(), NIMessageRouterMetaData.getEssBackupServerPort());
    }

    private DatagramPacket makeDatagramPacket(NIBroadcastMessage nIBroadcastMessage, int n) {
        String string = nIBroadcastMessage.toString();
        byte[] byArray = new byte[string.length()];
        byArray = string.getBytes();
        return new DatagramPacket(byArray, byArray.length, mcGroupIPAddress, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

