/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.ni.messageRouter.NIDomainGroupTable;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterEssNodeData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterEstablishConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterInputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMessage;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterOutputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.messageRouter.NIProcessChannelTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTable;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableFile;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NIMessageRouterConfigurationInterface
extends NIMessageRouter {
    private static final int MAX_RETRIES = 25;
    private static NIMessageRouter singleton = null;
    private static final int MAX_WAIT = 30000;
    private static final int WAIT_INTERVAL = 500;

    protected NIMessageRouterConfigurationInterface() {
    }

    public synchronized NIMessageRouterEssNodeData getEssNode(String string) {
        NIMessageRouterEssNodeData nIMessageRouterEssNodeData;
        block2: {
            nIMessageRouterEssNodeData = null;
            NIRoutingTableEntry nIRoutingTableEntry = NIRoutingTable.getRoutingTable().get(string);
            if (nIRoutingTableEntry == null) break block2;
            try {
                nIMessageRouterEssNodeData = new NIMessageRouterEssNodeData(nIRoutingTableEntry.getEssServerName(), nIRoutingTableEntry.getPrimaryIP(), nIRoutingTableEntry.getSecondaryIP(), nIRoutingTableEntry.getPrimaryPort(), nIRoutingTableEntry.getSecondaryPort(), nIRoutingTableEntry.getDomainGroupID());
            }
            catch (IOException iOException) {
                NIMessageRouter.logger.throwable((Throwable)iOException);
            }
        }
        return nIMessageRouterEssNodeData;
    }

    public synchronized NIMessageRouterReturnStatus addEssNode(NIMessageRouterEssNodeData nIMessageRouterEssNodeData) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        NIMessageRouter.logger.debug_general("Entering add ESS node: " + nIMessageRouterEssNodeData);
        NIRoutingTable nIRoutingTable = NIRoutingTable.getRoutingTable();
        NIRoutingTableEntry nIRoutingTableEntry = nIRoutingTable.get(nIMessageRouterEssNodeData.getEssServerName());
        if (nIRoutingTableEntry != null) {
            NIMessageRouter.logger.debug_general("Existing entry found. Returning");
            return nIMessageRouterReturnStatus;
        }
        if (NIMessageRouterMetaData.getEssServerName().compareTo("HMC2") == 0 && nIMessageRouterEssNodeData.getEssServerName().compareTo("HMC1") != 0 && nIMessageRouterEssNodeData.getEssServerName().compareTo("HMC2") != 0) {
            nIMessageRouterReturnStatus = this.forwardMessageToHMC1(nIMessageRouterEssNodeData, 14);
            if (nIMessageRouterReturnStatus.getStatus() == 9) {
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-12);
                try {
                    Thread.sleep(500L);
                    int n = 0;
                    while (n < 30000) {
                        if (NIRoutingTable.getRoutingTable().get(nIMessageRouterEssNodeData.getEssServerName()) != null) {
                            NIMessageRouter.logger.debug_general("Node added by HMC1");
                            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
                            break;
                        }
                        Thread.sleep(500L);
                        n += 500;
                    }
                }
                catch (Exception exception) {
                    NIMessageRouter.logger.error("Error while waiting for response from HMC1.");
                    NIMessageRouter.logger.throwable((Throwable)exception);
                }
            }
        } else {
            NIMessageRouterMetaData.setEssServerStateOnline();
            nIRoutingTableEntry = this.addNode(nIMessageRouterEssNodeData);
            if (nIRoutingTableEntry == null) {
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
            } else {
                if (NIMessageRouterMetaData.isNodeThisServer(nIRoutingTableEntry)) {
                    NIMessageRouterMetaData.updateMetaData(nIRoutingTableEntry);
                }
                this.saveChanges(2);
            }
        }
        NIMessageRouter.logger.debug_general("Leaving add ESS node: " + nIMessageRouterReturnStatus.getStatus());
        return nIMessageRouterReturnStatus;
    }

    public synchronized NIMessageRouterReturnStatus addManagementPeerNode(NIMessageRouterEssNodeData nIMessageRouterEssNodeData) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        NIMessageRouter.logger.debug_general("Entering set peer");
        NIRoutingTableEntry nIRoutingTableEntry = this.addNode(nIMessageRouterEssNodeData);
        if (nIRoutingTableEntry == null) {
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
        } else {
            nIMessageRouterReturnStatus = this.isNodeConnected(nIMessageRouterEssNodeData);
            NIMessageRouter.logger.debug_general("Set peer - checking if peer is online: " + nIMessageRouterReturnStatus.getStatus());
            if (nIMessageRouterReturnStatus.getStatus() != 9) {
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-12);
                NIRoutingTable.getRoutingTable().remove(nIMessageRouterEssNodeData.getEssServerName());
                NIDomainGroupTable.getDomainGroupTable().remove(nIMessageRouterEssNodeData.getDomainGroupID(), nIMessageRouterEssNodeData.getEssServerName());
                NIMessageRouterEstablishConnectionMonitor.getConnectionTable().stop(nIMessageRouterEssNodeData.getEssServerName());
                NIMessageRouterConnectionMonitor.getConnectionMonitor().remove(nIMessageRouterEssNodeData.getEssServerName());
            } else {
                this.saveChanges(7);
                NIMessageRouterMetaData.setEssServerStateOnline();
            }
        }
        NIMessageRouter.logger.debug_general("Done set peer: " + nIMessageRouterReturnStatus.getStatus());
        return nIMessageRouterReturnStatus;
    }

    public synchronized NIMessageRouterReturnStatus removeEssNode(NIMessageRouterEssNodeData nIMessageRouterEssNodeData) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = null;
        NIMessageRouter.logger.debug_general("Start remove ESS Node: " + nIMessageRouterEssNodeData);
        if (NIMessageRouterMetaData.getEssServerName().compareTo("HMC2") == 0 && nIMessageRouterEssNodeData.getEssServerName().compareTo("HMC1") != 0 && nIMessageRouterEssNodeData.getEssServerName().compareTo("HMC2") != 0) {
            nIMessageRouterReturnStatus = this.forwardMessageToHMC1(nIMessageRouterEssNodeData, 13);
            if (nIMessageRouterReturnStatus.getStatus() == 9) {
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-12);
                try {
                    Thread.sleep(500L);
                    int n = 0;
                    while (n < 30000) {
                        if (NIRoutingTable.getRoutingTable().get(nIMessageRouterEssNodeData.getEssServerName()) == null) {
                            NIMessageRouter.logger.debug_general("Node deleted by HMC1");
                            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
                            break;
                        }
                        Thread.sleep(500L);
                        n += 500;
                    }
                }
                catch (Exception exception) {
                    NIMessageRouter.logger.error("Error while waiting for response from HMC1.");
                    NIMessageRouter.logger.throwable((Throwable)exception);
                }
            }
        } else {
            NIRoutingTableEntry nIRoutingTableEntry = null;
            NIRoutingTable nIRoutingTable = NIRoutingTable.getRoutingTable();
            NIDomainGroupTable nIDomainGroupTable = NIDomainGroupTable.getDomainGroupTable();
            NIRoutingTableEntry nIRoutingTableEntry2 = nIRoutingTable.get(nIMessageRouterEssNodeData.getEssServerName());
            boolean bl = false;
            NIMessageRouterEssNodeData nIMessageRouterEssNodeData2 = null;
            try {
                nIMessageRouterEssNodeData2 = new NIMessageRouterEssNodeData("HMC2", null, null, 0, 0, null);
            }
            catch (IOException iOException) {
                NIMessageRouter.logger.throwable((Throwable)iOException);
            }
            NIMessageRouterMetaData.setEssServerStateOnline();
            if (nIRoutingTableEntry2 != null && NIMessageRouterMetaData.isNodeThisServer(nIRoutingTableEntry2) && nIRoutingTableEntry2.getEssServerName().compareTo("HMC1") == 0 && (nIMessageRouterReturnStatus = this.isNodeConnected(nIMessageRouterEssNodeData2)).getStatus() == 9) {
                bl = true;
            }
            nIMessageRouterReturnStatus = this.removeNode(nIRoutingTableEntry2);
            if (nIRoutingTableEntry2 != null && nIRoutingTableEntry2.getEssServerName().compareTo("HMC1") == 0 && NIMessageRouterMetaData.getEssServerName().compareTo("HMC2") == 0) {
                nIMessageRouterReturnStatus = this.removePeer(nIRoutingTableEntry2);
            }
            if (nIRoutingTableEntry2 != null) {
                nIRoutingTable.remove(nIRoutingTableEntry2.getEssServerName());
                NIDomainGroupTable.getDomainGroupTable().remove(nIRoutingTableEntry2.getDomainGroupID(), nIRoutingTableEntry2.getEssServerName());
                NIMessageRouter.logger.debug_general("Remove IP");
                NIMessageRouter.logger.debug_general(nIRoutingTableEntry2.toString());
            }
            if (nIRoutingTableEntry2 != null && NIMessageRouterMetaData.isNodeThisServer(nIRoutingTableEntry2)) {
                Object object;
                if (nIRoutingTableEntry2.getEssServerName().compareTo("HMC2") == 0) {
                    NIRoutingTableEntry nIRoutingTableEntry3 = nIRoutingTable.get("HMC1");
                    if (nIRoutingTableEntry3 != null) {
                        nIMessageRouterReturnStatus = this.removePeer(nIRoutingTableEntry3);
                    }
                } else {
                    boolean bl2 = false;
                    if (bl) {
                        object = nIRoutingTable.get("HMC2");
                        ((NIRoutingTableEntry)object).updateNeeded();
                        NIMessageRouterOutputStream nIMessageRouterOutputStream = this.getChannel().getNIMessageRouterOutputStream();
                        NIMessageRouterAddress nIMessageRouterAddress = new NIMessageRouterAddress(666, "HMC2");
                        try {
                            if (nIMessageRouterOutputStream.send(nIMessageRouterAddress, 5, new NIMessageRouterMessage(5)).getStatus() == 9) {
                                NIMessageRouter.logger.debug_general("Peer will update SUs.");
                            } else {
                                bl2 = true;
                            }
                        }
                        catch (IOException iOException) {
                            NIMessageRouter.logger.throwable((Throwable)iOException);
                        }
                    }
                    if (bl2 || !bl) {
                        NIMessageRouter.logger.debug_general("Updating konas routing table ourselves (" + bl2 + ", " + bl + ")");
                        nIRoutingTable.remove("HMC2");
                        NIMessageRouterConnectionMonitor.getConnectionMonitor().remove("HMC2");
                        NIMessageRouterEstablishConnectionMonitor.getConnectionTable().stop("HMC2");
                        this.propagateChanges(true, 11);
                    }
                }
                NIMessageRouterMetaData.setEssServerName(null);
                Iterator iterator = NIRoutingTable.getRoutingTable().iterator();
                nIRoutingTable.clear();
                nIDomainGroupTable.clear();
                while (iterator.hasNext()) {
                    object = ((NIRoutingTableEntry)iterator.next()).getEssServerName();
                    NIMessageRouterConnectionMonitor.getConnectionMonitor().remove((String)object);
                    NIMessageRouterEstablishConnectionMonitor.getConnectionTable().stop((String)object);
                }
                NIMessageRouter.logger.debug_general("Starting to redo routing table");
                object = new NIRoutingTableFile(NIMessageRouterMetaData.getFileNamePath());
                ((NIRoutingTableFile)object).reinitializeRoutingInformation();
            } else {
                if (nIRoutingTableEntry2 != null && nIRoutingTableEntry2.getEssServerName().compareTo("HMC1") == 0 && NIMessageRouterMetaData.getEssServerName().compareTo("HMC2") == 0) {
                    nIRoutingTable.remove("HMC1");
                    nIRoutingTable.remove("HMC2");
                    NIMessageRouterConnectionMonitor.getConnectionMonitor().remove("HMC1");
                    NIMessageRouterEstablishConnectionMonitor.getConnectionTable().stop("HMC1");
                    NIMessageRouterConnectionMonitor.getConnectionMonitor().remove("HMC2");
                    NIMessageRouterEstablishConnectionMonitor.getConnectionTable().stop("HMC2");
                    Map<String, NIRoutingTableEntry> map = Collections.synchronizedMap(new HashMap());
                    Iterator iterator = nIRoutingTable.iterator();
                    nIRoutingTable.clear();
                    NIDomainGroupTable.getDomainGroupTable().clear();
                    while (iterator.hasNext()) {
                        nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
                        map.put(nIRoutingTableEntry.getKey(), nIRoutingTableEntry);
                        NIMessageRouterConnectionMonitor.getConnectionMonitor().remove(nIRoutingTableEntry.getKey());
                        NIMessageRouterEstablishConnectionMonitor.getConnectionTable().stop(nIRoutingTableEntry.getKey());
                    }
                    NIRoutingTableFile nIRoutingTableFile = new NIRoutingTableFile(NIMessageRouterMetaData.getFileNamePath());
                    nIRoutingTableFile.reinitializeRoutingInformation();
                    iterator = map.values().iterator();
                    while (iterator.hasNext()) {
                        nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
                        nIRoutingTable.add(nIRoutingTableEntry);
                        nIDomainGroupTable.add(nIRoutingTableEntry.getDomainGroupID(), nIRoutingTableEntry.getEssServerName());
                    }
                }
                this.saveChanges(2);
                if (nIRoutingTableEntry2 != null) {
                    NIMessageRouterConnectionMonitor.getConnectionMonitor().remove(nIRoutingTableEntry2.getEssServerName());
                    NIMessageRouterEstablishConnectionMonitor.getConnectionTable().stop(nIRoutingTableEntry2.getEssServerName());
                }
            }
        }
        NIMessageRouter.logger.debug_general("Leaving remove ESS node data: " + nIMessageRouterReturnStatus.getStatus());
        return nIMessageRouterReturnStatus;
    }

    public synchronized NIMessageRouterReturnStatus isNodeConnected(NIMessageRouterEssNodeData nIMessageRouterEssNodeData) {
        Object object;
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-6);
        this.getChannel().getNIMessageRouterInputStream().reset();
        NIRoutingTableEntry nIRoutingTableEntry = NIRoutingTable.getRoutingTable().get(nIMessageRouterEssNodeData.getEssServerName());
        if (nIRoutingTableEntry != null && !NIMessageRouterMetaData.isNodeThisServer(nIRoutingTableEntry)) {
            try {
                object = this.getChannel().getNIMessageRouterOutputStream();
                NIMessageRouterAddress nIMessageRouterAddress = new NIMessageRouterAddress(666, nIMessageRouterEssNodeData.getEssServerName());
                nIMessageRouterReturnStatus = ((NIMessageRouterOutputStream)object).send(nIMessageRouterAddress, 5, new NIMessageRouterMessage(5));
                if (nIMessageRouterReturnStatus.getStatus() == 9) {
                    nIMessageRouterReturnStatus = this.getIsNodeConnectedResponse();
                }
            }
            catch (Exception exception) {
                NIMessageRouter.logger.throwable((Throwable)exception);
                NIMessageRouter.logger.warning("Unable to testEssNode" + nIMessageRouterEssNodeData.getEssServerName());
            }
        } else if (nIRoutingTableEntry != null && NIMessageRouterMetaData.isNodeThisServer(nIRoutingTableEntry)) {
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        }
        if (nIMessageRouterReturnStatus.getStatus() != 9 && nIRoutingTableEntry != null) {
            nIRoutingTableEntry.updateNeeded();
            object = NIRoutingTable.getRoutingTable();
            ((NIRoutingTable)object).add(nIRoutingTableEntry);
        }
        return nIMessageRouterReturnStatus;
    }

    protected synchronized void checkPeer() {
        block5: {
            NIMessageRouterReturnStatus nIMessageRouterReturnStatus = null;
            NIRoutingTableEntry nIRoutingTableEntry = this.getPeer();
            if (nIRoutingTableEntry == null) break block5;
            NIMessageRouterMetaData.setEssServerStateUnknown();
            this.getChannel().getNIMessageRouterInputStream().reset();
            try {
                NIMessageRouterOutputStream nIMessageRouterOutputStream = this.getChannel().getNIMessageRouterOutputStream();
                NIMessageRouterAddress nIMessageRouterAddress = new NIMessageRouterAddress(666, nIRoutingTableEntry.getEssServerName());
                nIMessageRouterReturnStatus = nIMessageRouterOutputStream.send(nIMessageRouterAddress, 9, new NIMessageRouterMessage(9));
                if (nIMessageRouterReturnStatus.getStatus() == 9) {
                    nIMessageRouterReturnStatus = this.getCheckPeerResponse();
                    if (nIMessageRouterReturnStatus.getStatus() != 9) {
                        NIMessageRouter.logger.warning("Peer did not respond to check peer message " + nIRoutingTableEntry.getEssServerName());
                        NIMessageRouterMetaData.setEssServerStateUnknown();
                    } else {
                        NIMessageRouter.logger.debug_general("Successful peer verification.");
                        NIMessageRouterMetaData.setEssServerStateOnline();
                    }
                    break block5;
                }
                NIMessageRouter.logger.warning("Unable to send check peer request to " + nIRoutingTableEntry.getEssServerName());
                NIMessageRouterMetaData.setEssServerStateUnknown();
            }
            catch (Exception exception) {
                NIMessageRouter.logger.throwable((Throwable)exception);
                NIMessageRouter.logger.warning("Unable to check peer " + nIRoutingTableEntry.getEssServerName());
            }
        }
    }

    protected synchronized NIMessageRouterReturnStatus propagateChanges(boolean bl, int n) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        NIRoutingTableEntry nIRoutingTableEntry = null;
        boolean bl2 = false;
        NIMessageRouter.logger.debug_general("Entering propagate changes newChange = " + bl + " type = " + n);
        if (!bl && NIMessageRouterMetaData.isEssServerStateUnknown()) {
            return nIMessageRouterReturnStatus;
        }
        Iterator iterator = NIRoutingTable.getRoutingTable().iterator();
        while (iterator.hasNext()) {
            try {
                this.getChannel().getNIMessageRouterInputStream().reset();
                nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
                if (!bl && (bl || nIRoutingTableEntry.isNodeUpdated())) continue;
                if (!NIMessageRouterMetaData.isNodeThisServer(nIRoutingTableEntry)) {
                    NIMessageRouterAddress nIMessageRouterAddress;
                    NIMessageRouterOutputStream nIMessageRouterOutputStream;
                    if (bl) {
                        nIRoutingTableEntry.updateNeeded();
                    }
                    if ((nIMessageRouterOutputStream = this.getChannel().getNIMessageRouterOutputStream()).send(nIMessageRouterAddress = new NIMessageRouterAddress(666, nIRoutingTableEntry.getEssServerName()), 5, new NIMessageRouterMessage(5)).getStatus() == 9) {
                        NIMessageRouterReturnStatus nIMessageRouterReturnStatus2 = this.getIsNodeConnectedResponse();
                        NIMessageRouter.logger.debug_general("Response for " + nIRoutingTableEntry.getEssServerName() + " = " + nIMessageRouterReturnStatus.getStatus());
                        if (nIMessageRouterReturnStatus2.getStatus() != 9 && nIRoutingTableEntry != null) {
                            nIRoutingTableEntry.updateNeeded();
                        } else {
                            nIRoutingTableEntry.nodeUpdated();
                        }
                        if (nIMessageRouterReturnStatus2.getStatus() == 9) continue;
                        nIMessageRouterReturnStatus = nIMessageRouterReturnStatus2;
                        continue;
                    }
                    NIMessageRouter.logger.error("Unable to propagate changes to remote node  " + nIRoutingTableEntry.getEssServerName());
                    continue;
                }
                nIRoutingTableEntry.nodeUpdated();
            }
            catch (Exception exception) {
                NIMessageRouter.logger.throwable((Throwable)exception);
                NIMessageRouter.logger.error("Unable to propagate changes to remote node  " + nIRoutingTableEntry.getEssServerName());
            }
        }
        NIMessageRouter.logger.debug_general("Done propagating changes");
        return nIMessageRouterReturnStatus;
    }

    protected synchronized NIMessageRouterReturnStatus saveChanges(int n) {
        NIMessageRouter.logger.debug_general("Entering save changes: " + n);
        NIRoutingTableFile nIRoutingTableFile = new NIRoutingTableFile(NIMessageRouterMetaData.getFileNamePath());
        nIRoutingTableFile.writeRoutingTableFile(null);
        return this.propagateChanges(true, n);
    }

    private NIMessageRouterChannel getChannel() {
        return NIProcessChannelTable.getProcessChannelTable().get(666);
    }

    private NIMessageRouterReturnStatus getIsNodeConnectedResponse() throws Exception {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-6);
        NIMessageRouterInputStream nIMessageRouterInputStream = this.getChannel().getNIMessageRouterInputStream();
        Thread.sleep(100L);
        int n = 25;
        while (n > 0 && nIMessageRouterInputStream.availableMessages() <= 0) {
            Thread.sleep(250L);
            --n;
        }
        while (nIMessageRouterInputStream.availableMessages() > 0 && nIMessageRouterReturnStatus.getStatus() != 9) {
            NIMessageRouterMessage nIMessageRouterMessage = (NIMessageRouterMessage)nIMessageRouterInputStream.readObject();
            if (nIMessageRouterMessage.getMessageType() == 6) {
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
                continue;
            }
            NIMessageRouter.logger.debug_general("Received some other type of message type = " + nIMessageRouterMessage.getMessageType() + " expecting " + 6);
            Thread.sleep(1000L);
        }
        return nIMessageRouterReturnStatus;
    }

    private NIMessageRouterReturnStatus getCheckPeerResponse() throws Exception {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-6);
        NIMessageRouterInputStream nIMessageRouterInputStream = this.getChannel().getNIMessageRouterInputStream();
        Thread.sleep(100L);
        int n = 25;
        while (n > 0 && nIMessageRouterInputStream.availableMessages() <= 0) {
            Thread.sleep(500L);
            --n;
        }
        while (nIMessageRouterInputStream.availableMessages() > 0 && nIMessageRouterReturnStatus.getStatus() != 9) {
            NIMessageRouterMessage nIMessageRouterMessage = (NIMessageRouterMessage)nIMessageRouterInputStream.readObject();
            if (nIMessageRouterMessage.getMessageType() == 10) {
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
                continue;
            }
            Thread.sleep(1000L);
        }
        return nIMessageRouterReturnStatus;
    }

    private NIRoutingTableEntry addNode(NIMessageRouterEssNodeData nIMessageRouterEssNodeData) {
        NIMessageRouter.logger.debug_general("Entering add node " + nIMessageRouterEssNodeData);
        NIRoutingTable nIRoutingTable = NIRoutingTable.getRoutingTable();
        NIRoutingTableEntry nIRoutingTableEntry = nIRoutingTable.get(nIMessageRouterEssNodeData.getEssServerName());
        if (nIRoutingTableEntry == null) {
            nIRoutingTableEntry = new NIRoutingTableEntry(nIMessageRouterEssNodeData);
        } else {
            NIMessageRouter.logger.debug_general("Existing data found, removing from table");
            nIRoutingTable.remove(nIRoutingTableEntry.getKey());
            nIRoutingTableEntry = new NIRoutingTableEntry(nIMessageRouterEssNodeData);
        }
        NIMessageRouter.logger.debug_general(" Entry created " + nIRoutingTableEntry);
        nIRoutingTable.add(nIRoutingTableEntry);
        NIDomainGroupTable.getDomainGroupTable().add(nIRoutingTableEntry.getDomainGroupID(), nIRoutingTableEntry.getEssServerName());
        NIMessageRouter.logger.debug_general("Leaving add node ");
        return nIRoutingTableEntry;
    }

    private NIMessageRouterReturnStatus removeNode(NIRoutingTableEntry nIRoutingTableEntry) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        NIMessageRouter.logger.debug_general("Entering remove node");
        this.getChannel().getNIMessageRouterInputStream().reset();
        if (nIRoutingTableEntry != null && !NIMessageRouterMetaData.isNodeThisServer(nIRoutingTableEntry)) {
            try {
                NIMessageRouterOutputStream nIMessageRouterOutputStream = this.getChannel().getNIMessageRouterOutputStream();
                NIMessageRouterAddress nIMessageRouterAddress = new NIMessageRouterAddress(666, nIRoutingTableEntry.getEssServerName());
                nIMessageRouterReturnStatus = nIMessageRouterOutputStream.send(nIMessageRouterAddress, 11, new NIMessageRouterMessage(11)).getStatus() == 9 ? new NIMessageRouterReturnStatus(9) : new NIMessageRouterReturnStatus(-12);
            }
            catch (Exception exception) {
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
                NIMessageRouter.logger.throwable((Throwable)exception);
                NIMessageRouter.logger.warning("Unable to remove node" + nIRoutingTableEntry.getEssServerName());
            }
        }
        NIMessageRouter.logger.debug_general("Leaving remove node: " + nIMessageRouterReturnStatus.getStatus());
        return nIMessageRouterReturnStatus;
    }

    private NIMessageRouterReturnStatus removePeer(NIRoutingTableEntry nIRoutingTableEntry) {
        NIMessageRouter.logger.debug_general("Entering remove peer");
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        this.getChannel().getNIMessageRouterInputStream().reset();
        if (nIRoutingTableEntry != null) {
            try {
                NIMessageRouterOutputStream nIMessageRouterOutputStream = this.getChannel().getNIMessageRouterOutputStream();
                NIMessageRouterAddress nIMessageRouterAddress = new NIMessageRouterAddress(666, nIRoutingTableEntry.getEssServerName());
                nIMessageRouterReturnStatus = nIMessageRouterOutputStream.send(nIMessageRouterAddress, 12, new NIMessageRouterMessage(12)).getStatus() == 9 ? new NIMessageRouterReturnStatus(9) : new NIMessageRouterReturnStatus(-12);
            }
            catch (Exception exception) {
                nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
                NIMessageRouter.logger.throwable((Throwable)exception);
                NIMessageRouter.logger.warning("Unable to remove peer" + nIRoutingTableEntry.getEssServerName());
            }
        }
        NIMessageRouter.logger.debug_general("Leaving remove peer: " + nIMessageRouterReturnStatus.getStatus());
        return nIMessageRouterReturnStatus;
    }

    private NIMessageRouterReturnStatus forwardMessageToHMC1(NIMessageRouterEssNodeData nIMessageRouterEssNodeData, int n) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(9);
        NIMessageRouter.logger.debug_general("Entering forward to HMC1");
        Map<String, NIRoutingTableEntry> map = Collections.synchronizedMap(new HashMap());
        NIRoutingTableEntry nIRoutingTableEntry = new NIRoutingTableEntry(nIMessageRouterEssNodeData);
        map.put(nIRoutingTableEntry.getKey(), nIRoutingTableEntry);
        this.getChannel().getNIMessageRouterInputStream().reset();
        try {
            NIMessageRouterOutputStream nIMessageRouterOutputStream = this.getChannel().getNIMessageRouterOutputStream();
            NIMessageRouterAddress nIMessageRouterAddress = new NIMessageRouterAddress(666, "HMC1");
            nIMessageRouterReturnStatus = nIMessageRouterOutputStream.send(nIMessageRouterAddress, n, new NIMessageRouterMessage(n, map)).getStatus() == 9 ? new NIMessageRouterReturnStatus(9) : new NIMessageRouterReturnStatus(-12);
        }
        catch (Exception exception) {
            nIMessageRouterReturnStatus = new NIMessageRouterReturnStatus(-20);
            NIMessageRouter.logger.throwable((Throwable)exception);
            NIMessageRouter.logger.warning("Unable to forward to HMC1");
        }
        NIMessageRouter.logger.debug_general("Leaving forward to HMC1: " + nIMessageRouterReturnStatus.getStatus());
        return nIMessageRouterReturnStatus;
    }
}

