/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.jni.ci.NICIConnectionException;
import com.ibm.storage.ess.ni.jni.mr.NIMRClientInt;
import com.ibm.storage.ess.sm.SMComponent;
import java.io.File;

public class NIMessageRouterCrossNode
implements SMComponent {
    public static final String NAME = "CrossNodeMR";
    private Logger logger = null;
    private boolean initialized = false;
    private NIMRClientInt mr = null;

    public void init(Logger logger) {
        this.logger = logger;
        if (this.mr == null && !this.initialized) {
            try {
                this.mr = new NIMRClientInt();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.mr = null;
                this.initialized = false;
                logger.debug_detailed("Failed to Initialize");
                logger.throwable((Throwable)unsatisfiedLinkError);
                return;
            }
            this.initialized = true;
        }
        logger.debug_detailed("Init Completed");
        try {
            this.mr.niMRStartServer();
            logger.debug_detailed("Message Router Cross Node started succesfully.");
        }
        catch (NICIConnectionException nICIConnectionException) {
            logger.error("Could not start Message Router Cross Node");
            logger.throwable((Throwable)nICIConnectionException);
            return;
        }
    }

    public void recover() {
    }

    public void start() {
    }

    public void stop() {
    }

    public void terminate() {
        block2: {
            if (this.mr == null || !this.initialized) break block2;
            try {
                this.mr.niMRStopServer();
                this.mr = null;
                this.initialized = false;
                this.logger.debug_detailed("Message Router Cross Node terminatted succesfully.");
            }
            catch (NICIConnectionException nICIConnectionException) {
                this.logger.error("Could not terminate Message Router Cross Node");
                this.logger.throwable((Throwable)nICIConnectionException);
            }
        }
    }

    public String getName() {
        return NAME;
    }

    public boolean isAlive() {
        try {
            return !this.initialized || this.mr.niMRisAlive();
        }
        catch (Throwable throwable) {
            this.logger.throwable(throwable);
            return false;
        }
    }

    public void dump(File file) {
    }
}

