/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.communication.connection.NIConnectionFactory;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry;
import com.ibm.storage.ess.ni.messageRouter.common.NIESSNIConstants;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NIMessageRouterMetaData
implements NIESSNIConstants {
    public static final String ROUTING_TABLE_PROPERTY = "RoutingTableFileProperty";
    public static final String NODE_DATA_PROPERTY = "NodeDataFileProperty";
    public static final int ESS_SERVER_ONLINE = 1;
    public static final int ESS_SERVER_OFFLINE = 0;
    public static final int ESS_SERVER_UNKNOWN = 2;
    public static final int MR_CHANNEL_ID = 666;
    public static final int MAX_BROADCAST_SLEEP_TIME = 2000;
    public static final String LOCAL_ADDRESS_PROPERTY = "com.ibm.storage.ess.ni.server.LocalAddress";
    private static final int ESS_SERVER_PORT1 = 1720;
    private static final int ESS_BROADCAST_PORT1 = 1730;
    private static final int ESS_SERVER_PORT2 = 1732;
    private static final int ESS_BROADCAST_PORT2 = 1731;
    private static final int ESS_BROADCAST_PORT3 = 1721;
    private static final String ESS_BROADCAST_IP = "224.0.0.1";
    private static NIConnectionFactory connectionFactory = null;
    private static int hostPort = 1720;
    private static int broadcastPort = 1730;
    private static int backupHostPort = 1732;
    private static int backupBroadcastPort = 1731;
    private static int broadcastPortOld = 1721;
    private static String storagePlexName;
    private static String serverName;
    private static String fileName;
    private static InetAddress primaryIP;
    private static InetAddress secondaryIP;
    private static String domainGroupID;
    private static int serverState;
    private static boolean sslConnections;
    private static NIMessageRouterMetaData singleton;
    private static Logger logger;
    private static boolean discoveryMode;
    private static boolean backupNetworkInterfaces;

    private NIMessageRouterMetaData() {
    }

    public static synchronized NIMessageRouterMetaData getInstanceOf() {
        if (singleton == null) {
            singleton = new NIMessageRouterMetaData();
        }
        return singleton;
    }

    public static boolean isEssServerUp() {
        return serverState != 0;
    }

    public static boolean isEssServerStateUnknown() {
        return serverState == 2;
    }

    public static String getStoragePlexName() {
        return storagePlexName;
    }

    public static void setStoragePlexName(String string) {
        storagePlexName = string;
    }

    public static String getEssServerName() {
        if (serverName == null) {
            return new String();
        }
        return serverName;
    }

    public static int getEssServerPort() {
        return hostPort;
    }

    public static int getEssBroadcastPort() {
        return broadcastPort;
    }

    public static int getEssBackupServerPort() {
        return backupHostPort;
    }

    public static int getEssBroadcastPortOld() {
        return broadcastPortOld;
    }

    public static int getEssBackupBroadcastPort() {
        return backupBroadcastPort;
    }

    public static InetAddress getPrimaryInetAddress() {
        return primaryIP;
    }

    public static InetAddress getSecondaryInetAddress() {
        return secondaryIP;
    }

    public static InetAddress getBroadcastInetAddress() throws UnknownHostException {
        return InetAddress.getByName(ESS_BROADCAST_IP);
    }

    public static String getGroupDomainID() {
        return domainGroupID;
    }

    public static void setEssServerName(String string) {
        serverName = string;
    }

    public static void setPrimaryInetAddress(InetAddress inetAddress) {
        primaryIP = inetAddress;
    }

    public static void setSecondaryInetAddress(InetAddress inetAddress) {
        secondaryIP = inetAddress;
    }

    public static void setGroupDomainID(String string) {
        domainGroupID = string;
    }

    public static void setEssServerStateOnline() {
        serverState = 1;
    }

    public static void setEssServerStateUnknown() {
        serverState = 2;
    }

    public static int setEssServerPort(int n) {
        hostPort = n;
        return hostPort;
    }

    public static void setEssServerPorts(int n, int n2) {
        backupHostPort = n2;
        hostPort = n;
    }

    public static int setEssBackupServerPort(int n) {
        backupHostPort = n;
        return backupHostPort;
    }

    public static String getFileNamePath() {
        return fileName;
    }

    public static void setFileNamePath(String string) {
        fileName = string;
    }

    public static void setDiscoveryMode(boolean bl) {
        discoveryMode = bl;
    }

    public static boolean isDiscoveryMode() {
        return discoveryMode;
    }

    public static void setSSLConnectionsActive() {
        sslConnections = true;
    }

    public static void setSSLConnectionsInactive() {
        sslConnections = false;
    }

    public static void setBackupNetworkInterfacesActive(boolean bl) {
        backupNetworkInterfaces = bl;
    }

    public static boolean areSSLConnectionsActive() {
        return sslConnections;
    }

    public static synchronized NIConnectionFactory getSocketConnectionFactory() {
        if (connectionFactory == null) {
            connectionFactory = NIConnectionFactory.getConnectionFactory();
        }
        return connectionFactory;
    }

    public static boolean isNonDiscoveryMode() {
        return !discoveryMode;
    }

    public static boolean areBackupNetworkInterfacesActive() {
        return backupNetworkInterfaces;
    }

    public static void setNodeData(String string, InetAddress inetAddress, InetAddress inetAddress2, int n, String string2) {
        NIMessageRouterMetaData.setEssServerName(string);
        NIMessageRouterMetaData.setPrimaryInetAddress(inetAddress);
        NIMessageRouterMetaData.setSecondaryInetAddress(inetAddress2);
        NIMessageRouterMetaData.setEssServerPort(n);
        NIMessageRouterMetaData.setGroupDomainID(string2);
    }

    public static void setNodeData(String string, InetAddress inetAddress, InetAddress inetAddress2, String string2) {
        NIMessageRouterMetaData.setEssServerName(string);
        NIMessageRouterMetaData.setPrimaryInetAddress(inetAddress);
        NIMessageRouterMetaData.setSecondaryInetAddress(inetAddress2);
        NIMessageRouterMetaData.setGroupDomainID(string2);
    }

    public static void updateMetaData(NIRoutingTableEntry nIRoutingTableEntry) {
        NIMessageRouterMetaData.setNodeData(nIRoutingTableEntry.getEssServerName(), nIRoutingTableEntry.getPrimaryIP(), nIRoutingTableEntry.getSecondaryIP(), nIRoutingTableEntry.getDomainGroupID());
    }

    public static boolean isNodeThisServer(NIRoutingTableEntry nIRoutingTableEntry) {
        boolean bl;
        block4: {
            bl = false;
            try {
                if (NIMessageRouterMetaData.getEssServerName() == null || NIMessageRouterMetaData.getEssServerName().length() == 0) {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    if (nIRoutingTableEntry.getPrimaryIP().getHostAddress().compareTo(inetAddress.getHostAddress()) != 0) break block4;
                    bl = true;
                    break block4;
                }
                if (nIRoutingTableEntry.getEssServerName().compareTo(NIMessageRouterMetaData.getEssServerName()) == 0) {
                    bl = true;
                }
            }
            catch (UnknownHostException unknownHostException) {
                logger.throwable((Throwable)unknownHostException);
            }
        }
        return bl;
    }

    protected static boolean isNodeThisServer(String string) {
        boolean bl = false;
        if (string.compareTo(NIMessageRouterMetaData.getEssServerName()) == 0) {
            bl = true;
        }
        return bl;
    }

    static {
        serverState = 0;
        sslConnections = false;
        singleton = null;
        logger = null;
        discoveryMode = true;
        backupNetworkInterfaces = true;
    }
}

