/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NILocalPortManager;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterBroadcastThread;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterCNCThread;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConfigurationInterface;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterDiscoveryThread;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterHeartbeatThread;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterInboundThread;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaDataFile;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableFile;
import java.io.EOFException;

public class NIMessageRouterThread
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterThread == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterThread = NIMessageRouterThread.class$("com.ibm.storage.ess.ni.messageRouter.NIMessageRouterThread")) : class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterThread);
    private static final int NONDISCOVERY_UPDATE_TIME_INTERVAL = 150000;
    private boolean nonDiscoveryMode = false;
    private String fileNamePath = null;
    private NIMessageRouterBroadcastThread broadcastThread = null;
    private NIMessageRouterDiscoveryThread discoveryThread1 = null;
    private NIMessageRouterDiscoveryThread discoveryThread2 = null;
    private NIMessageRouterDiscoveryThread discoveryThread3 = null;
    private NIMessageRouterInboundThread inboundMessageThread = null;
    private NIMessageRouterCNCThread cncThread = null;
    private NIMessageRouterHeartbeatThread heartbeatThread = null;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIMessageRouterThread;

    public NIMessageRouterThread() throws Exception {
        super("NIMessageRouterThread");
        this.setEnvVariables();
        if (NIMessageRouterMetaData.isNonDiscoveryMode()) {
            try {
                NIRoutingTableFile nIRoutingTableFile = new NIRoutingTableFile(NIMessageRouterMetaData.getFileNamePath());
                nIRoutingTableFile.readRoutingTableFile();
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
            }
        } else {
            try {
                NIMessageRouterMetaDataFile nIMessageRouterMetaDataFile = new NIMessageRouterMetaDataFile(NIMessageRouterMetaData.getFileNamePath());
                nIMessageRouterMetaDataFile.readData();
            }
            catch (NIMessageRouterException nIMessageRouterException) {
                logger.error("NIMessageRouterException:  " + nIMessageRouterException.getMRErrorValue());
            }
            catch (EOFException eOFException) {
                logger.throwable((Throwable)eOFException);
                logger.error("Metadata File is empty.");
            }
            catch (Exception exception) {
                logger.throwable((Throwable)exception);
                throw exception;
            }
        }
    }

    public void run() {
        try {
            NIMessageRouterMetaData.setEssServerStateOnline();
            logger.warning("Server ID:  " + NIMessageRouterMetaData.getEssServerName() + "  starting message router threads.");
            if (NIMessageRouterMetaData.isDiscoveryMode()) {
                this.broadcastThread = new NIMessageRouterBroadcastThread();
                this.broadcastThread.start();
                this.discoveryThread1 = new NIMessageRouterDiscoveryThread(NIMessageRouterMetaData.getPrimaryInetAddress(), NIMessageRouterMetaData.getEssBroadcastPort(), true);
                this.discoveryThread2 = new NIMessageRouterDiscoveryThread(NIMessageRouterMetaData.getSecondaryInetAddress(), NIMessageRouterMetaData.getEssBackupBroadcastPort(), false);
                this.discoveryThread3 = new NIMessageRouterDiscoveryThread(NIMessageRouterMetaData.getPrimaryInetAddress(), NIMessageRouterMetaData.getEssBroadcastPortOld(), true);
                this.discoveryThread1.start();
                this.discoveryThread2.start();
                this.discoveryThread3.start();
            }
            NILocalPortManager.getPortManager();
            NIMessageRouterConnectionMonitor.getConnectionMonitor();
            NIMessageRouter nIMessageRouter = NIMessageRouterFactory.getInstanceOf();
            nIMessageRouter.createNIMessageRouterChannel(666);
            if (NIAgentProperties.is1750()) {
                this.heartbeatThread = new NIMessageRouterHeartbeatThread();
                this.heartbeatThread.start();
            }
            this.inboundMessageThread = new NIMessageRouterInboundThread();
            this.inboundMessageThread.start();
            if (NIMessageRouterMetaData.isDiscoveryMode()) {
                this.broadcastThread.join();
                this.discoveryThread1.join();
                this.discoveryThread2.join();
                this.discoveryThread3.join();
                this.inboundMessageThread.join();
            } else if (NIAgentProperties.is1750()) {
                if (NIAgentProperties.isMC()) {
                    NIMessageRouterConfigurationInterface nIMessageRouterConfigurationInterface = (NIMessageRouterConfigurationInterface)nIMessageRouter;
                    nIMessageRouterConfigurationInterface.checkPeer();
                } else {
                    logger.debug_general("Starting CNC routing thread");
                    this.cncThread = new NIMessageRouterCNCThread();
                    this.cncThread.start();
                }
                this.inboundMessageThread.join();
            }
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            logger.error("Error running message router threads.");
        }
    }

    public void shutdown() {
        this.interrupt();
        if (this.broadcastThread != null) {
            this.broadcastThread.shutdown();
        }
        if (this.inboundMessageThread != null) {
            this.inboundMessageThread.shutdown();
        }
        if (this.cncThread != null) {
            this.cncThread.shutdown();
        }
        if (this.heartbeatThread != null) {
            this.heartbeatThread.shutdown();
        }
    }

    private void setEnvVariables() {
        NIMessageRouterMetaData.setFileNamePath(System.getProperty("RoutingTableFileProperty"));
        if (NIMessageRouterMetaData.getFileNamePath() == null) {
            NIMessageRouterMetaData.setFileNamePath(System.getProperty("NodeDataFileProperty"));
            NIMessageRouterMetaData.setDiscoveryMode(true);
            NIMessageRouterMetaData.setBackupNetworkInterfacesActive(true);
            NIMessageRouterMetaData.setSSLConnectionsInactive();
        } else {
            String string = System.getProperty("com.ibm.storage.ess.ni.communication.common.ConnectionType");
            if (string != null && string.compareTo("NOSSL") == 0) {
                NIMessageRouterMetaData.setSSLConnectionsInactive();
            } else if (NIAgentProperties.getAgentType() == 2 || NIAgentProperties.getAgentType() == 3) {
                NIMessageRouterMetaData.setSSLConnectionsInactive();
            } else {
                NIMessageRouterMetaData.setSSLConnectionsActive();
            }
            NIMessageRouterMetaData.setBackupNetworkInterfacesActive(false);
            NIMessageRouterMetaData.setDiscoveryMode(false);
        }
        if (NIMessageRouterMetaData.getFileNamePath() == null) {
            logger.error("Neither node data file, nor routing table file specified.");
        } else {
            logger.debug_general("File name path = " + NIMessageRouterMetaData.getFileNamePath());
        }
        if (NIMessageRouterMetaData.isDiscoveryMode()) {
            logger.debug_general("Discovery mode = true");
        } else {
            logger.debug_general("Discovery mode = false");
        }
        if (NIMessageRouterMetaData.areSSLConnectionsActive()) {
            logger.debug_general("SSL Connections used for ESS node communication");
        }
    }

    public void dump() {
        if (logger != null) {
            logger.dump();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

