/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterEstablishConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NIRoutingTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map table = null;
    private static NIRoutingTable routingTable = null;
    private Object tableLock = new Object();

    private NIRoutingTable() {
        this.table = Collections.synchronizedMap(new HashMap());
    }

    protected static synchronized NIRoutingTable getRoutingTable() {
        if (routingTable == null) {
            routingTable = new NIRoutingTable();
        }
        return routingTable;
    }

    public NIRoutingTableEntry merge(NIRoutingTableEntry nIRoutingTableEntry, NIRoutingTableEntry nIRoutingTableEntry2, boolean bl) {
        NIRoutingTableEntry nIRoutingTableEntry3 = nIRoutingTableEntry2.merge(nIRoutingTableEntry, bl);
        this.add(nIRoutingTableEntry3);
        return nIRoutingTableEntry3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NIRoutingTableEntry nIRoutingTableEntry) {
        Object object = this.tableLock;
        synchronized (object) {
            if (nIRoutingTableEntry != null) {
                nIRoutingTableEntry.setClean();
                this.table.put(nIRoutingTableEntry.getKey(), nIRoutingTableEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIRoutingTableEntry remove(String string) {
        Object object = this.tableLock;
        synchronized (object) {
            NIRoutingTableEntry nIRoutingTableEntry = (NIRoutingTableEntry)this.table.remove(string);
            if (nIRoutingTableEntry != null) {
                nIRoutingTableEntry.setDirty();
            }
            return nIRoutingTableEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Iterator iterator;
        if (NIAgentProperties.is1750()) {
            iterator = this.table.values().iterator();
            NIMessageRouterEstablishConnectionMonitor nIMessageRouterEstablishConnectionMonitor = NIMessageRouterEstablishConnectionMonitor.getConnectionTable();
            while (iterator.hasNext()) {
                NIRoutingTableEntry nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
                if (nIRoutingTableEntry == null) continue;
                nIRoutingTableEntry.setDirty();
                nIMessageRouterEstablishConnectionMonitor.stop(nIRoutingTableEntry.getEssServerName());
            }
        }
        iterator = this.tableLock;
        synchronized (iterator) {
            this.table.clear();
        }
    }

    public NIRoutingTableEntry get(String string) {
        return (NIRoutingTableEntry)this.table.get(string);
    }

    public NIRoutingTableEntry getByIP(String string) {
        NIRoutingTableEntry nIRoutingTableEntry = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
            if (nIRoutingTableEntry.getPrimaryIP().getHostAddress().compareTo(string) != 0) continue;
            return nIRoutingTableEntry;
        }
        return null;
    }

    public NIRoutingTableEntry getByIP(String string, int n) {
        NIRoutingTableEntry nIRoutingTableEntry = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
            if (nIRoutingTableEntry.getPrimaryIP().getHostAddress().compareTo(string) != 0) continue;
            if (n < 10000) {
                return nIRoutingTableEntry;
            }
            if (nIRoutingTableEntry.getEssServerPort() / 100 != n / 100) continue;
            return nIRoutingTableEntry;
        }
        return null;
    }

    public int size() {
        return this.table.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        HashMap<String, NIRoutingTableEntry> hashMap = new HashMap<String, NIRoutingTableEntry>();
        Iterator iterator = null;
        Object object = this.tableLock;
        synchronized (object) {
            iterator = this.table.values().iterator();
            while (iterator.hasNext()) {
                NIRoutingTableEntry nIRoutingTableEntry = (NIRoutingTableEntry)iterator.next();
                hashMap.put(nIRoutingTableEntry.getKey(), nIRoutingTableEntry);
            }
        }
        return hashMap.values().iterator();
    }

    public boolean contains(String string) {
        return this.table.containsKey(string);
    }

    protected Map getTableMap() {
        return this.table;
    }
}

