/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIBroadcastMessage;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterConnection;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterEssNodeData;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterEstablishConnectionMonitor;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterSocketConnection;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;

public class NIRoutingTableEntry
implements Serializable {
    public static final int MAX_IPS = 2;
    private static final long serialVersionUID = 1L;
    private static final int ESS_SERVER_ONLINE = 0;
    private static final int ESS_SERVER_OFFLINE = 1;
    private String essServerName;
    private InetAddress primaryIP;
    private InetAddress secondaryIP;
    private String domainGroupID;
    private Integer essServerPort;
    private Integer secondaryPort;
    private transient Boolean needsUpdate = Boolean.TRUE;
    private transient boolean usePrimaryIP = true;
    private transient long timeStamp = new Date().getTime();
    private transient long secondaryTimeStamp = new Date().getTime();
    private transient int essServerState = 0;
    private transient int essSecondaryServerState = 0;
    private boolean dirty = false;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableEntry == null ? (class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableEntry = NIRoutingTableEntry.class$("com.ibm.storage.ess.ni.messageRouter.NIRoutingTableEntry")) : class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableEntry);
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$messageRouter$NIRoutingTableEntry;

    public NIRoutingTableEntry(String string, InetAddress inetAddress, InetAddress inetAddress2, int n, String string2) {
        this.essServerName = string;
        this.primaryIP = inetAddress;
        this.secondaryIP = inetAddress2;
        this.domainGroupID = string2;
        this.secondaryPort = this.essServerPort = new Integer(n);
        this.updateTimeStamp();
        this.setEssOnline();
        this.updateNeeded();
    }

    public NIRoutingTableEntry(String string, InetAddress inetAddress, InetAddress inetAddress2, int n, int n2, String string2) {
        this(string, inetAddress, inetAddress2, n, string2);
        this.secondaryIP = inetAddress2;
        this.secondaryPort = new Integer(n2);
        this.updateSecondaryTimeStamp();
        this.setSecondaryEssOnline();
        this.updateNeeded();
    }

    public NIRoutingTableEntry(NIBroadcastMessage nIBroadcastMessage) {
        this(nIBroadcastMessage.getServerName(), nIBroadcastMessage.getIPAddress1(), nIBroadcastMessage.getIPAddress2(), nIBroadcastMessage.getPortNumber(), nIBroadcastMessage.getSecondaryPortNumber(), nIBroadcastMessage.getDomainGroupID());
    }

    public NIRoutingTableEntry(NIMessageRouterEssNodeData nIMessageRouterEssNodeData) {
        this(nIMessageRouterEssNodeData.getEssServerName(), nIMessageRouterEssNodeData.getPrimaryIP(), nIMessageRouterEssNodeData.getSecondaryIP(), nIMessageRouterEssNodeData.getEssServerPort(), nIMessageRouterEssNodeData.getSecondaryEssServerPort(), nIMessageRouterEssNodeData.getDomainGroupID());
    }

    private NIRoutingTableEntry(NIRoutingTableEntry nIRoutingTableEntry, NIRoutingTableEntry nIRoutingTableEntry2, boolean bl) {
        this.essServerName = nIRoutingTableEntry.getEssServerName();
        this.primaryIP = nIRoutingTableEntry.getPrimaryIP();
        this.secondaryIP = nIRoutingTableEntry.getSecondaryIP();
        this.domainGroupID = nIRoutingTableEntry.getDomainGroupID();
        this.essServerPort = new Integer(nIRoutingTableEntry.getPrimaryPort());
        this.secondaryPort = new Integer(nIRoutingTableEntry.getSecondaryPort());
        this.needsUpdate = nIRoutingTableEntry2.needsUpdate;
        if (bl) {
            this.updateTimeStamp();
            this.secondaryTimeStamp = nIRoutingTableEntry2.secondaryTimeStamp;
        } else {
            this.updateSecondaryTimeStamp();
            this.timeStamp = nIRoutingTableEntry2.timeStamp;
        }
        this.essServerState = nIRoutingTableEntry2.essServerState;
        this.essSecondaryServerState = nIRoutingTableEntry2.essSecondaryServerState;
    }

    public String getKey() {
        return this.getEssServerName();
    }

    public NIRoutingTableEntry merge(NIRoutingTableEntry nIRoutingTableEntry, boolean bl) {
        NIRoutingTableEntry nIRoutingTableEntry2 = new NIRoutingTableEntry(nIRoutingTableEntry, this, bl);
        return nIRoutingTableEntry2;
    }

    public String getEssServerName() {
        return this.essServerName;
    }

    public InetAddress getIP() {
        InetAddress inetAddress = null;
        if (this.usePrimaryIP) {
            this.usePrimaryIP = false;
            if (this.isEssOnline()) {
                inetAddress = this.getPrimaryIP();
            }
        } else {
            this.usePrimaryIP = true;
            if (this.isSecondaryEssOnline()) {
                inetAddress = this.getSecondaryIP();
            }
        }
        return inetAddress;
    }

    public InetAddress getPrimaryIP() {
        return this.primaryIP;
    }

    public InetAddress getSecondaryIP() {
        if (this.secondaryIP == null) {
            this.secondaryIP = this.primaryIP;
        }
        return this.secondaryIP;
    }

    protected void setPrimaryIP(InetAddress inetAddress) {
        this.primaryIP = inetAddress;
    }

    protected void setSecondaryIP(InetAddress inetAddress) {
        this.secondaryIP = inetAddress;
    }

    public String getDomainGroupID() {
        return this.domainGroupID;
    }

    public int getEssServerPort() {
        if (this.usePrimaryIP) {
            return this.secondaryPort;
        }
        return this.essServerPort;
    }

    public int getSecondaryPort() {
        if (this.secondaryPort == null) {
            this.secondaryPort = this.essServerPort;
        }
        return this.secondaryPort;
    }

    public int getPrimaryPort() {
        return this.essServerPort;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getSecondaryTimeStamp() {
        return this.secondaryTimeStamp;
    }

    protected void updateTimeStamp() {
        this.timeStamp = new Date().getTime();
    }

    protected void updateSecondaryTimeStamp() {
        this.secondaryTimeStamp = new Date().getTime();
    }

    protected void setEssOffline() {
        this.essServerState = 1;
    }

    protected void setSecondaryEssOffline() {
        this.essSecondaryServerState = 1;
    }

    protected void setEssOnline() {
        this.essServerState = 0;
    }

    protected void setSecondaryEssOnline() {
        this.essSecondaryServerState = 0;
    }

    public boolean isEssOnline() {
        return this.essServerState == 0;
    }

    public boolean isSecondaryEssOnline() {
        return this.essSecondaryServerState == 0;
    }

    protected void updateNeeded() {
        this.needsUpdate = Boolean.TRUE;
    }

    protected void nodeUpdated() {
        this.needsUpdate = Boolean.FALSE;
    }

    public boolean isNodeUpdated() {
        if (this.needsUpdate == null) {
            this.updateNeeded();
        }
        return this.needsUpdate == false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("Routing Table Entry = ");
        stringBuffer.append("\n");
        stringBuffer.append("  ESS Server Name = ");
        stringBuffer.append(this.getEssServerName());
        stringBuffer.append("\n");
        stringBuffer.append("  ESS Server Ports = ");
        stringBuffer.append(this.getPrimaryPort());
        stringBuffer.append("  +  ");
        stringBuffer.append(this.getSecondaryPort());
        stringBuffer.append("\n");
        stringBuffer.append("  ESS Server Primary IP = ");
        stringBuffer.append(this.getPrimaryIP().toString());
        stringBuffer.append("\n");
        stringBuffer.append("  ESS Server Secondary IP = ");
        stringBuffer.append(this.getSecondaryIP().toString());
        stringBuffer.append("\n");
        stringBuffer.append("  ESS Server Domain Group = ");
        stringBuffer.append(this.getDomainGroupID());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected NIMessageRouterConnection getConnection() {
        NIMessageRouterSocketConnection nIMessageRouterSocketConnection = null;
        if (NIAgentProperties.is1750()) {
            if (this.dirty) {
                logger.error("RTE " + this.getKey() + " is dirty");
                return null;
            }
            nIMessageRouterSocketConnection = NIMessageRouterEstablishConnectionMonitor.getConnectionTable().get(this.getKey());
            if (!(nIMessageRouterSocketConnection == null || nIMessageRouterSocketConnection.isConnecting() && nIMessageRouterSocketConnection.getEssServerIP().equals(this.getPrimaryIP()))) {
                NIMessageRouterEstablishConnectionMonitor.getConnectionTable().stop(this.getKey());
                nIMessageRouterSocketConnection = null;
            }
        }
        if (nIMessageRouterSocketConnection == null) {
            if (this.getPrimaryPort() != this.getSecondaryPort()) {
                InetAddress inetAddress = this.getIP();
                if (inetAddress != null) {
                    nIMessageRouterSocketConnection = new NIMessageRouterSocketConnection(this.getKey(), inetAddress, this.getEssServerPort(), !this.usePrimaryIP);
                }
            } else {
                nIMessageRouterSocketConnection = new NIMessageRouterSocketConnection(this.getKey(), this.getPrimaryIP(), this.getPrimaryPort(), true);
            }
            this.updateNeeded();
        }
        return nIMessageRouterSocketConnection;
    }

    public boolean equals(NIRoutingTableEntry nIRoutingTableEntry) {
        if (nIRoutingTableEntry == null) {
            return false;
        }
        return nIRoutingTableEntry.getDomainGroupID().compareTo(this.getDomainGroupID()) == 0 && nIRoutingTableEntry.getEssServerName().compareTo(this.getEssServerName()) == 0 && nIRoutingTableEntry.getPrimaryIP().equals(this.primaryIP) && nIRoutingTableEntry.getPrimaryPort() == this.getPrimaryPort() && nIRoutingTableEntry.getSecondaryIP().equals(this.secondaryIP) && nIRoutingTableEntry.getSecondaryPort() == this.getSecondaryPort();
    }

    public void setDirty() {
        this.dirty = true;
    }

    public void setClean() {
        this.dirty = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

