/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.messageRouter.common;

import com.ibm.storage.ess.ni.messageRouter.common.NIInvalidMessageAddressException;
import java.io.Serializable;

public class NIMessageRouterAddress
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer processChannelID;
    private String essServerName;

    public NIMessageRouterAddress(int n, String string) {
        this.processChannelID = new Integer(n);
        this.essServerName = string != null ? string : new String();
    }

    public String getEssServerName() {
        return this.essServerName;
    }

    public int getProcessChannelID() {
        return this.processChannelID;
    }

    public int compareTo(NIMessageRouterAddress nIMessageRouterAddress) {
        if (this.getEssServerName().compareTo(nIMessageRouterAddress.getEssServerName()) != 0) {
            return -1;
        }
        if (this.getProcessChannelID() != nIMessageRouterAddress.getProcessChannelID()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getEssServerName());
        stringBuffer.append(", ");
        stringBuffer.append(this.processChannelID.toString());
        return stringBuffer.toString();
    }

    public boolean isValid() throws NIInvalidMessageAddressException {
        if (this.processChannelID < 0) {
            throw new NIInvalidMessageAddressException("Invalid process channel ID");
        }
        if (this.essServerName == null) {
            throw new NIInvalidMessageAddressException("Invalid destination server");
        }
        return true;
    }

    public void setServerName(String string) {
        this.essServerName = string;
    }
}

