/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.olc;

import com.ibm.storage.ess.ni.application.resource.NIEnterprise;
import com.ibm.storage.ess.ni.application.resource.NIOfflineStoragePlex;
import com.ibm.storage.ess.ni.commandagent.NICommandAgent;
import com.ibm.storage.ess.ni.commandagent.NICommandAgentStartupException;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIEnterpriseID;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterThread;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseManager;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import com.ibm.storage.ess.ni.olc.services.NIOlcEnterpriseService;
import com.ibm.storage.ess.ni.olc.services.NIOlcHostConfigurationService;
import com.ibm.storage.ess.ni.olc.services.NIOlcLogicalConfigurationService;
import com.ibm.storage.ess.ni.olc.services.NIOlcOfflineDomainService;
import com.ibm.storage.ess.ni.olc.services.NIOlcPhysicalConfigurationService;
import java.io.File;
import java.util.List;

public class NIOlc {
    private static NIMessageRouterChannel channel;

    private NIOlc() {
    }

    public static void startCloudscape() {
        try {
            NIOlcDatabaseManager nIOlcDatabaseManager = new NIOlcDatabaseManager();
            nIOlcDatabaseManager.start();
        }
        catch (Exception exception) {
            NIOlcLogger.severe("Cloudscape exception", exception);
        }
    }

    public static void importXML(String string) {
        File file = new File(System.getProperty("user.dir") + File.separator + "xml" + File.separator + "olc.xml");
        if (!file.exists()) {
            return;
        }
        File file2 = new File(System.getProperty("user.dir") + File.separator + "xml" + File.separator + "olc_imported.xml");
        System.out.println("Importing file: " + file);
        if (NIOlcDatabaseManager.databaseExists("$TestEnterprise")) {
            NIOlcDatabaseManager.dropDatabase("$TestEnterprise");
        }
        NIOlcEnterpriseService nIOlcEnterpriseService = new NIOlcEnterpriseService();
        try {
            nIOlcEnterpriseService.importEnterpriseFromXML(file, new NIEnterpriseID(0, "MyDatabase"));
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            nIUnavailableServerException.printStackTrace();
        }
        catch (NIUnsupportedException nIUnsupportedException) {
            nIUnsupportedException.printStackTrace();
        }
        catch (NIUnauthorizedServerException nIUnauthorizedServerException) {
            nIUnauthorizedServerException.printStackTrace();
        }
        catch (NIServerException nIServerException) {
            nIServerException.printStackTrace();
        }
        file.renameTo(file2);
        System.out.println("File renamed to: " + file2);
        System.out.println(" ** Configuration successfully imported ** ");
    }

    private static void startCommandAgent() {
        NICommandAgent nICommandAgent = new NICommandAgent();
        NIMessageRouterAddress nIMessageRouterAddress = new NIMessageRouterAddress(2, "HMC");
        nICommandAgent.setLocalNodeAddress(nIMessageRouterAddress);
        nICommandAgent.setServiceClasses(new Object[]{new NIOlcEnterpriseService(), new NIOlcHostConfigurationService(), new NIOlcLogicalConfigurationService(), new NIOlcOfflineDomainService(), new NIOlcPhysicalConfigurationService()});
        try {
            nICommandAgent.startup();
        }
        catch (NICommandAgentStartupException nICommandAgentStartupException) {
            NIOlcLogger.severe("Unable to start command agent.", nICommandAgentStartupException);
        }
    }

    private static void startMessageRouter() {
        NIMessageRouter nIMessageRouter = NIMessageRouterFactory.getInstanceOf();
        NIMessageRouterThread nIMessageRouterThread = null;
        try {
            nIMessageRouterThread = new NIMessageRouterThread();
            nIMessageRouterThread.start();
        }
        catch (Exception exception) {
            NIOlcLogger.severe("Unable to create Message Router due to invalid message router metadata file.", exception);
        }
        try {
            channel = nIMessageRouter.createNIMessageRouterChannel(2);
        }
        catch (NIMessageRouterException nIMessageRouterException) {
            NIOlcLogger.severe("Unable to create Message Router process channel because it is already in use.", nIMessageRouterException);
        }
    }

    public static void main(String[] stringArray) {
        NIOlcLogger.info("************* Starting OLC **************");
        NIOlcLogger.info("Message Router Started");
        NIOlcLogger.info("Command Agent Started");
        NIOlc.startCloudscape();
        NIOlcLogger.info("Cloudscape Started");
        NIOlc.sanityTest();
        if (stringArray.length > 0) {
            NIOlc.importXML(stringArray[0]);
        }
    }

    public static void sanityTest() {
        System.out.println("Sleeping");
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        System.out.println("Awake");
        NIOlcEnterpriseService nIOlcEnterpriseService = new NIOlcEnterpriseService();
        try {
            List list = nIOlcEnterpriseService.getEnterprises("IBM_USER").getResourceList();
            System.out.println("Enterprises\n--------------\n");
            int n = 0;
            while (n < list.size()) {
                NIEnterprise nIEnterprise = (NIEnterprise)list.get(n);
                System.out.println(" -- Enterprise --> " + nIEnterprise.getUserName());
                List list2 = nIOlcEnterpriseService.getStoragePlexes((NIEnterpriseID)nIEnterprise.getID()).getResourceList();
                int n2 = 0;
                while (n2 < list2.size()) {
                    NIOfflineStoragePlex nIOfflineStoragePlex = (NIOfflineStoragePlex)list2.get(n2);
                    System.out.println("    -- Plex --> " + nIOfflineStoragePlex.isOnline());
                    ++n2;
                }
                ++n;
            }
        }
        catch (NIUnavailableServerException nIUnavailableServerException) {
            nIUnavailableServerException.printStackTrace();
        }
        catch (NIUnsupportedException nIUnsupportedException) {
            nIUnsupportedException.printStackTrace();
        }
        catch (NIUnauthorizedServerException nIUnauthorizedServerException) {
            nIUnauthorizedServerException.printStackTrace();
        }
        catch (NIServerException nIServerException) {
            nIServerException.printStackTrace();
        }
    }
}

