/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.olc;

import com.ibm.storage.ess.ni.application.resource.NIEnterprise;
import com.ibm.storage.ess.ni.identifiers.NIEnterpriseID;
import com.ibm.storage.ess.ni.olc.NIOlcCommon;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseHelper;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public final class NIOlcDatabaseMasterHelper
extends NIOlcDatabaseHelper {
    private static final String MASTER_TABLE = "Enterprises";
    private static final String MASTER_TABLE_CREATE_DDL = "CREATE TABLE Enterprises (enterprise_id SMALLINT DEFAULT AUTOINCREMENT,object com.ibm.storage.ess.ni.application.resource.NIEnterprise NOT NULL,database_name VARCHAR(64) NOT NULL,CONSTRAINT ENTERPRISES_PK PRIMARY KEY (ENTERPRISE_ID))";
    private static final String MASTER_TABLE_DROP_DDL = "DROP TABLE Enterprises";
    private static final String SELECT_DATABASE_NAMES = "SELECT CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIEnterpriseID).getDatabase() FROM Enterprises";
    private static final String SELECT_DATABASE_NAMES_A = "SELECT database_name FROM Enterprises";
    private static String INSERT_ENTRY_DML = "INSERT INTO Enterprises (object,database_name) VALUES(?,?)";
    private static String DELETE_ENTRY_A_DML = "DELETE FROM Enterprises WHERE CAST(object.getID() AS com.ibm.storage.ess.ni.identifiers.NIEnterpriseID).getDatabase()=?";
    private static String DELETE_ENTRY_B_DML = "DELETE FROM Enterprises WHERE database_name=?";
    private static String UPDATE_ENTRY_DML = "UPDATE Enterprises SET object=? WHERE database_name=?";
    private static String SELECT_ENTRY_A_DML = "SELECT object FROM Enterprises WHERE object.getUserID()=? AND database_name NOT LIKE '$%'";
    private static String SELECT_ENTRY_B_DML = "SELECT object FROM Enterprises WHERE enterprise_id=?";
    private static String SELECT_ENTRY_C_DML = "SELECT object FROM Enterprises WHERE database_name=?";
    private static PreparedStatement PS_INSERT_ENTRY;
    private static PreparedStatement PS_UPDATE_ENTRY;
    private static PreparedStatement PS_DELETE_ENTRY_A;
    private static PreparedStatement PS_DELETE_ENTRY_B;
    private static PreparedStatement PS_SELECT_ENTRY_A;
    private static PreparedStatement PS_SELECT_ENTRY_B;
    private static PreparedStatement PS_SELECT_ENTRY_C;

    public NIOlcDatabaseMasterHelper(Connection connection, String string) {
        super(connection, string);
    }

    protected void prepareAllStatements() {
        PS_INSERT_ENTRY = this.prepareStatement(INSERT_ENTRY_DML);
        PS_UPDATE_ENTRY = this.prepareStatement(UPDATE_ENTRY_DML);
        PS_DELETE_ENTRY_A = this.prepareStatement(DELETE_ENTRY_A_DML);
        PS_DELETE_ENTRY_B = this.prepareStatement(DELETE_ENTRY_B_DML);
        PS_SELECT_ENTRY_A = this.prepareStatement(SELECT_ENTRY_A_DML);
        PS_SELECT_ENTRY_B = this.prepareStatement(SELECT_ENTRY_B_DML);
        PS_SELECT_ENTRY_C = this.prepareStatement(SELECT_ENTRY_C_DML);
    }

    protected boolean generateSchema() {
        NIOlcLogger.info("in master generate");
        this.dropMasterTable();
        return this.executeUpdate(this.stmt, MASTER_TABLE_CREATE_DDL) > -1;
    }

    protected void dropMasterTable() {
        this.executeUpdate(this.stmt, MASTER_TABLE_DROP_DDL);
    }

    protected ArrayList getDatabaseNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = this.executeQuery(this.stmt, SELECT_DATABASE_NAMES_A);
        try {
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public boolean insertEnterprise(NIEnterprise nIEnterprise, String string) {
        PreparedStatement preparedStatement = PS_INSERT_ENTRY;
        try {
            preparedStatement.setObject(1, nIEnterprise);
            preparedStatement.setString(2, string);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        boolean bl = this.executeUpdate(preparedStatement) == 1;
        this.setKey(preparedStatement);
        return bl;
    }

    public boolean modifyEnterprise(NIEnterprise nIEnterprise) {
        NIEnterpriseID nIEnterpriseID = (NIEnterpriseID)nIEnterprise.getID();
        PreparedStatement preparedStatement = PS_UPDATE_ENTRY;
        try {
            preparedStatement.setObject(1, nIEnterprise);
            preparedStatement.setString(2, NIOlcCommon.getRealDatabaseName(nIEnterpriseID.getDatabase()));
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == 1;
    }

    public boolean deleteEnterprise(NIEnterpriseID nIEnterpriseID) {
        PreparedStatement preparedStatement = PS_DELETE_ENTRY_A;
        try {
            preparedStatement.setString(1, nIEnterpriseID.getDatabase());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == 1;
    }

    public boolean deleteEnterpriseByDatabase(String string) {
        PreparedStatement preparedStatement = PS_DELETE_ENTRY_B;
        try {
            preparedStatement.setString(1, string);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == 1;
    }

    public ArrayList getEnterprises(String string) {
        PreparedStatement preparedStatement = PS_SELECT_ENTRY_A;
        try {
            preparedStatement.setString(1, string);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        ArrayList<NIEnterprise> arrayList = new ArrayList<NIEnterprise>();
        ResultSet resultSet = this.executeQuery(preparedStatement);
        try {
            while (resultSet.next()) {
                arrayList.add((NIEnterprise)resultSet.getObject(1));
            }
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public NIEnterprise getEnterprise(NIEnterpriseID nIEnterpriseID) {
        PreparedStatement preparedStatement = PS_SELECT_ENTRY_B;
        try {
            preparedStatement.setInt(1, nIEnterpriseID.getPrimaryKey());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        NIEnterprise nIEnterprise = null;
        ResultSet resultSet = this.executeQuery(preparedStatement);
        try {
            while (resultSet.next()) {
                nIEnterprise = (NIEnterprise)resultSet.getObject(1);
            }
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return nIEnterprise;
    }

    public NIEnterprise getEnterpriseByDatabase(String string) {
        PreparedStatement preparedStatement = PS_SELECT_ENTRY_C;
        try {
            preparedStatement.setString(1, string);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        NIEnterprise nIEnterprise = null;
        ResultSet resultSet = this.executeQuery(preparedStatement);
        try {
            while (resultSet.next()) {
                nIEnterprise = (NIEnterprise)resultSet.getObject(1);
            }
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return nIEnterprise;
    }
}

