/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.olc;

import com.ibm.storage.ess.ni.application.resource.NIAddressGroup;
import com.ibm.storage.ess.ni.application.resource.NIArray;
import com.ibm.storage.ess.ni.application.resource.NIArraySite;
import com.ibm.storage.ess.ni.application.resource.NIExtentPool;
import com.ibm.storage.ess.ni.application.resource.NIIOPort;
import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.application.resource.NIOfflineESS;
import com.ibm.storage.ess.ni.application.resource.NIOfflineStorageFacility;
import com.ibm.storage.ess.ni.application.resource.NIOfflineStoragePlex;
import com.ibm.storage.ess.ni.application.resource.NIRank;
import com.ibm.storage.ess.ni.application.resource.NISCSIHostPort;
import com.ibm.storage.ess.ni.application.resource.NIStorageDeviceFRU;
import com.ibm.storage.ess.ni.application.resource.NIStorageEnclosure;
import com.ibm.storage.ess.ni.application.resource.NIStorageFacility;
import com.ibm.storage.ess.ni.application.resource.NIVolumeGroup;
import com.ibm.storage.ess.ni.identifiers.NIAddressGroupID;
import com.ibm.storage.ess.ni.identifiers.NIArrayID;
import com.ibm.storage.ess.ni.identifiers.NIArraySiteID;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.identifiers.NIEnclosureID;
import com.ibm.storage.ess.ni.identifiers.NIEnterpriseID;
import com.ibm.storage.ess.ni.identifiers.NIExtentPoolID;
import com.ibm.storage.ess.ni.identifiers.NIIOPortID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIRankID;
import com.ibm.storage.ess.ni.identifiers.NISCSIHostPortID;
import com.ibm.storage.ess.ni.identifiers.NIStorageFacilityID;
import com.ibm.storage.ess.ni.identifiers.NIStoragePlexID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeGroupID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.olc.NIOlcDatabaseHelper;
import com.ibm.storage.ess.ni.olc.NIOlcLogger;
import com.ibm.storage.ess.ni.option.config.NIDeviceType;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.resource.NILSSVolumeSetImpl;
import com.ibm.storage.ess.ni.resource.NIVolumeImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class NIOlcDatabaseSchemaHelper
extends NIOlcDatabaseHelper {
    private static short SINGLE_UPDATE = 1;
    private static HashMap TABLE_DROP_DDL = new HashMap();
    private static HashMap TABLE_CREATE_DDL = new HashMap();

    public NIOlcDatabaseSchemaHelper(Connection connection, String string) {
        super(connection, string);
    }

    protected void prepareAllStatements() {
        Object object;
        Object object2;
        Object object3;
        if (this.INSERT_PS.size() > 0 && this.SELECT_PS.size() > 0 && this.UPDATE_PS.size() > 0 && this.DELETE_PS.size() > 0) {
            return;
        }
        Iterator iterator = NIOlcDatabaseHelper.INSERT_DML.keySet().iterator();
        while (iterator.hasNext()) {
            object3 = (Integer)iterator.next();
            this.INSERT_PS.put(object3, this.prepareStatement((String)NIOlcDatabaseHelper.INSERT_DML.get(object3)));
        }
        NIOlcLogger.info("INSERT SQL statements prepared");
        object3 = NIOlcDatabaseHelper.SELECT_DML.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (Integer)object3.next();
            this.SELECT_PS.put(object2, this.prepareStatement((String)NIOlcDatabaseHelper.SELECT_DML.get(object2)));
        }
        NIOlcLogger.info("SELECT SQL statements prepared");
        object2 = NIOlcDatabaseHelper.UPDATE_DML.keySet().iterator();
        while (object2.hasNext()) {
            object = (Integer)object2.next();
            this.UPDATE_PS.put(object, this.prepareStatement((String)NIOlcDatabaseHelper.UPDATE_DML.get(object)));
        }
        NIOlcLogger.info("UPDATE SQL statements prepared");
        object = NIOlcDatabaseHelper.DELETE_DML.keySet().iterator();
        while (object.hasNext()) {
            Integer n = (Integer)object.next();
            this.DELETE_PS.put(n, this.prepareStatement((String)NIOlcDatabaseHelper.DELETE_DML.get(n)));
        }
        NIOlcLogger.info("DELETE SQL statements prepared");
    }

    protected boolean generateSchema() {
        NIOlcLogger.info("in regular generate");
        boolean bl = false;
        this.setConstraints("SET CONSTRAINTS ALL DISABLED");
        this.dropTables();
        bl = this.createTables();
        this.setConstraints("SET CONSTRAINTS ALL ENABLED");
        return bl;
    }

    private boolean dropTables() {
        NIOlcLogger.info("Dropping tables");
        boolean bl = true;
        Iterator iterator = TABLE_DROP_DDL.values().iterator();
        while (iterator.hasNext()) {
            bl &= this.executeUpdate(this.stmt, (String)iterator.next()) != -1;
        }
        return bl;
    }

    private boolean createTables() {
        NIOlcLogger.info("Creating tables");
        boolean bl = true;
        int n = 0;
        while (n < TABLE_CREATE_DDL.size()) {
            bl &= this.executeUpdate(this.stmt, (String)TABLE_CREATE_DDL.get(new Integer(n))) != -1;
            ++n;
        }
        return bl;
    }

    public boolean insertStoragePlex(NIOfflineStoragePlex nIOfflineStoragePlex) {
        PreparedStatement preparedStatement = (PreparedStatement)this.INSERT_PS.get(NIOlcDatabaseHelper.INSERT_PLEX);
        try {
            preparedStatement.setObject(1, nIOfflineStoragePlex);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        boolean bl = this.executeUpdate(preparedStatement) == 1;
        this.setKey(preparedStatement);
        return bl;
    }

    public List getStoragePlex(NIStoragePlexID nIStoragePlexID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_PLEX);
        ArrayList<NIOfflineStoragePlex> arrayList = new ArrayList<NIOfflineStoragePlex>();
        try {
            preparedStatement.setInt(1, nIStoragePlexID.getPrimaryKey());
            ResultSet resultSet = this.executeQuery(preparedStatement);
            if (resultSet.next()) {
                arrayList.add((NIOfflineStoragePlex)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getStoragePlexes(NIEnterpriseID nIEnterpriseID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_PLEXES);
        ResultSet resultSet = this.executeQuery(preparedStatement);
        ArrayList<NIOfflineStoragePlex> arrayList = new ArrayList<NIOfflineStoragePlex>();
        try {
            while (resultSet.next()) {
                arrayList.add((NIOfflineStoragePlex)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public boolean modifyStoragePlex(NIOfflineStoragePlex nIOfflineStoragePlex) {
        PreparedStatement preparedStatement = (PreparedStatement)this.UPDATE_PS.get(NIOlcDatabaseHelper.UPDATE_PLEX);
        try {
            preparedStatement.setObject(1, nIOfflineStoragePlex);
            preparedStatement.setInt(2, ((NIStoragePlexID)nIOfflineStoragePlex.getID()).getPrimaryKey());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean deleteStoragePlex(NIStoragePlexID nIStoragePlexID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_PLEX);
        try {
            preparedStatement.setInt(1, nIStoragePlexID.getPrimaryKey());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean insertStorageFacility(NIOfflineStorageFacility nIOfflineStorageFacility, NIStoragePlexID nIStoragePlexID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.INSERT_PS.get(NIOlcDatabaseHelper.INSERT_FACILITY);
        try {
            preparedStatement.setInt(1, nIStoragePlexID.getPrimaryKey());
            preparedStatement.setObject(2, nIOfflineStorageFacility);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean modifyStorageFacility(NIOfflineStorageFacility nIOfflineStorageFacility) {
        PreparedStatement preparedStatement = (PreparedStatement)this.UPDATE_PS.get(NIOlcDatabaseHelper.UPDATE_FACILITY);
        try {
            preparedStatement.setObject(1, nIOfflineStorageFacility);
            preparedStatement.setInt(2, ((NIStorageFacilityID)nIOfflineStorageFacility.getID()).getStoragePlex().getPrimaryKey());
            preparedStatement.setObject(3, (NIStorageFacilityID)nIOfflineStorageFacility.getID());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public List getFacilities() {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_FACILITY_D);
        ArrayList<NIStorageFacility> arrayList = new ArrayList<NIStorageFacility>();
        try {
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NIStorageFacility)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getFacilityByPlex(NIStoragePlexID nIStoragePlexID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_FACILITY_A);
        ArrayList<NIStorageFacility> arrayList = new ArrayList<NIStorageFacility>();
        try {
            preparedStatement.setInt(1, nIStoragePlexID.getPrimaryKey());
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NIStorageFacility)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getFacilityByID(NIStorageFacilityID[] nIStorageFacilityIDArray) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_FACILITY_B);
        ArrayList<NIStorageFacility> arrayList = new ArrayList<NIStorageFacility>();
        int n = 0;
        while (n < nIStorageFacilityIDArray.length) {
            try {
                preparedStatement.setObject(1, nIStorageFacilityIDArray[n]);
                ResultSet resultSet = this.executeQuery(preparedStatement);
                if (resultSet.next()) {
                    arrayList.add((NIStorageFacility)resultSet.getObject(1));
                }
                resultSet.close();
                preparedStatement.clearParameters();
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
            ++n;
        }
        return arrayList;
    }

    private int getFacilityPrimaryKey(NIStorageFacilityID nIStorageFacilityID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_FACILITY_C);
        int n = -1;
        try {
            preparedStatement.setObject(1, nIStorageFacilityID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return n;
    }

    public boolean deleteStorageFacility(NIStorageFacilityID nIStorageFacilityID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_FACILITY);
        try {
            preparedStatement.setInt(1, nIStorageFacilityID.getStoragePlex().getPrimaryKey());
            preparedStatement.setObject(2, nIStorageFacilityID);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean insertEss(NIOfflineESS nIOfflineESS) {
        PreparedStatement preparedStatement = (PreparedStatement)this.INSERT_PS.get(NIOlcDatabaseHelper.INSERT_ESS);
        try {
            preparedStatement.setInt(1, this.getFacilityPrimaryKey(((NIESSID)nIOfflineESS.getID()).getStorageFacility()));
            preparedStatement.setObject(2, nIOfflineESS);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public List getEssByPlex(NIStoragePlexID nIStoragePlexID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_ESS_A);
        ArrayList<NIOfflineESS> arrayList = new ArrayList<NIOfflineESS>();
        try {
            preparedStatement.setInt(1, nIStoragePlexID.getPrimaryKey());
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NIOfflineESS)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getEssByID(NIESSID[] nIESSIDArray) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_ESS_B);
        ArrayList<NIOfflineESS> arrayList = new ArrayList<NIOfflineESS>();
        int n = 0;
        while (n < nIESSIDArray.length) {
            try {
                preparedStatement.setObject(1, nIESSIDArray[n]);
                ResultSet resultSet = this.executeQuery(preparedStatement);
                if (resultSet.next()) {
                    arrayList.add((NIOfflineESS)resultSet.getObject(1));
                }
                resultSet.close();
                preparedStatement.clearParameters();
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
            ++n;
        }
        return arrayList;
    }

    public List getEssByFacility(NIStorageFacilityID nIStorageFacilityID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_ESS_C);
        ArrayList<NIOfflineESS> arrayList = new ArrayList<NIOfflineESS>();
        try {
            preparedStatement.setObject(1, nIStorageFacilityID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NIOfflineESS)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    private int getEssPrimaryKey(NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_ESS_D);
        int n = -1;
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return n;
    }

    public boolean modifyEss(NIOfflineESS nIOfflineESS) {
        PreparedStatement preparedStatement = (PreparedStatement)this.UPDATE_PS.get(NIOlcDatabaseHelper.UPDATE_ESS);
        try {
            preparedStatement.setObject(1, nIOfflineESS);
            preparedStatement.setObject(2, (NIESSID)nIOfflineESS.getID());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean deleteEss(NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_ESS);
        try {
            preparedStatement.setObject(1, nIESSID);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean insertArraySite(NIArraySite nIArraySite) {
        PreparedStatement preparedStatement = (PreparedStatement)this.INSERT_PS.get(NIOlcDatabaseHelper.INSERT_ARRAYSITE);
        try {
            preparedStatement.setLong(1, this.getEssPrimaryKey(((NIArraySiteID)nIArraySite.getID()).getESS()));
            preparedStatement.setObject(2, nIArraySite);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean modifyArraySite(NIArraySite nIArraySite) {
        boolean bl = true;
        PreparedStatement preparedStatement = (PreparedStatement)this.UPDATE_PS.get(NIOlcDatabaseHelper.UPDATE_ARRAYSITE);
        try {
            preparedStatement.setObject(1, nIArraySite);
            preparedStatement.setObject(2, (NIArraySiteID)nIArraySite.getID());
            bl = this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return bl;
    }

    public List getArraySitesByESS(NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_ARRAYSITE_A);
        ArrayList<NIArraySite> arrayList = new ArrayList<NIArraySite>();
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NIArraySite)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getArraySitesByID(NIArraySiteID[] nIArraySiteIDArray) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_ARRAYSITE_B);
        ArrayList<NIArraySite> arrayList = new ArrayList<NIArraySite>();
        int n = 0;
        while (n < nIArraySiteIDArray.length) {
            try {
                preparedStatement.setObject(1, nIArraySiteIDArray[n]);
                preparedStatement.setObject(2, nIArraySiteIDArray[n].getESS());
                ResultSet resultSet = this.executeQuery(preparedStatement);
                if (resultSet.next()) {
                    arrayList.add((NIArraySite)resultSet.getObject(1));
                }
                resultSet.close();
                preparedStatement.clearParameters();
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
            ++n;
        }
        return arrayList;
    }

    public boolean insertIOPort(NIIOPort nIIOPort) {
        boolean bl = true;
        PreparedStatement preparedStatement = (PreparedStatement)this.INSERT_PS.get(NIOlcDatabaseHelper.INSERT_IOPORT);
        try {
            preparedStatement.setLong(1, this.getEssPrimaryKey(((NIIOPortID)nIIOPort.getID()).getESS()));
            preparedStatement.setObject(2, nIIOPort);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public List getPorts(NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_IOPORT_A);
        ArrayList<NIIOPort> arrayList = new ArrayList<NIIOPort>();
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NIIOPort)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getPorts(NIIOPortID[] nIIOPortIDArray) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_IOPORT_B);
        ArrayList<NIIOPort> arrayList = new ArrayList<NIIOPort>();
        int n = 0;
        while (n < nIIOPortIDArray.length) {
            try {
                NIIOPort nIIOPort;
                preparedStatement.setObject(1, nIIOPortIDArray[n]);
                preparedStatement.setObject(2, nIIOPortIDArray[n].getESS());
                ResultSet resultSet = this.executeQuery(preparedStatement);
                if (resultSet.next() && ((NIIOPortID)(nIIOPort = (NIIOPort)resultSet.getObject(1)).getID()).getInterfaceIdentifier() == nIIOPortIDArray[n].getInterfaceIdentifier()) {
                    arrayList.add(nIIOPort);
                }
                resultSet.close();
                preparedStatement.clearParameters();
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
            ++n;
        }
        return arrayList;
    }

    public boolean modifyPort(NIIOPort nIIOPort) {
        PreparedStatement preparedStatement = (PreparedStatement)this.UPDATE_PS.get(NIOlcDatabaseHelper.UPDATE_IOPORT);
        try {
            preparedStatement.setObject(1, nIIOPort);
            preparedStatement.setObject(2, (NIIOPortID)nIIOPort.getID());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean insertAddressGroup(NIAddressGroup nIAddressGroup) {
        PreparedStatement preparedStatement = (PreparedStatement)this.INSERT_PS.get(NIOlcDatabaseHelper.INSERT_ADDRGROUP);
        try {
            preparedStatement.setLong(1, this.getEssPrimaryKey(((NIAddressGroupID)nIAddressGroup.getID()).getESS()));
            preparedStatement.setObject(2, nIAddressGroup);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean deleteAddressGroup(NIAddressGroup nIAddressGroup) {
        PreparedStatement preparedStatement = (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_ADDRGROUP);
        try {
            preparedStatement.setObject(1, (NIAddressGroupID)nIAddressGroup.getID());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean modifyAddressGroup(NIAddressGroup nIAddressGroup) {
        PreparedStatement preparedStatement = (PreparedStatement)this.UPDATE_PS.get(NIOlcDatabaseHelper.UPDATE_ADDRGROUP);
        try {
            preparedStatement.setObject(1, nIAddressGroup);
            preparedStatement.setObject(2, (NIAddressGroupID)nIAddressGroup.getID());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public List getAddressGroupsByESS(NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_ADDRGRP_A);
        ArrayList<NIAddressGroup> arrayList = new ArrayList<NIAddressGroup>();
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NIAddressGroup)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getAddressGroupsByID(NIAddressGroupID[] nIAddressGroupIDArray) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_ADDRGRP_B);
        ArrayList<NIAddressGroup> arrayList = new ArrayList<NIAddressGroup>();
        int n = 0;
        while (n < nIAddressGroupIDArray.length) {
            try {
                preparedStatement.setObject(1, nIAddressGroupIDArray[n]);
                preparedStatement.setObject(2, nIAddressGroupIDArray[n].getESS());
                ResultSet resultSet = this.executeQuery(preparedStatement);
                if (resultSet.next()) {
                    arrayList.add((NIAddressGroup)resultSet.getObject(1));
                }
                resultSet.close();
                preparedStatement.clearParameters();
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
            ++n;
        }
        return arrayList;
    }

    public boolean insertLSS(NILSS nILSS, NILSSVolumeSetImpl nILSSVolumeSetImpl) {
        PreparedStatement preparedStatement = (PreparedStatement)this.INSERT_PS.get(NIOlcDatabaseHelper.INSERT_LSS);
        try {
            preparedStatement.setLong(1, this.getEssPrimaryKey(((NILSSID)nILSS.getID()).getESS()));
            preparedStatement.setObject(2, nILSS.getID());
            preparedStatement.setObject(3, nILSS);
            preparedStatement.setObject(4, nILSSVolumeSetImpl);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean modifyLSS(NILSS nILSS) {
        PreparedStatement preparedStatement = (PreparedStatement)this.UPDATE_PS.get(NIOlcDatabaseHelper.UPDATE_LSS);
        try {
            preparedStatement.setObject(1, nILSS);
            preparedStatement.setObject(2, (NILSSID)nILSS.getID());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean modifyLSSVolumeSet(NILSSID nILSSID, NILSSVolumeSetImpl nILSSVolumeSetImpl) {
        PreparedStatement preparedStatement = (PreparedStatement)this.UPDATE_PS.get(NIOlcDatabaseHelper.UPDATE_LSSVOLUMESET);
        try {
            preparedStatement.setObject(1, nILSSVolumeSetImpl);
            preparedStatement.setObject(2, nILSSID);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean deleteLSS(NILSS nILSS) {
        PreparedStatement preparedStatement = (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_LSS);
        try {
            preparedStatement.setObject(1, (NILSSID)nILSS.getID());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public List getLogicalSubsystemsByESS(NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_LSS_A);
        ArrayList<NILSS> arrayList = new ArrayList<NILSS>();
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NILSS)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getLogicalSubsystemsByID(NILSSID[] nILSSIDArray) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_LSS_B);
        ArrayList<NILSS> arrayList = new ArrayList<NILSS>();
        int n = 0;
        while (n < nILSSIDArray.length) {
            try {
                preparedStatement.setObject(1, nILSSIDArray[n]);
                ResultSet resultSet = this.executeQuery(preparedStatement);
                if (resultSet.next()) {
                    arrayList.add((NILSS)resultSet.getObject(1));
                }
                resultSet.close();
                preparedStatement.clearParameters();
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
            ++n;
        }
        return arrayList;
    }

    public NILSSVolumeSetImpl getLSSVolumeSet(NILSSID nILSSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_LSSVOLUMESET);
        NILSSVolumeSetImpl nILSSVolumeSetImpl = new NILSSVolumeSetImpl();
        try {
            preparedStatement.setObject(1, nILSSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            if (resultSet.next()) {
                nILSSVolumeSetImpl = (NILSSVolumeSetImpl)resultSet.getObject(1);
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return nILSSVolumeSetImpl;
    }

    public List getLogicalSubsystemsByESSDevice(NIESSID nIESSID, NIDeviceType nIDeviceType) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(nIDeviceType instanceof NIDeviceTypeCKD ? NIOlcDatabaseHelper.SELECT_LSS_C1 : NIOlcDatabaseHelper.SELECT_LSS_C2);
        ArrayList<NILSS> arrayList = new ArrayList<NILSS>();
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NILSS)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public boolean insertArray(NIArray nIArray) {
        PreparedStatement preparedStatement = (PreparedStatement)this.INSERT_PS.get(NIOlcDatabaseHelper.INSERT_ARRAY);
        try {
            preparedStatement.setLong(1, this.getEssPrimaryKey(((NIArrayID)nIArray.getID()).getESS()));
            preparedStatement.setObject(2, nIArray);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean modifyArray(NIArray nIArray) {
        PreparedStatement preparedStatement = (PreparedStatement)this.UPDATE_PS.get(NIOlcDatabaseHelper.UPDATE_ARRAY);
        try {
            preparedStatement.setObject(1, nIArray);
            preparedStatement.setObject(2, (NIArrayID)nIArray.getID());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean deleteArray(NIArrayID nIArrayID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_ARRAY);
        try {
            preparedStatement.setObject(1, nIArrayID);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == 1;
    }

    public List getArraysByESS(NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_ARRAY_A);
        ArrayList<NIArray> arrayList = new ArrayList<NIArray>();
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NIArray)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getArraysByID(NIArrayID[] nIArrayIDArray) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_ARRAY_B);
        ArrayList<NIArray> arrayList = new ArrayList<NIArray>();
        int n = 0;
        while (n < nIArrayIDArray.length) {
            try {
                preparedStatement.setObject(1, nIArrayIDArray[n]);
                ResultSet resultSet = this.executeQuery(preparedStatement);
                if (resultSet.next()) {
                    arrayList.add((NIArray)resultSet.getObject(1));
                }
                resultSet.close();
                preparedStatement.clearParameters();
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
            ++n;
        }
        return arrayList;
    }

    public boolean insertRank(NIRank nIRank) {
        PreparedStatement preparedStatement = (PreparedStatement)this.INSERT_PS.get(NIOlcDatabaseHelper.INSERT_RANK);
        try {
            preparedStatement.setLong(1, this.getEssPrimaryKey(((NIRankID)nIRank.getID()).getESS()));
            preparedStatement.setObject(2, nIRank);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean modifyRank(NIRank nIRank) {
        PreparedStatement preparedStatement = (PreparedStatement)this.UPDATE_PS.get(NIOlcDatabaseHelper.UPDATE_RANK);
        try {
            preparedStatement.setObject(1, nIRank);
            preparedStatement.setObject(2, (NIRankID)nIRank.getID());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean deleteRank(NIRankID nIRankID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_RANK);
        try {
            preparedStatement.setObject(1, nIRankID);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == 1;
    }

    public List getRanksByESS(NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_RANK_A);
        ArrayList<NIRank> arrayList = new ArrayList<NIRank>();
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NIRank)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getRanksByExtentPool(NIExtentPoolID nIExtentPoolID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_RANK_B);
        ArrayList<NIRank> arrayList = new ArrayList<NIRank>();
        try {
            preparedStatement.setObject(1, nIExtentPoolID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NIRank)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getRanksByID(NIRankID[] nIRankIDArray) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_RANK_C);
        ArrayList<NIRank> arrayList = new ArrayList<NIRank>();
        int n = 0;
        while (n < nIRankIDArray.length) {
            try {
                preparedStatement.setObject(1, nIRankIDArray[n]);
                ResultSet resultSet = this.executeQuery(preparedStatement);
                if (resultSet.next()) {
                    arrayList.add((NIRank)resultSet.getObject(1));
                }
                resultSet.close();
                preparedStatement.clearParameters();
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
            ++n;
        }
        return arrayList;
    }

    private int getExtentPoolPrimaryKey(NIExtentPoolID nIExtentPoolID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_SPOOL_C);
        int n = -1;
        try {
            preparedStatement.setObject(1, nIExtentPoolID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return n;
    }

    public boolean insertExtentPool(NIExtentPool nIExtentPool) {
        boolean bl = true;
        PreparedStatement preparedStatement = (PreparedStatement)this.INSERT_PS.get(NIOlcDatabaseHelper.INSERT_EXTENT_POOL);
        try {
            preparedStatement.setLong(1, this.getEssPrimaryKey(((NIExtentPoolID)nIExtentPool.getID()).getESS()));
            preparedStatement.setObject(2, nIExtentPool);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean deleteExtentPool(NIExtentPool nIExtentPool) {
        PreparedStatement preparedStatement = (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_EXTENT_POOL);
        try {
            preparedStatement.setObject(1, (NIExtentPoolID)nIExtentPool.getID());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean modifyExtentPool(NIExtentPool nIExtentPool) {
        PreparedStatement preparedStatement = (PreparedStatement)this.UPDATE_PS.get(NIOlcDatabaseHelper.UPDATE_EXTENT_POOL);
        try {
            preparedStatement.setObject(1, nIExtentPool);
            preparedStatement.setObject(2, (NIExtentPoolID)nIExtentPool.getID());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public List getExtentPoolsByESS(NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_SPOOL_A);
        ArrayList<NIExtentPool> arrayList = new ArrayList<NIExtentPool>();
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NIExtentPool)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getExtentPoolsByID(NIExtentPoolID[] nIExtentPoolIDArray) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_SPOOL_B);
        ArrayList<NIExtentPool> arrayList = new ArrayList<NIExtentPool>();
        int n = 0;
        while (n < nIExtentPoolIDArray.length) {
            try {
                preparedStatement.setObject(1, nIExtentPoolIDArray[n]);
                ResultSet resultSet = this.executeQuery(preparedStatement);
                if (resultSet.next()) {
                    arrayList.add((NIExtentPool)resultSet.getObject(1));
                }
                resultSet.close();
                preparedStatement.clearParameters();
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
            ++n;
        }
        return arrayList;
    }

    public List getVolumesByESS(NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_VOLUMES_A);
        ArrayList arrayList = new ArrayList();
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.addAll(((NILSSVolumeSetImpl)resultSet.getObject(1)).getVolumes());
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getVolumesByID(NIVolumeID[] nIVolumeIDArray) {
        HashMap<NILSSID, NILSSVolumeSetImpl> hashMap = new HashMap<NILSSID, NILSSVolumeSetImpl>();
        ArrayList<NIVolumeImpl> arrayList = new ArrayList<NIVolumeImpl>();
        int n = 0;
        while (n < nIVolumeIDArray.length) {
            NILSSVolumeSetImpl nILSSVolumeSetImpl;
            NILSSID nILSSID = nIVolumeIDArray[n].getLSS();
            if (hashMap.containsKey(nILSSID)) {
                nILSSVolumeSetImpl = (NILSSVolumeSetImpl)hashMap.get(nILSSID);
            } else {
                nILSSVolumeSetImpl = this.getLSSVolumeSet(nILSSID);
                hashMap.put(nILSSID, nILSSVolumeSetImpl);
            }
            if (nILSSVolumeSetImpl.containsVolume(nIVolumeIDArray[n])) {
                arrayList.add(nILSSVolumeSetImpl.getVolume(nIVolumeIDArray[n]));
            }
            ++n;
        }
        return arrayList;
    }

    public List getVolumesByLSS(NILSSID nILSSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_VOLUMES_D);
        NILSSVolumeSetImpl nILSSVolumeSetImpl = new NILSSVolumeSetImpl();
        try {
            preparedStatement.setObject(1, nILSSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            if (resultSet.next()) {
                nILSSVolumeSetImpl = (NILSSVolumeSetImpl)resultSet.getObject(1);
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return new ArrayList(nILSSVolumeSetImpl.getVolumes());
    }

    public List getVolumesByESSDevice(NIESSID nIESSID, NIDeviceType nIDeviceType) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(nIDeviceType instanceof NIDeviceTypeCKD ? NIOlcDatabaseHelper.SELECT_VOLUMES_E1 : NIOlcDatabaseHelper.SELECT_VOLUMES_E2);
        ArrayList arrayList = new ArrayList();
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.addAll(((NILSSVolumeSetImpl)resultSet.getObject(1)).getVolumes());
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getVolumesByBase(NIVolumeID nIVolumeID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_VOLUMES_G);
        ArrayList arrayList = new ArrayList();
        try {
            preparedStatement.setObject(1, nIVolumeID.getESS());
            preparedStatement.setInt(2, nIVolumeID.getLSS().getLSSGroupID());
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.addAll(((NILSSVolumeSetImpl)resultSet.getObject(1)).getVolumesByBase(nIVolumeID.getVolNumber()));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public boolean insertSCSIHostPort(NISCSIHostPort nISCSIHostPort) {
        PreparedStatement preparedStatement = (PreparedStatement)this.INSERT_PS.get(NIOlcDatabaseHelper.INSERT_HOSTPORT);
        try {
            preparedStatement.setLong(1, this.getEssPrimaryKey(((NISCSIHostPortID)nISCSIHostPort.getID()).getESS()));
            preparedStatement.setObject(2, nISCSIHostPort);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean modifyScsiHostPort(NISCSIHostPort nISCSIHostPort) {
        PreparedStatement preparedStatement = (PreparedStatement)this.UPDATE_PS.get(NIOlcDatabaseHelper.UPDATE_HOSTPORT);
        try {
            preparedStatement.setObject(1, nISCSIHostPort);
            preparedStatement.setObject(2, (NISCSIHostPortID)nISCSIHostPort.getID());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean deleteScsiHostPort(NISCSIHostPortID nISCSIHostPortID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_HOSTPORT);
        try {
            preparedStatement.setObject(1, nISCSIHostPortID);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public List getScsiHostPortsByESS(NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_HOSTPORTS_A);
        ArrayList<NISCSIHostPort> arrayList = new ArrayList<NISCSIHostPort>();
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NISCSIHostPort)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getScsiHostPortsByESSUsername(NIESSID nIESSID, String string) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_HOSTPORTS_B);
        ArrayList<NISCSIHostPort> arrayList = new ArrayList<NISCSIHostPort>();
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setObject(2, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NISCSIHostPort)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getScsiHostPortsByID(NISCSIHostPortID[] nISCSIHostPortIDArray) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_HOSTPORTS_C);
        ArrayList<NISCSIHostPort> arrayList = new ArrayList<NISCSIHostPort>();
        int n = 0;
        while (n < nISCSIHostPortIDArray.length) {
            try {
                preparedStatement.setObject(1, nISCSIHostPortIDArray[n]);
                preparedStatement.setObject(2, nISCSIHostPortIDArray[n].getESS());
                ResultSet resultSet = this.executeQuery(preparedStatement);
                if (resultSet.next()) {
                    arrayList.add((NISCSIHostPort)resultSet.getObject(1));
                }
                resultSet.close();
                preparedStatement.clearParameters();
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
            ++n;
        }
        return arrayList;
    }

    public List getScsiHostPortsByWWPN(NIESSID nIESSID, long l) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_HOSTPORTS_D);
        ArrayList<NISCSIHostPort> arrayList = new ArrayList<NISCSIHostPort>();
        try {
            preparedStatement.setObject(1, nIESSID);
            preparedStatement.setLong(2, l);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NISCSIHostPort)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    private int getEnclosurePrimaryKey(int n, NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_ENCLOSURE_A);
        int n2 = -1;
        try {
            preparedStatement.setInt(1, n);
            preparedStatement.setObject(2, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return n2;
    }

    public boolean insertStorageEnclosure(NIStorageEnclosure nIStorageEnclosure) {
        PreparedStatement preparedStatement = (PreparedStatement)this.INSERT_PS.get(NIOlcDatabaseHelper.INSERT_ENCLOSURE);
        try {
            preparedStatement.setLong(1, this.getEssPrimaryKey(((NIEnclosureID)nIStorageEnclosure.getID()).getESS()));
            preparedStatement.setObject(2, nIStorageEnclosure);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public List getStorageEnclosures(NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_ENCLOSURES);
        ArrayList<NIStorageEnclosure> arrayList = new ArrayList<NIStorageEnclosure>();
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NIStorageEnclosure)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public boolean insertStorageDeviceFRU(NIStorageDeviceFRU nIStorageDeviceFRU) {
        PreparedStatement preparedStatement = (PreparedStatement)this.INSERT_PS.get(NIOlcDatabaseHelper.INSERT_FRU);
        try {
            preparedStatement.setInt(1, this.getEnclosurePrimaryKey(nIStorageDeviceFRU.getEnclosureNumber(), nIStorageDeviceFRU.getID().getESS()));
            preparedStatement.setObject(2, nIStorageDeviceFRU);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public List getStorageDeviceFRUs(NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_FRUS);
        ArrayList<NIStorageDeviceFRU> arrayList = new ArrayList<NIStorageDeviceFRU>();
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NIStorageDeviceFRU)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public boolean insertVolumeGroup(NIVolumeGroup nIVolumeGroup) {
        PreparedStatement preparedStatement = (PreparedStatement)this.INSERT_PS.get(NIOlcDatabaseHelper.INSERT_VOLUME_GROUP);
        try {
            preparedStatement.setLong(1, this.getEssPrimaryKey(((NIVolumeGroupID)nIVolumeGroup.getID()).getESS()));
            preparedStatement.setObject(2, nIVolumeGroup);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean deleteVolumeGroup(NIVolumeGroupID nIVolumeGroupID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_VOLUME_GROUP);
        try {
            preparedStatement.setObject(1, nIVolumeGroupID);
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public boolean modifyVolumeGroup(NIVolumeGroup nIVolumeGroup) {
        PreparedStatement preparedStatement = (PreparedStatement)this.UPDATE_PS.get(NIOlcDatabaseHelper.UPDATE_VOLUME_GROUP);
        try {
            preparedStatement.setObject(1, nIVolumeGroup);
            preparedStatement.setObject(2, (NIVolumeGroupID)nIVolumeGroup.getID());
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return this.executeUpdate(preparedStatement) == SINGLE_UPDATE;
    }

    public List getVolumeGroupsByESS(NIESSID nIESSID) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_VOLGRP_A);
        ArrayList<NIVolumeGroup> arrayList = new ArrayList<NIVolumeGroup>();
        try {
            preparedStatement.setObject(1, nIESSID);
            ResultSet resultSet = this.executeQuery(preparedStatement);
            while (resultSet.next()) {
                arrayList.add((NIVolumeGroup)resultSet.getObject(1));
            }
            resultSet.close();
            preparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            NIOlcLogger.sql("", sQLException);
        }
        return arrayList;
    }

    public List getVolumeGroupsByID(NIVolumeGroupID[] nIVolumeGroupIDArray) {
        PreparedStatement preparedStatement = (PreparedStatement)this.SELECT_PS.get(NIOlcDatabaseHelper.SELECT_VOLGRP_B);
        ArrayList<NIVolumeGroup> arrayList = new ArrayList<NIVolumeGroup>();
        int n = 0;
        while (n < nIVolumeGroupIDArray.length) {
            try {
                preparedStatement.setObject(1, nIVolumeGroupIDArray[n]);
                ResultSet resultSet = this.executeQuery(preparedStatement);
                if (resultSet.next()) {
                    arrayList.add((NIVolumeGroup)resultSet.getObject(1));
                }
                resultSet.close();
                preparedStatement.clearParameters();
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
            ++n;
        }
        return arrayList;
    }

    public boolean deleteAllByESS(NIESSID nIESSID) {
        PreparedStatement[] preparedStatementArray = new PreparedStatement[]{(PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_FRU_BY_ESS), (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_ADDRESSGROUPS_BY_ESS), (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_ARRAYS_BY_ESS), (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_ARRAYSITES_BY_ESS), (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_EXTENTPOOLS_BY_ESS), (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_ENCLOSURE_BY_ESS), (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_HOSTPORT_BY_ESS), (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_IOPORTS_BY_ESS), (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_LSS_BY_ESS), (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_RANKS_BY_ESS), (PreparedStatement)this.DELETE_PS.get(NIOlcDatabaseHelper.DELETE_VOLUME_GROUP_BY_ESS)};
        boolean bl = true;
        int n = 0;
        while (n < preparedStatementArray.length) {
            try {
                preparedStatementArray[n].setObject(1, nIESSID);
            }
            catch (SQLException sQLException) {
                NIOlcLogger.sql("", sQLException);
            }
            int n2 = this.executeUpdate(preparedStatementArray[n]);
            if (n2 < 0) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    static {
        TABLE_DROP_DDL.put(new Integer(0), "DROP TABLE Plexes CASCADE");
        TABLE_CREATE_DDL.put(new Integer(0), "CREATE TABLE Plexes (plex_id INT DEFAULT AUTOINCREMENT,object com.ibm.storage.ess.ni.application.resource.NIStoragePlex NOT NULL,CONSTRAINT plexes_pk PRIMARY KEY (plex_id))");
        TABLE_DROP_DDL.put(new Integer(1), "DROP TABLE Facilities CASCADE");
        TABLE_CREATE_DDL.put(new Integer(1), "CREATE TABLE Facilities (facility_id INT DEFAULT AUTOINCREMENT,plex_id INT,object com.ibm.storage.ess.ni.application.resource.NIStorageFacility NOT NULL,CONSTRAINT facilities_pk PRIMARY KEY (facility_id),CONSTRAINT facilities_fk FOREIGN KEY (plex_id) REFERENCES Plexes(plex_id) )");
        TABLE_DROP_DDL.put(new Integer(2), "DROP TABLE ESS CASCADE");
        TABLE_CREATE_DDL.put(new Integer(2), "CREATE TABLE ESS (ess_id INT DEFAULT AUTOINCREMENT,facility_id INT,object com.ibm.storage.ess.ni.application.resource.NIESS NOT NULL,CONSTRAINT ess_pk PRIMARY KEY (ess_id),CONSTRAINT ess_fk FOREIGN KEY (facility_id) REFERENCES Facilities(facility_id) )");
        TABLE_DROP_DDL.put(new Integer(3), "DROP TABLE ArraySites CASCADE");
        TABLE_CREATE_DDL.put(new Integer(3), "CREATE TABLE ArraySites (arraysite_id INT DEFAULT AUTOINCREMENT,ess_id INT,object com.ibm.storage.ess.ni.application.resource.NIArraySite NOT NULL,CONSTRAINT arraySites_pk PRIMARY KEY (arraysite_id),CONSTRAINT arraySites_fk FOREIGN KEY (ess_id) REFERENCES ESS(ess_id) )");
        TABLE_DROP_DDL.put(new Integer(4), "DROP TABLE IOPorts CASCADE");
        TABLE_CREATE_DDL.put(new Integer(4), "CREATE TABLE IOPorts (ioport_id INT DEFAULT AUTOINCREMENT,ess_id INT,object com.ibm.storage.ess.ni.application.resource.NIIOPort NOT NULL,CONSTRAINT ioports_pk PRIMARY KEY (ioport_id),CONSTRAINT ioports_fk FOREIGN KEY (ess_id) REFERENCES ESS(ess_id) )");
        TABLE_DROP_DDL.put(new Integer(5), "DROP TABLE AddressGroups CASCADE");
        TABLE_CREATE_DDL.put(new Integer(5), "CREATE TABLE AddressGroups (addressgroup_id INT DEFAULT AUTOINCREMENT,ess_id INT,object com.ibm.storage.ess.ni.application.resource.NIAddressGroup NOT NULL,CONSTRAINT addressgroups_pk PRIMARY KEY (addressgroup_id),CONSTRAINT addressgroups_fk FOREIGN KEY (ess_id) REFERENCES ESS(ess_id) )");
        TABLE_DROP_DDL.put(new Integer(6), "DROP TABLE LSS CASCADE");
        TABLE_CREATE_DDL.put(new Integer(6), "CREATE TABLE LSS (id INT DEFAULT AUTOINCREMENT,ess_id INT,lss_id com.ibm.storage.ess.ni.identifiers.NILSSID NOT NULL,object com.ibm.storage.ess.ni.application.resource.NILSS NOT NULL,volumes com.ibm.storage.ess.ni.resource.NILSSVolumeSetImpl NOT NULL,CONSTRAINT lss_fk FOREIGN KEY (ess_id) REFERENCES ESS(ess_id) )");
        TABLE_DROP_DDL.put(new Integer(7), "DROP TABLE Arrays CASCADE");
        TABLE_CREATE_DDL.put(new Integer(7), "CREATE TABLE Arrays (array_id INT DEFAULT AUTOINCREMENT,ess_id INT,object com.ibm.storage.ess.ni.application.resource.NIArray NOT NULL,CONSTRAINT arrays_pk PRIMARY KEY (array_id),CONSTRAINT arrays_fk FOREIGN KEY (ess_id) REFERENCES ESS(ess_id) )");
        TABLE_DROP_DDL.put(new Integer(8), "DROP TABLE Ranks CASCADE");
        TABLE_CREATE_DDL.put(new Integer(8), "CREATE TABLE Ranks (rank_id INT DEFAULT AUTOINCREMENT,ess_id INT,object com.ibm.storage.ess.ni.application.resource.NIRank NOT NULL,CONSTRAINT ranks_pk PRIMARY KEY (rank_id),CONSTRAINT ranks_fk FOREIGN KEY (ess_id) REFERENCES ESS(ess_id) )");
        TABLE_DROP_DDL.put(new Integer(9), "DROP TABLE ExtentPools CASCADE");
        TABLE_CREATE_DDL.put(new Integer(9), "CREATE TABLE ExtentPools (extentpool_id INT DEFAULT AUTOINCREMENT,ess_id INT,object com.ibm.storage.ess.ni.application.resource.NIExtentPool NOT NULL,CONSTRAINT extentpool_pk PRIMARY KEY (extentpool_id),CONSTRAINT extentpool_fk FOREIGN KEY (ess_id) REFERENCES ESS(ess_id) )");
        TABLE_DROP_DDL.put(new Integer(10), "DROP TABLE Volumes CASCADE");
        TABLE_CREATE_DDL.put(new Integer(10), "CREATE TABLE Volumes (volume_id INT DEFAULT AUTOINCREMENT,extentpool_id INT,object com.ibm.storage.ess.ni.application.resource.NIVolume NOT NULL,CONSTRAINT volumes_pk PRIMARY KEY (volume_id),CONSTRAINT volumes_fk FOREIGN KEY (extentpool_id) REFERENCES ExtentPools(extentpool_id) )");
        TABLE_DROP_DDL.put(new Integer(11), "DROP TABLE SCSIHostPorts CASCADE");
        TABLE_CREATE_DDL.put(new Integer(11), "CREATE TABLE SCSIHostPorts (scsihostport_id INT DEFAULT AUTOINCREMENT,ess_id INT,object com.ibm.storage.ess.ni.application.resource.NISCSIHostPort NOT NULL,CONSTRAINT scsihostports_pk PRIMARY KEY (scsihostport_id),CONSTRAINT scsihostports_fk FOREIGN KEY (ess_id) REFERENCES ESS(ess_id) )");
        TABLE_DROP_DDL.put(new Integer(12), "DROP TABLE StorageEnclosures CASCADE");
        TABLE_CREATE_DDL.put(new Integer(12), "CREATE TABLE StorageEnclosures (enclosure_id INT DEFAULT AUTOINCREMENT,ess_id INT,object com.ibm.storage.ess.ni.application.resource.NIStorageEnclosure NOT NULL,CONSTRAINT storageenclosure_pk PRIMARY KEY (enclosure_id),CONSTRAINT storageenclosure_fk FOREIGN KEY (ess_id) REFERENCES ESS(ess_id) )");
        TABLE_DROP_DDL.put(new Integer(13), "DROP TABLE StorageDeviceFRUs CASCADE");
        TABLE_CREATE_DDL.put(new Integer(13), "CREATE TABLE StorageDeviceFRUs (device_id INT DEFAULT AUTOINCREMENT,enclosure_id INT,object com.ibm.storage.ess.ni.application.resource.NIStorageDeviceFRU NOT NULL,CONSTRAINT device_pk PRIMARY KEY (device_id),CONSTRAINT device_fk FOREIGN KEY (enclosure_id) REFERENCES StorageEnclosures(enclosure_id) )");
        TABLE_DROP_DDL.put(new Integer(14), "DROP TABLE VolumeGroups CASCADE");
        TABLE_CREATE_DDL.put(new Integer(14), "CREATE TABLE VolumeGroups (volumegroup_id INT DEFAULT AUTOINCREMENT,ess_id INT,object com.ibm.storage.ess.ni.application.resource.NIVolumeGroup NOT NULL,CONSTRAINT volumegroups_pk PRIMARY KEY (volumegroup_id),CONSTRAINT volumegroups_fk FOREIGN KEY (ess_id) REFERENCES ESS(ess_id) )");
    }
}

