/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.resource;

import com.ibm.storage.ess.ni.application.resource.NILSS;
import com.ibm.storage.ess.ni.identifiers.NIAddressGroupID;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model3;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model3TPF;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUType3990Model6;
import com.ibm.storage.ess.ni.option.config.NICKDBaseCUTypeBS2000;
import com.ibm.storage.ess.ni.option.config.NIDeviceType;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeCKD;
import com.ibm.storage.ess.ni.option.config.NIDeviceTypeFB;
import com.ibm.storage.ess.ni.resource.NIResourceImpl;
import java.lang.reflect.Field;

public class NILSSImpl
extends NIResourceImpl
implements NILSS {
    private static final long serialVersionUID = 7722821279565032259L;
    protected NILSSID lssId;
    protected NIAddressGroupID addrGroupID;
    protected NIDeviceType deviceType;
    protected int configuredDevices;
    protected NICKDBaseCUType cuBaseType;
    protected boolean criticalModeEnabled;
    protected boolean elbEnabled;
    protected int elbActiveTime;
    protected int configurationState;
    protected int ccTimeout;
    protected int xrcTimeout;

    public NILSSImpl(NILSSID nILSSID, NIDeviceType nIDeviceType, NIAddressGroupID nIAddressGroupID, int n, NICKDBaseCUType nICKDBaseCUType, boolean bl, boolean bl2, int n2, int n3, int n4) {
        this.lssId = nILSSID;
        this.deviceType = nIDeviceType;
        this.addrGroupID = nIAddressGroupID;
        this.configuredDevices = n;
        this.cuBaseType = nICKDBaseCUType;
        this.criticalModeEnabled = bl;
        this.elbEnabled = bl2;
        this.elbActiveTime = n2;
        this.ccTimeout = n3;
        this.xrcTimeout = n4;
        this.configurationState = 0;
    }

    public NILSSImpl() {
    }

    public NIResourceID getID() {
        return this.lssId;
    }

    public int getSSID() {
        return this.lssId.getSSID();
    }

    public void setSSID(int n) {
        this.addChangedMethod("setSSID");
        this.lssId = new NILSSID(this.lssId.getESS(), this.lssId.getLSSNumber(), n);
    }

    public void setCriticalModeEnabled(boolean bl) {
        this.addChangedMethod("setCriticalModeEnabled");
        this.criticalModeEnabled = bl;
    }

    public void setELBEnabled(boolean bl) {
        this.addChangedMethod("setELBEnabled");
        this.elbEnabled = bl;
    }

    public NIAddressGroupID getAddressGroupID() {
        return this.addrGroupID;
    }

    public NIDeviceType getDeviceType() {
        return this.deviceType;
    }

    public int getConfiguredDevices() {
        return this.configuredDevices;
    }

    public NICKDBaseCUType getCUBaseType() {
        return this.cuBaseType;
    }

    public void setCUBaseType(NICKDBaseCUType nICKDBaseCUType) {
        this.addChangedMethod("setCUBaseType");
        this.cuBaseType = nICKDBaseCUType;
    }

    public void setID(NILSSID nILSSID) {
        this.lssId = nILSSID;
    }

    public boolean isCriticalModeEnabled() {
        return this.criticalModeEnabled;
    }

    public boolean isELBEnabled() {
        return this.elbEnabled;
    }

    public int getLSSNumber() {
        return this.lssId.getLSSNumber();
    }

    public void setAddressGroupID(NIAddressGroupID nIAddressGroupID) {
        this.addChangedMethod("setAddressGroupID");
        this.addrGroupID = nIAddressGroupID;
    }

    public void setDeviceType(NIDeviceType nIDeviceType) {
        this.addChangedMethod("setDeviceType");
        this.deviceType = nIDeviceType;
    }

    public void setConfiguredDevices(int n) {
        this.addChangedMethod("setConfiguredDevices");
        this.configuredDevices = n;
    }

    public int getELBActiveTime() {
        return this.elbActiveTime;
    }

    public int getCCTimeout() {
        return this.ccTimeout;
    }

    public int getXRCTimeout() {
        return this.xrcTimeout;
    }

    public void setELBActiveTime(int n) {
        this.addChangedMethod("setELBActiveTime");
        this.elbActiveTime = n;
    }

    public void setCCTimeout(int n) {
        this.addChangedMethod("setCCTimeout");
        this.ccTimeout = n;
    }

    public void setXRCTimeout(int n) {
        this.addChangedMethod("setXRCTimeout");
        this.xrcTimeout = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NILSS: [");
        stringBuffer.append("id = " + this.lssId + ", ");
        stringBuffer.append("deviceType = " + this.deviceType + ", ");
        stringBuffer.append("addrGroupID = " + this.addrGroupID + ", ");
        stringBuffer.append("configuredDevices = " + this.configuredDevices + ", ");
        stringBuffer.append("cuBaseType = " + this.cuBaseType + ", ");
        stringBuffer.append("configurationState = " + this.configurationState + ", ");
        stringBuffer.append("criticalModeEnabled = " + this.criticalModeEnabled + ", ");
        stringBuffer.append("elbActiveTime = " + this.elbActiveTime + ", ");
        stringBuffer.append("elbEnabled = " + this.elbEnabled + ", ");
        stringBuffer.append("ssid = " + this.lssId.getSSID() + ", ");
        stringBuffer.append("ccTimeout = " + this.ccTimeout + "]");
        return stringBuffer.toString();
    }

    public String toXml() {
        Class<?> clazz = this.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        Object object = "";
        String string = "<LSS ";
        int n = 0;
        while (n < fieldArray.length) {
            try {
                if (!fieldArray[n].getType().isArray() && (fieldArray[n].isAccessible() || fieldArray[n].getName() != "serialVersionUID")) {
                    object = fieldArray[n].get(this);
                    if (object instanceof NIAddressGroupID) {
                        int n2 = ((NIAddressGroupID)object).getAddressGroupNumber();
                        string = string + "addressGroupNumber=\"" + n2 + "\" ";
                    } else if (object instanceof NILSSID) {
                        int n3 = ((NILSSID)object).getLSSNumber();
                        int n4 = ((NILSSID)object).getSSID();
                        string = string + "number=\"" + n3 + "\" ";
                        string = string + "ssid=\"" + n4 + "\" ";
                    } else if (object instanceof NICKDBaseCUType) {
                        String string2 = "";
                        if (object instanceof NICKDBaseCUType3990Model3) {
                            string2 = "3990M3";
                        } else if (object instanceof NICKDBaseCUType3990Model3TPF) {
                            string2 = "3990M3TPF";
                        } else if (object instanceof NICKDBaseCUType3990Model6) {
                            string2 = "3990M6";
                        } else if (object instanceof NICKDBaseCUTypeBS2000) {
                            string2 = "BS2000";
                        }
                        string = string + fieldArray[n].getName();
                        string = string + "=\"" + string2 + "\" ";
                    } else if (object instanceof NIDeviceType) {
                        String string3 = "";
                        if (object instanceof NIDeviceTypeFB) {
                            string3 = "FB";
                        } else if (object instanceof NIDeviceTypeCKD) {
                            string3 = "CKD";
                        }
                        string = string + fieldArray[n].getName();
                        string = string + "=\"" + string3 + "\" ";
                    } else if (object != null) {
                        string = string + fieldArray[n].getName();
                        string = object.toString().equals("-1") ? string + "=\"\" " : string + "=\"" + object.toString() + "\" ";
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                string = string + fieldArray[n].getName();
                string = string + "=\"\" ";
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println(illegalAccessException.toString());
            }
            ++n;
        }
        string = string + "/>";
        return string;
    }
}

