/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.resource;

import com.ibm.storage.ess.ni.application.resource.NIProblem;
import com.ibm.storage.ess.ni.application.resource.NIProblemFRU;
import com.ibm.storage.ess.ni.identifiers.NIProblemID;
import com.ibm.storage.ess.ni.identifiers.NIResourceID;
import com.ibm.storage.ess.ni.resource.NIProblemFRUImpl;
import com.ibm.storage.ess.ni.resource.NIResourceImpl;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class NIProblemImpl
extends NIResourceImpl
implements NIProblem {
    private static final long serialVersionUID = 1L;
    protected NIProblemID problemId;
    protected int type;
    protected int code;
    protected int version;
    protected int occurrences;
    protected NIProblemFRU[] fruList;
    protected Date lastOccurrence;
    protected Date firstOccurrence;
    protected int currentState;
    protected String debuggingInfo;
    protected int detector;
    protected int severity;
    protected Calendar lastOccurrenceAsCalendar;
    protected Calendar firstOccurrenceAsCalendar;

    public NIProblemImpl(NIProblemID nIProblemID, int n, int n2, int n3, int n4, Date date, Date date2, String string, int n5, NIProblemFRU[] nIProblemFRUArray, int n6, int n7) {
        this.problemId = nIProblemID;
        this.type = n;
        this.code = n2;
        this.version = n3;
        this.occurrences = n4;
        this.lastOccurrence = date;
        if (date != null) {
            this.lastOccurrenceAsCalendar = new GregorianCalendar();
            this.lastOccurrenceAsCalendar.setTime(date);
        }
        this.firstOccurrence = date2;
        if (date2 != null) {
            this.firstOccurrenceAsCalendar = new GregorianCalendar();
            this.firstOccurrenceAsCalendar.setTime(date2);
        }
        this.debuggingInfo = string;
        this.detector = n5;
        this.fruList = nIProblemFRUArray;
        if (nIProblemFRUArray != null) {
            int n8 = 0;
            while (n8 < nIProblemFRUArray.length) {
                if (nIProblemFRUArray[n8] != null) {
                    ((NIProblemFRUImpl)nIProblemFRUArray[n8]).clearSetMethods();
                }
                ++n8;
            }
        }
        this.currentState = n6;
        this.severity = n7;
    }

    public NIProblemImpl(NIProblemID nIProblemID, int n, int n2, int n3, int n4, Calendar calendar, Calendar calendar2, String string, int n5, NIProblemFRU[] nIProblemFRUArray, int n6, int n7) {
        this.problemId = nIProblemID;
        this.type = n;
        this.code = n2;
        this.version = n3;
        this.occurrences = n4;
        this.lastOccurrenceAsCalendar = calendar;
        if (calendar != null) {
            this.lastOccurrence = calendar.getTime();
        }
        this.firstOccurrenceAsCalendar = calendar2;
        if (calendar2 != null) {
            this.firstOccurrence = calendar2.getTime();
        }
        this.debuggingInfo = string;
        this.detector = n5;
        this.fruList = nIProblemFRUArray;
        if (nIProblemFRUArray != null) {
            int n8 = 0;
            while (n8 < nIProblemFRUArray.length) {
                if (nIProblemFRUArray[n8] != null) {
                    ((NIProblemFRUImpl)nIProblemFRUArray[n8]).clearSetMethods();
                }
                ++n8;
            }
        }
        this.currentState = n6;
        this.severity = n7;
    }

    public int getCode() {
        return this.code;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public String getDebuggingInfo() {
        return this.debuggingInfo;
    }

    public int getDetector() {
        return this.detector;
    }

    public Date getFirstOccurrence() {
        return this.firstOccurrence;
    }

    public NIProblemFRU[] getFRUList() {
        return this.fruList;
    }

    public int getFRUNumber() {
        if (this.fruList != null) {
            return this.fruList.length;
        }
        return 0;
    }

    public NIProblemID getId() {
        return this.problemId;
    }

    public Date getLastOccurrence() {
        return this.lastOccurrence;
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    public int getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String toString() {
        String string = null;
        if (this.fruList != null) {
            string = "[";
            int n = 0;
            while (n < this.fruList.length - 1) {
                string = string + this.fruList[n] + ", ";
                ++n;
            }
            if (this.fruList.length != 0) {
                string = string + this.fruList[this.fruList.length - 1];
            }
            string = string + "]";
        }
        StringBuffer stringBuffer = new StringBuffer("NIProblem: [");
        stringBuffer.append("problemId = " + this.problemId + ", ");
        stringBuffer.append("type = " + this.type + ", ");
        stringBuffer.append("severity = " + this.severity + ", ");
        stringBuffer.append("code = " + this.code + ", ");
        stringBuffer.append("version = " + this.version + ", ");
        stringBuffer.append("occurrences = " + this.occurrences + ", ");
        stringBuffer.append("fruList = " + string + ", ");
        stringBuffer.append("lastOccurrenceAsCalendar = " + this.lastOccurrenceAsCalendar + ", ");
        stringBuffer.append("firstOccurrenceAsCalendar = " + this.firstOccurrenceAsCalendar + ", ");
        stringBuffer.append("currentState = " + this.currentState + ", ");
        stringBuffer.append("debuggingInfo = " + this.debuggingInfo + ", ");
        stringBuffer.append("detector = " + this.detector + "]");
        return stringBuffer.toString();
    }

    public NIResourceID getID() {
        return this.problemId;
    }

    public Calendar getFirstOccurrenceAsCalendar() {
        return this.firstOccurrenceAsCalendar;
    }

    public Calendar getLastOccurrenceAsCalendar() {
        return this.lastOccurrenceAsCalendar;
    }
}

