/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.resource;

import com.ibm.storage.ess.ni.application.resource.NIVolumeGroupSCSIMask;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.identifiers.NILSSID;
import com.ibm.storage.ess.ni.identifiers.NIVolumeID;
import com.ibm.storage.ess.ni.resource.NIVolumeGroupLunIdAndVolumeImpl;
import com.ibm.storage.ess.ni.resource.NIVolumeGroupMaskImpl;
import java.util.Collections;
import java.util.Vector;

public class NIVolumeGroupSCSIMaskImpl
extends NIVolumeGroupMaskImpl
implements NIVolumeGroupSCSIMask {
    private static final long serialVersionUID = -6567095121084338854L;
    private int BASE_LUN_ID = 0x40004000;
    private int LSS_BITS_OFFSET = 16;
    private int BYTE_2 = 0xFF0000;
    private int BYTE_0 = 255;

    public NIVolumeGroupSCSIMaskImpl() {
    }

    public NIVolumeGroupSCSIMaskImpl(NIVolumeID[] nIVolumeIDArray) throws NIParameterInvalidServerException {
        super(nIVolumeIDArray);
    }

    public synchronized int getLunID(NIVolumeID nIVolumeID) {
        int n = -1;
        if (nIVolumeID != null && this.contains(nIVolumeID)) {
            n = this.convertVolIdToLunId(nIVolumeID);
        }
        return n;
    }

    private int convertVolIdToLunId(NIVolumeID nIVolumeID) {
        int n = nIVolumeID.getLSS().getLSSNumber() << this.LSS_BITS_OFFSET;
        return this.BASE_LUN_ID | n | nIVolumeID.getVolNumber();
    }

    public synchronized NIVolumeID getVolume(int n) {
        NILSSID nILSSID;
        NIVolumeID nIVolumeID;
        int n2;
        NIVolumeID nIVolumeID2 = null;
        int n3 = (n & this.BYTE_2) >>> this.LSS_BITS_OFFSET;
        int n4 = n & this.BYTE_0;
        int n5 = n & ~this.BYTE_2 & ~this.BYTE_0;
        if (n5 == this.BASE_LUN_ID && this.size() > 0 && (n2 = Collections.binarySearch(this.volumeList, nIVolumeID = new NIVolumeID(nILSSID = new NILSSID(((NIVolumeID)this.volumeList.get(0)).getESS(), n3), n4))) >= 0) {
            nIVolumeID2 = (NIVolumeID)this.volumeList.get(n2);
        }
        return nIVolumeID2;
    }

    public synchronized int[] getLunIDsOfVolsInGroup() {
        int[] nArray = new int[this.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.convertVolIdToLunId((NIVolumeID)this.volumeList.get(n));
            ++n;
        }
        return nArray;
    }

    public synchronized Vector getVolsAndLunIDsInGroup() {
        int n = this.size();
        Vector<NIVolumeGroupLunIdAndVolumeImpl> vector = new Vector<NIVolumeGroupLunIdAndVolumeImpl>(n);
        int n2 = 0;
        while (n2 < n) {
            NIVolumeID nIVolumeID = (NIVolumeID)this.volumeList.get(n2);
            int n3 = this.convertVolIdToLunId(nIVolumeID);
            vector.add(new NIVolumeGroupLunIdAndVolumeImpl(nIVolumeID, n3));
            ++n2;
        }
        return vector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NIVolumeGroupSCSIMaskImpl: [");
        stringBuffer.append(super.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

