/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.results;

import com.ibm.storage.ess.ni.application.results.NIAsyncPPRCCGFailureInfo;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.util.NICSErrorCodeParser;
import com.ibm.storage.ess.ni.util.NISequenceNumberParser;
import java.io.Serializable;

public class NIAsyncPPRCCGFailureInfoImpl
implements NIAsyncPPRCCGFailureInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    private String ESSSequence;
    private int failingLSS;
    private int errorReason;
    private int masterState;
    private String controlUnitType;
    private String plantOfManufacturing;
    private int status;
    public static final int ERR_STATUS_NOT_AS_REQUIRED = 3840;

    public NIAsyncPPRCCGFailureInfoImpl(String string, int n, int n2, int n3) {
        if (string.equals("") && n2 == 0 && n3 == 0 && n == 0) {
            this.status = 16;
            this.ESSSequence = NIESSID.SEQUENCE_UNKNOWN;
            this.plantOfManufacturing = "Unknown";
            this.controlUnitType = "Unknown";
        } else if (n == 255 && n2 == 65535 && n3 == 255) {
            this.status = 18;
            this.ESSSequence = NIESSID.SEQUENCE_UNKNOWN;
            this.plantOfManufacturing = "Unknown";
            this.controlUnitType = "Unknown";
        } else {
            this.status = 17;
            this.failingLSS = n;
            this.errorReason = n2;
            this.masterState = n3;
            this.ESSSequence = NISequenceNumberParser.extractSerialFromSequence(string);
            this.plantOfManufacturing = NISequenceNumberParser.extractPlantFromSequence(string);
            this.controlUnitType = NISequenceNumberParser.extractCUTypeFromSequence(string);
        }
    }

    public String getESSSequence() {
        if (!this.ESSSequence.equalsIgnoreCase(NIESSID.SEQUENCE_UNKNOWN)) {
            return NISequenceNumberParser.trimLeadingZerosFromString(this.ESSSequence, 5);
        }
        return this.ESSSequence;
    }

    public int getFailingLSS() {
        return this.failingLSS;
    }

    public int getErrorReason() {
        int n;
        if ((this.errorReason & 0xF000) == 28672) {
            n = 28672;
        } else if ((this.errorReason & 0xFF00) == 3840) {
            n = NICSErrorCodeParser.get0FReasonCode(this.errorReason);
            if (n == 1) {
                n = 65535;
            }
        } else {
            switch (this.errorReason & 0xFFFF) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 1024: 
                case 61445: 
                case 61469: {
                    n = this.errorReason;
                    break;
                }
                default: {
                    n = 65535;
                }
            }
        }
        return n;
    }

    public int getMasterState() {
        return this.masterState;
    }

    public String getPlantOfManufacture() {
        return this.plantOfManufacturing;
    }

    public String getControlUnitType() {
        return this.controlUnitType;
    }

    public int getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NIAsyncPPRCCGFailureInfoImpl [");
        stringBuffer.append("masterESSSequenceNum = " + this.getESSSequence() + ", ");
        stringBuffer.append("failingLSS = " + this.failingLSS + ", ");
        stringBuffer.append("masterState = 0x" + Integer.toHexString(this.masterState) + ", ");
        stringBuffer.append("errorReason = 0x" + Integer.toHexString(0xFFFF & this.getErrorReason()) + ", ");
        stringBuffer.append("plantOfManufacturing = " + this.plantOfManufacturing + ", ");
        stringBuffer.append("controlUnitType = " + this.controlUnitType + ", ");
        stringBuffer.append("status = " + this.status + "]");
        return stringBuffer.toString();
    }
}

