/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.results;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.results.NIAsyncPPRCMasterSubordinateInfo;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NIResultImpl;
import com.ibm.storage.ess.ni.util.NISequenceNumberParser;

public class NIAsyncPPRCMasterSubordinateInfoImpl
extends NIResultImpl
implements NIAsyncPPRCMasterSubordinateInfo {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$results$NIAsyncPPRCMasterSubordinateInfoImpl == null ? (class$com$ibm$storage$ess$ni$results$NIAsyncPPRCMasterSubordinateInfoImpl = NIAsyncPPRCMasterSubordinateInfoImpl.class$("com.ibm.storage.ess.ni.results.NIAsyncPPRCMasterSubordinateInfoImpl")) : class$com$ibm$storage$ess$ni$results$NIAsyncPPRCMasterSubordinateInfoImpl);
    private int masterSSID;
    private int subordinateSSID;
    private int masterLSS;
    private int subordinateLSS;
    private String subordinateSequenceNumber;
    private String controlUnitType;
    private String plantOfManufacturing;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$results$NIAsyncPPRCMasterSubordinateInfoImpl;

    public NIAsyncPPRCMasterSubordinateInfoImpl(long l, int n, int n2, int n3, int n4, String string) {
        super(l == 0L, l);
        this.masterSSID = n;
        this.subordinateSSID = n2;
        this.masterLSS = n3;
        this.subordinateLSS = n4;
        this.subordinateSequenceNumber = NISequenceNumberParser.extractSerialFromSequence(string);
        this.plantOfManufacturing = NISequenceNumberParser.extractPlantFromSequence(string);
        this.controlUnitType = NISequenceNumberParser.extractCUTypeFromSequence(string);
    }

    public int getMasterSSID() {
        return this.masterSSID;
    }

    public int getSubordinateSSID() {
        return this.subordinateSSID;
    }

    public int getMasterPathAssociationLSSNumber() {
        return this.masterLSS;
    }

    public int getSubordinatePathAssociationLSSNumber() {
        return this.subordinateLSS;
    }

    public String getSubordinateSequenceNumber() {
        if (!this.subordinateSequenceNumber.equalsIgnoreCase(NIESSID.SEQUENCE_UNKNOWN)) {
            return NISequenceNumberParser.trimLeadingZerosFromString(this.subordinateSequenceNumber, 5);
        }
        return this.subordinateSequenceNumber;
    }

    public String getPlantOfManufacture() {
        return this.plantOfManufacturing;
    }

    public String getControlUnitType() {
        return this.controlUnitType;
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Master SSID: " + Integer.toHexString(this.masterSSID) + "\n");
            stringBuffer.append("Subordinate SSID: " + Integer.toHexString(this.subordinateSSID) + "\n");
            stringBuffer.append("Master LSS: " + this.masterLSS + "\n");
            stringBuffer.append("Subordinate LSS: " + this.subordinateLSS + "\n");
            stringBuffer.append("Subordinate CU Sequence Number: " + this.getSubordinateSequenceNumber());
            stringBuffer.append(" Subordinate Plant of Manufacture: " + this.plantOfManufacturing);
            stringBuffer.append(" Subordinate Control Unit Type: " + this.controlUnitType + "\n");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            return "ERROR";
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

