/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.results;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.results.NIXDCIncrementStatus;
import com.ibm.storage.ess.ni.exception.NIParameterInvalidServerException;
import com.ibm.storage.ess.ni.identifiers.NISessionID;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.results.NIXDCResultImpl;
import com.ibm.storage.ess.ni.util.NIByteArray;
import java.io.Serializable;

public class NIXDCIncrementStatusImpl
extends NIXDCResultImpl
implements NIXDCIncrementStatus,
Serializable {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$results$NIXDCIncrementStatusImpl == null ? (class$com$ibm$storage$ess$ni$results$NIXDCIncrementStatusImpl = NIXDCIncrementStatusImpl.class$("com.ibm.storage.ess.ni.results.NIXDCIncrementStatusImpl")) : class$com$ibm$storage$ess$ni$results$NIXDCIncrementStatusImpl);
    private static final long serialVersionUID = 1L;
    private int[] rawData = null;
    private byte[] actualRawData;
    private NIByteArray byteArray;
    private int byteDataLength = 0;
    private boolean dataAvailable = false;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$results$NIXDCIncrementStatusImpl;

    public NIXDCIncrementStatusImpl(byte[] byArray, long l) {
        super(l == 0L, l);
        this.actualRawData = byArray;
        this.byteDataLength = this.actualRawData.length;
        if (this.byteDataLength > 0 && l == 0L) {
            this.dataAvailable = true;
            this.byteArray = new NIByteArray(this.actualRawData);
        }
    }

    public void updateFrom2105Data() {
        if (this.rawData != null) {
            this.actualRawData = new byte[this.rawData.length * 4];
            int n = 0;
            int n2 = 0;
            while (n < this.rawData.length) {
                this.actualRawData[n2++] = (byte)((this.rawData[n] & 0xFF000000) >>> 24);
                this.actualRawData[n2++] = (byte)((this.rawData[n] & 0xFF0000) >>> 16);
                this.actualRawData[n2++] = (byte)((this.rawData[n] & 0xFF00) >>> 8);
                this.actualRawData[n2++] = (byte)(this.rawData[n] & 0xFF);
                ++n;
            }
            this.rawData = null;
            this.byteDataLength = this.actualRawData.length;
            if (this.byteDataLength > 0 && this.getCode() == 0) {
                this.byteArray = new NIByteArray(this.actualRawData);
                this.dataAvailable = true;
            }
        }
    }

    public byte[] getRawData() {
        return this.actualRawData;
    }

    public boolean noVolumesDefined() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(0, 0);
        }
        return true;
    }

    public boolean inaccessibleData() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(0, 4);
        }
        return true;
    }

    public boolean isRevertibleOrNotRevertibleAndEqual() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(1, 0);
        }
        return false;
    }

    public boolean isNonRevertibleAndEqual() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(1, 1);
        }
        return false;
    }

    public boolean isRevertibleAndNotRevertible() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(1, 2);
        }
        return false;
    }

    public boolean isAllRevertible() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(1, 3);
        }
        return false;
    }

    public boolean isConsistencyGroupCorrupted() {
        if (this.dataAvailable) {
            return this.byteArray.bitIsSet(1, 4);
        }
        return false;
    }

    public NISessionID getSessionID() {
        int n = this.byteArray.getByteAsInt(3);
        NISessionID nISessionID = null;
        try {
            nISessionID = new NISessionID(64, n);
        }
        catch (NIParameterInvalidServerException nIParameterInvalidServerException) {
            logger.throwable((Throwable)nIParameterInvalidServerException);
        }
        return nISessionID;
    }

    public long getOOSTracksForSession() {
        return this.byteArray.getLongValueFromBytes(4, 11);
    }

    public long getFLCTracksLeftToCopy() {
        return this.byteArray.getLongValueFromBytes(36, 43);
    }

    public long getLastCGFLCSequenceNumber() {
        return 0xFFFFFFFFL & (long)this.byteArray.getIntValueFromBytes(44, 47);
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("XDC Increment Status Results, x4A: \n");
            stringBuffer.append(super.toString() + "\n");
            if (this.dataAvailable) {
                stringBuffer.append("Flag Byte 0: 0x" + Integer.toHexString(0xFF & this.byteArray.extractByte(0)) + " \n");
                if (!this.inaccessibleData()) {
                    stringBuffer.append("Consistency Group Flags: 0x" + Integer.toHexString(0xFF & this.byteArray.extractByte(1)) + " \n");
                    stringBuffer.append(this.getSessionID().toString() + "\n");
                    stringBuffer.append("Out Of Sync Tracks for Session: " + this.byteArray.getLongValueFromBytes(4, 11) + "\n");
                    stringBuffer.append("Flash Copy Tracks Left to Copy: " + this.byteArray.getLongValueFromBytes(36, 43) + "\n");
                    stringBuffer.append("Flash Copy Sequence Number for last CG attempted: 0x" + Integer.toHexString(0xFFFFFFFF & this.byteArray.getIntValueFromBytes(44, 47)) + "\n");
                }
            } else {
                stringBuffer.append("No rawData available or query is not successful");
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
            return "ERROR";
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

