/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.sa;

import com.ibm.storage.ess.ni.application.NIServices;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.option.NICodeLoadConcurrent;
import com.ibm.storage.ess.ni.option.NICodeLoadNonConcurrent;
import com.ibm.storage.ess.ni.option.NICodeLoadOption;
import com.ibm.storage.ess.ni.option.NIKonaOption;
import com.ibm.storage.ess.ni.sa.NISACodeLoadStatus;
import com.ibm.storage.ess.ni.sa.NISACopyCodeThread;
import com.ibm.storage.ess.ni.sa.NISAMonitor;
import com.ibm.storage.ess.ni.sa.NISAReefCodeBundleDescriptor;
import com.ibm.storage.ess.ni.sa.NISAResult;
import com.ibm.storage.ess.ni.sa.NISAUtilities;
import com.ibm.storage.ess.ni.sa.NISAVersion;
import com.ibm.storage.ess.ni.services.NICodeLoadService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class NISACodeLoad {
    public static final int NISA_CCL = 0;
    public static final int NISA_NCCL = 1;
    public static final int NISA_ForceNCCL = 2;
    public static final int NISA_CLSTAT = 3;
    private NIServices services;
    private NISAReefCodeBundleDescriptor codePackage = null;
    private JarFile codePackageFile = null;
    private final String bundleClassName = NISAUtilities.getProperty("REEF_BUNDLE_DESCRIPTOR");
    private final String bundleTarName = NISAUtilities.getProperty("BUNDLE_TAR_NAME");
    private final String reefDesDir = NISAUtilities.getProperty("REEF_DEST_DIR");
    private final long copyTimeOut = Long.valueOf(NISAUtilities.getProperty("COPY_CODE_TIMEOUT"));
    private final String reefTempDirEnvName = NISAUtilities.getProperty("REEF_TEMP_DIR_ENV_NAME");
    private final String cclPrefix = NISAUtilities.getProperty("CCL_PREFIX");
    private final String ncclPrefix = NISAUtilities.getProperty("NCCL_PREFIX");
    private final String headerNotfound = "header_not_found";
    private int clProgress = 0;
    private int clPercent = 0;
    private String clStatLine = null;
    private Properties bundleProp = null;
    private Properties loadedProp = null;
    private String bundleTarMd5Sum = null;
    private NISAMonitor monitor = new NISAMonitor();

    public NISACodeLoad(NIServices nIServices) {
        this.services = nIServices;
    }

    protected NISACodeLoad() {
    }

    public NISAResult setCodePackage(JarFile jarFile) {
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAUtilities.getLog().info("NISACodeLoad.setCodePackage() start  - the input jarfile is " + (null == jarFile ? null : jarFile.getName()) + "\n");
        NISAResult nISAResult = new NISAResult();
        if (null == jarFile) {
            NISAUtilities.getLog().warning("NISACodeLoad.setCodePackage() finish  - the input jar file is " + jarFile);
            nISAResult.setCode(-1098383356);
            return nISAResult;
        }
        this.codePackageFile = jarFile;
        JarEntry jarEntry = jarFile.getJarEntry(this.bundleClassName + ".class");
        if (null == jarEntry) {
            NISAUtilities.getLog().warning("NISACodeLoad.setCodePackage() - Fail to find the class " + this.bundleClassName + " in the bundle");
            nISAResult.setCode(-1098383356);
            return nISAResult;
        }
        NISAUtilities.getLog().info("NISACodeLoad.setCodePackage() - Success get the jarEntry " + jarEntry.getName());
        String string = null;
        try {
            string = NISAUtilities.getEnvVariable(this.reefTempDirEnvName);
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("NISACodeLoad.setCodePackage() - Fail The Exception is: \n" + NISAUtilities.getExceptionStackTrace(exception));
            nISAResult.setCode(-1098383330);
            return nISAResult;
        }
        if (!NISAUtilities.isValidDir(string)) {
            NISAUtilities.getLog().warning("NISACodeLoad.setCodePackage() finish - Fail - " + string + " not valid directory");
            nISAResult.setCode(-1098383358);
            return nISAResult;
        }
        if (!NISAUtilities.extractJarEntry(jarEntry, jarFile, string + File.separator + jarEntry.getName())) {
            NISAUtilities.getLog().warning("NISACodeLoad.setCodePackage() - Fail Extract  " + jarEntry.getName());
            nISAResult.setCode(-1098383357);
            return nISAResult;
        }
        NISAUtilities.getLog().info("NISACodeLoad.setCodePackage() - Finish extractJarEntry() OK");
        String string2 = NISAUtilities.getProperty("BUNDLE_PROPERTIES_NAME");
        JarEntry jarEntry2 = jarFile.getJarEntry(string2);
        if (null != jarEntry2) {
            if (NISAUtilities.extractJarEntry(jarEntry2, jarFile, string + File.separator + string2)) {
                this.bundleProp = new Properties();
                try {
                    this.bundleProp.load(new FileInputStream(new File(string + File.separator + string2)));
                }
                catch (Exception exception) {
                    NISAUtilities.getLog().warning("setCodePackage() - Failed to load " + string2);
                    this.bundleProp = null;
                }
            } else {
                NISAUtilities.getLog().warning("setCodePackage() - fail to extract " + string2);
            }
        } else {
            NISAUtilities.getLog().warning("setCodePackage() - can't find " + string2);
        }
        NISAUtilities.getLog().info("NISACodeLoad.setCodePackage() finish  - OK ");
        nISAResult.setSuccessful(true);
        return nISAResult;
    }

    public NISAReefCodeBundleDescriptor getCodePackage() {
        return this.codePackage;
    }

    public JarFile getCodePackageFile() {
        return this.codePackageFile;
    }

    public NISAResult getBundleVersion() {
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAUtilities.getLog().info("NISACodeLoad.getPackageVersion() - start");
        NISAResult nISAResult = new NISAResult();
        if (null == this.codePackage) {
            NISAUtilities.getLog().warning("NISACodeLoad.getPackageVersion() finish  - the codePackage class is null");
            nISAResult.setCode(-1098383355);
            return nISAResult;
        }
        nISAResult.setBundleVersion(this.codePackage.getVersion());
        if (null == nISAResult.getBundleVersion()) {
            NISAUtilities.getLog().warning("NISACodeLoad.getPackageVersion() finish - the version on the package is invalid");
            nISAResult.setCode(-1098383356);
            return nISAResult;
        }
        NISAUtilities.getLog().info("NISACodeLoad.getPackageVersion() sfinish  - OK");
        nISAResult.setSuccessful(true);
        return nISAResult;
    }

    public NISAResult isCompatible(NIESSID nIESSID, int n) {
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAResult nISAResult = new NISAResult();
        NISAUtilities.getLog().info("NISACodeLoad.isCompatible() start");
        NISAUtilities.getLog().info("NISACodeLoad.isCompatible() - Finish - Skip the compatibility check and return Success ");
        NISAUtilities.getLog().info("NISACodeLoad.isCompatible() - OK");
        nISAResult.setSuccessful(true);
        return nISAResult;
    }

    public NISAResult copyCode(NIESSID nIESSID, int n) {
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAUtilities.getLog().info("NISACodeLoad.copyCode() - start \n");
        NISAResult nISAResult = new NISAResult();
        String[] stringArray = new String[2];
        NICodeLoadService nICodeLoadService = this.services.getCodeLoadService();
        if (null == nICodeLoadService) {
            nISAResult.setCode(-1098383359);
            NISAUtilities.getLog().warning("finish copyCode() - Fail - codeLoadService = null");
            return nISAResult;
        }
        nISAResult = this.isCompatible(nIESSID, n);
        if (!nISAResult.isSuccessful()) {
            NISAUtilities.getLog().warning("NISACodeLoad.copyCode() - Failed - the package is incompatible to Reef");
            return nISAResult;
        }
        String[] stringArray2 = NISAUtilities.getKonasIP(nIESSID, this.services);
        if (null == stringArray2) {
            NISAUtilities.getLog().warning("NISACopyCode.copyCode() Fail to get konasIP in method NISAUtilities.getKonasIP(): in ESSNI command getNetworkPorts ");
            nISAResult.setCode(-1098383340);
            return nISAResult;
        }
        try {
            new NISAMonitor().pDate(InetAddress.getByName(stringArray2[0]));
        }
        catch (UnknownHostException unknownHostException) {
            NISAUtilities.getLog().warning("copyCode() - can't get the reef date.\n the Exception is: \n" + NISAUtilities.getExceptionStackTrace(unknownHostException));
        }
        int n2 = this.isCopyAllowed(stringArray2, n);
        switch (n2) {
            case 0: {
                NISAUtilities.getLog().info("NISACodeLoad.copyCode() - got the copy permission \n");
                break;
            }
            case 1: {
                NISAUtilities.getLog().warning("NISACodeLoad.copyCode() -  header not found - act like allowed copy \n");
                break;
            }
            case -1: {
                NISAUtilities.getLog().warning("NISACodeLoad.copyCode() - fail isCopyAllowed() miss IP of reef. RC = " + n2 + "\n");
                nISAResult.setCode(-1098383340);
                return nISAResult;
            }
            case -2: {
                NISAUtilities.getLog().warning("NISACodeLoad.copyCode() - fail Not allowed to copy - copy in progress. isCopyAllowed() RC = " + n2 + "\n");
                nISAResult.setCode(-1098383318);
                return nISAResult;
            }
            case -3: {
                NISAUtilities.getLog().warning("NISACodeLoad.copyCode() - fail Not allowed to copy - cl in progress. isCopyAllowed() RC = " + n2);
                nISAResult.setCode(-1098383317);
                return nISAResult;
            }
            default: {
                NISAUtilities.getLog().warning("NISACodeLoad.copyCode() - fail to run isCopyAllowed() unknowen error. RC = " + n2);
                nISAResult.setCode(1);
                return nISAResult;
            }
        }
        String string = null;
        try {
            string = NISAUtilities.getEnvVariable(this.reefTempDirEnvName);
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("NISACodeLoad.copyCode() - Fail The Exception is: \n" + NISAUtilities.getExceptionStackTrace(exception));
            nISAResult.setCode(-1098383330);
            return nISAResult;
        }
        if (!NISAUtilities.isValidDir(string)) {
            NISAUtilities.getLog().warning("NISACodeLoad.copyCode() finish  - " + string + "not valid directory");
            nISAResult.setCode(-1098383358);
            return nISAResult;
        }
        String string2 = string + File.separator + Long.toString(Calendar.getInstance().getTimeInMillis()) + this.bundleTarName;
        File file = NISAUtilities.getBundleTar(this.codePackageFile, this.bundleTarName, string2);
        if (null == file) {
            NISAUtilities.getLog().warning("NISACodeLoad.copyCode() - Failed - the tar file = " + this.bundleTarName + "not found");
            nISAResult.setCode(-1098383339);
            return nISAResult;
        }
        this.bundleTarMd5Sum = NISAUtilities.md5JarEntry;
        stringArray[0] = NISAUtilities.getPassword(nIESSID, this.services, 0);
        stringArray[1] = NISAUtilities.getPassword(nIESSID, this.services, 1);
        if (null == stringArray[0] || null == stringArray[1]) {
            NISAUtilities.getLog().warning("NISACodeLoad.copyCode() finish  - Failed in NISAUtilities.getPassword() pswd 0 = " + (stringArray[0] == null ? "null " : "OK ") + " pswd 1 = " + (stringArray[1] == null ? "null " : "OK "));
            nISAResult.setCode(-1098383343);
            return nISAResult;
        }
        NISAUtilities.getLog().info("NISACodeLoad.copyCode() - finish to get the password - OK");
        this.clearOldBundles(string2, stringArray, nIESSID, stringArray2);
        boolean bl = true;
        long l = file.length() / 1024L;
        NISAUtilities.getLog().info("copyCode(): tar bundle size = " + l);
        long[] lArray = new long[]{0L, 0L};
        int n3 = 0;
        while (n3 < lArray.length) {
            try {
                lArray[n3] = this.monitor.dfPersist(InetAddress.getByName(stringArray2[n3]));
                if (lArray[n3] > 0L && l > lArray[n3]) {
                    NISAUtilities.getLog().warning("copyCode(): no free space. IP=" + stringArray2[n3] + " free_space=" + lArray[n3]);
                    bl = false;
                }
            }
            catch (UnknownHostException unknownHostException) {
                NISAUtilities.getLog().warning("copyCode(): can't check free space. Exception:\n" + NISAUtilities.getExceptionStackTrace(unknownHostException));
            }
            ++n3;
        }
        if (!bl) {
            NISAUtilities.getLog().warning("copyCode(): no free space for bundle. RC=-1098383292");
            nISAResult.setCode(-1098383292);
            return nISAResult;
        }
        File file2 = new File(string + File.separator + NISAUtilities.getProperty("BUNDLE_PROPERTIES_NAME"));
        this.copyBundleProp(file2, stringArray, nIESSID, stringArray2);
        nISAResult = this.copyCodeToReef(nIESSID, stringArray2, stringArray, file.getAbsolutePath(), n);
        if (file.delete()) {
            NISAUtilities.getLog().info("NISACodeLoad.copyCode() - deleted the copied tar file " + file.getAbsolutePath());
        } else {
            NISAUtilities.getLog().warning("NISACodeLoad.copyCode() - fail to delete the copied tar file " + file.getAbsolutePath());
        }
        if (!nISAResult.isSuccessful()) {
            nISAResult.setCode(-1098383352);
            NISAUtilities.getLog().warning("NISACodeLoad.copyCode() - Failed - copyCodeToReef");
        } else {
            NISAUtilities.getLog().info("NISACodeLoad.copyCode() - finish - OK");
            nISAResult.setSuccessful(true);
        }
        return nISAResult;
    }

    private void copyBundleProp(File file, String[] stringArray, NIESSID nIESSID, String[] stringArray2) {
        if (file.isFile()) {
            NISAUtilities.getLog().info("bundleProp exist, send it to reef");
            if (this.copyCodeToReef(nIESSID, stringArray2, stringArray, file.getAbsolutePath(), -1).isSuccessful()) {
                NISAUtilities.getLog().info("bundle properties has copied");
                if (!file.delete()) {
                    NISAUtilities.getLog().warning("failed to del bundlePropFile");
                }
            } else {
                NISAUtilities.getLog().warning("failed copy bundle properties. conmtinue.");
            }
        } else {
            NISAUtilities.getLog().warning("bundle properties not exist. continue.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOldBundles(String string, String[] stringArray, NIESSID nIESSID, String[] stringArray2) {
        File file = new File(string + ".empty");
        try {
            NISAUtilities.getLog().warning("NISACodeLoad.copyCode() - Copying over empty files");
            file.createNewFile();
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.print(0);
            printWriter.flush();
            printWriter.close();
            this.copyCodeToReef(nIESSID, stringArray2, stringArray, file.getAbsolutePath(), 0);
            this.copyCodeToReef(nIESSID, stringArray2, stringArray, file.getAbsolutePath(), 1);
        }
        catch (IOException iOException) {
            NISAUtilities.getLog().warning("NISACodeLoad.copyCode() - Empty file creation failed, continue on");
        }
        finally {
            if (!file.delete()) {
                NISAUtilities.getLog().warning("NISACodeLoad.copyCode() - fail to delete the empty file " + file.getAbsolutePath());
            }
        }
    }

    protected int isCopyAllowed(String[] stringArray, int n) {
        if (2 != stringArray.length) {
            NISAUtilities.getLog().warning("isCopyAllowed() - fail doesn't have 2 IPs. IP length = " + stringArray.length + "\n");
            return -1;
        }
        NISAUtilities.getLog().info("isCopyAllowed() - start for IP " + stringArray[0] + " " + stringArray[1] + " type " + n + "\n");
        String[] stringArray2 = new String[2];
        boolean[] blArray = new boolean[2];
        stringArray2[0] = this.getStatReport(stringArray[0], n);
        stringArray2[1] = this.getStatReport(stringArray[1], n);
        NISAUtilities.getLog().info("isCopyAllowed() - got the reports: kona0 " + stringArray2[0] + " kona1 " + stringArray2[1]);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            if (null == stringArray2[n2]) {
                blArray[n2] = true;
                NISAUtilities.getLog().warning("isCopyAllowed() - fail to get the report for kona " + n2);
            } else {
                String[] stringArray3 = stringArray2[n2].split("\\s");
                int n3 = 2 > stringArray3.length ? 0 : Integer.valueOf(stringArray3[1]);
                blArray[n2] = 0 == n3;
                NISAUtilities.getLog().info("isCopyAllowed() - report for kona " + n2 + " = " + blArray[n2]);
            }
            ++n2;
        }
        if (!blArray[0] || !blArray[1]) {
            NISAUtilities.getLog().warning("isCopyAllowed() - fail. NOT ALLOWED at least in one kona. \n cl0 " + blArray[0] + " cl1 " + blArray[1]);
            return -2;
        }
        NISAUtilities.getLog().info("isCopyAllowed() - OK. Allowed cl_0=" + blArray[0] + " cl_1=" + blArray[1]);
        return 0;
    }

    private NISAResult copyCodeToReef(NIESSID nIESSID, String[] stringArray, String[] stringArray2, String string, int n) {
        Object object;
        String string2;
        NISAUtilities.getLog().info("copyCodeToReef() - start ESSID=" + nIESSID + " bundleTarName=" + this.bundleTarName + "\n");
        NISAResult nISAResult = new NISAResult();
        String string3 = NISAUtilities.getProperty("MN_USER_NAME");
        NISACopyCodeThread[] nISACopyCodeThreadArray = new NISACopyCodeThread[2];
        if (-1 == n) {
            string2 = "";
        } else {
            object = n == 0 ? this.cclPrefix : this.ncclPrefix;
            string2 = (String)object + this.bundleTarName;
        }
        object = new int[]{0, 1};
        String[] stringArray3 = new String[2];
        String string4 = null;
        if (NISAUtilities.linuxOs()) {
            stringArray3[0] = stringArray2[0] + " " + string + " " + string3 + "@" + stringArray[0] + ":/" + this.reefDesDir + string2;
            stringArray3[1] = stringArray2[1] + " " + string + " " + string3 + "@" + stringArray[1] + ":/" + this.reefDesDir + string2;
            string4 = NISAUtilities.getProperty("COPY_TO_REEF_LNX_CMD");
        } else if (NISAUtilities.winOs()) {
            stringArray3[0] = "-pw " + stringArray2[0] + " \"" + string + "\" " + string3 + "@" + stringArray[0] + ":" + this.reefDesDir + string2;
            stringArray3[1] = "-pw " + stringArray2[1] + " \"" + string + "\" " + string3 + "@" + stringArray[1] + ":" + this.reefDesDir + string2;
            string4 = NISAUtilities.getProperty("COPY_TO_REEF_WIN_CMD");
        } else {
            System.err.println("can not recognized the Operation System type");
            NISAUtilities.getLog().warning("copyCodeToReef() - finish, can not recognized the Operation System");
            nISAResult.setCode(-1098383350);
            return nISAResult;
        }
        int[] nArray = new int[]{1, 1};
        long[] lArray = new long[]{0L, 0L};
        int n2 = 0;
        while (n2 < 2) {
            NISAUtilities.getLog().info("copyCodeToReef() - Start copy cycle # " + n2 + "\n");
            int n3 = 0;
            while (n3 < 2) {
                if (0 != nArray[n3]) {
                    nISACopyCodeThreadArray[n3] = new NISACopyCodeThread(string4, stringArray3[n3], (int)object[n3]);
                    nISACopyCodeThreadArray[n3].start();
                    NISAUtilities.getLog().info("copyCodeToReef() - start thread " + n3 + " parms= -pw *** " + stringArray3[n3].substring(13));
                }
                ++n3;
            }
            long l = 10000L;
            int n4 = (int)(120000L / l);
            int n5 = (int)(this.copyTimeOut / l);
            int n6 = 1;
            while (n6 <= n5) {
                try {
                    Thread.sleep(l);
                    if (!nISACopyCodeThreadArray[0].isAlive() && !nISACopyCodeThreadArray[1].isAlive()) {
                        NISAUtilities.getLog().info("copyCodeToReef(): no thread alive. break");
                        break;
                    }
                    if (0 == n6 % n4) {
                        int n7 = 0;
                        while (n7 < nISACopyCodeThreadArray.length) {
                            lArray[n7] = this.testCopyProgress(nISACopyCodeThreadArray[n7], stringArray[n7], this.reefDesDir + string2, lArray[n7]);
                            ++n7;
                        }
                    }
                }
                catch (Exception exception) {
                    NISAUtilities.getLog().warning("copyCodeToReef(): Exception in monitor copy process -> continue \n" + NISAUtilities.getExceptionStackTrace(exception));
                }
                ++n6;
            }
            int n8 = 0;
            int n9 = 0;
            while (n9 < nISACopyCodeThreadArray.length) {
                if (nISACopyCodeThreadArray[n9].isAlive()) {
                    NISAUtilities.getLog().warning("copyCodeToReef(): timeout on thread=" + n9);
                    nISACopyCodeThreadArray[n9].interrupt();
                    nISAResult.setCode(-1098383351);
                }
                nArray[n9] = nISACopyCodeThreadArray[n9].getReturnCode();
                if (string.endsWith(NISAUtilities.getProperty("BUNDLE_TAR_NAME"))) {
                    nArray[n9] = 0 == nArray[n9] && !this.testMd5Sum(this.bundleTarMd5Sum, stringArray[n9], this.reefDesDir + string2) ? 1 : nArray[n9];
                }
                NISAUtilities.getLog().info("copyCodeToReef(): finish kona" + n9 + " RC=" + nArray[n9]);
                n8 += nArray[n9];
                ++n9;
            }
            if (0 == n8) {
                nISAResult.setSuccessful(true);
                break;
            }
            nISAResult.setCode(0 == nISAResult.getCode() ? -1098383352 : nISAResult.getCode());
            NISAUtilities.getLog().info("copyCodeToReef(): finish copy cycle #" + n2 + " RC=" + Integer.toHexString(nISAResult.getCode()));
            ++n2;
        }
        NISAUtilities.getLog().info("copyCodeToReef(): finish. RC=" + Integer.toHexString(nISAResult.getCode()));
        return nISAResult;
    }

    private long testCopyProgress(NISACopyCodeThread nISACopyCodeThread, String string, String string2, long l) {
        long l2;
        NISAUtilities.getLog().info("testCopyProgress(): start Ip=" + string + " fileName=" + string2 + " lastSize=" + l);
        if (!nISACopyCodeThread.isAlive()) {
            NISAUtilities.getLog().warning("testCopyProgress(): thread dead. IP=" + string + " RC=" + l);
            return l;
        }
        try {
            String string3 = this.monitor.fileStat(string2, InetAddress.getByName(string));
            l2 = Long.parseLong(string3.split(":")[1].split(" ")[0]);
            if (l2 <= l) {
                NISAUtilities.getLog().warning("testCopyProgress(): finish IP=" + string + " copy stuck, kill process RC=-1. IP=" + string);
                nISACopyCodeThread.interrupt();
                return -1L;
            }
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("testCopyProgress(): finish IP=" + string + " Exception, RC=" + l + "\n" + NISAUtilities.getExceptionStackTrace(exception));
            return l;
        }
        NISAUtilities.getLog().info("testCopyProgress(): IP=" + string + " finish. lastSize=" + l + " RC=currentSize=" + l2);
        return l2;
    }

    private boolean testMd5Sum(String string, String string2, String string3) {
        NISAUtilities.getLog().info("testMd5Sum(): start localMd5=" + string + " IP=" + string2 + " file=" + string3);
        try {
            String string4 = this.monitor.md5sum(string3, InetAddress.getByName(string2));
            NISAUtilities.getLog().info("testMd5Sum(): md5sum result: \nlocal =" + string + "\nremote=" + string4 + " IP=" + string2);
            if (null != string && null != string4) {
                if (0 != string.compareTo(string4)) {
                    NISAUtilities.getLog().warning("testMd5Sum(): Ip=" + string2 + " md5sum not correct RC=false");
                    return false;
                }
            } else {
                NISAUtilities.getLog().warning("testMd5Sum(): can't check md5sum, at least one null IP=" + string2);
            }
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("testMd5Sum(): Exception:" + NISAUtilities.getExceptionStackTrace(exception));
        }
        NISAUtilities.getLog().info("testMd5Sum(): finish RC=true IP=" + string2);
        return true;
    }

    public NISAResult activate(NIESSID nIESSID, NICodeLoadOption nICodeLoadOption, NIKonaOption nIKonaOption) {
        String[] stringArray;
        String string;
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAUtilities.getLog().info("NISACodeLoad.activate() - Start for essId= " + nIESSID + " Type= " + nICodeLoadOption + " kona=" + nIKonaOption + "\n");
        NISAResult nISAResult = new NISAResult();
        this.clProgress = 1;
        this.clPercent = 1;
        String[] stringArray2 = NISAUtilities.getKonasIP(nIESSID, this.services);
        String string2 = null == stringArray2 ? "NISACodeLoad.activate() - Fail to get reefIPs = null" : (string = 2 < stringArray2.length ? "NISACodeLoad.activate() - Fail to get reefIPs - get only " + stringArray2.length + "IPs from the 2 konas" : "NISACodeLoad.activate() - finish OK to get reef IPs cl_0 = " + stringArray2[0] + " cl_1 = " + stringArray2[1]);
        if (null == stringArray2 || 2 < stringArray2.length) {
            NISAUtilities.getLog().warning(string);
            nISAResult.setCode(-1098383340);
            return nISAResult;
        }
        NISAUtilities.getLog().info(string);
        String string3 = "noPreCl";
        int n = 0;
        while (n < 3) {
            String string4 = this.getStatReport(stringArray2[0], 3);
            NISAUtilities.getLog().info("activate(): in try #" + n + ": preCl=" + string4);
            if (null != string4) {
                string3 = string4.trim();
                break;
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                NISAUtilities.getLog().warning("activate() - failed sleep...");
            }
            ++n;
        }
        NISAUtilities.getLog().info("activate(): preCl line= " + string3);
        int n2 = NISAUtilities.getIntProperty("ACTIVATE_STATUS_SLEEP_TIME");
        int n3 = nICodeLoadOption instanceof NICodeLoadNonConcurrent ? NISAUtilities.getIntProperty("NCCL_ACTIVATE_TIME_OUT") : NISAUtilities.getIntProperty("CCL_ACTIVATE_TIME_OUT");
        int n4 = NISAUtilities.getIntProperty("CL_NORESPONSE_TIME_OUT");
        int n5 = NISAUtilities.getIntProperty("CL_NOCHANGE_TIME_OUT");
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 3;
        String string5 = string3;
        NICodeLoadService nICodeLoadService = this.services.getCodeLoadService();
        try {
            NISAUtilities.getLog().info("activate() -essid=" + nIESSID + " send activat cmd to reef ");
            stringArray = nICodeLoadService.activateCodeLoad(nIESSID, nICodeLoadOption, nIKonaOption);
            if (!stringArray.isSuccessful()) {
                int n10 = stringArray.getCode();
                NISAUtilities.getLog().warning("activate() - Fail to execute cl script. RC= " + n10);
                nISAResult = this.convert2saresult("coming_from rc=" + n10, n10, nICodeLoadOption);
                return nISAResult;
            }
        }
        catch (NIUnauthorizedServerException nIUnauthorizedServerException) {
            NISAUtilities.getLog().warning("NISACodeLoad.activate() - Fail to execute the cl script \n the Exception is: " + NISAUtilities.getExceptionStackTrace(nIUnauthorizedServerException));
            nISAResult.setCode(-1098383315);
            return nISAResult;
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("NISACodeLoad.activate() - Fail to execute the cl script \n the Exception is: " + NISAUtilities.getExceptionStackTrace(exception));
            nISAResult.setCode(-1098383328);
            return nISAResult;
        }
        NISAUtilities.getLog().info("\nNISACodeLoad.activate() - code load script started \n");
        try {
            new NISAMonitor().pDate(InetAddress.getByName(stringArray2[0]));
        }
        catch (UnknownHostException unknownHostException) {
            NISAUtilities.getLog().warning("activate() - can't get the reef date.\n the Exception is: \n" + NISAUtilities.getExceptionStackTrace(unknownHostException));
        }
        String string6 = null;
        NISAMonitor nISAMonitor = new NISAMonitor();
        while (n8 < n3 && n6 < n4) {
            ++n8;
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                NISAUtilities.getLog().warning("NISACodeLoad.activate() - Fail tosleep in Thread sleep. cycle - " + n8 + " of " + n3);
            }
            this.clStatLine = this.getStatReport(stringArray2[0], 3);
            if (null == this.clStatLine) {
                NISAUtilities.getLog().warning("clStat - no response \n noRespCount=" + ++n6 + " noChangeCount=" + ++n7 + " totCycle=" + n8 + " maxAsk4Stat=" + n3);
                continue;
            }
            try {
                n6 = 0;
                if (0 == this.clStatLine.compareTo(string5)) {
                    NISAUtilities.getLog().warning("clStat - no change noChangeReport=" + ++n7 + " maxNoChange=" + n5 + " totCycle=" + n8 + " maxAsk4Stat=" + n3);
                    if (n7 < n5) continue;
                    NISAUtilities.getLog().info("activate(): reached maxNoChange -> check if cl active");
                    string6 = nISAMonitor.isCodeLoadActive(InetAddress.getByName(stringArray2[0]));
                    if (null != string6 && 0 == string6.compareToIgnoreCase("yes")) {
                        NISAUtilities.getLog().info("activate(): clActive=" + string6 + " -> continue monitor");
                        continue;
                    }
                    NISAUtilities.getLog().info("activate(): clActive=" + string6 + " --> exit");
                    break;
                }
                n7 = 0;
                string5 = this.clStatLine;
                stringArray = this.clStatLine.split("\\s");
                if (n9 > stringArray.length) {
                    NISAUtilities.getLog().warning("activate() - missing required values clStatLine=" + this.clStatLine);
                    continue;
                }
                if (this.clPercent < Integer.valueOf(stringArray[1])) {
                    this.clPercent = Integer.valueOf(stringArray[1]);
                }
                this.clProgress = Integer.valueOf(stringArray[2]);
                String string7 = "statetimeout=";
                int n11 = this.clStatLine.indexOf(string7);
                if (n11 >= 0) {
                    String string8 = this.clStatLine.substring(n11 + string7.length()).split("\\s")[0];
                    n5 = Integer.valueOf(string8) / (n2 / 1000);
                    NISAUtilities.getLog().info("NISACodeLoad.activate()- maxNoChange = " + n5);
                } else {
                    n5 = NISAUtilities.getIntProperty("CL_NOCHANGE_TIME_OUT");
                    NISAUtilities.getLog().warning("NISACodeLoad.activate() - state time out field is missing");
                }
                NISAUtilities.getLog().info("NISACodeLoad.activate() - finish get the State for cycle " + n8 + " percent = " + this.clPercent + " progress = " + this.clProgress + "\n");
            }
            catch (Exception exception) {
                NISAUtilities.getLog().warning("NISACodeLoad.activate() - Exception in cycle " + n8 + " from " + n3 + "\n the Exception is \n " + NISAUtilities.getExceptionStackTrace(exception));
                continue;
            }
            if (0 > this.clProgress) {
                if (null != string3 && 0 == this.clStatLine.compareTo(string3)) {
                    NISAUtilities.getLog().warning("NISACodeLoad.activate() - the clStatLine is the same as the one before start cl - continue");
                    continue;
                }
                NISAUtilities.getLog().warning("NISACodeLoad.activate() - finish Fail the clProgress = " + this.clProgress + "\n");
                nISAResult = this.convert2saresult(this.clStatLine, this.clProgress, nICodeLoadOption);
                break;
            }
            if (0 != this.clProgress) continue;
            if (null != string3 && 0 == this.clStatLine.compareTo(string3)) {
                NISAUtilities.getLog().warning("NISACodeLoad.activate() - the clStatLine is the same as the one before start cl - continue");
                continue;
            }
            NISAUtilities.getLog().info("NISACodeLoad.activate() - finish Success \n");
            nISAResult.setSuccessful(true);
            break;
        }
        NISAUtilities.getLog().info("NISACodeLoad.activate() - finish :\n maxNoRespond=" + n4 + ", noRespCount= " + n6 + "\n " + "maxNoChange=" + n5 + ", noChangeCount=" + n7 + "\n " + "maxAsk4Stat=" + n3 + ", cyclesCount=" + n8);
        if (!nISAResult.isSuccessful()) {
            if (0 == nISAResult.getCode()) {
                if (n6 >= n4) {
                    nISAResult.setCode(NISAResult.REASON_FAILURE_CL_NORESPONSE_TIMEOUT);
                } else if (n7 >= n5) {
                    nISAResult.setCode(NISAResult.REASON_FAILURE_CL_NOCHANGE_TIMEOUT);
                } else if (n8 >= n3) {
                    nISAResult.setCode(-1098383351);
                }
            }
            NISAUtilities.getLog().warning("activate() - Failure. RC= " + Integer.toHexString(nISAResult.getCode()));
        } else {
            NISAUtilities.getLog().info("activate() - finish Successful ");
        }
        return nISAResult;
    }

    protected NISAResult convert2saresult(String string, int n, NICodeLoadOption nICodeLoadOption) {
        NISAUtilities.getLog().info("convert2saresult() - start clRc=" + n + "\nclStatLine=" + string);
        int n2 = n < 0 ? -n : n;
        String[] stringArray = null;
        boolean bl = false;
        if (string.matches("coming_from.*")) {
            NISAUtilities.getLog().info("convert2saresult() - coming_from err No." + n);
            switch (n2) {
                case 2: 
                case 28: {
                    n2 = -1098383299;
                    bl = true;
                    break;
                }
                case 42: {
                    n2 = -1098383298;
                    bl = true;
                    break;
                }
                case 82: {
                    n2 = -1098383297;
                    bl = true;
                }
            }
        } else {
            int n3 = string.indexOf("error4sa=") + 9;
            if (8 < n3) {
                String string2 = string.substring(n3, string.indexOf(45, n3));
                try {
                    n2 = Integer.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    NISAUtilities.getLog().warning("convert2saresult() - can't convert intVal " + string2);
                }
                NISAUtilities.getLog().info("convert2saresult() - going_to error4sa No." + n2);
                switch (n2) {
                    case 11: {
                        n2 = -1098383296;
                        bl = true;
                        break;
                    }
                    case 12: {
                        n2 = -1098383302;
                        bl = true;
                        break;
                    }
                    case 13: {
                        n2 = -1098383301;
                        bl = true;
                        break;
                    }
                    case 32: {
                        n2 = -1098383299;
                        bl = true;
                    }
                }
            }
        }
        if (!bl) {
            n2 = nICodeLoadOption instanceof NICodeLoadConcurrent ? -1098383305 : -1098383304;
            stringArray = new String[]{string};
        }
        NISAUtilities.getLog().info("convert2saresult() - finish sa rc=" + Integer.toHexString(n2));
        return new NISAResult(0 == n2, n2, stringArray);
    }

    protected String getStatReport(String string, int n) {
        Object object;
        NISAUtilities.getLog().info("NISACodeLoad.getStatReport() - Start for IP- " + string + " and mode " + n + "\n");
        String string2 = null;
        String string3 = null;
        String string4 = "CL_STAT_REPORT";
        String string5 = "ALLOW_COPY";
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        if (NISAUtilities.winOs()) {
            string2 = NISAUtilities.getProperty("SSH_TO_REEF_WIN_CMD");
            string7 = "cl@" + string + " -pw cl";
            string8 = "cl@" + string + " -pw cl allow_copy /persist/scratch/Nccl.SEA.tar";
            string9 = "cl@" + string + " -pw cl allow_copy /persist/scratch/Ccl.SEA.tar";
        } else if (NISAUtilities.linuxOs()) {
            string2 = NISAUtilities.getProperty("SSH_TO_REEF_LNX_CMD");
            string7 = "cl cl@" + string;
            string8 = "cl cl@" + string + " allow_copy /persist/scratch/Nccl.SEA.tar";
            string9 = "cl cl@" + string + " allow_copy /persist/scratch/Ccl.SEA.tar";
        } else {
            NISAUtilities.getLog().warning("getStatReport fail - unknown Operation System");
            return null;
        }
        switch (n) {
            case 0: {
                string6 = string9;
                string3 = string5;
                break;
            }
            case 1: {
                string6 = string8;
                string3 = string5;
                break;
            }
            case 3: {
                string3 = string4;
                string6 = string7;
                break;
            }
            default: {
                NISAUtilities.getLog().warning("NISACodeLoad.getStatReport() - fail not available mode = " + n);
                return null;
            }
        }
        int n2 = 600000;
        String string10 = null;
        try {
            string10 = NISAUtilities.getEnvVariable(this.reefTempDirEnvName) + File.separator + "clReport";
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("NISACodeLoad.getStatReport() - Fail The Exception is: \n" + NISAUtilities.getExceptionStackTrace(exception));
            return null;
        }
        RunScriptThread runScriptThread = new RunScriptThread(string2, string6, 0, string10);
        runScriptThread.start();
        try {
            runScriptThread.join(n2);
        }
        catch (InterruptedException interruptedException) {
            NISAUtilities.getLog().warning("NISACodeLoad.getStatReport() - fail - scriptThread interupted. The Exception is \n" + NISAUtilities.getExceptionStackTrace(interruptedException));
            return null;
        }
        if (runScriptThread.isAlive()) {
            NISAUtilities.getLog().warning("NISACodeLoad.getStatReport() - Failed to run the scriptThread - Time out ");
            runScriptThread.interrupt();
            return null;
        }
        int n3 = NISAUtilities.getCopyToKona0RetCode();
        if (0 != n3) {
            NISAUtilities.getLog().warning("NISACodeLoad.getStatReport() - Fail in excute the plink command. the return value = " + n3);
            return null;
        }
        NISAUtilities.getLog().info("NISACodeLoad.getStatReport() - finish get the clState file ");
        File file = new File(string10);
        String string11 = "header_not_found";
        try {
            String string12;
            object = new BufferedReader(new FileReader(file));
            while (null != (string12 = ((BufferedReader)object).readLine())) {
                if (!string12.trim().matches(".*" + string3 + ".*")) continue;
                NISAUtilities.getLog().info("NISACodeLoad.getStatReport() - find the report line = " + string12);
                string11 = string12;
                break;
            }
            ((BufferedReader)object).close();
            if (file.delete()) {
                NISAUtilities.getLog().info("NISACodeLoad.getStatReport() - delete the report file " + file);
            } else {
                NISAUtilities.getLog().warning("NISACodeLoad.getStatReport() - fail to delete the report file " + file);
            }
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("NISACodeLoad.getStatReport() - Fail to find the report line in file " + string10 + "\nthe Exception is \n" + NISAUtilities.getExceptionStackTrace(exception));
            return null;
        }
        object = NISAUtilities.getProperty("SCP_RESPONSE");
        string11 = string11.startsWith((String)object) ? string11.substring(1) : string11;
        NISAUtilities.getLog().info("NISACodeLoad.getStatReport() - finish the return line is " + string11);
        return string11;
    }

    protected int getPercentComplete() {
        return this.clPercent;
    }

    protected boolean isCodeLoadFailed() {
        return this.clProgress < 0;
    }

    public NISACodeLoadStatus getCodeloadStatus() {
        return new NISACodeLoadStatus(this);
    }

    public NISAResult getLoadedBundleVersions(NIESSID nIESSID) {
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAUtilities.getLog().info("getLoadedBundleVersions() - start");
        String string = null;
        String[] stringArray = null;
        String string2 = null;
        try {
            string = NISAUtilities.getEnvVariable(this.reefTempDirEnvName);
        }
        catch (IOException iOException) {
            NISAUtilities.getLog().warning("getLoadedBundleVersions() - failed get tmpDirexception: " + NISAUtilities.getExceptionStackTrace(iOException));
            return new NISAResult(false, -1098383330);
        }
        string2 = NISAUtilities.getPassword(nIESSID, this.services, 0);
        stringArray = NISAUtilities.getKonasIP(nIESSID, this.services);
        if (null == stringArray || null == string2) {
            NISAUtilities.getLog().warning("getLoadedBundleVersions() - fail Ips or pswd is null ");
            return new NISAResult(false, -1098383328);
        }
        String string3 = string + File.separator + NISAUtilities.getProperty("LOADED_BUNDLE_PROPERTIES_NAME");
        String string4 = NISAUtilities.getProperty("REEF_DEST_DIR") + NISAUtilities.getProperty("BUNDLE_PROPERTIES_NAME");
        String string5 = NISAUtilities.getProperty("MN_USER_NAME");
        int n = NISAUtilities.scpFile(stringArray[0], string5, string2, string3, string4);
        if (0 != n) {
            NISAUtilities.getLog().warning("getLoadedBundleVersions() - fail to copy the file");
            return new NISAResult(false, n);
        }
        this.loadedProp = new Properties();
        try {
            this.loadedProp.load(new FileInputStream(new File(string3)));
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("getLoadedBundleVersions() - Failed to load " + string3);
            this.loadedProp = null;
        }
        NISAUtilities.getLog().info("getLoadedBundleVersions() - put versions on result");
        return this.getBundleVersions(this.loadedProp);
    }

    public NISAResult getLocalBundleVersions() {
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        return this.getBundleVersions(this.bundleProp);
    }

    private NISAResult getBundleVersions(Properties properties) {
        NISAUtilities.getLog().info("getBundleVersions() - start");
        NISAResult nISAResult = new NISAResult(true, 0);
        String string = null;
        try {
            string = properties.getProperty("BUNDLE_LIC_VERSION");
            nISAResult.setLicVersion(new NISAVersion(string));
            string = properties.getProperty("BUNDLE_MCP_VERSION");
            nISAResult.setMcpVersion(new NISAVersion(string));
            string = properties.getProperty("BUNDLE_IDENTIFICATION_NUMBER");
            nISAResult.setBundleVersion(new NISAVersion(string));
        }
        catch (Exception exception) {
            nISAResult.setCode(-1098383356);
            NISAUtilities.getLog().warning("getBundleVersions(): failed - bundleProperties not loaded or corrupted");
        }
        NISAUtilities.getLog().info("getBundleVersions() - finish. rc=" + Integer.toHexString(nISAResult.getCode()));
        return nISAResult;
    }

    protected String getClStatLine() {
        return this.clStatLine;
    }

    protected int getClProgress() {
        return this.clProgress;
    }

    private class RunScriptThread
    extends Thread {
        private String scriptName;
        private String cmdParams;
        private int konaId;
        private String reDirectFileName;
        volatile boolean stop = false;

        private RunScriptThread(String string, String string2, int n, String string3) {
            this.scriptName = string;
            this.cmdParams = string2;
            this.konaId = n;
            this.reDirectFileName = string3;
        }

        public void run() {
            int n;
            NISAUtilities.getLog().info("RunScriptThread.run() - Start running " + this.scriptName + " to " + this.reDirectFileName);
            String string = NISAUtilities.getProperty("SCP_RESPONSE");
            try {
                n = NISAUtilities.ourExec(this.scriptName, this.cmdParams, string, this.reDirectFileName);
            }
            catch (FileNotFoundException fileNotFoundException) {
                n = 1;
                NISAUtilities.getLog().warning("NISACopyCodeThread.run() Fail - execption:" + NISAUtilities.getExceptionStackTrace(fileNotFoundException));
            }
            if (this.konaId == 0) {
                NISAUtilities.setCopyToKona0RetCode(n);
            } else if (this.konaId == 1) {
                NISAUtilities.setCopyToKona1RetCode(n);
            } else {
                NISAUtilities.getLog().warning("RunScriptThread.run() - no common return value is set ");
            }
            NISAUtilities.getLog().info("RunScriptThread.run() finish the return code is " + n);
        }
    }
}

