/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.sa;

import com.ibm.storage.ess.ni.application.NIServices;
import com.ibm.storage.ess.ni.application.resource.NIESSDomainElement;
import com.ibm.storage.ess.ni.application.resource.NIStoragePlex;
import com.ibm.storage.ess.ni.application.results.NIESSDomainResult;
import com.ibm.storage.ess.ni.application.results.NIPEPackageResult;
import com.ibm.storage.ess.ni.exception.NIServerException;
import com.ibm.storage.ess.ni.exception.NITimeoutServerException;
import com.ibm.storage.ess.ni.exception.NIUnauthorizedServerException;
import com.ibm.storage.ess.ni.exception.NIUnavailableServerException;
import com.ibm.storage.ess.ni.exception.NIUnsupportedException;
import com.ibm.storage.ess.ni.identifiers.NIESSID;
import com.ibm.storage.ess.ni.option.NIKonaLeft;
import com.ibm.storage.ess.ni.option.NIKonaOption;
import com.ibm.storage.ess.ni.option.NIKonaRight;
import com.ibm.storage.ess.ni.resource.NIESSDomainElementImpl;
import com.ibm.storage.ess.ni.sa.NISAMonitor;
import com.ibm.storage.ess.ni.sa.NISAResult;
import com.ibm.storage.ess.ni.sa.NISAUtilities;
import com.ibm.storage.ess.ni.services.NITraceService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class NISAPEpackage {
    private final String zipNameSuffix = NISAUtilities.getProperty("PE_PACKAGE_ZIP_SUFFIX");
    private final String pePackageSrc = NISAUtilities.getProperty("PEPACKAGE_SRC");
    private String password = null;
    private boolean copyLogs = true;
    private String zipName = null;
    private String peName = "peName";

    public NISAResult createAndCopy(NIServices nIServices, NIESSID nIESSID) {
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAUtilities.getLog().info("\ncreateAndCopy() - Starat. essId=" + nIESSID + "\n");
        File file = NISAUtilities.getSend2IBMDir();
        if (null == file) {
            NISAUtilities.getLog().warning("createAndCopy() - fail to getthe send2IBM dir ");
            return new NISAResult(false, -1098383325);
        }
        NISAResult nISAResult = this.createAndCopy(nIServices, nIESSID, file);
        NISAUtilities.getLog().info("\ncreateAndCopy() - Finish, rc = " + Integer.toHexString(nISAResult.getCode()) + "\n");
        return nISAResult;
    }

    public NISAResult createAndCopy(NIServices nIServices, NIESSID nIESSID, File file) {
        NISAResult nISAResult;
        NISAResult nISAResult2;
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAUtilities.getLog().info("NISAPEpackage.createAndCopy() start: destinationDir = " + file);
        NISAResult nISAResult3 = NISAUtilities.preCond(nIServices, nIESSID, file);
        if (!nISAResult3.isSuccessful()) {
            NISAUtilities.getLog().warning("createAndCopy() - Fail preCond");
            return nISAResult3;
        }
        String[] stringArray = nISAResult3.getArray();
        try {
            new NISAMonitor().pDate(InetAddress.getByName(stringArray[0]));
        }
        catch (UnknownHostException unknownHostException) {
            NISAUtilities.getLog().warning("createAndCopy() - can't get the reef date.\n the Exception is: \n" + NISAUtilities.getExceptionStackTrace(unknownHostException));
        }
        NITraceService nITraceService = nIServices.getTraceService();
        if (null == nITraceService) {
            NISAUtilities.getLog().warning("NISAPEpackage.createAndCopy() finish - Fail to get the raceServise(): in ESSNI command essniConnection.getTraceService()");
            new NISAResult(false, -1098383334);
        }
        NISAUtilities.getLog().info("NISAPEpackage.createAndCopy() finish getTraceService() - OK");
        this.copyLogs = true;
        String string = null;
        try {
            nISAResult2 = this.createAndCopyOneKona(0, nIServices, nIESSID, file, stringArray[0], nITraceService);
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("NISAPEpackage.createAndCopy() - Fail in createAndCopyOneKona for kona 0. the Exception is: \n" + NISAUtilities.getExceptionStackTrace(exception));
            nISAResult2 = new NISAResult(false, -1098383328);
        }
        if (nISAResult2.isSuccessful()) {
            NISAUtilities.getLog().info("NISAPEpackage.createAndCopy() createAndCopyOneKona() - OK for kona 0");
            string = this.zipName;
        } else {
            NISAUtilities.getLog().warning("NISAPEpackage.createAndCopy() createAndCopyOneKona() - Fail for kona 0 - continue to kona 1 \nThere will be no PE_Package from kona 0.");
        }
        this.zipName = null;
        try {
            nISAResult = this.createAndCopyOneKona(1, nIServices, nIESSID, file, stringArray[1], nITraceService);
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("NISAPEpackage.createAndCopy() - Fail in createAndCopyOneKona for kona 1. the Exception is: \n" + NISAUtilities.getExceptionStackTrace(exception));
            nISAResult = new NISAResult(false, -1098383328);
        }
        if (!nISAResult2.isSuccessful() && nISAResult.isSuccessful()) {
            NISAUtilities.getLog().warning("createAndCopy() - success kona 1 only");
            nISAResult3.setCopiedFiles(new String[]{this.zipName});
            nISAResult3.setCode(-1098383322);
            return nISAResult3;
        }
        if (nISAResult2.isSuccessful() && !nISAResult.isSuccessful()) {
            NISAUtilities.getLog().warning("createAndCopy() - success kona 0 only");
            nISAResult3.setCopiedFiles(new String[]{string});
            nISAResult3.setCode(-1098383321);
            return nISAResult3;
        }
        if (!nISAResult2.isSuccessful() && !nISAResult.isSuccessful()) {
            NISAUtilities.getLog().warning("createAndCopy() - Fail both konas");
            return new NISAResult(false, -1098383348);
        }
        nISAResult3.setCopiedFiles(new String[]{string, this.zipName});
        NISAUtilities.getLog().info("createAndCopy() finish - OK successful");
        nISAResult3.setSuccessful(true);
        return nISAResult3;
    }

    private NISAResult createAndCopyOneKona(int n, NIServices nIServices, NIESSID nIESSID, File file, String string, NITraceService nITraceService) throws NIUnavailableServerException, NIUnsupportedException, NIUnauthorizedServerException, NIServerException {
        String string2;
        NIKonaOption nIKonaOption;
        NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() Start - OK for kona " + n + " the kona hostName = " + string);
        if (null == string) {
            NISAUtilities.getLog().warning("NISAPEpackage.createAndCopyOneKona() - Fail - The paramter kona_hostName = " + string);
            return new NISAResult(false, -1098383340);
        }
        if (0 == n) {
            nIKonaOption = NIKonaLeft.Option;
            string2 = "subDir_0";
        } else {
            nIKonaOption = NIKonaRight.Option;
            string2 = "subDir_1";
        }
        this.password = NISAUtilities.getPassword(nIESSID, nIServices, n);
        if (null == this.password) {
            NISAUtilities.getLog().warning("NISAPEpackage.createAndCopyOneKona() Fail to get password for kona " + n);
            return new NISAResult(false, -1098383343);
        }
        NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() finish get password - OK");
        File file2 = this.getSubDir(file, string2);
        if (null == file2) {
            NISAUtilities.getLog().warning("NISAPEpackage.createAndCopyOneKona() finish - Fail in getSubDir() for kona " + n);
            return new NISAResult(false, -1098383358);
        }
        NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() - finish getSubDir - OK ");
        boolean bl = false;
        try {
            NIPEPackageResult nIPEPackageResult = nITraceService.createPEPackage(nIESSID, nIKonaOption);
            if (!nIPEPackageResult.isSuccessful()) {
                NISAUtilities.getLog().warning("NISAPEpackage.createAndCopyOneKona() finish - Fail in ESSNI NITraceService.createPEPackage() for kona " + n);
                return new NISAResult(false, -1098383348);
            }
            NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() - finish createPEPackage - Ok for kona " + n);
        }
        catch (NITimeoutServerException nITimeoutServerException) {
            NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() - waiting  createPEPackage caught NITimeoutServerException for kona " + n);
            bl = true;
        }
        int n2 = 1;
        int n3 = 0;
        if (bl) {
            n2 = NISAUtilities.getIntProperty("COPY_PEPACKAGE_MAX_TRIES");
            n3 = NISAUtilities.getIntProperty("COPY_PEPACKAGE_SLEEP_TIME");
            NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() - Start polling on kona " + n + " with " + n3 + " millis intervals for " + n2 + " maximum tries");
            if (n2 < 1) {
                n2 = 1;
            }
        }
        NISAResult nISAResult = null;
        int n4 = 0;
        while (n4 < n2) {
            try {
                Thread.sleep(n3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            nISAResult = this.copyPEPackage(n, string, file2);
            if (nISAResult.isSuccessful()) break;
            ++n4;
        }
        if (!nISAResult.isSuccessful()) {
            if (bl) {
                NISAUtilities.getLog().warning("NISAPEpackage.createAndCopyOneKona() finish - Fail in ESSNI NITraceService.createPEPackage() for kona " + n);
                return new NISAResult(false, -1098383348);
            }
            NISAUtilities.getLog().warning("NISAPEpackage.createAndCopyOneKona() - Failed in copyPEPackage for kona " + n);
            return nISAResult;
        }
        NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() - finish copyPEPackage for kona " + n + " - OK ");
        this.zipName = this.buildZipName(file2);
        if (null == this.zipName) {
            NISAUtilities.getLog().warning("NISAPEpackage.createAndCopyOneKona() - Failed in buildZipName for kona " + n + " the zipName = " + this.zipName);
            return new NISAResult(false, -1098383346);
        }
        NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() - finish buildZipName - OK, the zipName =  " + this.zipName);
        if (this.copyLogs) {
            if (0 != this.copyGUILogs(file2)) {
                NISAUtilities.getLog().warning("NISAPEpackage.createAndCopyOneKona() - Fail to copyGUILogs - there will be no logs from the GUI in the pePackage zip file");
            } else {
                NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() - finish copyGUILogs - OK - the logs are in the package of kona " + n);
            }
            if (0 != this.copyEssniLogs(file2)) {
                NISAUtilities.getLog().warning("NISAPEpackage.createAndCopyOneKona() - Fail  to copyEssniLogs - there will be no logs from the Essni in the pePackage zip file");
            } else {
                NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() - finish copyEssniLogs - OK -  the logs are in the package of kona " + n);
            }
            if (0 != this.copyDsCliLogs(file2)) {
                NISAUtilities.getLog().warning("NISAPEpackage.createAndCopyOneKona() - Fail to copyDsCliLogs - there will be no logs from the DsCli in the pePackage zip file");
            } else {
                NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() - finish copyDsCliLogs - OK - the logs are in the package of kona " + n);
            }
            if (0 != this.copySMLogs(file2)) {
                NISAUtilities.getLog().warning("NISAPEpackage.createAndCopyOneKona() - Fail to copySMLogs - there will be no logs from the SM in the pePackage zip file");
            } else {
                NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() - finish copySMLogs - OK - the logs are in the package of kona " + n);
            }
            this.copyLogs = false;
        }
        try {
            NISAUtilities.createZip(this.zipName, file2);
        }
        catch (IOException iOException) {
            NISAUtilities.getLog().warning("NISAPEpackage.createAndCopyOneKona() - Fail in NISAUtilities.createZip method for kona " + n + " the Exception is : \n" + NISAUtilities.getExceptionStackTrace(iOException));
            return new NISAResult(false, -1098383332);
        }
        NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() - finish createZip - OK ");
        if (!NISAUtilities.delDir(file2)) {
            NISAUtilities.getLog().warning("NISAPEpackage.createAndCopyOneKona() - Fail to delDir for directory = " + file2.getAbsolutePath());
        } else {
            NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() - finish createZip - OK to delDir for directory = " + file2.getAbsolutePath());
        }
        NISAUtilities.getLog().info("NISAPEpackage.createAndCopyOneKona() - finish OK for kona " + n);
        return new NISAResult(true, 0);
    }

    private File getSubDir(File file, String string) {
        NISAUtilities.getLog().info("NISAPEpackage.getSubDir() Start. subDir name = " + string);
        File file2 = new File(file, string);
        if (file2.exists()) {
            NISAUtilities.getLog().info(".getSubDir() the dir exist - try to delete it");
            if (!NISAUtilities.delDir(file2)) {
                NISAUtilities.getLog().warning("getSubDir() - Fail to delete the exist subdir " + file2.getAbsolutePath());
                return null;
            }
            NISAUtilities.getLog().info(".getSubDir() finish delete exists_dir - OK");
        }
        if (!file2.mkdir()) {
            NISAUtilities.getLog().warning(".getSubDir() - Fail to mkdir for " + file.getAbsolutePath() + "/" + string);
            return null;
        }
        NISAUtilities.getLog().info(".getSubDir() finish  - OK " + file2.getAbsolutePath() + " created");
        return file2;
    }

    private boolean isValidDir(File file) {
        if (!file.isDirectory()) {
            NISAUtilities.getLog().warning("isValidDir() - Not valid dir " + file);
            return false;
        }
        NISAUtilities.getLog().info("isValidDir() - is a valid dir " + file);
        return true;
    }

    private NISAResult copyPEPackage(int n, String string, File file) {
        NISAUtilities.getLog().info("NISAPEpackage.copyPEPackage() - start copy the pePackage for kona " + n);
        String string2 = null;
        String string3 = null;
        String string4 = "-pw " + this.password + " " + NISAUtilities.getProperty("MN_USER_NAME") + "@" + string + ":/" + this.pePackageSrc;
        String string5 = " \"" + file.getAbsolutePath() + "\"";
        String string6 = this.password + " " + NISAUtilities.getProperty("MN_USER_NAME") + "@" + string + ":/" + this.pePackageSrc;
        String string7 = " " + file.getAbsolutePath();
        String[] stringArray = new String[]{"pepackage.tar.gz", this.peName, "header"};
        try {
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string8;
                if (NISAUtilities.linuxOs()) {
                    string2 = NISAUtilities.getProperty("COPY_PEPACKAGE_LNX");
                    string8 = string6 + stringArray[n2] + string7;
                } else if (NISAUtilities.winOs()) {
                    string2 = NISAUtilities.getProperty("COPY_PEPACKAGE_WIN");
                    string8 = string4 + stringArray[n2] + string5;
                    string3 = NISAUtilities.getProperty("SCP_RESPONSE");
                } else {
                    System.err.println("can not recognized the Operation System type");
                    NISAUtilities.getLog().warning("NISAPEpackage.copyPEPackage() - Fail - can not recognized the Operation System");
                    return new NISAResult(false, -1098383350);
                }
                if (0 != NISAUtilities.ourExec(string2, string8, string3, null)) {
                    NISAUtilities.getLog().warning("NISAPEpackage.copyPEPackage() - Fail to copy " + stringArray[n2]);
                    return new NISAResult(false, -1098383346);
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            NISAUtilities.getLog().warning("NISAPEpackage.copyPEPackage() - Fail - for kona " + n + " the exception is \n " + NISAUtilities.getExceptionStackTrace((Exception)throwable));
            return new NISAResult(false, 2);
        }
        NISAUtilities.getLog().info("NISAPEpackage.copyPEPackage() - finish copy the pePackage - OK - for kona " + n + " command name " + string2);
        return new NISAResult(true, 0);
    }

    private int copyLogs(File file, File file2, String string) {
        NISAUtilities.getLog().info("NISAPEpackage.copyLogs() Start. destDir name = " + file + " srcDir  name = " + file2 + " match = " + string);
        File[] fileArray = file2.listFiles();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < fileArray.length) {
            if (!fileArray[n3].getName().matches(".*.lck") && fileArray[n3].getName().matches(string)) {
                NISAUtilities.getLog().info("getLogs() - found file " + fileArray[n3].getName());
                if (fileArray[n3].isDirectory()) {
                    NISAUtilities.getLog().info(fileArray[n3].getName() + " is directory");
                } else {
                    ++n2;
                    File file3 = new File(file.getAbsoluteFile() + File.separator + fileArray[n3].getName());
                    int n4 = this.copyFile(fileArray[n3], file3);
                    if (0 != n4) {
                        NISAUtilities.getLog().warning("getLogs() - Fail copy " + fileArray[n3].getName() + " to " + file.getName() + " RC= " + n4);
                    } else {
                        NISAUtilities.getLog().info("copyLogs() - OK - copied  " + fileArray[n3].getName() + " to " + file.getName());
                        ++n;
                    }
                }
            }
            ++n3;
        }
        if (n2 > n) {
            NISAUtilities.getLog().warning("copyLogs() - Fail to copy all the log files. found logs = " + n2 + " successfully copied = " + n);
        }
        NISAUtilities.getLog().info("NISAPEpackage.copyLogs() Finish ");
        return n;
    }

    private int copyEssniLogs(File file) {
        File file2;
        File file3;
        File file4;
        File file5;
        Object object;
        NISAUtilities.getLog().info("NISAPEpackage.copyEssniLogs() - Start, the dest dir = " + file.getAbsolutePath());
        String string = null;
        String string2 = NISAUtilities.getProperty("ESSNI_DIR");
        String string3 = NISAUtilities.getProperty("ESSNI_LOGS_SERVER_DIR");
        File file6 = null;
        File file7 = null;
        File file8 = null;
        NISAUtilities.getLog().info("----------ESSNI---------------\n");
        file6 = this.getSubDir(file, string2);
        if (file6 == null) {
            NISAUtilities.getLog().warning(".copyEssniLogs() - Failed - The ESSNI dir wasn't created - use " + file);
            file6 = file;
        }
        try {
            string = NISAUtilities.getEnvVariable(NISAUtilities.getProperty("ESSNI_HOME_ENV_NAME"));
            object = new File(string + File.separator + NISAUtilities.getProperty("ESSNI_ETC_DIR"));
            if (this.isValidDir((File)object)) {
                if (this.copyLogs(file6, (File)object, NISAUtilities.getProperty("MessageRouter")) == 1) {
                    NISAUtilities.getLog().info("MessageRouterRoutingInformation.txtwas found and copied successfully");
                } else {
                    NISAUtilities.getLog().info("MessageRouterRoutingInformation.txtwasnt copied");
                }
            }
            if (this.isValidDir(file5 = new File(string + File.separator + NISAUtilities.getProperty("ESSNI_BIN_DIR")))) {
                int n = this.copyLogs(file6, file5, NISAUtilities.getProperty("JAVACORE_FILES"));
                NISAUtilities.getLog().info("were found " + n + " javacore* files ");
            }
            if (this.isValidDir(file4 = new File(string + File.separator + NISAUtilities.getProperty("ESSNI_LOGS_DIR")))) {
                file7 = this.getSubDir(file6, string3);
                if (file7 == null) {
                    NISAUtilities.getLog().warning(".copyEssniLogs() - Failed - The SERVER sub dir wasnt created - use " + file6);
                    file7 = file6;
                }
                if (this.isValidDir(file3 = new File(file4 + File.separator + NISAUtilities.getProperty("ESSNI_LOGS_SERVER_DIR")))) {
                    this.copyLogs(file7, file3, NISAUtilities.getProperty("ALL_FILES"));
                }
                if ((file8 = this.getSubDir(file6, string3 = NISAUtilities.getProperty("ESSNI_LOGS_OFFLINE_DIR"))) == null) {
                    NISAUtilities.getLog().warning(".copyEssniLogs() - Failed - The SERVER sub dir wasnt created - use " + file6);
                    file8 = file6;
                }
                if (this.isValidDir(file2 = new File(file4 + File.separator + NISAUtilities.getProperty("ESSNI_LOGS_OFFLINE_DIR")))) {
                    this.copyLogs(file8, file2, NISAUtilities.getProperty("ALL_FILES"));
                }
            }
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning(".copyEssniLogs() - Fail - can't get the essniHomeDir = " + string + NISAUtilities.getExceptionStackTrace(exception));
            return -1098383358;
        }
        object = NISAUtilities.getProperty("ESSNI_SRV_JAR");
        file5 = new File(string + File.separator + NISAUtilities.getProperty("ESSNI_LIB_DIR"));
        file4 = new File(string + File.separator + NISAUtilities.getProperty("ESSNI_JAVA_DIR"));
        if (this.isValidDir(file4) && this.isValidDir(file3 = new File(file4 + File.separator + NISAUtilities.getProperty("ESSNI_JAVA_JRE_DIR"))) && this.isValidDir(file2 = new File(file3 + File.separator + NISAUtilities.getProperty("ESSNI_JAVA_JRE_BIN_DIR")))) {
            File file9 = new File(file6, "javaJarCmd");
            File file10 = new File(file6, "essniClientVersion");
            File file11 = new File(file6, "readme.txt");
            File file12 = new File(file6, "date");
            File file13 = new File(file6, "time");
            File file14 = new File(file6, "command");
            File file15 = new File(file6, "netstat.log");
            File[] fileArray = new File[]{file12, file13, file14};
            try {
                if (NISAUtilities.winOs()) {
                    if (0 != NISAUtilities.ourExec("cmd /c date", "/t", null, file12.getAbsolutePath())) {
                        NISAUtilities.getLog().warning("Failed to exec cmd /c date");
                    }
                    if (0 != NISAUtilities.ourExec("cmd /c time", "/t", null, file13.getAbsolutePath())) {
                        NISAUtilities.getLog().warning("Failed to exec cmd /c time");
                    }
                } else if (NISAUtilities.linuxOs() && 0 != NISAUtilities.ourExec("date", "", null, file12.getAbsolutePath())) {
                    NISAUtilities.getLog().warning("Failed to exec cmd date");
                }
                if (0 != NISAUtilities.ourExec("netstat", "-n", null, file14.getAbsolutePath())) {
                    NISAUtilities.getLog().warning("Failed to exec command: netstat -n");
                }
                if (this.isValidDir(file5)) {
                    String string4;
                    String string5 = NISAUtilities.getEnvVariable(NISAUtilities.getProperty("REEF_JAVA_DIR_ENV_NAME")) + File.separator + "bin" + File.separator + "java";
                    File file16 = new File(file5 + File.separator + (String)object);
                    String string6 = string4 = NISAUtilities.winOs() ? "\"" + file16.getAbsolutePath() + "\"" : file16.getAbsolutePath();
                    if (0 != NISAUtilities.ourExec(string5, string4, null, file9.getAbsolutePath())) {
                        NISAUtilities.getLog().warning("Failed to exec command: java -jar ESSNIServer.jar");
                    }
                    String string7 = NISAUtilities.getProperty("ESSNI_CLNT_JAR");
                    File file17 = new File(file5 + File.separator + string7);
                    String string8 = string4 = NISAUtilities.winOs() ? "\"" + file17.getAbsolutePath() + "\"" : file17.getAbsolutePath();
                    if (0 != NISAUtilities.ourExec(string5, string4, null, file10.getAbsolutePath())) {
                        NISAUtilities.getLog().warning("Failed to exec command: java -jar ESSNIClient.jar");
                    }
                }
                NISAUtilities.concatFiles(file15, fileArray);
                fileArray[2] = file9;
                NISAUtilities.concatFiles(file11, fileArray);
                if (!(file12.delete() && file13.delete() && file14.delete() && file9.delete())) {
                    NISAUtilities.getLog().warning("Fail to delete file one or more files: date, time, command, javaJarCmd");
                }
            }
            catch (Exception exception) {
                NISAUtilities.getLog().warning(".copyEssniLogs() - Fail to get netstat or ESSNIServer. The exception is : \n" + NISAUtilities.getExceptionStackTrace(exception));
            }
        }
        NISAUtilities.getLog().info("NISAPEpackage.copyEssniLogs() - Finish OK ");
        return 0;
    }

    private int copyGUILogs(File file) {
        File file2;
        File file3;
        File file4;
        File file5;
        NISAUtilities.getLog().info("NISAPEpackage.copyGUILogs() - Start, the dest dir = " + file.getAbsolutePath());
        String string = NISAUtilities.getProperty("GUI_LOG_NAME");
        String string2 = NISAUtilities.getProperty("GUI_LOGS_NAME");
        String string3 = NISAUtilities.getProperty("GUI_DIR");
        String string4 = NISAUtilities.getProperty("LOGS_SRV1_NAME");
        File file6 = null;
        NISAUtilities.getLog().info("------------GUI---------------\n");
        file6 = this.getSubDir(file, string3);
        if (file6 == null) {
            NISAUtilities.getLog().warning("copyGUILogs() - Failed - to create GUI sub dir - use " + file);
            file6 = file;
        }
        try {
            file5 = new File(NISAUtilities.getEnvVariable(NISAUtilities.getProperty("REEF_JAVA_DIR_ENV_NAME")));
        }
        catch (IOException iOException) {
            NISAUtilities.getLog().warning("copyGUILogs() - Fail - can not build the GUIlogs dir. the Exception is: \n" + NISAUtilities.getExceptionStackTrace(iOException));
            return -1098383339;
        }
        File file7 = null;
        string3 = NISAUtilities.getProperty("DS6000_LOG_DIR");
        File file8 = new File(file5.getParent() + File.separator + string2);
        if (this.isValidDir(file8)) {
            file7 = this.getSubDir(file6, string3);
            if (file7 == null) {
                NISAUtilities.getLog().warning("copyGUILogs() - Failed - to create destGUISubDirDS6000 - use " + file6);
                file7 = file6;
            }
            this.copyLogs(file7, file8, NISAUtilities.getProperty("ALL_FILES"));
            string3 = NISAUtilities.getProperty("LOGS_SRV1_NAME");
            file4 = new File(file8.getPath() + File.separator + string4);
            if (this.isValidDir(file4)) {
                file3 = this.getSubDir(file6, string3);
                if (file3 == null) {
                    NISAUtilities.getLog().warning("copyGUILogs() - Failed - to create destGUISubDirSrv1 - use " + file6);
                    file3 = file6;
                }
                this.copyLogs(file3, file4, NISAUtilities.getProperty("ALL_FILES"));
            }
        }
        string3 = NISAUtilities.getProperty("APP_SRV_LOG");
        file4 = new File(file5.getParent() + File.separator + string);
        if (this.isValidDir(file4)) {
            file3 = this.getSubDir(file6, string3);
            if (file3 == null) {
                NISAUtilities.getLog().warning("copyGUILogs() - Failed - to create destGUISubDirAppLog - use " + file6);
                file3 = file6;
            }
            this.copyLogs(file3, file4, NISAUtilities.getProperty("ALL_FILES"));
        }
        file3 = new File(file4.getParent());
        String string5 = NISAUtilities.getProperty("SMSRV_APPL_CNFG");
        String string6 = NISAUtilities.getProperty("SMSRV_APPL_CNFG_CELLS");
        String string7 = NISAUtilities.getProperty("SMSRV_APPL_CNFG_CELLS_DN");
        String string8 = NISAUtilities.getProperty("SMSRV_APPL_CNFG_CELLS_DN_NODES");
        String string9 = NISAUtilities.getProperty("SMSRV_APPL_CNFG_CELLS_DN_NODES_DN");
        String string10 = File.separator + string5 + File.separator + string6 + File.separator + string7 + File.separator + string8 + File.separator + string9;
        File file9 = new File(file3.getAbsolutePath() + string10);
        if (this.isValidDir(file9)) {
            file2 = this.getSubDir(this.getSubDir(this.getSubDir(this.getSubDir(this.getSubDir(file6, string5), string6), string7), string8), string9);
            if (file2 == null) {
                NISAUtilities.getLog().warning("copyGUILogs() - Failed to create subDir " + string10 + "\n  - use " + file6);
                file2 = file6;
            }
            this.copyLogs(file2, file9, NISAUtilities.getProperty("ALL_FILES"));
        }
        string3 = NISAUtilities.getProperty("SM_SRV_LOG");
        file2 = new File(file3.getParent() + File.separator + string2);
        if (this.isValidDir(file2)) {
            File file10 = this.getSubDir(file6, string3);
            if (file10 == null) {
                NISAUtilities.getLog().warning("copyGUILogs() - Failed - to create destGUISubDirSMlogs - use " + file6);
                file10 = file6;
            }
            this.copyLogs(file10, file2, NISAUtilities.getProperty("ALL_FILES"));
        }
        NISAUtilities.getLog().info("NISAPEpackage.copyGUILogs() - Finish OK ");
        return 0;
    }

    private int copyDsCliLogs(File file) {
        Object object;
        NISAUtilities.getLog().info("NISAPEpackage.copyDsCliLogs() - Start, the destDir = " + file.getAbsolutePath());
        String string = ".*.log";
        String string2 = "dscli" + File.separator + "log";
        String string3 = null;
        String string4 = NISAUtilities.getProperty("CLI_DIR");
        File file2 = null;
        NISAUtilities.getLog().info("----------CLI-----------------\n");
        file2 = this.getSubDir(file, string4);
        if (null == file2) {
            NISAUtilities.getLog().warning(".copyDsCliLogs() - Failed - The CLI sub dir wasnt created - use " + file);
            file2 = file;
        }
        try {
            object = NISAUtilities.winOs() ? NISAUtilities.getEnvVariable("USERPROFILE") : (NISAUtilities.linuxOs() ? "~" : null);
            string3 = (String)object + File.separator + string2;
        }
        catch (IOException iOException) {
            NISAUtilities.getLog().warning("copyDsCliLogs() - fail to get the dscli log directory. The Exception is: \n" + NISAUtilities.getExceptionStackTrace(iOException));
            return -1098383339;
        }
        if (null == string3) {
            NISAUtilities.getLog().warning(".copyDsCliLogs() - fail to get the logs dest dir = null");
            return -1098383339;
        }
        NISAUtilities.getLog().info(".copyDsCliLogs() - the logs dir = " + string3);
        object = new File(string3);
        if (!this.isValidDir((File)object)) {
            return -1098383358;
        }
        this.copyLogs(file2, (File)object, string);
        NISAUtilities.getLog().info("NISAPEpackage.copyDsCliLogs() - Finish OK ");
        return 0;
    }

    private int copySMLogs(File file) {
        NISAUtilities.getLog().info("copySMLogs() - start, the dest dir = " + file.getAbsolutePath());
        String string = NISAUtilities.getProperty("SA_LOG_NAME");
        String string2 = null;
        String string3 = NISAUtilities.getProperty("SA_DIR");
        File file2 = null;
        File file3 = null;
        File file4 = null;
        NISAUtilities.getLog().info("-----------SA-----------------\n");
        file2 = this.getSubDir(file, string3);
        if (file2 == null) {
            NISAUtilities.getLog().warning("copySMLogs() - Failed - The SA sub dir wasnt created - use " + file);
            file2 = file;
        }
        try {
            string2 = NISAUtilities.getEnvVariable(NISAUtilities.getProperty("REEF_HOME_DIR_ENV_NAME")) + File.separator + NISAUtilities.getProperty("SA_LOGS_DIR");
        }
        catch (IOException iOException) {
            NISAUtilities.getLog().warning("copySMLogs() - Fail - can not build the SAlogs dir. the Exception is: \n" + NISAUtilities.getExceptionStackTrace(iOException));
            return -1098383339;
        }
        NISAUtilities.getLog().info("copySMLogs() -  the logsDir name =  " + string2);
        File file5 = new File(string2);
        if (!this.isValidDir(file5)) {
            return -1098383358;
        }
        this.copyLogs(file2, file5, string + ".*");
        string3 = NISAUtilities.getProperty("REMOTE_DIR");
        NISAUtilities.getLog().info("---------Remote-----------------\n");
        file4 = this.getSubDir(file, string3);
        if (file4 == null) {
            NISAUtilities.getLog().warning("copySMLogs() - Failed - The Remote sub dir wasnt created - use " + file);
            file4 = file;
        }
        String string4 = NISAUtilities.getProperty("REMOTE_LOG_NAME");
        this.copyLogs(file4, file5, string4);
        string4 = NISAUtilities.getProperty("MODEM_LOG_NAME");
        this.copyLogs(file4, file5, string4);
        string4 = NISAUtilities.getProperty("TCP_PMH_LOG_NAME");
        this.copyLogs(file4, file5, string4);
        string3 = NISAUtilities.getProperty("INSTALL_DIR");
        NISAUtilities.getLog().info("---------Install-----------------\n");
        String string5 = NISAUtilities.getProperty("INSTALL_LOG_DIR");
        File file6 = file5.getParentFile();
        File file7 = new File(file6.getParent() + File.separator + string5);
        if (!this.isValidDir(file7)) {
            return -1098383358;
        }
        file3 = this.getSubDir(file, string3);
        if (file3 == null) {
            NISAUtilities.getLog().warning("copySMLogs() - Failed - The Install sub dir wasnt created - use " + file);
            file3 = file;
        }
        String string6 = NISAUtilities.getProperty("INSTALL_LOG_NAME");
        this.copyLogs(file3, file7, string6);
        NISAUtilities.getLog().info("copySMLogs() - Finish OK ");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyFile(File file, File file2) {
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file2)));
            while (null != (string = bufferedReader.readLine())) {
                printWriter.println(string);
            }
        }
        catch (Throwable throwable) {
            NISAUtilities.getLog().warning("NISAPEpackage.copyFile() - Failed - when try to copy file - " + file.getName() + " - Exception is :\n " + NISAUtilities.getExceptionStackTrace((Exception)throwable));
            int n = -1098383338;
            return n;
        }
        finally {
            try {
                if (null != printWriter) {
                    printWriter.close();
                }
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                NISAUtilities.getLog().warning("copyFile() - fail to close file. The Exception is: \n" + NISAUtilities.getExceptionStackTrace(iOException));
                return -1098383324;
            }
        }
        NISAUtilities.getLog().info("NISAPEpackage.copyFile() - Copy file " + file.getName() + " - OK");
        return 0;
    }

    private String buildZipName(File file) {
        NISAUtilities.getLog().info("buildZipName() Start - destDir = " + file.getAbsolutePath());
        String string = file.getParent() + System.getProperty("file.separator");
        File file2 = new File(file.getAbsoluteFile() + File.separator + this.peName);
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file2));
            string2 = bufferedReader.readLine();
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("NISAPEpackage.buildZipName() - Fail to get the convention name from file " + this.peName);
            return null;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            NISAUtilities.getLog().warning("buildZipName() - fail to close the file. the Exception is :\n" + NISAUtilities.getExceptionStackTrace(iOException));
        }
        if (null == string2) {
            NISAUtilities.getLog().warning("buildZipName() - Fail to get the zip name from " + this.peName);
            return null;
        }
        string = string + string2 + this.zipNameSuffix;
        if (!file2.delete()) {
            NISAUtilities.getLog().warning("buildZipName() - Fail to delete the file " + this.peName + " the proccess continue");
        }
        NISAUtilities.getLog().info("buildZipName() Finish OK the zip name = " + string);
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println("collectSMClogs.java - main - Start \n");
        NISAPEpackage nISAPEpackage = new NISAPEpackage();
        if (stringArray[1] == "collectSMClogs") {
            NISAResult nISAResult = nISAPEpackage.collectSMCLogs(stringArray[2]);
            System.out.println("RC=" + nISAResult.getCode());
        }
    }

    public NISAResult collectSMCLogs(NIServices nIServices, NIESSID nIESSID, String string) {
        NISAUtilities.getLog().info("collectSMCLogs(): Start essid=" + nIESSID + " compName=" + string);
        String string2 = NISAUtilities.getProperty("DEF_SERIAL_NUM");
        String[] stringArray = this.findSerNumCompName(nIServices, nIESSID, string);
        NISAResult nISAResult = this.collectSMCLogs(stringArray[1]);
        if (nISAResult.isSuccessful() && 0 != stringArray[0].compareTo(string2)) {
            String string3;
            String string4 = nISAResult.getCopiedFiles()[0];
            File file = new File(string4);
            if (file.renameTo(new File(string3 = string4.replaceFirst(string2, stringArray[0])))) {
                nISAResult.setCopiedFiles(new String[]{string3});
            } else {
                NISAUtilities.getLog().warning("collectSMCLogs(): failed to update smc logs file with serial num -> stay with default");
            }
        }
        return nISAResult;
    }

    public NISAResult collectSMCLogs(String string) {
        File file;
        int n;
        if (0 != NISAUtilities.getInitialError()) {
            return new NISAResult(false, NISAUtilities.getInitialError());
        }
        NISAUtilities.getLog().info("\ncollectSMCLogs() - Start customer_name12=" + string + "\n");
        if (string.length() > 15) {
            NISAUtilities.getLog().warning("collectSMCLogs() - Fail - bad customer name \nrc = " + Integer.toHexString(NISAResult.REASON_FAILURE_BAD_CUSTOMER_NAME));
            return new NISAResult(false, NISAResult.REASON_FAILURE_BAD_CUSTOMER_NAME);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            n = string.charAt(n2);
            if (!Character.isLetterOrDigit((char)n)) {
                stringBuffer.append('_');
            } else {
                stringBuffer.append((char)n);
            }
            ++n2;
        }
        if (string.length() < 15) {
            n = 0;
            while (n < 15 - string.length()) {
                stringBuffer.insert(string.length() + n, '_');
                ++n;
            }
        }
        string = stringBuffer.toString();
        String string2 = NISAUtilities.getProperty("DEF_MTM") + NISAUtilities.getProperty("DEF_SERIAL_NUM") + ".";
        String string3 = NISAUtilities.getProperty("PROBLEM_NUM_AND_PMH");
        String string4 = NISAUtilities.getProperty("CLUSTER_TYPE_EXTENTION");
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss");
        String string5 = simpleDateFormat.format(date);
        String string6 = string2 + string + string3 + string5 + string4;
        if (null != NISAUtilities.getSend2IBMDir()) {
            file = this.getSubDir(NISAUtilities.getSend2IBMDir(), "tempName");
            if (null == file) {
                NISAUtilities.getLog().warning("collectSMCLogs() - Fail - tempDir wasnt created \nrc = " + Integer.toHexString(NISAResult.REASON_FAILURE_CREATE_DIRECTORY));
                return new NISAResult(false, NISAResult.REASON_FAILURE_CREATE_DIRECTORY);
            }
        } else {
            NISAUtilities.getLog().warning("collectSMCLogs() - Fail - send2IBMDir wasnt created \nrc = " + Integer.toHexString(NISAResult.REASON_FAILURE_CREATE_DIRECTORY));
            return new NISAResult(false, NISAResult.REASON_FAILURE_CREATE_DIRECTORY);
        }
        string6 = file.getParent() + File.separator + string6;
        NISAUtilities.getLog().info("collectSMCLogs() - zipFileName=" + string6);
        int n3 = 0;
        if (0 != this.copyGUILogs(file)) {
            NISAUtilities.getLog().warning("collectSMCLogs() - Fail to collect GUI logs");
        } else {
            ++n3;
            NISAUtilities.getLog().info("collectSMCLogs() - collected GUI logs successfully");
        }
        if (0 != this.copyEssniLogs(file)) {
            NISAUtilities.getLog().warning("collectSMCLogs() - Fail to collect ESSNI logs");
        } else {
            ++n3;
            NISAUtilities.getLog().info("collectSMCLogs() - collected ESSNI logs successfully");
        }
        if (0 != this.copyDsCliLogs(file)) {
            NISAUtilities.getLog().warning("collectSMCLogs() - Fail to collect DsCli logs");
        } else {
            ++n3;
            NISAUtilities.getLog().info("collectSMCLogs() - collected DsCli logs successfully");
        }
        if (0 != this.copySMLogs(file)) {
            NISAUtilities.getLog().warning("collectSMCLogs() - Fail to collect SM logs");
        } else {
            ++n3;
            NISAUtilities.getLog().info("collectSMCLogs() - collected SM logs successfully");
        }
        if (n3 == 0) {
            NISAUtilities.getLog().warning("collectSMCLogs() - Fail - no logs \nrc = " + Integer.toHexString(-1098383338));
            return new NISAResult(false, -1098383338);
        }
        NISAResult nISAResult = new NISAResult();
        try {
            if (0 != NISAUtilities.createZip(string6, file)) {
                NISAUtilities.getLog().warning("collectSMCLogs() - Fail - zip file creation \nrc = " + Integer.toHexString(NISAResult.REASON_FAILURE_ZIP_ALL_SMC_LOGS));
                nISAResult.setCode(NISAResult.REASON_FAILURE_ZIP_ALL_SMC_LOGS);
                return nISAResult;
            }
            nISAResult.setCopiedFiles(new String[]{string6});
            NISAUtilities.getLog().info("collectSMCLogs() - " + string6 + "was created");
        }
        catch (IOException iOException) {
            NISAUtilities.getLog().warning("\n collectSMCLogs() - Fail, the exception is: \n" + NISAUtilities.getExceptionStackTrace(iOException) + "\n rc = " + Integer.toHexString(NISAResult.REASON_FAILURE_ZIP_ALL_SMC_LOGS));
            nISAResult.setCode(NISAResult.REASON_FAILURE_ZIP_ALL_SMC_LOGS);
            return nISAResult;
        }
        if (!NISAUtilities.delDir(file)) {
            NISAUtilities.getLog().warning("Failed to delete tempDir");
        }
        NISAUtilities.getLog().info("Collected successfully " + n3 + " out of 4 logs types" + "\n collectSMCLogs() - Finished \n");
        nISAResult.setSuccessful(true);
        return nISAResult;
    }

    private String[] findSerNumCompName(NIServices nIServices, NIESSID nIESSID, String string) {
        Object object;
        List list;
        block15: {
            NISAUtilities.getLog().info("findSerNum_compName(): Start essid=" + nIESSID + " compName=" + string);
            list = new ArrayList();
            try {
                list = nIServices.getInitialConfigurationService().getESSs().getResourceList();
            }
            catch (Exception exception) {
                NISAUtilities.getLog().warning("findSerNumCompName(): Exception while try to get list of essids \n" + NISAUtilities.getExceptionStackTrace(exception));
            }
            if (null == string || 0 == string.compareTo("")) {
                NIESSDomainResult nIESSDomainResult;
                string = NISAUtilities.getProperty("DEF_COMPANY_NAME");
                NISAUtilities.getLog().info("findSerNum_compName(): no compName -> search by using essid");
                if (null != nIESSID) {
                    try {
                        object = new NIESSDomainElementImpl(nIESSID);
                        nIESSDomainResult = nIServices.getInitialConfigurationService().testConnection((NIESSDomainElement)object);
                        if (nIESSDomainResult.isSuccessful()) {
                            string = ((NIStoragePlex)nIServices.getDomainService().getStoragePlex(nIESSID).getResourceList().get(0)).getContactInformation().getCompanyName();
                            break block15;
                        }
                        NISAUtilities.getLog().warning("findSerNumCompName(): no connection to essid=" + nIESSID + " use default compName");
                    }
                    catch (Exception exception) {
                        NISAUtilities.getLog().warning("findSerNum_compName(): Exception in get compName -> use default \n" + NISAUtilities.getExceptionStackTrace(exception));
                    }
                } else {
                    NISAUtilities.getLog().info("findSerNum_compName(): get essids from server");
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        try {
                            nIESSID = ((NIESSDomainElement)iterator.next()).getESS();
                            NISAUtilities.getLog().info("findSerNumCompName(): find essid=" + nIESSID);
                            object = new NIESSDomainElementImpl(nIESSID);
                            nIESSDomainResult = nIServices.getInitialConfigurationService().testConnection((NIESSDomainElement)object);
                            if (!nIESSDomainResult.isSuccessful()) {
                                NISAUtilities.getLog().warning("findSerNumCompName(): no connection to essid=" + nIESSID);
                                continue;
                            }
                            string = ((NIStoragePlex)nIServices.getDomainService().getStoragePlex(nIESSID).getResourceList().get(0)).getContactInformation().getCompanyName();
                            NISAUtilities.getLog().info("findSerNumCompName(): find compName=" + string);
                            break;
                        }
                        catch (Exception exception) {
                            NISAUtilities.getLog().warning("findSerNum_compName(): Exception in get compName -> continue to next\n" + NISAUtilities.getExceptionStackTrace(exception));
                        }
                    }
                }
            }
        }
        object = NISAUtilities.getProperty("DEF_SERIAL_NUM");
        try {
            if (null == nIESSID) {
                nIESSID = ((NIESSDomainElement)list.get(0)).getESS();
            }
            object = nIESSID.getManufacturePlant() + nIESSID.getSequence();
        }
        catch (Exception exception) {
            NISAUtilities.getLog().warning("findSerNumCompName(): Exception - find serNul -> use default \n" + NISAUtilities.getExceptionStackTrace(exception));
        }
        NISAUtilities.getLog().info("findSerNumCompName(): finish serNum=" + (String)object + " compName=" + string);
        return new String[]{object, string};
    }
}

