/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.sa;

import com.ibm.storage.ess.ni.sa.NISAUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;

public class NISAStreamHandler
extends Thread {
    InputStream is;
    OutputStream os = null;
    String type;

    public NISAStreamHandler(InputStream inputStream, String string) {
        this.is = inputStream;
        this.type = string;
    }

    public NISAStreamHandler(InputStream inputStream, String string, OutputStream outputStream) {
        this.is = inputStream;
        this.type = string;
        this.os = outputStream;
    }

    public void run() {
        try {
            PrintWriter printWriter = null;
            if (this.os != null) {
                printWriter = new PrintWriter(this.os);
            }
            InputStreamReader inputStreamReader = new InputStreamReader(this.is);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (printWriter != null) {
                    printWriter.println(string);
                }
                if (this.type.matches("ERROR.*")) {
                    NISAUtilities.getLog().warning("NISAStreamHandler.run() - \n" + this.type + ">" + string);
                }
                if (this.type.matches("OUTPUT.*") && this.type.matches(".*pscp.exe") && string.matches(".*SEA.tar.*")) continue;
                NISAUtilities.getLog().info("NISAStreamHandler.run() -  \n" + this.type + ">" + string);
            }
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
        catch (IOException iOException) {
            NISAUtilities.getLog().warning(NISAUtilities.getExceptionStackTrace(iOException));
        }
    }
}

