/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.sa.remotevpn;

import com.ibm.storage.ess.ni.sa.remotevpn.IBMRemoteClientFactory;
import com.ibm.storage.ess.ni.sa.remotevpn.IBMRemoteException;
import com.ibm.storage.ess.ni.sa.remotevpn.IBMRemoteUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;

public class IBMRemoteClientDialingCredentials {
    public static final String MODEM_PROPERTY_FILE_NAME = IBMRemoteUtilities.getEtcDirectoryName() + File.separator + "modem_credential.properties";
    static final String DASD_GROUP_LIST_FILE_NAME = IBMRemoteUtilities.getEtcDirectoryName() + File.separator + "DASDGRP.LIST";
    static final String COUNTRY_LIST_FILE_NAME = IBMRemoteUtilities.getEtcDirectoryName() + File.separator + "CNTRY.LIST";
    static final String PHONE_LIST_FILE_NAME = IBMRemoteUtilities.getEtcDirectoryName() + File.separator + "PHONE.LIST";
    static IBMRemoteClientDialingCredentials SYSTEM_CREDENTIALS;
    private static final String MANUAL_OVERRIDE_KEY = "manualOverride";
    private static final String COUNTRY_CODE_KEY = "countryCode";
    private static final String COUNTRY_NAME_KEY = "countryName";
    private static final String IP_ADDRESS1_KEY = "ipAddress1";
    private static final String PORT1_KEY = "port1";
    private static final String IP_ADDRESS2_KEY = "ipAddress2";
    private static final String PORT2_KEY = "port2";
    private static final String ACCOUNT_NAME_KEY = "accountName";
    private static final String USER_ID_KEY = "userID";
    private static final String PASSWORD_KEY = "password";
    private static final String DEFAULT_COUNTRY_CODE = "US";
    private static final String DEFAULT_COUNTRY_NAME = "United States";
    private static final String DEFAULT_IP1 = "167.210.250.58";
    private static final String DEFAULT_PORT1 = "19285";
    private static final String DEFAULT_IP2 = "9.56.214.249";
    private static final String DEFAULT_PORT2 = "19285";
    private static final String DEFAULT_ACCOUNT = "urus";
    private static final String DEFAULT_USER = "dasdus";
    private static final String DEFAULT_PASSWORD = "DIAL4IBM";
    private static final String OVERRIDE_VALUE;
    private boolean manualOverride;
    private String countryCode;
    private String countryName;
    private String ipAddress1;
    private String port1;
    private String ipAddress2;
    private String port2;
    private String accountName;
    private String userID;
    private String password;

    public static IBMRemoteClientDialingCredentials getSystemDialingCredentials() {
        return SYSTEM_CREDENTIALS;
    }

    public static IBMRemoteClientDialingCredentials updateSystemDialingCredentials() {
        IBMRemoteUtilities.getLog().info(" updateSystemDialingCredentials - ENTRY");
        IBMRemoteClientDialingCredentials iBMRemoteClientDialingCredentials = new IBMRemoteClientDialingCredentials();
        boolean bl = false;
        Properties properties = new Properties();
        File file = new File(MODEM_PROPERTY_FILE_NAME);
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(MODEM_PROPERTY_FILE_NAME));
                String string = properties.getProperty(MANUAL_OVERRIDE_KEY);
                if (string.toLowerCase().equals(OVERRIDE_VALUE)) {
                    IBMRemoteUtilities.getLog().info("updateSystemDialingCredentials - Manual Override set, using exising configuration");
                    iBMRemoteClientDialingCredentials.manualOverride = true;
                    bl = true;
                }
            }
            catch (IOException iOException) {
                IBMRemoteUtilities.getLog().log(Level.WARNING, "updateSystemDialingCredentials - Error to load the existing file, Exception", iOException);
            }
        }
        if (!bl) {
            properties = IBMRemoteClientDialingCredentials.generateProperties();
        }
        iBMRemoteClientDialingCredentials.countryCode = properties.getProperty(COUNTRY_CODE_KEY, DEFAULT_COUNTRY_CODE);
        iBMRemoteClientDialingCredentials.countryName = properties.getProperty(COUNTRY_NAME_KEY, DEFAULT_COUNTRY_NAME);
        iBMRemoteClientDialingCredentials.ipAddress1 = properties.getProperty(IP_ADDRESS1_KEY, DEFAULT_IP1);
        iBMRemoteClientDialingCredentials.port1 = properties.getProperty(PORT1_KEY, "19285");
        iBMRemoteClientDialingCredentials.ipAddress2 = properties.getProperty(IP_ADDRESS2_KEY, DEFAULT_IP2);
        iBMRemoteClientDialingCredentials.port2 = properties.getProperty(PORT2_KEY, "19285");
        iBMRemoteClientDialingCredentials.accountName = properties.getProperty(ACCOUNT_NAME_KEY, DEFAULT_ACCOUNT);
        iBMRemoteClientDialingCredentials.userID = properties.getProperty(USER_ID_KEY, DEFAULT_USER);
        iBMRemoteClientDialingCredentials.password = properties.getProperty(PASSWORD_KEY, DEFAULT_PASSWORD);
        IBMRemoteUtilities.getLog().info("updateSystemDialingCredentials - EXIT, returning " + iBMRemoteClientDialingCredentials);
        SYSTEM_CREDENTIALS = iBMRemoteClientDialingCredentials;
        return iBMRemoteClientDialingCredentials;
    }

    private static Properties generateProperties() {
        Object object;
        Object object2;
        IBMRemoteUtilities.getLog().info("generateProperties - ENTRY");
        Properties properties = new Properties();
        File file = new File(DASD_GROUP_LIST_FILE_NAME);
        File file2 = new File(COUNTRY_LIST_FILE_NAME);
        File file3 = new File(PHONE_LIST_FILE_NAME);
        properties.setProperty(MANUAL_OVERRIDE_KEY, Boolean.toString(false));
        String string = null;
        try {
            object2 = IBMRemoteClientFactory.getInstance().getModemProperties();
            object = new String[]{((Properties)object2).getProperty("PROPERTY_PHONE_NUMBER_1"), ((Properties)object2).getProperty("PROPERTY_PHONE_NUMBER_2"), ((Properties)object2).getProperty("PROPERTY_PHONE_NUMBER_3"), ((Properties)object2).getProperty("PROPERTY_PHONE_NUMBER_4")};
            int n = 0;
            while (n < ((String[])object).length && string == null) {
                String string2 = object[n];
                if (string2.length() > 0) {
                    String string3;
                    string2 = string2.replaceAll("-", "");
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file3));
                    while ((string3 = bufferedReader.readLine()) != null) {
                        if ((string3 = string3.replaceAll("-", "")).indexOf(string2) < 0) continue;
                        IBMRemoteUtilities.getLog().info("generateProperties - found country for given number - " + string3);
                        String[] stringArray = string3.split(",");
                        if (stringArray.length < 1) continue;
                        string = stringArray[0].trim();
                        break;
                    }
                }
                ++n;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            IBMRemoteUtilities.getLog().log(Level.SEVERE, "generateProperties - Phone File Not Found, attempting to read - " + file3, fileNotFoundException);
        }
        catch (IOException iOException) {
            IBMRemoteUtilities.getLog().log(Level.SEVERE, "generateProperties - Phone File read error - " + file3, iOException);
        }
        catch (IBMRemoteException iBMRemoteException) {
            IBMRemoteUtilities.getLog().log(Level.SEVERE, "generateProperties - Error retrieving phone number ", iBMRemoteException);
        }
        if (string == null) {
            IBMRemoteUtilities.getLog().info("generateProperties - Could not match phone numbers to locale, using system settings ");
            string = System.getProperty("user.country", Locale.getDefault().getCountry());
        }
        properties.setProperty(COUNTRY_CODE_KEY, string);
        IBMRemoteUtilities.getLog().info("generateProperties - User Country is set to countryCode " + string);
        try {
            object2 = new BufferedReader(new FileReader(file));
            while ((object = ((BufferedReader)object2).readLine()) != null) {
                if (!((String)object).toUpperCase().startsWith(string)) continue;
                IBMRemoteUtilities.getLog().info("generateProperties - found account for given country - " + (String)object);
                String[] stringArray = ((String)object).split(",");
                if (stringArray.length < 5) continue;
                properties.setProperty(ACCOUNT_NAME_KEY, stringArray[1].trim());
                properties.setProperty(USER_ID_KEY, stringArray[2].trim());
                properties.setProperty(COUNTRY_NAME_KEY, stringArray[4].trim());
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            IBMRemoteUtilities.getLog().log(Level.SEVERE, "generateProperties - Group File Not Found, attempting to read - " + file, fileNotFoundException);
        }
        catch (IOException iOException) {
            IBMRemoteUtilities.getLog().log(Level.SEVERE, "generateProperties - Group File read error - " + file, iOException);
        }
        try {
            object2 = new BufferedReader(new FileReader(file2));
            while ((object = ((BufferedReader)object2).readLine()) != null) {
                if (!((String)object).startsWith(string)) continue;
                IBMRemoteUtilities.getLog().info("generateProperties - found addresses for given country - " + (String)object);
                String[] stringArray = ((String)object).split(",");
                if (stringArray.length < 10) continue;
                properties.setProperty(IP_ADDRESS1_KEY, stringArray[4].trim());
                properties.setProperty(PORT1_KEY, stringArray[5].trim());
                properties.setProperty(IP_ADDRESS2_KEY, stringArray[6].trim());
                properties.setProperty(PORT2_KEY, stringArray[7].trim());
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            IBMRemoteUtilities.getLog().log(Level.SEVERE, "generateProperties - Country File Not Found, attempting to read - " + file2, fileNotFoundException);
        }
        catch (IOException iOException) {
            IBMRemoteUtilities.getLog().log(Level.SEVERE, "generateProperties - Country File read error - " + file2, iOException);
        }
        try {
            object2 = new File(MODEM_PROPERTY_FILE_NAME);
            object = new FileOutputStream((File)object2);
            properties.store((OutputStream)object, "***** To Provide Custom IBM Dialing Configuration, set manualOverride=" + OVERRIDE_VALUE + " *****");
            ((FileOutputStream)object).close();
        }
        catch (IOException iOException) {
            IBMRemoteUtilities.getLog().log(Level.SEVERE, "generateProperties - Error in saving configuration file - " + MODEM_PROPERTY_FILE_NAME, iOException);
        }
        return properties;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String string) {
        this.accountName = string;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String string) {
        this.countryCode = string;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String string) {
        this.countryName = string;
    }

    public String getIpAddress1() {
        return this.ipAddress1;
    }

    public void setIpAddress1(String string) {
        this.ipAddress1 = string;
    }

    public String getIpAddress2() {
        return this.ipAddress2;
    }

    public void setIpAddress2(String string) {
        this.ipAddress2 = string;
    }

    public boolean isManualOverride() {
        return this.manualOverride;
    }

    public void setManualOverride(boolean bl) {
        this.manualOverride = bl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPort1() {
        return this.port1;
    }

    public void setPort1(String string) {
        this.port1 = string;
    }

    public String getPort2() {
        return this.port2;
    }

    public void setPort2(String string) {
        this.port2 = string;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String string) {
        this.userID = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IBMRemoteDialingCredentials {");
        stringBuffer.append(MANUAL_OVERRIDE_KEY);
        stringBuffer.append("=");
        stringBuffer.append(this.manualOverride);
        stringBuffer.append(", ");
        stringBuffer.append(COUNTRY_CODE_KEY);
        stringBuffer.append("=");
        stringBuffer.append(this.countryCode);
        stringBuffer.append(", ");
        stringBuffer.append(COUNTRY_NAME_KEY);
        stringBuffer.append("=");
        stringBuffer.append(this.countryName);
        stringBuffer.append(", ");
        stringBuffer.append(ACCOUNT_NAME_KEY);
        stringBuffer.append("=");
        stringBuffer.append(this.accountName);
        stringBuffer.append(", ");
        stringBuffer.append(USER_ID_KEY);
        stringBuffer.append("=");
        stringBuffer.append(this.userID);
        stringBuffer.append(", ");
        stringBuffer.append(PASSWORD_KEY);
        stringBuffer.append("=");
        stringBuffer.append(this.password);
        stringBuffer.append(", ");
        stringBuffer.append(IP_ADDRESS1_KEY);
        stringBuffer.append("=");
        stringBuffer.append(this.ipAddress1);
        stringBuffer.append(", ");
        stringBuffer.append(PORT1_KEY);
        stringBuffer.append("=");
        stringBuffer.append(this.port1);
        stringBuffer.append(", ");
        stringBuffer.append(IP_ADDRESS2_KEY);
        stringBuffer.append("=");
        stringBuffer.append(this.ipAddress2);
        stringBuffer.append(", ");
        stringBuffer.append(PORT2_KEY);
        stringBuffer.append("=");
        stringBuffer.append(this.port2);
        stringBuffer.append(", ");
        return stringBuffer.toString();
    }

    static {
        OVERRIDE_VALUE = Boolean.toString(true);
    }
}

