/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.security;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouter;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterChannel;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterException;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterInputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterOutputStream;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterReturnStatus;
import com.ibm.storage.ess.ni.messageRouter.common.NIMessageRouterAddress;
import com.ibm.storage.ess.ni.security.NISecuritySynchronizer;
import java.io.IOException;

public class NIMRSecurityCommunicator
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$security$NIMRSecurityCommunicator == null ? (class$com$ibm$storage$ess$ni$security$NIMRSecurityCommunicator = NIMRSecurityCommunicator.class$("com.ibm.storage.ess.ni.security.NIMRSecurityCommunicator")) : class$com$ibm$storage$ess$ni$security$NIMRSecurityCommunicator);
    private NIMessageRouterAddress alternateAddress;
    private NIMessageRouterInputStream mris = null;
    private NIMessageRouterOutputStream mros = null;
    private NIMessageRouter messageRouterInterface = null;
    private NIMessageRouterChannel mrChannel = null;
    private NISecuritySynchronizer syncObject;
    private boolean alive;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$security$NIMRSecurityCommunicator;

    public NIMRSecurityCommunicator(NIMessageRouterAddress nIMessageRouterAddress, NISecuritySynchronizer nISecuritySynchronizer) {
        this.alternateAddress = nIMessageRouterAddress;
        this.syncObject = nISecuritySynchronizer;
        this.alive = false;
    }

    public void run() {
        this.alive = true;
        try {
            if (this.connect()) {
                while (this.alive) {
                    this.syncObject.addRequestToWorkQueue(this.receive());
                    this.syncObject.notifyForDataFromPeer();
                }
            } else {
                logger.error("Unable to connect Security Communicator.  Exiting");
            }
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
    }

    public Object receive() throws NIMessageRouterException, InterruptedException, IOException {
        return this.mris.readObject();
    }

    public boolean send(Object object) {
        NIMessageRouterReturnStatus nIMessageRouterReturnStatus = null;
        try {
            nIMessageRouterReturnStatus = this.mros.send(this.alternateAddress, object);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
        return nIMessageRouterReturnStatus != null && nIMessageRouterReturnStatus.getStatus() == 9;
    }

    public void setAlternateAddress(NIMessageRouterAddress nIMessageRouterAddress) {
        this.alternateAddress = nIMessageRouterAddress;
    }

    private boolean connect() throws Exception {
        this.messageRouterInterface = NIMessageRouterFactory.getInstanceOf();
        this.mrChannel = this.messageRouterInterface.createNIMessageRouterChannel(7);
        this.mris = this.mrChannel.getNIMessageRouterInputStream();
        this.mros = this.mrChannel.getNIMessageRouterOutputStream();
        return true;
    }

    public void shutDown() {
        logger.debug_general("Shutting down NIMRSecurityCommunicator.");
        this.alive = false;
        this.interrupt();
        if (this.mrChannel != null && this.messageRouterInterface != null) {
            this.messageRouterInterface.destroyNIMessageRouterChannel(this.mrChannel);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

