/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.security;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.application.results.security.NISecurityResult;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogEntryImpl;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogFileHandler;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogTable;
import com.ibm.storage.ess.ni.auditLog.NIAuditLogUtil;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.security.NIConnectionManager;
import com.ibm.storage.ess.ni.security.NISecuritySynchronizer;
import com.ibm.storage.ess.ni.security.common.NIRecoveryToolPacket;
import com.ibm.storage.ess.ni.server.command.NIShutdownThread;
import java.util.Vector;

public class NIRecoveryToolListener
extends Thread {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$security$NIRecoveryToolListener == null ? (class$com$ibm$storage$ess$ni$security$NIRecoveryToolListener = NIRecoveryToolListener.class$("com.ibm.storage.ess.ni.security.NIRecoveryToolListener")) : class$com$ibm$storage$ess$ni$security$NIRecoveryToolListener);
    private NIConnectionManager connManager = null;
    private NISecuritySynchronizer syncObject;
    private Vector workQueue;
    private boolean alive;
    private NIAuditLogFileHandler auditLogFileHandler = NIAuditLogFileHandler.getInstance();
    private NIAuditLogTable auditLogTable = NIAuditLogTable.getInstance();
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$security$NIRecoveryToolListener;

    public NIRecoveryToolListener(NISecuritySynchronizer nISecuritySynchronizer) {
        this.connManager = new NIConnectionManager();
        this.syncObject = nISecuritySynchronizer;
        this.workQueue = new Vector();
        this.alive = false;
    }

    public void run() {
        this.alive = true;
        if (this.setupServerSocket()) {
            logger.debug_general("Succesfully set up server socket to listen for RT");
            while (this.alive) {
                logger.debug_general("Waiting for client to connect");
                if (this.connManager.listenForConnection()) {
                    logger.debug_general("A client connected");
                    int n = this.connManager.readNumberOfPacketsToExpect();
                    if (n != -1) {
                        Vector<NIRecoveryToolPacket> vector = new Vector<NIRecoveryToolPacket>(n);
                        Vector vector2 = new Vector(n);
                        boolean bl = false;
                        int n2 = 0;
                        while (n2 < n) {
                            NIRecoveryToolPacket nIRecoveryToolPacket = this.connManager.readPacket();
                            if (nIRecoveryToolPacket != null) {
                                vector.add(nIRecoveryToolPacket);
                            } else {
                                bl = true;
                            }
                            ++n2;
                        }
                        if (!bl) {
                            boolean bl2 = false;
                            int n3 = 0;
                            while (n3 < n) {
                                if (((NIRecoveryToolPacket)vector.elementAt(n3)).getRequestData() == 4) {
                                    NIRecoveryToolPacket[] nIRecoveryToolPacketArray = new NIRecoveryToolPacket[]{new NIRecoveryToolPacket(1, 0, 4)};
                                    this.sendResponse(nIRecoveryToolPacketArray);
                                    this.handleTerminate();
                                } else {
                                    bl2 = true;
                                    vector2.add(vector.elementAt(n3));
                                }
                                ++n3;
                            }
                            if (bl2) {
                                NIRecoveryToolPacket nIRecoveryToolPacket;
                                int n4;
                                Object object;
                                int n5 = 0;
                                while (n5 < vector2.size()) {
                                    object = (NIRecoveryToolPacket)vector2.get(n5);
                                    NISecurityResult nISecurityResult = this.syncObject.performRequest(object);
                                    this.workQueue.add(new NIRecoveryToolPacket(1, nISecurityResult.getCode(), ((NIRecoveryToolPacket)object).getRequestData()));
                                    ++n5;
                                }
                                object = new NIRecoveryToolPacket[vector2.size()];
                                int n6 = this.workQueue.size();
                                int n7 = 0;
                                while (n7 < n6) {
                                    object[n7] = (NIRecoveryToolPacket)this.workQueue.remove(0);
                                    n4 = vector.size() - 1;
                                    while (n4 >= 0) {
                                        nIRecoveryToolPacket = (NIRecoveryToolPacket)vector.elementAt(n4);
                                        if (nIRecoveryToolPacket.getResponseType() == ((NIRecoveryToolPacket)object[n7]).getResponseType()) {
                                            vector.remove(n4);
                                        }
                                        --n4;
                                    }
                                    ++n7;
                                }
                                n4 = n6;
                                while (n4 < vector2.size()) {
                                    nIRecoveryToolPacket = (NIRecoveryToolPacket)vector.remove(0);
                                    object[n4] = new NIRecoveryToolPacket(1, -1099689717, nIRecoveryToolPacket.getResponseType());
                                    ++n4;
                                }
                                this.sendResponse((NIRecoveryToolPacket[])object);
                            }
                        } else {
                            logger.error("Failed to read the number of packets specified, so closing connection");
                        }
                    } else {
                        logger.error("Failed to read the number of packets, so closing the connection.");
                    }
                    this.connManager.closeConnection();
                    continue;
                }
                logger.error("Failed to connect to a client.  Going to retry.");
            }
        } else {
            logger.error("Unable to create the server socket to listen to the RT");
        }
    }

    private void sendResponse(NIRecoveryToolPacket[] nIRecoveryToolPacketArray) {
        int n = 0;
        while (n < nIRecoveryToolPacketArray.length) {
            this.connManager.writePacket(nIRecoveryToolPacketArray[n]);
            this.writeAuditLogEntry(nIRecoveryToolPacketArray[n]);
            ++n;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            logger.throwable((Throwable)interruptedException);
        }
    }

    private void handleTerminate() {
        NIShutdownThread nIShutdownThread = new NIShutdownThread();
        nIShutdownThread.start();
    }

    private boolean setupServerSocket() {
        return this.connManager.createServerSocket();
    }

    public void shutdown() {
        logger.debug_general("Shutting down NIRecoveryToolListener.");
        this.alive = false;
        this.connManager.closeConnection();
        this.connManager.closeServerConnection();
        this.interrupt();
    }

    private void writeAuditLogEntry(NIRecoveryToolPacket nIRecoveryToolPacket) {
        try {
            NIAuditLogEntryImpl nIAuditLogEntryImpl = new NIAuditLogEntryImpl();
            if (nIRecoveryToolPacket.getResponseType() == 2) {
                nIAuditLogEntryImpl.setStaticFields(this.auditLogTable.getEntry("1120"));
            } else if (nIRecoveryToolPacket.getResponseType() == 3) {
                nIAuditLogEntryImpl.setStaticFields(this.auditLogTable.getEntry("1121"));
            }
            nIAuditLogEntryImpl.setLogLocation(NIAuditLogUtil.getLogLocation());
            nIAuditLogEntryImpl.setExitCode(Integer.toHexString(nIRecoveryToolPacket.getResponseData()));
            this.auditLogFileHandler.output(nIAuditLogEntryImpl);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

