/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.security.common;

import com.ibm.storage.ess.ni.application.results.security.NISecurityResult;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class NISynchronizationData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int INVALID_TRANSACTION = -1;
    public static final int SINGLE_UPDATE_BOTH = 1;
    public static final int SINGLE_UPDATE_LOCAL = 2;
    public static final int RESYNC_REPOSITORY_STEP_2 = 4;
    public static final int SINGLE_UPDATE_RESPONSE = 5;
    public static final int RESYNC_RESPONSE = 6;
    public static final int RESYNC_REPOSITORY_STEP_1 = 7;
    public static final int OVERWRITE_ACC_ON_PEER = 8;
    public static final int ALIVE_MESSAGE = 9;
    private int typeOfTransaction;
    public static final int INVALID_ACTION = -1;
    public static final int INSERT = 1;
    public static final int MODIFY = 2;
    public static final int DELETE = 3;
    private int singleUpdateAction;
    public static final int INVALID_OBJECT = -1;
    public static final int USER_ACCOUNT = 1;
    public static final int USER_GROUP = 2;
    public static final int SECURITY_SETTINGS = 3;
    private int objectToUpdate;
    private NISecurityResult result;
    private Vector objects;
    private boolean resyncOperation;
    public static int lastTransactionID = 0;
    private int transactionID;
    private int version = 1;
    private static final int VERSION_0 = 0;
    private static final int VERSION_1 = 1;

    public NISynchronizationData(int n, int n2, Object object, String string) {
        this(1, n, n2, null, new Vector(), false, NISynchronizationData.getNextTransactionID());
        this.objects.add(object);
        this.objects.add(string);
    }

    public NISynchronizationData(int n, int n2, Object object, String string, int n3) {
        this(2, n, n2, null, new Vector(), false, n3);
        this.objects.add(object);
        this.objects.add(string);
    }

    public NISynchronizationData(NISecurityResult nISecurityResult, Vector vector, int n) {
        this(6, -1, -1, nISecurityResult, vector, false, n);
    }

    public NISynchronizationData(NISecurityResult nISecurityResult, int n) {
        this(5, -1, -1, nISecurityResult, null, false, n);
    }

    public NISynchronizationData(Vector vector, boolean bl) {
        this(4, -1, -1, null, vector, bl, NISynchronizationData.getNextTransactionID());
    }

    public NISynchronizationData(int n) {
        this(n, -1, -1, null, null, false, 0);
    }

    private NISynchronizationData(int n, int n2, int n3, NISecurityResult nISecurityResult, Vector vector, boolean bl, int n4) {
        this.typeOfTransaction = n;
        this.singleUpdateAction = n2;
        this.objectToUpdate = n3;
        this.result = nISecurityResult;
        this.objects = vector;
        this.resyncOperation = bl;
        this.transactionID = n4;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.version == 0) {
            this.resyncOperation = true;
        }
    }

    public int getTypeOfTransaction() {
        return this.typeOfTransaction;
    }

    public int getSingleUpdateAction() {
        return this.singleUpdateAction;
    }

    public int getObjectTypeToUpdate() {
        return this.objectToUpdate;
    }

    public Vector getObjects() {
        return this.objects;
    }

    public Object getSingleUpdateObject() {
        Object var1_1 = null;
        if (this.objects != null && this.objects.size() > 0) {
            var1_1 = this.objects.firstElement();
        }
        return var1_1;
    }

    public String getAccountName() {
        String string = null;
        if (this.objects != null && this.objects.size() > 1) {
            string = (String)this.objects.elementAt(1);
        }
        return string;
    }

    public NISecurityResult getResult() {
        return this.result;
    }

    public static int getNextTransactionID() {
        return lastTransactionID++;
    }

    public int getTransactionID() {
        return this.transactionID;
    }

    public boolean isResyncOperation() {
        return this.resyncOperation;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NISynchronizationData: [typeOfTransaction=" + this.typeOfTransaction + ", ");
        stringBuffer.append("singleUpdateAction=" + this.singleUpdateAction + ", ");
        stringBuffer.append("objectToUpdate=" + this.objectToUpdate + ", ");
        stringBuffer.append("result=" + stringBuffer + ", ");
        stringBuffer.append("objects=" + this.objects + ", ");
        stringBuffer.append("resyncOperation=" + this.resyncOperation + ", ");
        stringBuffer.append("transactionID=0x" + Integer.toHexString(this.transactionID) + "]");
        return stringBuffer.toString();
    }
}

