/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.util;

public class NIAsciiEbcdicConverter {
    private static final byte MASK_EBCDIC_TYPE = -16;
    private static final byte TYPE_ASCII_NUMBER = 48;
    private static final byte TYPE_EBCDIC_NUMBER = -16;
    private static final byte TYPE_EBCDIC_LETTER_0 = -128;
    private static final byte TYPE_EBCDIC_LETTER_1 = -112;
    private static final byte TYPE_EBCDIC_LETTER_2 = -96;
    private static final byte TYPE_EBCDIC_LETTER_3 = -64;
    private static final byte TYPE_EBCDIC_LETTER_4 = -48;
    private static final byte TYPE_EBCDIC_LETTER_5 = -32;
    private static final byte MASK_NUM_CONVERTER = -64;
    private static final byte[][] MODIFIER = new byte[][]{{32, -32}, {39, -39}, {47, -47}, {-128, -128}, {-121, 121}, {-113, 113}};

    public static byte convertToASCII(byte by) {
        byte by2 = (byte)(by & 0xFFFFFFF0);
        byte by3 = -1;
        switch (by2) {
            case -16: {
                by3 = NIAsciiEbcdicConverter.convertNum(by);
                break;
            }
            case -128: {
                by3 = NIAsciiEbcdicConverter.convertLetter(0, by);
                break;
            }
            case -112: {
                by3 = NIAsciiEbcdicConverter.convertLetter(1, by);
                break;
            }
            case -96: {
                by3 = NIAsciiEbcdicConverter.convertLetter(2, by);
                break;
            }
            case -64: {
                by3 = NIAsciiEbcdicConverter.convertLetter(3, by);
                break;
            }
            case -48: {
                by3 = NIAsciiEbcdicConverter.convertLetter(4, by);
                break;
            }
            case -32: {
                by3 = NIAsciiEbcdicConverter.convertLetter(5, by);
            }
        }
        return by3;
    }

    public static byte convertToEBCDIC(byte by) {
        byte by2 = -1;
        switch (by) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                by2 = NIAsciiEbcdicConverter.convertNum(by);
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                by2 = NIAsciiEbcdicConverter.convertLetter(3, by);
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                by2 = NIAsciiEbcdicConverter.convertLetter(4, by);
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                by2 = NIAsciiEbcdicConverter.convertLetter(5, by);
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                by2 = NIAsciiEbcdicConverter.convertLetter(0, by);
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                by2 = NIAsciiEbcdicConverter.convertLetter(1, by);
                break;
            }
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                by2 = NIAsciiEbcdicConverter.convertLetter(2, by);
            }
        }
        return by2;
    }

    private static byte convertNum(byte by) {
        return (byte)(by ^ 0xFFFFFFC0);
    }

    private static byte convertLetter(int n, byte by) {
        return (byte)(MODIFIER[n][(by & 0x80) >> 7 & 1] + by);
    }
}

