/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.util;

import com.ibm.storage.ess.ni.util.NIAsciiEbcdicConverter;
import java.io.Serializable;

public class NIByteArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] data;
    private int endianness;
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;
    private static final int SEQUENCE_NUM_LENGTH = 10;
    public char[] ebcidToAscii = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u009c', '\t', '\u0086', '\u007f', '\u0097', '\u008d', '\u008e', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u009d', '\u0085', '\b', '\u0087', '\u0018', '\u0019', '\u0092', '\u008f', '\u001c', '\u001d', '\u001e', '\u001f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\n', '\u0017', '\u001b', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u0005', '\u0006', '\u0007', '\u0090', '\u0091', '\u0016', '\u0093', '\u0094', '\u0095', '\u0096', '\u0004', '\u0098', '\u0099', '\u009a', '\u009b', '\u0014', '\u0015', '\u009e', '\u001a', ' ', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '[', '.', '<', '(', '+', '!', '&', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', ']', '$', '*', ')', ';', '^', '-', '/', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '|', ',', '%', '_', '>', '?', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '`', ':', '#', '@', '\'', '=', '\"', '\u00c3', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\\', '\u009f', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public NIByteArray(byte[] byArray, int n) throws Exception {
        this.data = byArray;
        if (n != 0 && n != 1) {
            throw new Exception("ByteArray given invalid endianness parameter");
        }
        this.endianness = n;
    }

    public NIByteArray(byte[] byArray) {
        this.data = byArray;
        this.endianness = 1;
    }

    public NIByteArray() {
        this.data = null;
        this.endianness = 1;
    }

    public void setByteArray(byte[] byArray) {
        this.data = byArray;
    }

    public byte[] getByteArray() {
        return this.data;
    }

    public void storeNumber(int n, int n2, long l) {
        int n3 = 0;
        while (n3 < n2) {
            this.data[n + n2 - n3 - 1] = (byte)(l >> 8 * n3 & 0xFFL);
            ++n3;
        }
    }

    public void orEquals(int n, byte by) {
        int n2 = n;
        this.data[n2] = (byte)(this.data[n2] | by);
    }

    public void andEquals(int n, byte by) {
        int n2 = n;
        this.data[n2] = (byte)(this.data[n2] & by);
    }

    public void setBit(int n, int n2) {
        if (n2 < 8 && n2 >= 0) {
            int n3 = n;
            this.data[n3] = (byte)(this.data[n3] | (byte)(128 >>> n2));
        }
    }

    public void clearBit(int n, int n2) {
        if (n2 < 8 && n2 >= 0) {
            int n3 = n;
            this.data[n3] = (byte)(this.data[n3] & (byte)(65407 >> n2));
        }
    }

    public void setEndianness(int n) throws Exception {
        if (n != 0 && n != 1) {
            throw new Exception("ByteArray given invalid endianness parameter");
        }
        this.endianness = n;
    }

    public void setBigEndian(boolean bl) {
        this.endianness = bl ? 1 : 0;
    }

    public boolean isBigEndian() {
        return this.endianness == 1;
    }

    public boolean isLittleEndian() {
        return this.endianness == 0;
    }

    public byte extractByte(int n) {
        if (this.data != null) {
            return this.data[n];
        }
        return -1;
    }

    public void writeByte(int n, byte by) {
        if (this.data != null) {
            this.data[n] = by;
        }
    }

    public void storeSequenceNumber(int n, String string) {
        int n2 = 0;
        while (n2 < 10) {
            this.data[n + n2] = -16;
            ++n2;
        }
        char[] cArray = string.toCharArray();
        int n3 = 0;
        while (n3 < string.length()) {
            this.data[10 - string.length() + n3 + n] = NIAsciiEbcdicConverter.convertToEBCDIC((byte)cArray[n3]);
            ++n3;
        }
    }

    public void storeString(int n, int n2, String string) {
        int n3 = n2 - string.length();
        char[] cArray = string.toCharArray();
        int n4 = 0;
        while (n4 < cArray.length && n4 < n2) {
            this.data[n + n4 + n3] = (byte)cArray[n4];
            ++n4;
        }
    }

    public int extractInt(int n) {
        if (this.data != null) {
            if (this.isBigEndian()) {
                return this.data[n] << 24 & 0xFF000000 | this.data[n + 1] << 16 & 0xFF0000 | this.data[n + 2] << 8 & 0xFF00 | this.data[n + 3] & 0xFF;
            }
            return this.data[n + 3] << 24 & 0xFF000000 | this.data[n + 2] << 16 & 0xFF0000 | this.data[n + 1] << 8 & 0xFF00 | this.data[n] & 0xFF;
        }
        return -1;
    }

    public int extractInt(int n, boolean bl) {
        if (this.data != null) {
            if (bl) {
                return this.data[n] << 24 & 0xFF000000 | this.data[n + 1] << 16 & 0xFF0000 | this.data[n + 2] << 8 & 0xFF00 | this.data[n + 3] & 0xFF;
            }
            return this.data[n + 3] << 24 & 0xFF000000 | this.data[n + 2] << 16 & 0xFF0000 | this.data[n + 1] << 8 & 0xFF00 | this.data[n] & 0xFF;
        }
        return -1;
    }

    public short extractShort(int n) {
        int n2 = 0;
        n2 = this.isBigEndian() ? this.data[n] << 8 & 0xFF00 | this.data[n + 1] & 0xFF : this.data[n + 1] << 8 & 0xFF00 | this.data[n] & 0xFF;
        return (short)n2;
    }

    public long extractLong(int n) {
        if (this.data != null) {
            if (this.isBigEndian()) {
                return (long)this.data[n] << 56 & 0xFF00000000000000L | (long)this.data[n + 1] << 48 & 0xFF000000000000L | (long)this.data[n + 2] << 40 & 0xFF0000000000L | (long)this.data[n + 3] << 32 & 0xFF00000000L | (long)this.data[n + 4] << 24 & 0xFF000000L | (long)this.data[n + 5] << 16 & 0xFF0000L | (long)this.data[n + 6] << 8 & 0xFF00L | (long)this.data[n + 7] & 0xFFL;
            }
            return (long)this.data[n + 7] << 56 & 0xFF00000000000000L | (long)this.data[n + 6] << 48 & 0xFF000000000000L | (long)this.data[n + 5] << 40 & 0xFF0000000000L | (long)this.data[n + 4] << 32 & 0xFF00000000L | (long)this.data[n + 3] << 24 & 0xFF000000L | (long)this.data[n + 2] << 16 & 0xFF0000L | (long)this.data[n + 1] << 8 & 0xFF00L | (long)this.data[n] & 0xFFL;
        }
        return -1L;
    }

    public String extractString(int n, int n2) {
        if (this.data != null) {
            int n3 = 0;
            while (n3 < n2) {
                if (this.data[n + n3] == 0) break;
                ++n3;
            }
            return new String(this.data, n, n3);
        }
        return "-1";
    }

    public boolean extractBooleanZeroFalse(int n) {
        if (this.data != null) {
            boolean bl = true;
            if ((this.data[n] | this.data[n + 1] | this.data[n + 2] | this.data[n + 3]) == 0) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public boolean extractBooleanZeroTrue(int n) {
        if (this.data != null) {
            boolean bl = false;
            if ((this.data[n] | this.data[n + 1] | this.data[n + 2] | this.data[n + 3]) == 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int getIntValueFromBytes(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            n3 <<= 8;
            n3 += this.getByteAsInt(n4);
            ++n4;
        }
        return n3;
    }

    public int getByteAsInt(int n) {
        return 0xFF & this.data[n];
    }

    public long getLongValueFromBytes(int n, int n2) {
        long l = 0L;
        int n3 = n;
        while (n3 <= n2) {
            l <<= 8;
            l += (long)this.getByteAsInt(n3);
            ++n3;
        }
        return l;
    }

    private int getBitMask0(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < 8) {
            n3 <<= 1;
            if (n4 >= n && n4 <= n2) {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    private int getBitMask(int n) {
        return this.getBitMask0(n, n);
    }

    public boolean bitIsSet(int n, int n2) {
        int n3;
        int n4 = this.getByteAsInt(n);
        boolean bl = (n4 & (n3 = this.getBitMask(n2))) != 0;
        return bl;
    }

    private int getBitMask(int n, int n2) {
        int n3 = 0;
        int n4 = n2;
        while (n4 >= 0) {
            n3 <<= 1;
            if (n4 >= n && n4 <= n2) {
                ++n3;
            }
            --n4;
        }
        return n3;
    }

    private int getBitsFromInt(int n, int n2, int n3) {
        int n4 = this.getBitMask(n2, n3);
        int n5 = n4 & n;
        return n5 >> n2;
    }

    public int getBitVal(int n, int n2, int n3) {
        int n4 = this.getByteAsInt(n);
        return this.getBitsFromInt(n4, n2, n3);
    }

    public byte getByte(int n) {
        return this.data[n];
    }

    public byte[] getBytes(int n, int n2) {
        byte[] byArray = new byte[n2 - n + 1];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[n3] = this.data[n + n3];
            ++n3;
        }
        return byArray;
    }

    public boolean equalByteArrays(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        boolean bl = true;
        if (n2 - n != n4 - n3) {
            bl = false;
        } else {
            int n5 = 0;
            while (n5 <= n2 - n) {
                if (byArray[n + n5] != byArray2[n3 + n5]) {
                    bl = false;
                    break;
                }
                ++n5;
            }
        }
        return bl;
    }

    private String getSerialFromEbcidBytes(byte[] byArray) {
        String string = "";
        int n = 0;
        while (n < byArray.length) {
            char c;
            int n2 = 0xFF & byArray[n];
            if (n2 != 0 && (c = this.ebcidToAscii[n2]) >= '0' && c <= 'z') {
                string = string + (char)c;
            }
            ++n;
        }
        return string;
    }

    public String getSerialFromEbcidBytes(int n, int n2) {
        byte[] byArray = this.getBytes(n, n2);
        return this.getSerialFromEbcidBytes(byArray);
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hexChar[(byArray[n] & 0xF0) >>> 4]);
            stringBuffer.append(hexChar[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static byte[] hexToByteArray(String string) {
        int n = 0;
        byte[] byArray = new byte[string.length() / 2];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)Integer.parseInt(string.substring(n, n + 2), 16);
            ++n2;
            n += 2;
        }
        return byArray;
    }
}

