/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.util;

import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.util.NIQueueFullException;

public class NIQueue {
    public static final double DEFAULT_REDUCTION = 0.05;
    private Object[] queue;
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$util$NIQueue == null ? (class$com$ibm$storage$ess$ni$util$NIQueue = NIQueue.class$("com.ibm.storage.ess.ni.util.NIQueue")) : class$com$ibm$storage$ess$ni$util$NIQueue);
    private int addIndex = 0;
    private int removeIndex = 0;
    private int maxSize = 0;
    private double queueReductionPercent = 0.0;
    private int reductionCount = 0;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$util$NIQueue;

    public NIQueue(int n, double d) {
        this.maxSize = n;
        this.queueReductionPercent = d;
        if (d < 0.0 || d > 100.0) {
            logger.error("Invalid reduction percentage " + d + ". Resetting to default.");
            this.queueReductionPercent = 0.05;
        } else if (d >= 1.0) {
            this.queueReductionPercent = d / 100.0;
        }
        this.queue = new Object[this.maxSize];
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object[] objectArray = this.queue;
        synchronized (this.queue) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.addIndex >= this.removeIndex ? this.addIndex - this.removeIndex : this.addIndex + this.maxSize - this.removeIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object object) throws NIQueueFullException, IllegalArgumentException {
        if (object == null) {
            logger.error("object is null");
            throw new IllegalArgumentException();
        }
        if (this.queue[this.addIndex] != null) {
            logger.error("queue full, can't enqueue " + object);
            this.reductionCount = (int)((double)this.maxSize * this.queueReductionPercent);
            throw new NIQueueFullException();
        }
        if (this.reductionCount > 0) {
            logger.error("queue reducing, can't enqueue " + object);
            throw new NIQueueFullException();
        }
        Object[] objectArray = this.queue;
        synchronized (this.queue) {
            logger.debug_general("enqueueing: " + object);
            this.queue[this.addIndex] = object;
            this.addIndex = this.findNextIndex(this.addIndex);
            this.queue.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue() throws InterruptedException {
        Object object = null;
        Object[] objectArray = this.queue;
        synchronized (this.queue) {
            while (this.queue[this.removeIndex] == null) {
                this.queue.wait();
            }
            object = this.queue[this.removeIndex];
            this.queue[this.removeIndex] = null;
            this.removeIndex = this.findNextIndex(this.removeIndex);
            --this.reductionCount;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object[] objectArray = this.queue;
        synchronized (this.queue) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.queue[this.removeIndex] == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object[] objectArray = this.queue;
        synchronized (this.queue) {
            int n = 0;
            while (n < this.maxSize) {
                this.queue[n] = null;
                ++n;
            }
            this.addIndex = 0;
            this.removeIndex = 0;
            this.reductionCount = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private int findNextIndex(int n) {
        return ++n % this.maxSize;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

