/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.util;

import com.ibm.storage.ess.ni.identifiers.NIESSID;

public class NISequenceNumberParser {
    private static final int TYPE2105_UNKNOWN = 0;
    private static final int TYPE2107 = 1;
    private static final int TYPE1750 = 2;
    private static final int CONTROL_UNIT_OFFSET = 1;
    private static final int FIRST_PLANT_NUMBER = 3;
    private static final int SECOND_PLANT_NUMBER = 4;

    NISequenceNumberParser() {
    }

    public static String extractSerialFromSequence(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < 5) {
            cArray[n] = 48;
            ++n;
        }
        return new String(cArray);
    }

    public static String trimLeadingZerosFromString(String string, int n) {
        if (n < string.length()) {
            return string.substring(n);
        }
        return "";
    }

    public static String extractCUTypeFromSequence(String string) {
        char[] cArray = string.toCharArray();
        if ('0' == cArray[1]) {
            return "Unknown";
        }
        if ('1' == cArray[1]) {
            return "2107";
        }
        if ('2' == cArray[1]) {
            return "1750";
        }
        return "Unknown";
    }

    public static String extractPlantFromSequence(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[]{cArray[3], cArray[4]};
        if (cArray[3] == '0' && cArray[4] == '0') {
            return "Unknown";
        }
        return new String(cArray2);
    }

    public static String createSequenceNumber(String string, String string2, String string3) {
        if (string2.equalsIgnoreCase("Unknown") || string2.equalsIgnoreCase("2105")) {
            string2 = "00";
        } else if (string2.equalsIgnoreCase("1750")) {
            string2 = 0 + Integer.toString(2);
        } else if (string2.equalsIgnoreCase("2107")) {
            string2 = 0 + Integer.toString(1);
        }
        if (string3.equalsIgnoreCase("Unknown")) {
            string3 = "00";
        }
        if (string.equalsIgnoreCase(NIESSID.SEQUENCE_UNKNOWN)) {
            string = "00000";
        }
        return string2 + "0" + string3 + string;
    }
}

