/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.ess.ni.utilPrograms;

import com.ibm.rsct.rmc.McSession;
import com.ibm.rsct.rmcjni.McApi;
import com.ibm.rsct.rmcjni.McQueryRsp;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtString;
import com.ibm.rsct.util.CuException;
import com.ibm.storage.ess.logging.Logger;
import com.ibm.storage.ess.ni.agent.NIAgentProperties;
import com.ibm.storage.ess.ni.logging.NILoggerFactory;
import com.ibm.storage.ess.ni.messageRouter.NIMessageRouterMetaDataFile;
import com.ibm.storage.ess.ni.util.NIMtmsParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class NINodeAgent {
    private static final Logger logger = NILoggerFactory.getLogger(class$com$ibm$storage$ess$ni$utilPrograms$NINodeAgent == null ? (class$com$ibm$storage$ess$ni$utilPrograms$NINodeAgent = NINodeAgent.class$("com.ibm.storage.ess.ni.utilPrograms.NINodeAgent")) : class$com$ibm$storage$ess$ni$utilPrograms$NINodeAgent);
    private static final String NON_ROUTING_IP = "172";
    private static final String LAB_MODE_TOUCH_FILE = "/opt/esshmc/data/mmhmcreallabmode";
    private static final String DEFAULT_IP_EN0 = "ipen0";
    private static final String DEFAULT_IP_EN1 = "ipen1";
    private static final int INVALID_OCTET = -1;
    private String fileNamePath = System.getProperty("NodeDataFileProperty");
    private String serverName = null;
    private InetAddress ip1 = null;
    private InetAddress ip2 = null;
    private String domainGroup = null;
    private String storagePlex = null;
    private boolean fieldMode = true;
    private int numOfHMCs = 0;
    static /* synthetic */ Class class$com$ibm$storage$ess$ni$utilPrograms$NINodeAgent;

    public NINodeAgent() {
        if (this.fileNamePath == null) {
            logger.error("Node data file not specified.");
        } else {
            logger.debug_general("Metadata file = " + this.fileNamePath);
        }
    }

    public static void main(String[] stringArray) {
        NINodeAgent nINodeAgent = new NINodeAgent();
        nINodeAgent.createMessageRouterMetaDataFile();
    }

    public void createMessageRouterMetaDataFile() {
        if (NIAgentProperties.getAgentType() == 2) {
            this.getLparNodeData();
            this.determineCECLabOrFieldMode();
        } else if (NIAgentProperties.getAgentType() == 3) {
            this.getHmcNodeData();
            this.saveNumOfHMCs();
        }
        this.setStoragePlexBasedOnFieldMode();
        try {
            NIMessageRouterMetaDataFile nIMessageRouterMetaDataFile = new NIMessageRouterMetaDataFile(true, this.fileNamePath);
            nIMessageRouterMetaDataFile.writeData(this.getServerName(), this.getIPAddress1(), this.getIPAddress2(), this.getDomainGroup(), this.getStoragePlex());
            nIMessageRouterMetaDataFile.close();
        }
        catch (Exception exception) {
            logger.error("Unable to create message router meta data file.");
            logger.throwable((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLparNodeData() {
        long l = this.startSession();
        try {
            block4: {
                try {
                    McQueryRsp[] mcQueryRspArray = this.executeQuery(l, "IBM.EssServer");
                    McQueryRsp[] mcQueryRspArray2 = this.executeQuery(l, "IBM.ManagementServer");
                    McQueryRsp[] mcQueryRspArray3 = this.executeQuery(l, "IBM.NetworkInterface");
                    if (mcQueryRspArray == null || mcQueryRspArray2 == null || mcQueryRspArray3 == null) break block4;
                    this.processServerQuery(mcQueryRspArray);
                    this.processMsQuery(mcQueryRspArray2);
                    this.processNiQuery(mcQueryRspArray3);
                }
                catch (Exception exception) {
                    logger.error("General Exception in creation of meta data file attributes.");
                    logger.throwable((Throwable)exception);
                    Object var7_7 = null;
                    this.endSession(l);
                }
            }
            Object var7_6 = null;
            this.endSession(l);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.endSession(l);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getHmcNodeData() {
        long l = this.startSession();
        try {
            block4: {
                try {
                    McQueryRsp[] mcQueryRspArray = this.executeQuery(l, "IBM.ManagedNode");
                    McQueryRsp[] mcQueryRspArray2 = this.executeQuery(l, "IBM.EssHMC");
                    McQueryRsp[] mcQueryRspArray3 = this.executeQuery(l, "IBM.NetworkInterface");
                    if (mcQueryRspArray2 == null || mcQueryRspArray3 == null || mcQueryRspArray == null) break block4;
                    this.processHmcMnQuery(mcQueryRspArray);
                    this.processHmcQuery(mcQueryRspArray2);
                    this.processHmcNiQuery(mcQueryRspArray3);
                }
                catch (Exception exception) {
                    logger.error("Error processing queries for HMC.");
                    logger.throwable((Throwable)exception);
                    Object var7_7 = null;
                    this.endSession(l);
                }
            }
            Object var7_6 = null;
            this.endSession(l);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.endSession(l);
            throw throwable;
        }
    }

    private McQueryRsp[] executeQuery(long l, String string) {
        logger.debug_general("Executing query for ." + string);
        McQueryRsp[] mcQueryRspArray = null;
        boolean bl = false;
        try {
            boolean bl2;
            do {
                bl2 = true;
                mcQueryRspArray = McApi.queryPSelect_BP((long)l, (String)string, null, null);
                if (mcQueryRspArray == null) {
                    logger.error("Error reading from RMC.  pSelectResponse = null " + string);
                    continue;
                }
                int n = 0;
                while (n < mcQueryRspArray.length && mcQueryRspArray != null) {
                    if (mcQueryRspArray[n].hasError()) {
                        logger.error("Error reading from RMC.  RMC Error Msg = " + mcQueryRspArray[n].getErrorMessage() + " for RM  " + string + " response number " + n);
                        mcQueryRspArray = null;
                        if (mcQueryRspArray[n].getError().getErrorId() == 262154) {
                            if (!bl) {
                                logger.debug_general(string + "  not available.  Looping until " + string + "  is available.");
                                bl = true;
                            }
                            bl2 = false;
                            Thread.sleep(10000L);
                        }
                    }
                    ++n;
                }
            } while (!bl2);
        }
        catch (CuException cuException) {
            logger.error("Exception reading from RMC.  RMC Error Msg = " + cuException.getErrorData().getErrorMessage());
            logger.throwable((Throwable)cuException);
        }
        catch (InterruptedException interruptedException) {
            logger.throwable((Throwable)interruptedException);
        }
        logger.debug_general("Query for ." + string + "  has completed.");
        return mcQueryRspArray;
    }

    private void processServerQuery(McQueryRsp[] mcQueryRspArray) {
        logger.debug_general("Extracting info for domain group and server name from IBM.EssServer.");
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < mcQueryRspArray.length) {
            int n2 = 0;
            while (n2 < mcQueryRspArray[n].getAttributes().length) {
                CtDataType ctDataType;
                if (mcQueryRspArray[n].getAttributes()[n2].getName().equals("storageFacilityImageMTMS")) {
                    ctDataType = mcQueryRspArray[n].getAttributes()[n2].getValue();
                    string2 = ((CtString)ctDataType).getData();
                }
                if (mcQueryRspArray[n].getAttributes()[n2].getName().equals("server")) {
                    ctDataType = mcQueryRspArray[n].getAttributes()[n2].getValue();
                    string = ctDataType.toString();
                }
                ++n2;
            }
            ++n;
        }
        if (string2 == null || string == null) {
            logger.error("Unable to find storageFacilityImageMTMS attribute in SFI query result.");
            return;
        }
        NIMtmsParser nIMtmsParser = new NIMtmsParser(string2);
        this.setServerName(nIMtmsParser.getESSNIString() + string);
        this.setDomainGroup(nIMtmsParser.getESSNIString());
    }

    private void processMsQuery(McQueryRsp[] mcQueryRspArray) {
        logger.debug_general("Extracting info for storage plex from IBM.ManagementServer.");
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < mcQueryRspArray.length) {
            String string4;
            int n2 = 0;
            while (n2 < mcQueryRspArray[n].getAttributes().length) {
                if (mcQueryRspArray[n].getAttributes()[n2].getName().equals("HMCAddIPs")) {
                    CtDataType ctDataType = mcQueryRspArray[n].getAttributes()[n2].getValue();
                    string4 = ((CtString)ctDataType).getData();
                    logger.debug_general("HMCAddIPs value = " + string4);
                    string2 = this.parseForHmcIP(string4);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < mcQueryRspArray[n].getAttributes().length) {
                if (mcQueryRspArray[n].getAttributes()[n3].getName().equals("HMCName")) {
                    string4 = mcQueryRspArray[n].getAttributes()[n3].getValue();
                    string = ((CtString)string4).getData();
                }
                ++n3;
            }
            if (string2 != null && (string2.equals("172.17.0.2") || string2.equals("172.16.0.1"))) {
                string3 = this.parseForStoragePlexName(string);
                logger.debug_general("storageplex   " + string3);
            }
            ++n;
        }
        if (string == null) {
            logger.error("Unable to find HMCName attribute in Management Server query result.");
            return;
        }
        if (string3 == null) {
            logger.error("Unable to find HMC IP Address 172.17.0.2 or 172.16.0.1 in Management Server query result.");
            return;
        }
        this.setStoragePlex(string3);
    }

    private String parseForHmcIP(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements() && string2 == null) {
            String string3 = (String)stringTokenizer.nextElement();
            if (!string3.equals("172.17.0.2") && !string3.equals("172.16.0.1")) continue;
            string2 = string3;
        }
        return string2;
    }

    private String parseForStoragePlexName(String string) {
        int n = string.indexOf("[");
        int n2 = string.indexOf("]");
        int n3 = string.indexOf("*");
        logger.debug_general(string);
        String string2 = string.substring(n + 1, n2);
        logger.debug_general("x1 = " + string2);
        String string3 = string.substring(n3, string.length());
        logger.debug_general("x2 = " + string3);
        String string4 = string2 + string3;
        logger.debug_general(string4);
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHmcQuery(McQueryRsp[] mcQueryRspArray) {
        logger.debug_general("Extracting info for HMC from IBM.EssHMC.");
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Process process = null;
        BufferedReader bufferedReader = null;
        try {
            process = Runtime.getRuntime().exec("getHMCVPD -a");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string5 = bufferedReader.readLine();
            if (string5 == null) {
                return;
            }
            logger.debug_general("local   " + string5);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                }
            }
            if (process != null) {
                try {
                    process.getInputStream().close();
                    process.getOutputStream().close();
                    process.getErrorStream().close();
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                }
            }
        }
        boolean bl = false;
        this.numOfHMCs = mcQueryRspArray.length;
        int n = 0;
        while (n < mcQueryRspArray.length) {
            int n2 = 0;
            while (n2 < mcQueryRspArray[n].getAttributes().length) {
                String string6 = mcQueryRspArray[n].getAttributes()[n2].getName();
                CtDataType ctDataType = mcQueryRspArray[n].getAttributes()[n2].getValue();
                if (string6.equals("hardwareManagementConsoleNumber")) {
                    string2 = ctDataType.toString();
                    logger.debug_detailed("currentId   " + string2);
                } else if (string6.equals("hardwareManagementConsoleMTMS")) {
                    string4 = ctDataType.toString();
                    logger.debug_detailed("currentMtms   " + string4);
                }
                ++n2;
            }
            if (string2.equals("1")) {
                string3 = string4;
                logger.debug_detailed("storageplex   " + string3);
            }
            if (!bl && string4.equals(string5)) {
                string = string2;
                bl = true;
            }
            ++n;
        }
        if (string == null) {
            logger.error("Unable to find HMC name from query result.");
            return;
        }
        if (string3 == null) {
            logger.error("Unable to find peer domain for HMC.");
            return;
        }
        this.setStoragePlex(string3);
        this.setServerName("HMC" + string);
        this.setDomainGroup("HMC");
    }

    private void processNiQuery(McQueryRsp[] mcQueryRspArray) throws UnknownHostException {
        logger.debug_general("Extracting info for IP addresses from IBM.NetworkInterface.");
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < mcQueryRspArray.length) {
            int n2 = 0;
            while (n2 < mcQueryRspArray[n].getAttributes().length) {
                if (mcQueryRspArray[n].getAttributes()[n2].getName().equals("Name")) {
                    CtDataType ctDataType = mcQueryRspArray[n].getAttributes()[n2].getValue();
                    string3 = ((CtString)ctDataType).getData();
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < mcQueryRspArray[n].getAttributes().length) {
                if (mcQueryRspArray[n].getAttributes()[n3].getName().equals("IPAddress")) {
                    CtDataType ctDataType = mcQueryRspArray[n].getAttributes()[n3].getValue();
                    if (string3.equals("en0")) {
                        string = ((CtString)ctDataType).getData();
                    } else if (string3.equals("en1")) {
                        string2 = ((CtString)ctDataType).getData();
                    }
                }
                ++n3;
            }
            ++n;
        }
        if (string == null || string2 == null) {
            logger.error("Unable to find IP Addresses in NetworkInterface query result.");
            return;
        }
        this.setIPAddress1(InetAddress.getByName(string));
        this.setIPAddress2(InetAddress.getByName(string2));
    }

    private void processHmcNiQuery(McQueryRsp[] mcQueryRspArray) throws UnknownHostException {
        logger.debug_general("Extracting HMC info for IP addresses from IBM.NetworkInterface.");
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < mcQueryRspArray.length) {
            int n2 = 0;
            while (n2 < mcQueryRspArray[n].getAttributes().length) {
                if (mcQueryRspArray[n].getAttributes()[n2].getName().equals("Name")) {
                    CtDataType ctDataType = mcQueryRspArray[n].getAttributes()[n2].getValue();
                    string3 = ((CtString)ctDataType).getData();
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < mcQueryRspArray[n].getAttributes().length) {
                if (mcQueryRspArray[n].getAttributes()[n3].getName().equals("IPAddress")) {
                    CtDataType ctDataType = mcQueryRspArray[n].getAttributes()[n3].getValue();
                    if (string3.equals("eth3")) {
                        string2 = ((CtString)ctDataType).getData();
                    } else if (this.isFieldMode()) {
                        if (string3.equals("eth0")) {
                            logger.debug_general("Running in Field Mode.");
                            string = ((CtString)ctDataType).getData();
                        }
                    } else if (string3.equals("eth2")) {
                        logger.debug_general("Running in Lab Mode.");
                        string = ((CtString)ctDataType).getData();
                    }
                }
                ++n3;
            }
            ++n;
        }
        if (string == null || string2 == null) {
            logger.error("Unable to find IP Addresses in NetworkInterface query result.");
            return;
        }
        this.setIPAddress1(InetAddress.getByName(string));
        this.setIPAddress2(InetAddress.getByName(string2));
    }

    private void processHmcMnQuery(McQueryRsp[] mcQueryRspArray) {
        logger.debug_general("Extracting info for HMC from IBM.ManagedNode.");
        int n = 0;
        while (n < mcQueryRspArray.length) {
            int n2 = 0;
            while (n2 < mcQueryRspArray[n].getAttributes().length) {
                CtDataType ctDataType;
                String string;
                if (mcQueryRspArray[n].getAttributes()[n2].getName().equals("Name") && !(string = ((CtString)(ctDataType = mcQueryRspArray[n].getAttributes()[n2].getValue())).getData()).startsWith(NON_ROUTING_IP)) {
                    this.setFieldModeFalse();
                    return;
                }
                ++n2;
            }
            ++n;
        }
        File file = new File(LAB_MODE_TOUCH_FILE);
        if (file.exists()) {
            this.setFieldModeFalse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determineCECLabOrFieldMode() {
        Object object;
        Object object2;
        String string = DEFAULT_IP_EN0;
        String string2 = DEFAULT_IP_EN1;
        Process process = null;
        BufferedReader bufferedReader = null;
        try {
            process = Runtime.getRuntime().exec("ifconfig en0");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((object2 = bufferedReader.readLine()) != null) {
                if (((String)object2).indexOf("inet") == -1) continue;
                string = ((String)object2).substring(((String)object2).indexOf("inet") + 5, ((String)object2).indexOf(" ", ((String)object2).indexOf("inet") + 5));
            }
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                }
            }
            if (process != null) {
                try {
                    process.getInputStream().close();
                    process.getOutputStream().close();
                    process.getErrorStream().close();
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                }
            }
        }
        try {
            process = Runtime.getRuntime().exec("ifconfig en1");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((object2 = bufferedReader.readLine()) != null) {
                if (((String)object2).indexOf("inet") == -1) continue;
                string2 = ((String)object2).substring(((String)object2).indexOf("inet") + 5, ((String)object2).indexOf(" ", ((String)object2).indexOf("inet") + 5));
            }
        }
        catch (IOException iOException) {
            logger.throwable((Throwable)iOException);
        }
        catch (Exception exception) {
            logger.throwable((Throwable)exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                }
            }
            if (process != null) {
                try {
                    process.getInputStream().close();
                    process.getOutputStream().close();
                    process.getErrorStream().close();
                }
                catch (IOException iOException) {
                    logger.throwable((Throwable)iOException);
                }
            }
        }
        logger.debug_general("ipen0 = " + string + " ipen1 = " + string2);
        if (string.equals(DEFAULT_IP_EN0)) {
            logger.debug_general("en0 is down setting field mode to true..");
            this.setFieldModeTrue();
        } else if (string2.equals(DEFAULT_IP_EN1)) {
            object2 = new StringTokenizer(string, ".");
            if (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                String string3 = "";
                int n = -1;
                int n2 = -1;
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    string3 = ((StringTokenizer)object2).nextToken();
                }
                try {
                    if (((StringTokenizer)object2).hasMoreTokens()) {
                        n = Integer.parseInt(((StringTokenizer)object2).nextToken());
                    }
                    if (((StringTokenizer)object2).hasMoreTokens()) {
                        n2 = Integer.parseInt(((StringTokenizer)object2).nextToken());
                    }
                }
                catch (Exception exception) {
                    logger.throwable((Throwable)exception);
                }
                if (((String)object).equals(NON_ROUTING_IP) && string3.equals("16")) {
                    if (n == 0 && n2 >= 3 && n2 <= 255) {
                        logger.debug_general("en0 was in range 1 setting to field mode");
                        this.setFieldModeTrue();
                    } else if (n == 1 && n2 >= 0 && n2 <= 254) {
                        logger.debug_general("en0 was in range 2 setting to field mode");
                        this.setFieldModeTrue();
                    } else {
                        logger.debug_general("en0 was not in range 2 setting to  lab mode");
                        this.setFieldModeFalse();
                    }
                } else if (((String)object).equals("10") && string3.equals("235")) {
                    if (n == 158 && n2 >= 3 && n2 <= 255) {
                        logger.debug_general("en0 was in range 3 setting to field mode");
                        this.setFieldModeTrue();
                    } else if (n == 159 && n2 >= 0 && n2 <= 254) {
                        logger.debug_general("en0 was in range 4 setting to field mode");
                        this.setFieldModeTrue();
                    } else {
                        logger.debug_general("en0 was not in range 4 setting to  lab mode");
                        this.setFieldModeFalse();
                    }
                } else if (((String)object).equals("192") && string3.equals("168")) {
                    if (n == 162 && n2 >= 3 && n2 <= 255) {
                        logger.debug_general("en0 was in range 5 setting to field mode");
                        this.setFieldModeTrue();
                    } else if (n == 163 && n2 >= 0 && n2 <= 254) {
                        logger.debug_general("en0 was in range 6 setting to field mode");
                        this.setFieldModeTrue();
                    } else {
                        logger.debug_general("en0 was not in range 6 setting to  lab mode");
                        this.setFieldModeFalse();
                    }
                } else if (((String)object).equals("9") && string3.equals("15")) {
                    if (n == 132 && n2 >= 3 && n2 <= 255) {
                        logger.debug_general("en0 was in range 7 setting to field mode");
                        this.setFieldModeTrue();
                    } else if (n == 133 && n2 >= 0 && n2 <= 254) {
                        logger.debug_general("en0 was in range 8 setting to field mode");
                        this.setFieldModeTrue();
                    } else {
                        logger.debug_general("en0 was not in range 8 setting to  lab mode");
                        this.setFieldModeFalse();
                    }
                } else if (n == -1 && n2 == -1) {
                    logger.debug_general("invalid IP, defaulting to field mode..");
                    this.setFieldModeTrue();
                } else {
                    logger.debug_general("en0 was not in range, setting to lab mode");
                    this.setFieldModeFalse();
                }
            } else {
                logger.debug_general("en0 isnt even in IP format?? setting to field mode");
                this.setFieldModeTrue();
            }
        } else {
            object2 = new StringTokenizer(string, ".");
            object = new StringTokenizer(string2, ".");
            if (((StringTokenizer)object2).hasMoreTokens() && ((StringTokenizer)object).hasMoreTokens()) {
                if (((StringTokenizer)object2).nextToken().equals(((StringTokenizer)object).nextToken())) {
                    logger.debug_general("first octect are the same setting field mode true");
                    this.setFieldModeTrue();
                } else {
                    logger.debug_general("first octect are different setting field mode false");
                    this.setFieldModeFalse();
                }
            }
        }
    }

    private void setStoragePlexBasedOnFieldMode() {
        if (this.isFieldMode()) {
            this.setStoragePlex("*");
        }
    }

    private void setFieldModeFalse() {
        this.fieldMode = false;
    }

    private void setFieldModeTrue() {
        this.fieldMode = true;
    }

    private boolean isFieldMode() {
        return this.fieldMode;
    }

    private void setServerName(String string) {
        this.serverName = string;
    }

    private void setStoragePlex(String string) {
        this.storagePlex = string;
    }

    private void setDomainGroup(String string) {
        this.domainGroup = string;
    }

    private void setIPAddress1(InetAddress inetAddress) {
        this.ip1 = inetAddress;
    }

    private void setIPAddress2(InetAddress inetAddress) {
        this.ip2 = inetAddress;
    }

    private String getStoragePlex() {
        return this.storagePlex;
    }

    private String getServerName() {
        return this.serverName;
    }

    private String getDomainGroup() {
        return this.domainGroup;
    }

    private InetAddress getIPAddress1() {
        return this.ip1;
    }

    private InetAddress getIPAddress2() {
        return this.ip2;
    }

    private long startSession() {
        long l = 0L;
        try {
            logger.debug_general("Connecting to RMC");
            try {
                McSession mcSession = new McSession(null, 1, null, null);
                l = mcSession.getHandle();
            }
            catch (CuException cuException) {
                logger.error("Unable to connect to RMC.");
                logger.throwable((Throwable)cuException);
            }
        }
        catch (Exception exception) {
            logger.error("General Exception in creation of meta data file attributes.");
            logger.throwable((Throwable)exception);
        }
        return l;
    }

    private void endSession(long l) {
        try {
            McApi.endSession((long)l);
        }
        catch (CuException cuException) {
            logger.error("Error closing RMC session.");
            logger.throwable((Throwable)cuException);
        }
    }

    private void getAllIPs() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    System.out.println(inetAddress + "   local IP");
                }
            }
        }
        catch (Exception exception) {}
    }

    private void saveNumOfHMCs() {
        block3: {
            logger.debug_general("Number of HMCs found is " + this.numOfHMCs);
            try {
                File file = new File("/opt/essni/etc/dualHMCsConfigured");
                if (this.numOfHMCs == 2) {
                    file.createNewFile();
                    break block3;
                }
                file.delete();
            }
            catch (Exception exception) {
                logger.error("Error handling dualHMCs file");
                logger.throwable((Throwable)exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

