/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;
import javax.security.cert.X509Certificate;

public final class X509V1CertImpl
extends X509Certificate
implements Serializable {
    static final long serialVersionUID = -2048442350420423405L;
    private java.security.cert.X509Certificate wrappedCert;

    private static synchronized CertificateFactory a() throws java.security.cert.CertificateException {
        return CertificateFactory.getInstance(X509V1CertImpl.a("_~z8W"));
    }

    public X509V1CertImpl() {
    }

    public X509V1CertImpl(byte[] byArray) throws CertificateException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.wrappedCert = (java.security.cert.X509Certificate)X509V1CertImpl.a().generateCertificate(byteArrayInputStream);
        }
        catch (java.security.cert.CertificateException certificateException) {
            throw new CertificateException(certificateException.getMessage());
        }
    }

    public X509V1CertImpl(InputStream inputStream) throws CertificateException {
        try {
            this.wrappedCert = (java.security.cert.X509Certificate)X509V1CertImpl.a().generateCertificate(inputStream);
        }
        catch (java.security.cert.CertificateException certificateException) {
            throw new CertificateException(certificateException.getMessage());
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.wrappedCert.getEncoded();
        }
        catch (java.security.cert.CertificateEncodingException certificateEncodingException) {
            throw new CertificateEncodingException(certificateEncodingException.getMessage());
        }
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.wrappedCert.verify(publicKey);
        }
        catch (java.security.cert.CertificateException certificateException) {
            throw new CertificateException(certificateException.getMessage());
        }
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.wrappedCert.verify(publicKey, string);
        }
        catch (java.security.cert.CertificateException certificateException) {
            throw new CertificateException(certificateException.getMessage());
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        try {
            this.wrappedCert.checkValidity(date);
        }
        catch (java.security.cert.CertificateNotYetValidException certificateNotYetValidException) {
            throw new CertificateNotYetValidException(certificateNotYetValidException.getMessage());
        }
        catch (java.security.cert.CertificateExpiredException certificateExpiredException) {
            throw new CertificateExpiredException(certificateExpiredException.getMessage());
        }
    }

    public String toString() {
        return this.wrappedCert.toString();
    }

    public PublicKey getPublicKey() {
        PublicKey publicKey = this.wrappedCert.getPublicKey();
        return publicKey;
    }

    public int getVersion() {
        String string = System.getProperty(X509V1CertImpl.a("m19i@q5={\u0007h>"));
        if (string.compareTo(X509V1CertImpl.a("6~{")) >= 0) {
            return this.wrappedCert.getVersion() - 1;
        }
        return this.wrappedCert.getVersion();
    }

    public BigInteger getSerialNumber() {
        return this.wrappedCert.getSerialNumber();
    }

    public Principal getSubjectDN() {
        return this.wrappedCert.getSubjectDN();
    }

    public Principal getIssuerDN() {
        return this.wrappedCert.getIssuerDN();
    }

    public Date getNotBefore() {
        return this.wrappedCert.getNotBefore();
    }

    public Date getNotAfter() {
        return this.wrappedCert.getNotAfter();
    }

    public String getSigAlgName() {
        return this.wrappedCert.getSigAlgName();
    }

    public String getSigAlgOID() {
        return this.wrappedCert.getSigAlgOID();
    }

    public byte[] getSigAlgParams() {
        return this.wrappedCert.getSigAlgParams();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.write(this.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IOException(X509V1CertImpl.a("`5;M\u0000d?+m\n'6.a\u0002b4u(") + certificateEncodingException.getMessage());
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.wrappedCert = (java.security.cert.X509Certificate)X509V1CertImpl.a().generateCertificate(objectInputStream);
        }
        catch (java.security.cert.CertificateException certificateException) {
            throw new IOException(X509V1CertImpl.a("`5!m\u001cf$*K\u000bu$&n\u0007d1;mNa1&d\u000bcjo") + certificateException.getMessage());
        }
    }

    public java.security.cert.X509Certificate getX509Certificate() {
        return this.wrappedCert;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 7;
                        break;
                    }
                    case 1: {
                        n5 = 80;
                        break;
                    }
                    case 2: {
                        n5 = 79;
                        break;
                    }
                    case 3: {
                        n5 = 8;
                        break;
                    }
                    default: {
                        n5 = 110;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

