/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.configuration;

import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.update.configuration.ILocalSystemInfoListener;
import org.eclipse.update.configuration.IVolume;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.Volume;

public class LocalSystemInfo {
    public static final long SIZE_UNKNOWN = -1L;
    public static final int VOLUME_UNKNOWN = -1;
    public static final int VOLUME_INVALID_PATH = -2;
    public static final int VOLUME_REMOVABLE = 1;
    public static final int VOLUME_FIXED = 2;
    public static final int VOLUME_REMOTE = 3;
    public static final int VOLUME_CDROM = 4;
    public static final int VOLUME_RAMDISK = 5;
    public static final int VOLUME_FLOPPY_5 = 6;
    public static final int VOLUME_FLOPPY_3 = 7;
    public static final int VOLUME_ADDED = 0;
    public static final int VOLUME_REMOVED = 1;
    public static final int VOLUME_CHANGED = 2;
    private static ArrayList listeners = new ArrayList();
    private static boolean hasNatives = false;

    static {
        try {
            System.loadLibrary("update");
            hasNatives = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            UpdateCore.warn("Unable to load native library 'update'.");
            hasNatives = false;
        }
    }

    public static long getFreeSpace(File path) {
        if (hasNatives) {
            try {
                long bytes = LocalSystemInfo.nativeGetFreeSpace(path);
                return bytes != 0L ? bytes / 1024L : 0L;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
        return -1L;
    }

    public static IVolume[] getVolumes() {
        String[] mountPoints = LocalSystemInfo.listMountPoints();
        IVolume[] vol = new Volume[]{};
        if (mountPoints != null) {
            vol = new Volume[mountPoints.length];
            int i = 0;
            while (i < mountPoints.length) {
                File root = new File(mountPoints[i]);
                String label = LocalSystemInfo.getLabel(root);
                int type = LocalSystemInfo.getType(root);
                long size = LocalSystemInfo.getFreeSpace(root);
                vol[i] = new Volume(root, label, type, size);
                ((ModelObject)((Object)vol[i])).markReadOnly();
                ++i;
            }
        } else {
            UpdateCore.warn("Unable to find mount points");
            File[] roots = File.listRoots();
            if (roots.length == 1) {
                File root = roots[0];
                roots = root.listFiles();
            }
            vol = new Volume[roots.length];
            int i = 0;
            while (i < roots.length) {
                vol[i] = new Volume(roots[i], null, -1, -1L);
                ((ModelObject)((Object)vol[i])).markReadOnly();
                ++i;
            }
        }
        return vol;
    }

    public static void addInfoListener(ILocalSystemInfoListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void removeInfoListener(ILocalSystemInfoListener listener) {
        ((AbstractCollection)listeners).remove(listener);
    }

    public static void fireSystemInfoChanged(IVolume volume, int changeType) {
        int i = 0;
        while (i < listeners.size()) {
            ((ILocalSystemInfoListener)listeners.get(i)).systemInfoChanged(volume, changeType);
            ++i;
        }
    }

    private static String getLabel(File path) {
        if (hasNatives) {
            try {
                return LocalSystemInfo.nativeGetLabel(path);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
        return null;
    }

    private static int getType(File path) {
        if (hasNatives) {
            try {
                return LocalSystemInfo.nativeGetType(path);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
        return -1;
    }

    private static String[] listMountPoints() {
        if (hasNatives) {
            try {
                String[] mountPoints = LocalSystemInfo.nativeListMountPoints();
                return mountPoints;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
        return null;
    }

    private static native long nativeGetFreeSpace(File var0);

    private static native String nativeGetLabel(File var0);

    private static native int nativeGetType(File var0);

    private static native String[] nativeListMountPoints();
}

