/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.Response;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class ContentReference {
    public static final long UNKNOWN_SIZE = -1L;
    public static final int DEFAULT_EXECUTABLE_PERMISSION = -1;
    private static final String FILE_URL_PROTOCOL = "file";
    private String id;
    private URL url;
    private File file;
    private Response response;
    private int permission;
    private boolean tempLocal = false;

    private ContentReference() {
    }

    public ContentReference(String id, URL url) {
        this.id = id == null ? "" : id;
        this.url = url;
        this.file = null;
    }

    public ContentReference(String id, File file) {
        this.id = id == null ? "" : id;
        this.file = file;
        this.url = null;
    }

    public ContentReference createContentReference(String id, File file) {
        return new ContentReference(id, file, true);
    }

    private ContentReference(String id, File file, boolean b) {
        this(id, file);
        this.setTempLocal(b);
    }

    public String getIdentifier() {
        return this.id;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.url != null) {
            if (this.response == null) {
                URL resolvedURL = URLEncoder.encode(this.url);
                this.response = UpdateCore.getPlugin().get(resolvedURL);
                UpdateManagerUtils.checkConnectionResult(this.response, resolvedURL);
            }
            return this.response.getInputStream();
        }
        throw new IOException(Policy.bind("ContentReference.UnableToCreateInputStream", this.toString()));
    }

    public long getInputSize() throws IOException {
        if (this.file != null) {
            return this.file.length();
        }
        if (this.url != null) {
            long size;
            if (this.response == null) {
                URL resolvedURL = null;
                try {
                    resolvedURL = URLEncoder.encode(this.url);
                    this.response = UpdateCore.getPlugin().get(resolvedURL);
                }
                catch (IOException iOException) {
                    return -1L;
                }
                UpdateManagerUtils.checkConnectionResult(this.response, resolvedURL);
            }
            return (size = this.response.getContentLength()) == -1L ? -1L : size;
        }
        return -1L;
    }

    public boolean isLocalReference() {
        return this.tempLocal;
    }

    public File asFile() throws IOException {
        if (this.file != null) {
            return this.file;
        }
        if (this.url != null && FILE_URL_PROTOCOL.equals(this.url.getProtocol())) {
            File result = new File(this.url.getFile());
            if (result.exists()) {
                return result;
            }
            throw new IOException(Policy.bind("ContentReference.FileDoesNotExist", this.toString()));
        }
        throw new IOException(Policy.bind("ContentReference.UnableToReturnReferenceAsFile", this.toString()));
    }

    public URL asURL() throws IOException {
        if (this.url != null) {
            return this.url;
        }
        if (this.file != null) {
            return this.file.toURL();
        }
        throw new IOException(Policy.bind("ContentReference.UnableToReturnReferenceAsURL", this.toString()));
    }

    public String toString() {
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        return this.url.toExternalForm();
    }

    public int getPermission() {
        return this.permission;
    }

    public void setPermission(int permission) {
        this.permission = permission;
    }

    protected void setTempLocal(boolean tempLocal) {
        this.tempLocal = tempLocal;
    }
}

