/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;

public class Utilities {
    private static Map entryMap;
    private static Map timerMap;
    private static Stack bufferPool;
    private static final int BUFFER_SIZE = 4096;
    private static final DateFormat dateFormat;
    private static long tmpseed;
    private static String dirRoot;

    static {
        timerMap = new HashMap();
        dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        tmpseed = new Date().getTime();
        dirRoot = null;
    }

    public static synchronized File createWorkingDirectory() throws IOException {
        if (dirRoot == null) {
            dirRoot = System.getProperty("java.io.tmpdir");
            if (!dirRoot.endsWith(File.separator)) {
                dirRoot = String.valueOf(dirRoot) + File.separator;
            }
            dirRoot = String.valueOf(dirRoot) + "eclipse" + File.separator + ".update" + File.separator + Long.toString(tmpseed) + File.separator;
        }
        String tmpName = String.valueOf(dirRoot) + Long.toString(++tmpseed) + File.separator;
        File tmpDir = new File(tmpName);
        Utilities.verifyPath(tmpDir, false);
        if (!tmpDir.exists()) {
            throw new FileNotFoundException(tmpName);
        }
        return tmpDir;
    }

    public static synchronized File createLocalFile(File tmpDir, String name) throws IOException {
        File temp;
        if (name != null) {
            String filePath = name.replace('/', File.separatorChar);
            if (filePath.startsWith(File.separator)) {
                filePath = filePath.substring(1);
            }
            temp = new File(tmpDir, filePath);
        } else {
            temp = File.createTempFile("eclipse", null, tmpDir);
        }
        temp.deleteOnExit();
        Utilities.verifyPath(temp, true);
        return temp;
    }

    public static synchronized void mapLocalFile(String key, File temp) {
        if (key != null) {
            if (entryMap == null) {
                entryMap = new HashMap();
            }
            entryMap.put(key, temp);
        }
    }

    public static synchronized File lookupLocalFile(String key) {
        if (entryMap == null) {
            return null;
        }
        return (File)entryMap.get(key);
    }

    public static synchronized void flushLocalFile() {
        entryMap = null;
    }

    public static synchronized void removeLocalFile(String key) {
        if (entryMap != null) {
            entryMap.remove(key);
        }
    }

    public static void copy(InputStream is, OutputStream os, InstallMonitor monitor) throws IOException, InstallAbortedException {
        byte[] buf = Utilities.getBuffer();
        try {
            long currentLen = 0L;
            int len = is.read(buf);
            while (len != -1) {
                currentLen += (long)len;
                os.write(buf, 0, len);
                if (monitor != null) {
                    monitor.setCopyCount(currentLen);
                    if (monitor.isCanceled()) {
                        String msg = Policy.bind("Feature.InstallationCancelled");
                        throw new InstallAbortedException(msg, null);
                    }
                }
                len = is.read(buf);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Utilities.freeBuffer(buf);
            throw throwable;
        }
        Object var8_9 = null;
        Utilities.freeBuffer(buf);
    }

    public static CoreException newCoreException(String s, int code, Throwable e) {
        MultiStatus status;
        String id = UpdateCore.getPlugin().getDescriptor().getUniqueIdentifier();
        if (e instanceof CoreException) {
            if (s == null) {
                s = "";
            }
            status = new MultiStatus(id, code, s, e);
            IStatus childrenStatus = ((CoreException)e).getStatus();
            status.add(childrenStatus);
            status.addAll(childrenStatus);
        } else {
            StringBuffer completeString = new StringBuffer("");
            if (s != null) {
                completeString.append(s);
            }
            if (e != null) {
                completeString.append(" [");
                String msg = e.getLocalizedMessage();
                completeString.append(msg != null ? msg : e.toString());
                completeString.append("]");
            }
            status = new Status(4, id, code, completeString.toString(), e);
        }
        return new CoreException((IStatus)status);
    }

    public static CoreException newCoreException(String s, Throwable e) {
        return Utilities.newCoreException(s, 0, e);
    }

    public static CoreException newCoreException(String s, String s1, String s2, CoreException e1, CoreException e2) {
        String id = UpdateCore.getPlugin().getDescriptor().getUniqueIdentifier();
        if (s == null) {
            s = "";
        }
        IStatus childStatus1 = e1.getStatus();
        IStatus childStatus2 = e2.getStatus();
        int code = childStatus1.getCode() == childStatus2.getCode() ? childStatus1.getCode() : 0;
        MultiStatus multi = new MultiStatus(id, code, s, null);
        multi.add(childStatus1);
        multi.addAll(childStatus1);
        multi.add(childStatus2);
        multi.addAll(childStatus2);
        return new CoreException((IStatus)multi);
    }

    public static String format(Date date) {
        if (date == null) {
            return "";
        }
        return dateFormat.format(date);
    }

    public static void shutdown() {
        if (dirRoot == null) {
            return;
        }
        File temp = new File(dirRoot);
        Utilities.cleanupTemp(temp);
        temp.delete();
    }

    private static void cleanupTemp(File root) {
        File[] files = root.listFiles();
        int i = 0;
        while (files != null && i < files.length) {
            if (files[i].isDirectory()) {
                Utilities.cleanupTemp(files[i]);
            }
            files[i].delete();
            ++i;
        }
    }

    private static void verifyPath(File path, boolean isFile) {
        if (isFile && path.getAbsolutePath().endsWith(File.separator)) {
            path = path.getParentFile();
            isFile = false;
        }
        if (path.exists()) {
            return;
        }
        File parent = path.getParentFile();
        Utilities.verifyPath(parent, false);
        if (!isFile) {
            path.mkdir();
        }
        path.deleteOnExit();
    }

    private static synchronized byte[] getBuffer() {
        if (bufferPool == null) {
            return new byte[4096];
        }
        try {
            return (byte[])bufferPool.pop();
        }
        catch (EmptyStackException emptyStackException) {
            return new byte[4096];
        }
    }

    private static synchronized void freeBuffer(byte[] buf) {
        if (bufferPool == null) {
            bufferPool = new Stack();
        }
        bufferPool.push(buf);
    }
}

