/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class ErrorRecoveryLog {
    public static final boolean RECOVERY_ON = false;
    private static final String ERROR_RECOVERY_LOG = "platform.cfg.log";
    private static final String LOG_ENTRY_KEY = "LogEntry.";
    private static final String RETURN_CARRIAGE = "\r\n";
    private static final String END_OF_FILE = "eof=eof";
    public static final String START_INSTALL_LOG = "START_INSTALL_LOG";
    public static final String PLUGIN_ENTRY = "PLUGIN";
    public static final String FRAGMENT_ENTRY = "FRAGMENT";
    public static final String FEATURE_ENTRY = "FEATURE";
    public static final String ALL_INSTALLED = "ALL_FEATURES_INSTALLED";
    public static final String RENAME_ENTRY = "RENAME";
    public static final String END_INSTALL_LOG = "END_INSTALL_LOG";
    public static final String START_REMOVE_LOG = "REMOVE_LOG";
    public static final String END_ABOUT_REMOVE = "END_ABOUT_TO_REMOVE";
    public static final String DELETE_ENTRY = "DELETE";
    public static final String END_REMOVE_LOG = "END_REMOVE_LOG";
    public static boolean forceRemove = false;
    private static ErrorRecoveryLog inst;
    private FileWriter out;
    private int index;
    private List paths;
    private boolean open = false;
    private int nbOfOpen = 0;

    private ErrorRecoveryLog() {
    }

    public static ErrorRecoveryLog getLog() {
        if (inst == null) {
            inst = new ErrorRecoveryLog();
        }
        return inst;
    }

    public static String getLocalRandomIdentifier(String path) {
        if (path == null) {
            return null;
        }
        if (path.endsWith(File.separator) || path.endsWith("/")) {
            return path;
        }
        File file = new File(path);
        String newName = UpdateManagerUtils.getLocalRandomIdentifier(file.getName(), new Date());
        while (new File(newName).exists()) {
            newName = UpdateManagerUtils.getLocalRandomIdentifier(file.getName(), new Date());
        }
        File newFile = new File(file.getParentFile(), newName);
        return newFile.getAbsolutePath();
    }

    public File getRecoveryLogFile() {
        IPlatformConfiguration configuration = BootLoader.getCurrentPlatformConfiguration();
        URL location = configuration.getConfigurationLocation();
        String locationString = location.getFile();
        File platformConfiguration = new File(locationString);
        if (!platformConfiguration.isDirectory()) {
            platformConfiguration = platformConfiguration.getParentFile();
        }
        return new File(platformConfiguration, ERROR_RECOVERY_LOG);
    }

    public void open(String logEntry) throws CoreException {
        if (this.open) {
            ++this.nbOfOpen;
            UpdateCore.warn("Open nested Error/Recovery log #" + this.nbOfOpen + ":" + logEntry);
            return;
        }
        File logFile = null;
        try {
            logFile = this.getRecoveryLogFile();
            this.out = new FileWriter(logFile);
            this.index = 0;
            this.paths = null;
            this.open = true;
            this.nbOfOpen = 0;
            UpdateCore.warn("Start new Error/Recovery log #" + this.nbOfOpen + ":" + logEntry);
        }
        catch (IOException e) {
            throw Utilities.newCoreException(Policy.bind("UpdateManagerUtils.UnableToLog", new Object[]{logFile}), e);
        }
        this.append(logEntry);
    }

    public void append(String logEntry) throws CoreException {
        Object logFile = null;
        try {
            if (!this.open) {
                UpdateCore.warn("Internal Error: The Error/Recovery log is not open:" + logEntry);
                return;
            }
            StringBuffer buffer = new StringBuffer(LOG_ENTRY_KEY);
            buffer.append(this.index);
            buffer.append("=");
            buffer.append(logEntry);
            buffer.append(RETURN_CARRIAGE);
            this.out.write(buffer.toString());
            this.out.flush();
            ++this.index;
        }
        catch (IOException e) {
            throw Utilities.newCoreException(Policy.bind("UpdateManagerUtils.UnableToLog", new Object[]{logFile}), e);
        }
    }

    public void appendPath(String logEntry, String path) throws CoreException {
        if (path == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer(logEntry);
        buffer.append(" ");
        buffer.append(path);
        this.append(buffer.toString());
        this.addPath(path);
    }

    public void close(String logEntry) throws CoreException {
        block5: {
            if (this.nbOfOpen > 0) {
                UpdateCore.warn("Close nested Error/Recovery log #" + this.nbOfOpen + ":" + logEntry);
                --this.nbOfOpen;
                return;
            }
            UpdateCore.warn("Close Error/Recovery log #" + this.nbOfOpen + ":" + logEntry);
            this.append(logEntry);
            if (this.out == null) break block5;
            try {
                try {
                    this.out.write(END_OF_FILE);
                    this.out.flush();
                    this.out.close();
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.out = null;
                this.open = false;
                throw throwable;
            }
            Object var2_4 = null;
            this.out = null;
            this.open = false;
        }
    }

    public void delete() {
        this.getRecoveryLogFile();
    }

    private void addPath(String path) {
        if (this.paths == null) {
            this.paths = new ArrayList();
        }
        this.paths.add(path);
    }

    public IStatus recover() {
        IStatus mainStatus = this.createStatus(0, "Recovering status", null);
        MultiStatus multi = new MultiStatus(mainStatus.getPlugin(), mainStatus.getCode(), mainStatus.getMessage(), null);
        UpdateCore.warn("Recovering is turned off. Abort recovery");
        return multi;
    }

    private IStatus createStatus(int statusSeverity, String msg, Exception e) {
        String id = UpdateCore.getPlugin().getDescriptor().getUniqueIdentifier();
        StringBuffer completeString = new StringBuffer("");
        if (msg != null) {
            completeString.append(msg);
        }
        if (e != null) {
            completeString.append("\r\n[");
            completeString.append(e.toString());
            completeString.append("]\r\n");
        }
        return new Status(statusSeverity, id, 0, completeString.toString(), (Throwable)e);
    }

    private IStatus processRecoverInstall(Properties prop) {
        IStatus mainStatus = this.createStatus(0, "", null);
        MultiStatus multi = new MultiStatus(mainStatus.getPlugin(), mainStatus.getCode(), "", null);
        Collection values = ((Hashtable)prop).values();
        if (values.contains(END_INSTALL_LOG)) {
            this.delete();
            UpdateCore.warn("Found log file. Log file contains END_INSTALL_LOG. No need to process rename");
            multi.add(this.createStatus(0, null, null));
            return multi;
        }
        if (values.contains(ALL_INSTALLED) && !forceRemove) {
            int index = 0;
            boolean found = false;
            String val = prop.getProperty(LOG_ENTRY_KEY + index);
            while (val != null && !found) {
                if (val.equalsIgnoreCase(ALL_INSTALLED)) {
                    found = true;
                }
                IStatus renameStatus = this.processRename(val);
                UpdateCore.log(renameStatus);
                if (renameStatus.getSeverity() != 0) {
                    multi.add(renameStatus);
                }
                val = prop.getProperty(LOG_ENTRY_KEY + ++index);
            }
            if (val == null) {
                UpdateCore.warn("Unable to find value for :LogEntry." + index);
                multi.add(this.createStatus(4, "Wrong log file. Unable to find entry for:LogEntry." + index, null));
                return multi;
            }
            this.delete();
            UpdateCore.warn("Found log file. Successfully recovered by renaming. Feature is installed.");
            multi.add(this.createStatus(0, null, null));
        } else {
            int index = 0;
            String val = prop.getProperty(LOG_ENTRY_KEY + index);
            while (val != null) {
                IStatus removeStatus = this.processRemove(val);
                UpdateCore.log(removeStatus);
                if (removeStatus.getSeverity() != 0) {
                    multi.addAll(removeStatus);
                }
                val = prop.getProperty(LOG_ENTRY_KEY + ++index);
            }
            this.delete();
            UpdateCore.warn("Found log file. Successfully recovered by removing. Feature is removed.");
            multi.add(this.createStatus(0, null, null));
        }
        return multi;
    }

    private IStatus processRename(String val) {
        int index = -1;
        String newFileName = null;
        if (val.startsWith(PLUGIN_ENTRY)) {
            index = PLUGIN_ENTRY.length();
            newFileName = "plugin.xml";
        }
        if (val.startsWith(FRAGMENT_ENTRY)) {
            index = FRAGMENT_ENTRY.length();
            newFileName = "fragment.xml";
        }
        if (val.startsWith(FEATURE_ENTRY)) {
            index = FEATURE_ENTRY.length();
            newFileName = "feature.xml";
        }
        if (index == -1) {
            return this.createStatus(4, "Unable to determine what action was taken by parsing" + val, null);
        }
        String oldName = val.substring(index + 1);
        File oldFile = new File(oldName);
        File parentFile = oldFile.getParentFile();
        File newFile = new File(parentFile, newFileName);
        if (!oldFile.exists()) {
            if (newFile.exists()) {
                return this.createStatus(0, "File already renamed into:" + newFile, null);
            }
            return this.createStatus(4, "Unable to find file:" + oldFile, null);
        }
        boolean sucess = false;
        if (newFile.exists()) {
            UpdateManagerUtils.removeFromFileSystem(newFile);
            UpdateCore.warn("Removing already existing file:" + newFile);
        }
        if (!(sucess = oldFile.renameTo(newFile))) {
            String msg = "Unable to rename old in new:" + oldFile + newFile;
            return this.createStatus(4, msg, null);
        }
        return this.createStatus(0, "Sucessfully renamed:" + oldFile + " to:" + newFile, null);
    }

    private IStatus processRemove(String val) {
        IStatus mainStatus = this.createStatus(0, "", null);
        MultiStatus multi = new MultiStatus(mainStatus.getPlugin(), mainStatus.getCode(), "", null);
        int index = -1;
        if (val.startsWith(PLUGIN_ENTRY)) {
            index = PLUGIN_ENTRY.length();
        }
        if (val.startsWith(FRAGMENT_ENTRY)) {
            index = FRAGMENT_ENTRY.length();
        }
        if (val.startsWith(FEATURE_ENTRY)) {
            index = FEATURE_ENTRY.length();
        }
        if (index == -1) {
            return this.createStatus(4, "Unable to determine what action was taken by parsing" + val, null);
        }
        String oldName = val.substring(index + 1);
        File oldFile = new File(oldName);
        File parentFile = oldFile.getParentFile();
        if (!parentFile.exists()) {
            multi.add(this.createStatus(4, "Unable to find file:" + oldFile, null));
            return multi;
        }
        multi.addAll(this.removeFromFileSystem(parentFile));
        return multi;
    }

    public IStatus removeFromFileSystem(File file) {
        String[] files;
        IStatus mainStatus = this.createStatus(0, "", null);
        MultiStatus multi = new MultiStatus(mainStatus.getPlugin(), mainStatus.getCode(), "", null);
        if (!file.exists()) {
            multi.add(this.createStatus(4, "Unable to find file to remove:" + file, null));
            return multi;
        }
        if (file.isDirectory() && (files = file.list()) != null) {
            int i = 0;
            while (i < files.length) {
                multi.addAll(this.removeFromFileSystem(new File(file, files[i])));
                ++i;
            }
        }
        if (!file.delete()) {
            String msg = "Unable to remove file" + file.getAbsolutePath();
            multi.add(this.createStatus(4, msg, null));
        }
        return multi;
    }

    private IStatus processRecoverRemove(Properties prop) {
        IStatus mainStatus = this.createStatus(0, "", null);
        MultiStatus multi = new MultiStatus(mainStatus.getPlugin(), mainStatus.getCode(), "", null);
        Collection values = ((Hashtable)prop).values();
        if (values.contains(END_REMOVE_LOG)) {
            this.delete();
            UpdateCore.warn("Found log file. Log file contains END_REMOVE_LOG. No need to process rename");
            multi.add(this.createStatus(0, null, null));
            return multi;
        }
        if (!values.contains(END_ABOUT_REMOVE)) {
            multi.add(this.createStatus(4, "The remove process didn't start. Please remove the disable feature from the program.", null));
            return multi;
        }
        int index = 0;
        boolean found = false;
        String val = prop.getProperty(LOG_ENTRY_KEY + index);
        while (val != null && !found) {
            if (val.equalsIgnoreCase(END_ABOUT_REMOVE)) {
                found = true;
            }
            IStatus renameStatus = this.processRemove(val);
            UpdateCore.log(renameStatus);
            if (renameStatus.getSeverity() != 0) {
                multi.add(renameStatus);
            }
            val = prop.getProperty(LOG_ENTRY_KEY + ++index);
        }
        if (val == null) {
            UpdateCore.warn("Unable to find value for :LogEntry." + index);
            multi.add(this.createStatus(4, "Wrong log file. Unable to find entry for:LogEntry." + index, null));
            return multi;
        }
        this.delete();
        UpdateCore.warn("Found log file. Successfully recovered by deleting. Feature is removed.");
        multi.add(this.createStatus(0, null, null));
        return multi;
    }
}

