/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.internal.core.ConnectionThreadManager;
import org.eclipse.update.internal.core.Response;
import org.eclipse.update.internal.core.UpdateCore;

public class HttpResponse
extends Response {
    private static final long POLLING_INTERVAL = 200L;

    public HttpResponse(URL url) {
        super(url);
    }

    public InputStream getInputStream(IProgressMonitor monitor) throws IOException, CoreException {
        if (this.in == null && this.url != null) {
            this.connection = this.url.openConnection();
            this.in = monitor != null && this.connection instanceof HttpURLConnection ? this.openStreamWithCancel((HttpURLConnection)this.connection, monitor) : this.connection.getInputStream();
        }
        return this.in;
    }

    private InputStream openStreamWithCancel(HttpURLConnection urlConnection, IProgressMonitor monitor) throws IOException, CoreException {
        ConnectionThreadManager.StreamRunnable runnable = new ConnectionThreadManager.StreamRunnable(urlConnection);
        Thread t = UpdateCore.getPlugin().getConnectionManager().createThread(runnable);
        t.start();
        InputStream is = null;
        try {
            while (true) {
                if (monitor.isCanceled()) {
                    runnable.disconnect();
                    break;
                }
                if (runnable.getInputStream() != null) {
                    is = runnable.getInputStream();
                    break;
                }
                if (runnable.getIOException() != null) {
                    throw runnable.getIOException();
                }
                t.join(200L);
            }
        }
        catch (InterruptedException interruptedException) {}
        return is;
    }
}

