/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.update.configuration.IInstallDeltaHandler;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.configuration.ISessionDelta;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFactory;
import org.eclipse.update.core.ISiteFactoryExtension;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.SiteLocal;
import org.eclipse.update.internal.core.SiteTypeFactory;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.model.InstallChangeParser;

public class InternalSiteManager {
    public static ILocalSite localSite;
    public static final String DEFAULT_SITE_TYPE = "org.eclipse.update.core.http";
    private static final String DEFAULT_EXECUTABLE_SITE_TYPE = "org.eclipse.update.core.file";
    private static final String SIMPLE_EXTENSION_ID = "deltaHandler";
    private static Map estimates;
    private static Map sites;
    public static boolean globalUseCache;
    private static CoreException exceptionOccured;

    static {
        sites = new HashMap();
        globalUseCache = true;
        exceptionOccured = null;
    }

    public static ILocalSite getLocalSite() throws CoreException {
        return InternalSiteManager.internalGetLocalSite(false);
    }

    private static ILocalSite internalGetLocalSite(boolean isOptimistic) throws CoreException {
        if (exceptionOccured != null) {
            throw exceptionOccured;
        }
        if (localSite == null) {
            try {
                localSite = SiteLocal.internalGetLocalSite(isOptimistic);
            }
            catch (CoreException e) {
                exceptionOccured = e;
                throw e;
            }
        }
        return localSite;
    }

    public static ISite getSite(URL siteURL, boolean useCache, IProgressMonitor monitor) throws CoreException {
        ISite site;
        block12: {
            File dir;
            site = null;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if (siteURL == null) {
                return null;
            }
            if (useCache && globalUseCache && sites.containsKey(siteURL)) {
                site = (ISite)sites.get(siteURL);
                return site;
            }
            boolean fileProtocol = "file".equalsIgnoreCase(siteURL.getProtocol());
            boolean directoryExists = false;
            if (fileProtocol && (dir = new File(siteURL.getFile())) != null && dir.isDirectory() && !new File(dir, "site.xml").exists()) {
                directoryExists = true;
            }
            monitor.beginTask(Policy.bind("InternalSiteManager.ConnectingToSite"), 8);
            if (fileProtocol && directoryExists) {
                site = InternalSiteManager.attemptCreateSite(DEFAULT_EXECUTABLE_SITE_TYPE, siteURL, monitor);
                monitor.worked(4);
            } else {
                try {
                    monitor.worked(3);
                    site = InternalSiteManager.attemptCreateSite(DEFAULT_SITE_TYPE, siteURL, monitor);
                    monitor.worked(1);
                }
                catch (CoreException preservedException) {
                    if (monitor.isCanceled()) break block12;
                    if (!fileProtocol) {
                        throw preservedException;
                    }
                    try {
                        site = InternalSiteManager.attemptCreateSite(DEFAULT_EXECUTABLE_SITE_TYPE, siteURL, monitor);
                    }
                    catch (CoreException retryException) {
                        IStatus firstStatus = preservedException.getStatus();
                        MultiStatus multi = new MultiStatus(firstStatus.getPlugin(), 0, Policy.bind("InternalSiteManager.FailedRetryAccessingSite"), (Throwable)retryException);
                        multi.addAll(firstStatus);
                        throw preservedException;
                    }
                }
            }
        }
        if (site != null) {
            sites.put(siteURL, site);
        }
        JarContentReference.shutdown();
        Utilities.flushLocalFile();
        return site;
    }

    private static ISite attemptCreateSite(String guessedTypeSite, URL siteURL, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ISite site = null;
        try {
            monitor.worked(1);
            site = InternalSiteManager.createSite(guessedTypeSite, siteURL, monitor);
            monitor.worked(1);
        }
        catch (InvalidSiteTypeException e) {
            if (monitor.isCanceled()) {
                return null;
            }
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_TYPE) {
                UpdateCore.debug("The Site :" + siteURL.toExternalForm() + " is a different type than the guessed type based on the protocol. new Type:" + e.getNewType());
            }
            InvalidSiteTypeException exception = e;
            try {
                if (exception.getNewType() == null) {
                    throw e;
                }
                site = InternalSiteManager.createSite(exception.getNewType(), siteURL, monitor);
            }
            catch (InvalidSiteTypeException e1) {
                throw Utilities.newCoreException(Policy.bind("InternalSiteManager.UnableToCreateSiteWithType", e.getNewType(), siteURL.toExternalForm()), e1);
            }
        }
        return site;
    }

    private static ISite createSite(String siteType, URL url, IProgressMonitor monitor) throws CoreException, InvalidSiteTypeException {
        ISite site = null;
        ISiteFactory factory = SiteTypeFactory.getInstance().getFactory(siteType);
        try {
            if (monitor != null) {
                monitor.worked(1);
            }
            site = InternalSiteManager.createSite(factory, url, monitor);
        }
        catch (CoreException e) {
            URL urlRetry;
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            if (url.getRef() != null) {
                throw Utilities.newCoreException(Policy.bind("InternalSiteManager.UnableToAccessURL", url.toExternalForm()), e);
            }
            if (url.getFile().endsWith("/")) {
                URL urlRetry2;
                try {
                    urlRetry2 = new URL(url, "site.xml");
                }
                catch (MalformedURLException e1) {
                    throw Utilities.newCoreException(Policy.bind("InternalSiteManager.UnableToCreateURL", String.valueOf(url.toExternalForm()) + "+" + "site.xml"), e1);
                }
                try {
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    site = InternalSiteManager.createSite(factory, urlRetry2, monitor);
                }
                catch (CoreException e1) {
                    throw Utilities.newCoreException(Policy.bind("InternalSiteManager.UnableToAccessURL", url.toExternalForm()), url.toExternalForm(), urlRetry2.toExternalForm(), e, e1);
                }
            }
            if (url.getFile().endsWith("site.xml")) {
                throw Utilities.newCoreException(Policy.bind("InternalSiteManager.UnableToAccessURL", url.toExternalForm()), e);
            }
            try {
                urlRetry = new URL(url.getProtocol(), url.getHost(), url.getPort(), String.valueOf(url.getFile()) + "/" + "site.xml");
            }
            catch (MalformedURLException e1) {
                throw Utilities.newCoreException(Policy.bind("InternalSiteManager.UnableToCreateURL", String.valueOf(url.toExternalForm()) + "+" + "site.xml"), e1);
            }
            try {
                if (monitor != null) {
                    monitor.worked(1);
                }
                site = InternalSiteManager.createSite(factory, urlRetry, monitor);
            }
            catch (CoreException e1) {
                throw Utilities.newCoreException(Policy.bind("InternalSiteManager.UnableToAccessURL", url.toExternalForm()), url.toExternalForm(), urlRetry.toExternalForm(), e, e1);
            }
        }
        return site;
    }

    private static ISite createSite(ISiteFactory factory, URL url, IProgressMonitor monitor) throws CoreException, InvalidSiteTypeException {
        if (factory instanceof ISiteFactoryExtension) {
            return ((ISiteFactoryExtension)((Object)factory)).createSite(url, monitor);
        }
        return factory.createSite(url);
    }

    public static ISite createSite(File siteLocation) throws CoreException {
        ISite site = null;
        if (siteLocation != null) {
            try {
                URL siteURL = siteLocation.toURL();
                site = InternalSiteManager.getSite(siteURL, false, null);
            }
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(Policy.bind("InternalSiteManager.UnableToCreateURL", siteLocation.getAbsolutePath()), e);
            }
        }
        return site;
    }

    public static void handleNewChanges() throws CoreException {
        IInstallDeltaHandler handler = null;
        String pluginID = UpdateCore.getPlugin().getDescriptor().getUniqueIdentifier();
        IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
        IConfigurationElement[] elements = pluginRegistry.getConfigurationElementsFor(pluginID, SIMPLE_EXTENSION_ID);
        if (elements == null || elements.length == 0) {
            throw Utilities.newCoreException(Policy.bind("SiteReconciler.UnableToFindInstallDeltaFactory", String.valueOf(pluginID) + "." + SIMPLE_EXTENSION_ID), null);
        }
        IConfigurationElement element = elements[0];
        handler = (IInstallDeltaHandler)element.createExecutableExtension("class");
        if (handler != null) {
            ISessionDelta[] deltas = InternalSiteManager.getSessionDeltas();
            handler.init(deltas);
            handler.open();
        }
    }

    private static ISessionDelta[] getSessionDeltas() {
        ArrayList<ISessionDelta> sessionDeltas = new ArrayList<ISessionDelta>();
        IPath path = UpdateCore.getPlugin().getStateLocation();
        File file = path.toFile();
        if (file.isDirectory()) {
            File[] allFiles = file.listFiles();
            int i = 0;
            while (i < allFiles.length) {
                block7: {
                    try {
                        InstallChangeParser parser;
                        ISessionDelta change;
                        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                            UpdateCore.debug("Found delta change:" + allFiles[i]);
                        }
                        if ((change = (parser = new InstallChangeParser(allFiles[i])).getInstallChange()) != null) {
                            sessionDeltas.add(change);
                        }
                    }
                    catch (Exception e) {
                        if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_RECONCILER) break block7;
                        UpdateCore.log("Unable to parse install change:" + allFiles[i], e);
                    }
                }
                ++i;
            }
        }
        if (sessionDeltas.size() == 0) {
            return new ISessionDelta[0];
        }
        return (ISessionDelta[])sessionDeltas.toArray(InternalSiteManager.arrayTypeFor(sessionDeltas));
    }

    private static Object[] arrayTypeFor(List l) {
        if (l == null || l.size() == 0) {
            return null;
        }
        return (Object[])Array.newInstance(l.get(0).getClass(), 0);
    }

    public static boolean reconcile(boolean optimisticReconciliation) throws CoreException {
        InternalSiteManager.internalGetLocalSite(optimisticReconciliation);
        if (localSite instanceof SiteLocal) {
            return SiteLocal.newFeaturesFound;
        }
        return false;
    }

    public static void downloaded(long downloadSize, long time, URL url) {
        if (downloadSize <= 0L || time < 0L) {
            return;
        }
        String host = url.getHost();
        long sizeByTime = time == 0L ? 0L : downloadSize / time;
        Long value = new Long(sizeByTime);
        if (estimates == null) {
            estimates = new HashMap();
        } else {
            Long previous = (Long)estimates.get(host);
            if (previous != null) {
                value = new Long((previous + sizeByTime) / 2L);
            }
        }
        estimates.put(host, value);
    }

    public static long getEstimatedTransferRate(String host) {
        if (estimates == null) {
            return 0L;
        }
        Long value = (Long)estimates.get(host);
        if (value == null) {
            return 0L;
        }
        return value;
    }
}

