/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureFactory;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.FeatureTypeFactory;
import org.eclipse.update.internal.core.ISiteContentConsumer;
import org.eclipse.update.internal.core.InstallHandlerProxy;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.SiteFileContentConsumer;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteFile
extends Site {
    private List pluginEntries = new ArrayList(0);

    public ISiteContentConsumer createSiteContentConsumer(IFeature targetFeature) throws CoreException {
        SiteFileContentConsumer consumer = new SiteFileContentConsumer(targetFeature);
        consumer.setSite(this);
        return consumer;
    }

    public String getDefaultPackagedFeatureType() {
        return "org.eclipse.update.core.installed";
    }

    public IFeatureReference install(IFeature sourceFeature, IVerificationListener verificationListener, IProgressMonitor progress) throws CoreException {
        return this.install(sourceFeature, null, verificationListener, progress);
    }

    public IFeatureReference install(IFeature sourceFeature, IFeatureReference[] optionalfeatures, IVerificationListener verificationListener, IProgressMonitor progress) throws CoreException {
        if (sourceFeature == null) {
            return null;
        }
        InstallMonitor monitor = progress == null ? null : (progress instanceof InstallMonitor ? (InstallMonitor)progress : new InstallMonitor(progress));
        IFeature localFeature = this.createExecutableFeature(sourceFeature);
        IFeatureReference localFeatureReference = null;
        localFeatureReference = sourceFeature.install(localFeature, optionalfeatures, verificationListener, monitor);
        return localFeatureReference;
    }

    public IFeatureReference install(IFeature sourceFeature, IFeatureReference[] optionalfeatures, IFeatureContentConsumer parentContentConsumer, IVerifier parentVerifier, IVerificationListener verificationListener, IProgressMonitor progress) throws InstallAbortedException, CoreException {
        if (sourceFeature == null) {
            return null;
        }
        InstallMonitor monitor = progress == null ? null : (progress instanceof InstallMonitor ? (InstallMonitor)progress : new InstallMonitor(progress));
        IFeature localFeature = this.createExecutableFeature(sourceFeature);
        parentContentConsumer.addChild(localFeature);
        IVerifier vr = sourceFeature.getFeatureContentProvider().getVerifier();
        if (vr != null) {
            vr.setParent(parentVerifier);
        }
        IFeatureReference localFeatureReference = null;
        localFeatureReference = sourceFeature.install(localFeature, optionalfeatures, verificationListener, monitor);
        return localFeatureReference;
    }

    public void remove(IFeature feature, IProgressMonitor progress) throws CoreException {
        if (feature == null) {
            UpdateCore.warn("Feature to remove is null");
            return;
        }
        ErrorRecoveryLog recoveryLog = ErrorRecoveryLog.getLog();
        InstallMonitor monitor = progress == null ? null : (progress instanceof InstallMonitor ? (InstallMonitor)progress : new InstallMonitor(progress));
        InstallHandlerProxy handler = new InstallHandlerProxy(4, feature, feature.getInstallHandlerEntry(), monitor);
        boolean success = false;
        Throwable originalException = null;
        try {
            try {
                ISiteFeatureReference[] featureReferences;
                recoveryLog.open("REMOVE_LOG");
                this.aboutToRemove(feature);
                recoveryLog.append("END_ABOUT_TO_REMOVE");
                handler.uninstallInitiated();
                IPluginEntry[] pluginsToRemove = this.getPluginEntriesOnlyReferencedBy(feature);
                if (monitor != null) {
                    monitor.beginTask(String.valueOf(Policy.bind("SiteFile.Removing")) + feature.getLabel(), pluginsToRemove.length + 1);
                }
                if ((featureReferences = this.getFeatureReferences()) != null) {
                    int indexRef = 0;
                    while (indexRef < featureReferences.length) {
                        ISiteFeatureReference element = featureReferences[indexRef];
                        if (element.equals(feature)) {
                            this.removeFeatureReferenceModel((FeatureReferenceModel)((Object)element));
                            break;
                        }
                        ++indexRef;
                    }
                }
                ContentReference[] references = feature.getFeatureContentProvider().getFeatureEntryArchiveReferences(monitor);
                int i = 0;
                while (i < references.length) {
                    try {
                        UpdateManagerUtils.removeFromFileSystem(references[i].asFile());
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                    }
                    catch (IOException e) {
                        throw Utilities.newCoreException(Policy.bind("SiteFile.CannotRemoveFeature", feature.getVersionedIdentifier().getIdentifier(), this.getURL().toExternalForm()), e);
                    }
                    ++i;
                }
                i = 0;
                while (i < pluginsToRemove.length) {
                    this.remove(feature, pluginsToRemove[i], monitor);
                    ++i;
                }
                IIncludedFeatureReference[] childrenRef = feature.getIncludedFeatureReferences();
                int i2 = 0;
                while (i2 < childrenRef.length) {
                    IFeature childFeature = null;
                    try {
                        childFeature = childrenRef[i2].getFeature(null);
                    }
                    catch (CoreException coreException) {
                        UpdateCore.warn("Unable to retrieve feature to remove for:" + childrenRef[i2]);
                    }
                    if (childFeature != null) {
                        this.remove(childrenRef[i2].getFeature(null), monitor);
                    }
                    ++i2;
                }
                handler.completeUninstall();
                success = true;
            }
            catch (Throwable t) {
                originalException = t;
            }
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            Throwable newException = null;
            try {
                if (success) {
                    recoveryLog.close("END_REMOVE_LOG");
                    recoveryLog.delete();
                } else {
                    recoveryLog.close("END_REMOVE_LOG");
                }
                handler.uninstallCompleted(success);
            }
            catch (Throwable t) {
                newException = t;
            }
            if (originalException != null) {
                throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
            }
            if (newException != null) {
                throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
            }
            throw throwable;
        }
        Object var14_21 = null;
        Throwable newException = null;
        try {
            if (success) {
                recoveryLog.close("END_REMOVE_LOG");
                recoveryLog.delete();
            } else {
                recoveryLog.close("END_REMOVE_LOG");
            }
            handler.uninstallCompleted(success);
        }
        catch (Throwable t) {
            newException = t;
        }
        if (originalException != null) {
            throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), originalException);
        }
        if (newException != null) {
            throw Utilities.newCoreException(Policy.bind("InstallHandler.error", feature.getLabel()), newException);
        }
    }

    public long getDownloadSizeFor(IFeature feature) {
        long result = 0L;
        IPluginEntry[] entriesToInstall = feature.getPluginEntries();
        IPluginEntry[] siteEntries = this.getPluginEntries();
        entriesToInstall = UpdateManagerUtils.diff(entriesToInstall, siteEntries);
        INonPluginEntry[] nonPluginEntriesToInstall = feature.getNonPluginEntries();
        try {
            result = feature.getFeatureContentProvider().getDownloadSizeFor(entriesToInstall, nonPluginEntriesToInstall);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
            result = -1L;
        }
        return result;
    }

    public long getInstallSizeFor(IFeature feature) {
        long result = 0L;
        try {
            ArrayList<IPluginEntry> pluginsToInstall = new ArrayList<IPluginEntry>();
            pluginsToInstall.addAll(Arrays.asList(feature.getPluginEntries()));
            IIncludedFeatureReference[] children = feature.getIncludedFeatureReferences();
            IFeature currentFeature = null;
            int i = 0;
            while (i < children.length) {
                currentFeature = children[i].getFeature(null);
                if (currentFeature != null) {
                    pluginsToInstall.addAll(Arrays.asList(currentFeature.getPluginEntries()));
                }
                ++i;
            }
            IPluginEntry[] entriesToInstall = new IPluginEntry[]{};
            if (pluginsToInstall.size() > 0) {
                entriesToInstall = new IPluginEntry[pluginsToInstall.size()];
                pluginsToInstall.toArray(entriesToInstall);
            }
            IPluginEntry[] siteEntries = this.getPluginEntries();
            entriesToInstall = UpdateManagerUtils.diff(entriesToInstall, siteEntries);
            INonPluginEntry[] nonPluginEntriesToInstall = feature.getNonPluginEntries();
            result = feature.getFeatureContentProvider().getInstallSizeFor(entriesToInstall, nonPluginEntriesToInstall);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
            result = -1L;
        }
        return result;
    }

    public void addPluginEntry(IPluginEntry pluginEntry) {
        this.pluginEntries.add(pluginEntry);
    }

    public IPluginEntry[] getPluginEntries() {
        IPluginEntry[] result = new IPluginEntry[]{};
        if (this.pluginEntries != null && !this.pluginEntries.isEmpty()) {
            result = new IPluginEntry[this.pluginEntries.size()];
            this.pluginEntries.toArray(result);
        }
        return result;
    }

    public int getPluginEntryCount() {
        return this.getPluginEntries().length;
    }

    private IFeature createExecutableFeature(IFeature sourceFeature) throws CoreException {
        IFeature result = null;
        IFeatureFactory factory = FeatureTypeFactory.getInstance().getFactory("org.eclipse.update.core.installed");
        result = factory.createFeature(null, this, null);
        ((FeatureModel)((Object)result)).setFeatureIdentifier(sourceFeature.getVersionedIdentifier().getIdentifier());
        ((FeatureModel)((Object)result)).setFeatureVersion(sourceFeature.getVersionedIdentifier().getVersion().toString());
        return result;
    }

    private void remove(IFeature feature, IPluginEntry pluginEntry, InstallMonitor monitor) throws CoreException {
        if (pluginEntry == null) {
            return;
        }
        ContentReference[] references = feature.getFeatureContentProvider().getPluginEntryArchiveReferences(pluginEntry, monitor);
        int i = 0;
        while (i < references.length) {
            try {
                UpdateManagerUtils.removeFromFileSystem(references[i].asFile());
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            catch (IOException e) {
                throw Utilities.newCoreException(Policy.bind("SiteFile.CannotRemovePlugin", pluginEntry.getVersionedIdentifier().toString(), this.getURL().toExternalForm()), e);
            }
            ++i;
        }
    }

    private void aboutToRemove(IFeature feature) throws CoreException {
        ErrorRecoveryLog.getLog();
    }
}

